/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.Bzip2BitWriter;
import io.netty.handler.codec.compression.Bzip2BlockCompressor;
import io.netty.handler.codec.compression.EncoderUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;

public class Bzip2Encoder
extends MessageToByteEncoder<ByteBuf> {
    private State currentState = State.INIT;
    private final Bzip2BitWriter writer = new Bzip2BitWriter();
    private final int streamBlockSize;
    private int streamCRC;
    private Bzip2BlockCompressor blockCompressor;
    private volatile boolean finished;
    private volatile ChannelHandlerContext ctx;

    public Bzip2Encoder() {
        this(9);
    }

    /*
     * WARNING - void declaration
     */
    public Bzip2Encoder(int blockSizeMultiplier) {
        void var1_1;
        if (blockSizeMultiplier <= 0 || blockSizeMultiplier > 9) {
            throw new IllegalArgumentException("blockSizeMultiplier: " + blockSizeMultiplier + " (expected: 1-9)");
        }
        this.streamBlockSize = var1_1 * 100000;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        if (this.finished) {
            out.writeBytes(in);
            return;
        }
        block6: while (true) {
            switch (this.currentState) {
                case INIT: {
                    out.ensureWritable(4);
                    out.writeMedium(4348520);
                    out.writeByte(48 + this.streamBlockSize / 100000);
                    this.currentState = State.INIT_BLOCK;
                }
                case INIT_BLOCK: {
                    this.blockCompressor = new Bzip2BlockCompressor(this.writer, this.streamBlockSize);
                    this.currentState = State.WRITE_DATA;
                }
                case WRITE_DATA: {
                    void var1_1;
                    if (!in.isReadable()) {
                        return;
                    }
                    Bzip2BlockCompressor blockCompressor = this.blockCompressor;
                    int length = Math.min(in.readableBytes(), blockCompressor.availableSize());
                    ByteBuf byteBuf = in;
                    int bytesWritten = blockCompressor.write(byteBuf, byteBuf.readerIndex(), length);
                    in.skipBytes(bytesWritten);
                    if (!var1_1.isFull()) {
                        if (in.isReadable()) continue block6;
                        return;
                    }
                    this.currentState = State.CLOSE_BLOCK;
                }
                case CLOSE_BLOCK: {
                    this.closeBlock(out);
                    this.currentState = State.INIT_BLOCK;
                    continue block6;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    private void closeBlock(ByteBuf out) {
        Bzip2BlockCompressor blockCompressor = this.blockCompressor;
        if (!blockCompressor.isEmpty()) {
            void var1_2;
            void var2_3;
            blockCompressor.close(out);
            int blockCRC = var2_3.crc();
            this.streamCRC = (this.streamCRC << 1 | this.streamCRC >>> 31) ^ var1_2;
        }
    }

    public boolean isClosed() {
        return this.finished;
    }

    public ChannelFuture close() {
        Bzip2Encoder bzip2Encoder = this;
        return bzip2Encoder.close(bzip2Encoder.ctx().newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture close(ChannelPromise promise) {
        void var1_1;
        void var3_3;
        ChannelHandlerContext ctx = this.ctx();
        EventExecutor executor = ctx.executor();
        if (executor.inEventLoop()) {
            void var2_2;
            return this.finishEncode((ChannelHandlerContext)var2_2, promise);
        }
        var3_3.execute(new Runnable(this, promise){
            final /* synthetic */ ChannelPromise val$promise;
            final /* synthetic */ Bzip2Encoder this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$promise = channelPromise;
            }

            @Override
            public void run() {
                ChannelFuture channelFuture = Bzip2Encoder.access$100(this.this$0, this.this$0.ctx(), this.val$promise);
                PromiseNotifier.cascade((Future)channelFuture, (Promise)this.val$promise);
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var3_3;
        void var1_1;
        ChannelHandlerContext channelHandlerContext = ctx;
        ChannelFuture f = this.finishEncode(channelHandlerContext, channelHandlerContext.newPromise());
        EncoderUtil.closeAfterFinishEncode((ChannelHandlerContext)var1_1, (ChannelFuture)var3_3, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture finishEncode(ChannelHandlerContext ctx, ChannelPromise promise) {
        void var2_3;
        void var3_4;
        void var1_1;
        if (this.finished) {
            promise.setSuccess();
            return promise;
        }
        this.finished = true;
        ByteBuf footer = ctx.alloc().buffer();
        this.closeBlock(footer);
        int streamCRC = this.streamCRC;
        Bzip2BitWriter writer = this.writer;
        try {
            writer.writeBits(footer, 24, 1536581L);
            writer.writeBits(footer, 24, 3690640L);
            writer.writeInt(footer, streamCRC);
            writer.flush(footer);
        }
        finally {
            this.blockCompressor = null;
        }
        return var1_1.writeAndFlush((Object)var3_4, (ChannelPromise)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private ChannelHandlerContext ctx() {
        void var1_1;
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.ctx = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ChannelFuture access$100(Bzip2Encoder x0, ChannelHandlerContext x1, ChannelPromise x2) {
        void var2_2;
        void var1_1;
        return x0.finishEncode((ChannelHandlerContext)var1_1, (ChannelPromise)var2_2);
    }

    private static enum State {
        INIT,
        INIT_BLOCK,
        WRITE_DATA,
        CLOSE_BLOCK;

    }
}

