/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.Bzip2BitWriter;
import io.netty.handler.codec.compression.Bzip2DivSufSort;
import io.netty.handler.codec.compression.Bzip2HuffmanStageEncoder;
import io.netty.handler.codec.compression.Bzip2MTFAndRLE2StageEncoder;
import io.netty.handler.codec.compression.Crc32;
import io.netty.util.ByteProcessor;

final class Bzip2BlockCompressor {
    private final ByteProcessor writeProcessor = new ByteProcessor(this){
        final /* synthetic */ Bzip2BlockCompressor this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public boolean process(byte value) throws Exception {
            void var1_1;
            return this.this$0.write((int)var1_1);
        }
    };
    private final Bzip2BitWriter writer;
    private final Crc32 crc = new Crc32();
    private final byte[] block;
    private int blockLength;
    private final int blockLengthLimit;
    private final boolean[] blockValuesPresent = new boolean[256];
    private final int[] bwtBlock;
    private int rleCurrentValue = -1;
    private int rleLength;

    /*
     * WARNING - void declaration
     */
    Bzip2BlockCompressor(Bzip2BitWriter writer, int blockSize) {
        void var2_2;
        void var1_1;
        this.writer = var1_1;
        this.block = new byte[blockSize + 1];
        this.bwtBlock = new int[blockSize + 1];
        this.blockLengthLimit = var2_2 - 6;
    }

    private void writeSymbolMap(ByteBuf out) {
        int k;
        int j;
        Bzip2BitWriter writer = this.writer;
        boolean[] blockValuesPresent = this.blockValuesPresent;
        boolean[] condensedInUse = new boolean[16];
        block0: for (int i = 0; i < condensedInUse.length; ++i) {
            j = 0;
            k = i << 4;
            while (j < 16) {
                if (blockValuesPresent[k]) {
                    condensedInUse[i] = true;
                    continue block0;
                }
                ++j;
                ++k;
            }
        }
        boolean[] i = condensedInUse;
        int cfr_ignored_0 = condensedInUse.length;
        for (k = 0; k < 16; ++k) {
            boolean isCondensedInUse = i[k];
            writer.writeBoolean(out, isCondensedInUse);
        }
        for (int i2 = 0; i2 < condensedInUse.length; ++i2) {
            if (!condensedInUse[i2]) continue;
            j = 0;
            k = i2 << 4;
            while (j < 16) {
                writer.writeBoolean(out, blockValuesPresent[k]);
                ++j;
                ++k;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeRun(int value, int runLength) {
        void var3_3;
        void var2_2;
        void var1_1;
        int blockLength = this.blockLength;
        byte[] block = this.block;
        this.blockValuesPresent[value] = true;
        this.crc.updateCRC(value, runLength);
        byte byteValue = (byte)value;
        switch (runLength) {
            case 1: {
                block[blockLength] = byteValue;
                this.blockLength = blockLength + 1;
                return;
            }
            case 2: {
                block[blockLength] = byteValue;
                block[blockLength + 1] = byteValue;
                this.blockLength = blockLength + 2;
                return;
            }
            case 3: {
                block[blockLength] = byteValue;
                block[blockLength + 1] = byteValue;
                block[blockLength + 2] = byteValue;
                this.blockLength = blockLength + 3;
                return;
            }
        }
        this.blockValuesPresent[runLength -= 4] = true;
        block[blockLength] = byteValue;
        block[blockLength + 1] = byteValue;
        block[blockLength + 2] = byteValue;
        block[blockLength + 3] = var1_1;
        block[blockLength + 4] = (byte)var2_2;
        this.blockLength = var3_3 + 5;
    }

    /*
     * WARNING - void declaration
     */
    final boolean write(int value) {
        if (this.blockLength > this.blockLengthLimit) {
            return false;
        }
        int rleCurrentValue = this.rleCurrentValue;
        int rleLength = this.rleLength;
        if (rleLength == 0) {
            this.rleCurrentValue = value;
            this.rleLength = 1;
        } else if (rleCurrentValue != value) {
            void var1_1;
            this.writeRun(rleCurrentValue & 0xFF, rleLength);
            this.rleCurrentValue = var1_1;
            this.rleLength = 1;
        } else if (rleLength == 254) {
            void var2_2;
            this.writeRun((int)(var2_2 & 0xFF), 255);
            this.rleLength = 0;
        } else {
            void var3_3;
            this.rleLength = var3_3 + true;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    final int write(ByteBuf buffer, int offset, int length) {
        void var2_3;
        void var1_2;
        int index = buffer.forEachByte(offset, length, this.writeProcessor);
        if (index == -1) {
            void var3_4;
            return (int)var3_4;
        }
        return (int)(var1_2 - var2_3);
    }

    /*
     * WARNING - void declaration
     */
    final void close(ByteBuf out) {
        void var1_1;
        Bzip2HuffmanStageEncoder bzip2HuffmanStageEncoder;
        void var3_5;
        if (this.rleLength > 0) {
            Bzip2BlockCompressor bzip2BlockCompressor = this;
            bzip2BlockCompressor.writeRun(bzip2BlockCompressor.rleCurrentValue & 0xFF, this.rleLength);
        }
        this.block[this.blockLength] = this.block[0];
        Bzip2DivSufSort bzip2DivSufSort = new Bzip2DivSufSort(this.block, this.bwtBlock, this.blockLength);
        int bwtStartPointer = bzip2DivSufSort.bwt();
        Bzip2BitWriter writer = this.writer;
        writer.writeBits(out, 24, 3227993L);
        writer.writeBits(out, 24, 2511705L);
        writer.writeInt(out, this.crc.getCRC());
        writer.writeBoolean(out, false);
        writer.writeBits(out, 24, bwtStartPointer);
        this.writeSymbolMap(out);
        Bzip2MTFAndRLE2StageEncoder mtfEncoder = new Bzip2MTFAndRLE2StageEncoder(this.bwtBlock, this.blockLength, this.blockValuesPresent);
        mtfEncoder.encode();
        bzip2HuffmanStageEncoder = new Bzip2HuffmanStageEncoder((Bzip2BitWriter)var3_5, mtfEncoder.mtfBlock(), mtfEncoder.mtfLength(), mtfEncoder.mtfAlphabetSize(), ((Bzip2MTFAndRLE2StageEncoder)((Object)bzip2HuffmanStageEncoder)).mtfSymbolFrequencies());
        bzip2HuffmanStageEncoder.encode((ByteBuf)var1_1);
    }

    final int availableSize() {
        if (this.blockLength == 0) {
            return this.blockLengthLimit + 2;
        }
        return this.blockLengthLimit - this.blockLength + 1;
    }

    final boolean isFull() {
        return this.blockLength > this.blockLengthLimit;
    }

    final boolean isEmpty() {
        return this.blockLength == 0 && this.rleLength == 0;
    }

    final int crc() {
        return this.crc.getCRC();
    }
}

