/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;

final class Bzip2BitWriter {
    private long bitBuffer;
    private int bitCount;

    Bzip2BitWriter() {
    }

    /*
     * WARNING - void declaration
     */
    final void writeBits(ByteBuf out, int count, long value) {
        void var2_2;
        void var3_3;
        if (count < 0 || count > 32) {
            throw new IllegalArgumentException("count: " + count + " (expected: 0-32)");
        }
        int bitCount = this.bitCount;
        long bitBuffer = this.bitBuffer | var3_3 << 64 - count >>> bitCount;
        if ((bitCount += var2_2) >= 32) {
            void var1_1;
            var1_1.writeInt((int)(bitBuffer >>> 32));
            bitBuffer <<= 32;
            bitCount -= 32;
        }
        this.bitBuffer = bitBuffer;
        this.bitCount = bitCount;
    }

    /*
     * WARNING - void declaration
     */
    final void writeBoolean(ByteBuf out, boolean value) {
        void var3_3;
        void var2_2;
        int bitCount = this.bitCount + 1;
        long bitBuffer = this.bitBuffer | (var2_2 != false ? 1L << 64 - bitCount : 0L);
        if (bitCount == 32) {
            void var1_1;
            var1_1.writeInt((int)(bitBuffer >>> 32));
            bitBuffer = 0L;
            bitCount = 0;
        }
        this.bitBuffer = bitBuffer;
        this.bitCount = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    final void writeUnary(ByteBuf out, int value) {
        void var1_1;
        if (value < 0) {
            throw new IllegalArgumentException("value: " + value + " (expected 0 or more)");
        }
        while (value-- > 0) {
            this.writeBoolean(out, true);
        }
        this.writeBoolean((ByteBuf)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    final void writeInt(ByteBuf out, int value) {
        void var2_2;
        void var1_1;
        this.writeBits((ByteBuf)var1_1, 32, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final void flush(ByteBuf out) {
        int bitCount = this.bitCount;
        if (bitCount > 0) {
            void var2_2;
            void var3_3;
            void var1_1;
            long bitBuffer = this.bitBuffer;
            int shiftToRight = 64 - bitCount;
            if (bitCount <= 8) {
                out.writeByte((int)(bitBuffer >>> shiftToRight << 8 - bitCount));
                return;
            }
            if (bitCount <= 16) {
                out.writeShort((int)(bitBuffer >>> shiftToRight << 16 - bitCount));
                return;
            }
            if (bitCount <= 24) {
                out.writeMedium((int)(bitBuffer >>> shiftToRight << 24 - bitCount));
                return;
            }
            var1_1.writeInt((int)(var3_3 >>> shiftToRight << 32 - var2_2));
        }
    }
}

