/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;

class Bzip2BitReader {
    private static final int MAX_COUNT_OF_READABLE_BYTES = 0xFFFFFFF;
    private ByteBuf in;
    private long bitBuffer;
    private int bitCount;

    Bzip2BitReader() {
    }

    /*
     * WARNING - void declaration
     */
    void setByteBuf(ByteBuf in) {
        void var1_1;
        this.in = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    int readBits(int count) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (count < 0 || count > 32) {
            throw new IllegalArgumentException("count: " + count + " (expected: 0-32 )");
        }
        int bitCount = this.bitCount;
        long bitBuffer = this.bitBuffer;
        if (bitCount < count) {
            int offset;
            long readData;
            switch (this.in.readableBytes()) {
                case 1: {
                    readData = this.in.readUnsignedByte();
                    offset = 8;
                    break;
                }
                case 2: {
                    readData = this.in.readUnsignedShort();
                    offset = 16;
                    break;
                }
                case 3: {
                    readData = this.in.readUnsignedMedium();
                    offset = 24;
                    break;
                }
                default: {
                    readData = this.in.readUnsignedInt();
                    offset = 32;
                }
            }
            bitBuffer = bitBuffer << offset | readData;
            bitCount += offset;
            this.bitBuffer = bitBuffer;
        }
        this.bitCount = bitCount -= count;
        return (int)(var3_3 >>> var2_2 & (count != 32 ? (long)((1 << var1_1) - 1) : 0xFFFFFFFFL));
    }

    boolean readBoolean() {
        return this.readBits(1) != 0;
    }

    int readInt() {
        return this.readBits(32);
    }

    /*
     * WARNING - void declaration
     */
    void refill() {
        void var1_1;
        short readData = this.in.readUnsignedByte();
        this.bitBuffer = this.bitBuffer << 8 | (long)var1_1;
        this.bitCount += 8;
    }

    boolean isReadable() {
        return this.bitCount > 0 || this.in.isReadable();
    }

    /*
     * WARNING - void declaration
     */
    boolean hasReadableBits(int count) {
        void var1_1;
        if (count < 0) {
            throw new IllegalArgumentException("count: " + count + " (expected value greater than 0)");
        }
        return this.bitCount >= count || (this.in.readableBytes() << 3 & Integer.MAX_VALUE) >= var1_1 - this.bitCount;
    }

    /*
     * WARNING - void declaration
     */
    boolean hasReadableBytes(int count) {
        void var1_1;
        if (count < 0 || count > 0xFFFFFFF) {
            throw new IllegalArgumentException("count: " + count + " (expected: 0-268435455" + ')');
        }
        return this.hasReadableBits((int)(var1_1 << 3));
    }
}

