/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.CompressionUtil;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

abstract class ByteBufChecksum
implements Checksum {
    private final ByteProcessor updateProcessor = new ByteProcessor(this){
        final /* synthetic */ ByteBufChecksum this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public boolean process(byte value) throws Exception {
            void var1_1;
            this.this$0.update((int)var1_1);
            return true;
        }
    };

    ByteBufChecksum() {
    }

    /*
     * WARNING - void declaration
     */
    private static Method updateByteBuffer(Checksum checksum) {
        if (PlatformDependent.javaVersion() >= 8) {
            try {
                void var1_1;
                Checksum checksum2;
                Method method = checksum.getClass().getDeclaredMethod("update", ByteBuffer.class);
                method.invoke((Object)checksum2, ByteBuffer.allocate(1));
                return var1_1;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return null;
    }

    static ByteBufChecksum wrapChecksum(Checksum checksum) {
        Checksum checksum2;
        ObjectUtil.checkNotNull((Object)checksum, (String)"checksum");
        if (checksum instanceof ByteBufChecksum) {
            return (ByteBufChecksum)checksum;
        }
        if (checksum instanceof Adler32 && ZlibChecksumMethods.ADLER32_UPDATE_METHOD != null) {
            return new ReflectiveByteBufChecksum(checksum, ZlibChecksumMethods.ADLER32_UPDATE_METHOD);
        }
        if (checksum instanceof CRC32 && ZlibChecksumMethods.CRC32_UPDATE_METHOD != null) {
            return new ReflectiveByteBufChecksum(checksum, ZlibChecksumMethods.CRC32_UPDATE_METHOD);
        }
        return new SlowByteBufChecksum(checksum2);
    }

    /*
     * WARNING - void declaration
     */
    public void update(ByteBuf b, int off, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (b.hasArray()) {
            this.update(b.array(), b.arrayOffset() + off, len);
            return;
        }
        var1_1.forEachByte((int)var2_2, (int)var3_3, this.updateProcessor);
    }

    static /* synthetic */ Method access$000(Checksum x0) {
        return ByteBufChecksum.updateByteBuffer(x0);
    }

    private static class SlowByteBufChecksum
    extends ByteBufChecksum {
        protected final Checksum checksum;

        /*
         * WARNING - void declaration
         */
        SlowByteBufChecksum(Checksum checksum) {
            void var1_1;
            this.checksum = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void update(int b) {
            void var1_1;
            this.checksum.update((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void update(byte[] b, int off, int len) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.checksum.update((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        @Override
        public long getValue() {
            return this.checksum.getValue();
        }

        @Override
        public void reset() {
            this.checksum.reset();
        }
    }

    private static final class ReflectiveByteBufChecksum
    extends SlowByteBufChecksum {
        private final Method method;

        /*
         * WARNING - void declaration
         */
        ReflectiveByteBufChecksum(Checksum checksum, Method method) {
            super((Checksum)var1_1);
            void var2_2;
            void var1_1;
            this.method = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void update(ByteBuf b, int off, int len) {
            if (b.hasArray()) {
                this.update(b.array(), b.arrayOffset() + off, len);
                return;
            }
            try {
                void var3_3;
                void var2_2;
                void var1_1;
                this.method.invoke((Object)this.checksum, CompressionUtil.safeNioBuffer((ByteBuf)var1_1, (int)var2_2, (int)var3_3));
                return;
            }
            catch (Throwable throwable) {
                throw new Error();
            }
        }
    }

    private static class ZlibChecksumMethods {
        private static final Method ADLER32_UPDATE_METHOD = ByteBufChecksum.access$000(new Adler32());
        private static final Method CRC32_UPDATE_METHOD = ByteBufChecksum.access$000(new CRC32());

        private ZlibChecksumMethods() {
        }
    }
}

