/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.aayushatharva.brotli4j.encoder.BrotliEncoderChannel;
import com.aayushatharva.brotli4j.encoder.Encoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.BrotliOptions;
import io.netty.handler.codec.compression.CompressionUtil;
import io.netty.handler.codec.compression.EncoderUtil;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;

@ChannelHandler.Sharable
public final class BrotliEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final AttributeKey<Writer> ATTR = AttributeKey.valueOf((String)"BrotliEncoderWriter");
    private final Encoder.Parameters parameters;
    private final boolean isSharable;
    private Writer writer;

    public BrotliEncoder() {
        this(BrotliOptions.DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    public BrotliEncoder(BrotliOptions brotliOptions) {
        this(var1_1.parameters());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BrotliEncoder(Encoder.Parameters parameters) {
        this((Encoder.Parameters)var1_1, true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BrotliEncoder(Encoder.Parameters parameters, boolean isSharable) {
        void var2_2;
        void var1_1;
        this.parameters = (Encoder.Parameters)ObjectUtil.checkNotNull((Object)var1_1, (String)"Parameters");
        this.isSharable = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        Writer writer = new Writer(this.parameters, ctx);
        if (this.isSharable) {
            ctx.channel().attr(ATTR).set((Object)writer);
        } else {
            void var2_2;
            this.writer = var2_2;
        }
        super.handlerAdded((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.finish(ctx);
        super.handlerRemoved((ChannelHandlerContext)var1_1);
    }

    @Override
    protected final void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg, boolean preferDirect) throws Exception {
        void var1_1;
        void var3_3;
        void var2_2;
        if (!msg.isReadable()) {
            return Unpooled.EMPTY_BUFFER;
        }
        Writer writer = this.isSharable ? (Writer)ctx.channel().attr(ATTR).get() : this.writer;
        if (writer == null) {
            return Unpooled.EMPTY_BUFFER;
        }
        Writer.access$100(writer, (ByteBuf)var2_2, (boolean)var3_3);
        return ((Writer)var1_1).writableBuffer;
    }

    public final boolean isSharable() {
        return this.isSharable;
    }

    /*
     * WARNING - void declaration
     */
    public final void finish(ChannelHandlerContext ctx) throws IOException {
        void var1_1;
        void v0 = var1_1;
        this.finishEncode((ChannelHandlerContext)v0, v0.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture finishEncode(ChannelHandlerContext ctx, ChannelPromise promise) throws IOException {
        void var2_2;
        Writer writer = this.isSharable ? (Writer)ctx.channel().attr(ATTR).getAndSet(null) : this.writer;
        if (writer != null) {
            void var1_1;
            var1_1.close();
            this.writer = null;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var3_3;
        void var1_1;
        ChannelHandlerContext channelHandlerContext = ctx;
        ChannelFuture f = this.finishEncode(channelHandlerContext, channelHandlerContext.newPromise());
        EncoderUtil.closeAfterFinishEncode((ChannelHandlerContext)var1_1, (ChannelFuture)var3_3, (ChannelPromise)var2_2);
    }

    private static final class Writer
    implements WritableByteChannel {
        private ByteBuf writableBuffer;
        private final BrotliEncoderChannel brotliEncoderChannel;
        private final ChannelHandlerContext ctx;
        private boolean isClosed;

        /*
         * WARNING - void declaration
         */
        private Writer(Encoder.Parameters parameters, ChannelHandlerContext ctx) throws IOException {
            void var2_2;
            void var1_1;
            this.brotliEncoderChannel = new BrotliEncoderChannel((WritableByteChannel)this, (Encoder.Parameters)var1_1);
            this.ctx = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private void encode(ByteBuf msg, boolean preferDirect) throws Exception {
            try {
                void var3_5;
                this.allocate(preferDirect);
                ByteBuffer nioBuffer = CompressionUtil.safeReadableNioBuffer(msg);
                int position = nioBuffer.position();
                this.brotliEncoderChannel.write(nioBuffer);
                msg.skipBytes(nioBuffer.position() - var3_5);
                this.brotliEncoderChannel.flush();
                return;
            }
            catch (Exception e) {
                void var2_4;
                void var1_1;
                ReferenceCountUtil.release((Object)var1_1);
                throw var2_4;
            }
        }

        private void allocate(boolean preferDirect) {
            if (preferDirect) {
                this.writableBuffer = this.ctx.alloc().ioBuffer();
                return;
            }
            this.writableBuffer = this.ctx.alloc().buffer();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int write(ByteBuffer src) throws IOException {
            void var1_1;
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            return this.writableBuffer.writeBytes((ByteBuffer)var1_1).readableBytes();
        }

        @Override
        public final boolean isOpen() {
            return !this.isClosed;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void close() {
            void var1_1;
            ChannelPromise promise = this.ctx.newPromise();
            this.ctx.executor().execute(new Runnable(this, (ChannelPromise)var1_1){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ Writer this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    try {
                        this.this$0.finish(this.val$promise);
                        return;
                    }
                    catch (IOException ex) {
                        void var1_1;
                        this.val$promise.setFailure((Throwable)new IllegalStateException("Failed to finish encoding", (Throwable)var1_1));
                        return;
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        public final void finish(ChannelPromise promise) throws IOException {
            if (!this.isClosed) {
                void var1_1;
                this.allocate(true);
                try {
                    this.brotliEncoderChannel.close();
                    this.isClosed = true;
                }
                catch (Exception ex) {
                    void var2_2;
                    promise.setFailure((Throwable)var2_2);
                    ReferenceCountUtil.release((Object)this.writableBuffer);
                    return;
                }
                this.ctx.writeAndFlush((Object)this.writableBuffer, (ChannelPromise)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$100(Writer x0, ByteBuf x1, boolean x2) throws Exception {
            void var2_2;
            void var1_1;
            x0.encode((ByteBuf)var1_1, (boolean)var2_2);
        }
    }
}

