/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.aayushatharva.brotli4j.decoder.DecoderJNI;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteBuffer;
import java.util.List;

public final class BrotliDecoder
extends ByteToMessageDecoder {
    private final int inputBufferSize;
    private DecoderJNI.Wrapper decoder;
    private boolean destroyed;

    public BrotliDecoder() {
        this(8192);
    }

    /*
     * WARNING - void declaration
     */
    public BrotliDecoder(int inputBufferSize) {
        void var1_1;
        this.inputBufferSize = ObjectUtil.checkPositive((int)var1_1, (String)"inputBufferSize");
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuf pull(ByteBufAllocator alloc) {
        void var1_1;
        void var2_2;
        ByteBuffer nativeBuffer = this.decoder.pull();
        ByteBuf copy = alloc.buffer(nativeBuffer.remaining());
        copy.writeBytes((ByteBuffer)var2_2);
        return var1_1;
    }

    private State decompress(ByteBuf input, List<Object> output, ByteBufAllocator alloc) {
        block6: while (true) {
            switch (this.decoder.getStatus()) {
                case DONE: {
                    return State.DONE;
                }
                case OK: {
                    this.decoder.push(0);
                    continue block6;
                }
                case NEEDS_MORE_INPUT: {
                    if (this.decoder.hasOutput()) {
                        output.add(this.pull(alloc));
                    }
                    if (!input.isReadable()) {
                        return State.NEEDS_MORE_INPUT;
                    }
                    ByteBuffer decoderInputBuffer = this.decoder.getInputBuffer();
                    decoderInputBuffer.clear();
                    int readBytes = BrotliDecoder.readBytes(input, decoderInputBuffer);
                    this.decoder.push(readBytes);
                    continue block6;
                }
                case NEEDS_MORE_OUTPUT: {
                    output.add(this.pull(alloc));
                    continue block6;
                }
            }
            break;
        }
        return State.ERROR;
    }

    /*
     * WARNING - void declaration
     */
    private static int readBytes(ByteBuf in, ByteBuffer dest) {
        void var2_2;
        void var1_1;
        void var3_3;
        ByteBuf byteBuf;
        int limit = Math.min(in.readableBytes(), dest.remaining());
        ByteBuffer slice = dest.slice();
        slice.limit(limit);
        byteBuf.readBytes((ByteBuffer)var3_3);
        void v0 = var1_1;
        v0.position(v0.position() + limit);
        return (int)var2_2;
    }

    public final void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.decoder = new DecoderJNI.Wrapper(this.inputBufferSize);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (this.destroyed) {
            ByteBuf byteBuf = in;
            byteBuf.skipBytes(byteBuf.readableBytes());
            return;
        }
        if (!in.isReadable()) {
            return;
        }
        try {
            void var3_4;
            void var2_3;
            State state = this.decompress((ByteBuf)var2_3, (List<Object>)var3_4, ctx.alloc());
            if (state != State.DONE) {
                if (state == State.ERROR) {
                    throw new DecompressionException("Brotli stream corrupted");
                }
                return;
            }
            this.destroy();
        }
        catch (Exception e) {
            void var1_2;
            this.destroy();
            throw var1_2;
        }
    }

    private void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.decoder.destroy();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        try {
            this.destroy();
        }
        catch (Throwable throwable) {
            void var1_1;
            super.handlerRemoved0((ChannelHandlerContext)var1_1);
            throw throwable;
        }
        super.handlerRemoved0(ctx);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            this.destroy();
        }
        catch (Throwable throwable) {
            void var1_1;
            super.channelInactive((ChannelHandlerContext)var1_1);
            throw throwable;
        }
        super.channelInactive(ctx);
    }

    /*
     * WARNING - void declaration
     */
    static {
        try {
            Brotli.ensureAvailability();
            return;
        }
        catch (Throwable throwable) {
            void var0;
            throw new ExceptionInInitializerError((Throwable)var0);
        }
    }

    private static enum State {
        DONE,
        NEEDS_MORE_INPUT,
        ERROR;

    }
}

