/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.base64;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.base64.Base64Dialect;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteOrder;

public final class Base64 {
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    private static byte[] alphabet(Base64Dialect dialect) {
        return ((Base64Dialect)((Object)ObjectUtil.checkNotNull((Object)((Object)dialect), (String)"dialect"))).alphabet;
    }

    private static byte[] decodabet(Base64Dialect dialect) {
        return ((Base64Dialect)((Object)ObjectUtil.checkNotNull((Object)((Object)dialect), (String)"dialect"))).decodabet;
    }

    private static boolean breakLines(Base64Dialect dialect) {
        return ((Base64Dialect)((Object)ObjectUtil.checkNotNull((Object)((Object)dialect), (String)"dialect"))).breakLinesByDefault;
    }

    public static ByteBuf encode(ByteBuf src) {
        return Base64.encode(src, Base64Dialect.STANDARD);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf encode(ByteBuf src, Base64Dialect dialect) {
        void var1_1;
        return Base64.encode(src, Base64.breakLines(dialect), (Base64Dialect)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf encode(ByteBuf src, boolean breakLines) {
        void var1_1;
        return Base64.encode(src, (boolean)var1_1, Base64Dialect.STANDARD);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf encode(ByteBuf src, boolean breakLines, Base64Dialect dialect) {
        void var1_2;
        ByteBuf byteBuf;
        void var2_3;
        ObjectUtil.checkNotNull((Object)src, (String)"src");
        ByteBuf byteBuf2 = src;
        ByteBuf dest = Base64.encode(byteBuf2, byteBuf2.readerIndex(), src.readableBytes(), breakLines, (Base64Dialect)var2_3);
        ByteBuf byteBuf3 = byteBuf;
        byteBuf3.readerIndex(byteBuf3.writerIndex());
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf encode(ByteBuf src, int off, int len) {
        void var2_2;
        void var1_1;
        return Base64.encode(src, (int)var1_1, (int)var2_2, Base64Dialect.STANDARD);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf encode(ByteBuf src, int off, int len, Base64Dialect dialect) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Base64.encode(src, (int)var1_1, (int)var2_2, Base64.breakLines(dialect), (Base64Dialect)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf encode(ByteBuf src, int off, int len, boolean breakLines) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Base64.encode(src, (int)var1_1, (int)var2_2, (boolean)var3_3, Base64Dialect.STANDARD);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf encode(ByteBuf src, int off, int len, boolean breakLines, Base64Dialect dialect) {
        ByteBuf byteBuf;
        void var3_3;
        void var2_2;
        void var1_1;
        return Base64.encode(src, (int)var1_1, (int)var2_2, (boolean)var3_3, dialect, byteBuf.alloc());
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf encode(ByteBuf src, int off, int len, boolean breakLines, Base64Dialect dialect, ByteBufAllocator allocator) {
        ObjectUtil.checkNotNull((Object)src, (String)"src");
        ObjectUtil.checkNotNull((Object)((Object)dialect), (String)"dialect");
        ByteBuf dest = allocator.buffer(Base64.encodedBufferSize(len, breakLines)).order(src.order());
        byte[] alphabet = Base64.alphabet(dialect);
        int d = 0;
        int e = 0;
        int len2 = len - 2;
        int lineLength = 0;
        while (d < len2) {
            Base64.encode3to4(src, d + off, 3, dest, e, alphabet);
            if (breakLines && (lineLength += 4) == 76) {
                dest.setByte(e + 4, 10);
                ++e;
                lineLength = 0;
            }
            d += 3;
            e += 4;
        }
        if (d < len) {
            void var2_2;
            void var1_1;
            ByteBuf byteBuf;
            Base64.encode3to4(byteBuf, d + var1_1, (int)(var2_2 - d), dest, e, alphabet);
            e += 4;
        }
        if (e > 1 && dest.getByte(e - 1) == 10) {
            --e;
        }
        return dest.slice(0, e);
    }

    /*
     * WARNING - void declaration
     */
    private static void encode3to4(ByteBuf src2, int srcOffset, int numSigBytes, ByteBuf dest, int destOffset, byte[] alphabet) {
        void var3_5;
        void var2_4;
        int n;
        if (src2.order() == ByteOrder.BIG_ENDIAN) {
            int n2;
            switch (numSigBytes) {
                case 1: {
                    n2 = Base64.toInt(src2.getByte(srcOffset));
                    break;
                }
                case 2: {
                    n2 = Base64.toIntBE(src2.getShort(srcOffset));
                    break;
                }
                default: {
                    n2 = numSigBytes <= 0 ? 0 : Base64.toIntBE(src2.getMedium(srcOffset));
                }
            }
            int src2 = n2;
            Base64.encode3to4BigEndian(n2, numSigBytes, dest, destOffset, alphabet);
            return;
        }
        switch (numSigBytes) {
            case 1: {
                ByteBuf src2;
                n = Base64.toInt(src2.getByte(srcOffset));
                break;
            }
            case 2: {
                ByteBuf src2;
                n = Base64.toIntLE(src2.getShort(srcOffset));
                break;
            }
            default: {
                void var1_3;
                ByteBuf byteBuf;
                n = numSigBytes <= 0 ? 0 : Base64.toIntLE(byteBuf.getMedium((int)var1_3));
            }
        }
        int n3 = n;
        Base64.encode3to4LittleEndian(n, (int)var2_4, (ByteBuf)var3_5, destOffset, alphabet);
    }

    /*
     * WARNING - void declaration
     */
    static int encodedBufferSize(int len, boolean breakLines) {
        void var1_1;
        long len43 = ((long)len << 2) / 3L;
        long ret = len43 + 3L & 0xFFFFFFFFFFFFFFFCL;
        if (var1_1 != false) {
            void var2_2;
            ret += var2_2 / 76L;
        }
        if (ret < Integer.MAX_VALUE) {
            return (int)ret;
        }
        return Integer.MAX_VALUE;
    }

    private static int toInt(byte value) {
        return (value & 0xFF) << 16;
    }

    private static int toIntBE(short value) {
        short s;
        return (value & 0xFF00) << 8 | (s & 0xFF) << 8;
    }

    private static int toIntLE(short value) {
        short s;
        return (value & 0xFF) << 16 | s & 0xFF00;
    }

    private static int toIntBE(int mediumValue) {
        int n;
        return mediumValue & 0xFF0000 | mediumValue & 0xFF00 | n & 0xFF;
    }

    private static int toIntLE(int mediumValue) {
        int n;
        return (mediumValue & 0xFF) << 16 | mediumValue & 0xFF00 | n >>> 16 & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    private static void encode3to4BigEndian(int inBuff, int numSigBytes, ByteBuf dest, int destOffset, byte[] alphabet) {
        switch (numSigBytes) {
            case 3: {
                dest.setInt(destOffset, alphabet[inBuff >>> 18] << 24 | alphabet[inBuff >>> 12 & 0x3F] << 16 | alphabet[inBuff >>> 6 & 0x3F] << 8 | alphabet[inBuff & 0x3F]);
                return;
            }
            case 2: {
                dest.setInt(destOffset, alphabet[inBuff >>> 18] << 24 | alphabet[inBuff >>> 12 & 0x3F] << 16 | alphabet[inBuff >>> 6 & 0x3F] << 8 | 0x3D);
                return;
            }
            case 1: {
                int n;
                void var3_3;
                void var2_2;
                var2_2.setInt((int)var3_3, alphabet[inBuff >>> 18] << 24 | alphabet[n >>> 12 & 0x3F] << 16 | 0x3D00 | 0x3D);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void encode3to4LittleEndian(int inBuff, int numSigBytes, ByteBuf dest, int destOffset, byte[] alphabet) {
        switch (numSigBytes) {
            case 3: {
                dest.setInt(destOffset, alphabet[inBuff >>> 18] | alphabet[inBuff >>> 12 & 0x3F] << 8 | alphabet[inBuff >>> 6 & 0x3F] << 16 | alphabet[inBuff & 0x3F] << 24);
                return;
            }
            case 2: {
                dest.setInt(destOffset, alphabet[inBuff >>> 18] | alphabet[inBuff >>> 12 & 0x3F] << 8 | alphabet[inBuff >>> 6 & 0x3F] << 16 | 0x3D000000);
                return;
            }
            case 1: {
                int n;
                void var3_3;
                void var2_2;
                var2_2.setInt((int)var3_3, alphabet[inBuff >>> 18] | alphabet[n >>> 12 & 0x3F] << 8 | 0x3D0000 | 0x3D000000);
            }
        }
    }

    public static ByteBuf decode(ByteBuf src) {
        return Base64.decode(src, Base64Dialect.STANDARD);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf decode(ByteBuf src, Base64Dialect dialect) {
        void var1_1;
        ByteBuf byteBuf;
        ObjectUtil.checkNotNull((Object)src, (String)"src");
        ByteBuf byteBuf2 = src;
        ByteBuf dest = Base64.decode(byteBuf2, byteBuf2.readerIndex(), src.readableBytes(), dialect);
        ByteBuf byteBuf3 = byteBuf;
        byteBuf3.readerIndex(byteBuf3.writerIndex());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf decode(ByteBuf src, int off, int len) {
        void var2_2;
        void var1_1;
        return Base64.decode(src, (int)var1_1, (int)var2_2, Base64Dialect.STANDARD);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf decode(ByteBuf src, int off, int len, Base64Dialect dialect) {
        ByteBuf byteBuf;
        void var3_3;
        void var2_2;
        void var1_1;
        return Base64.decode(src, (int)var1_1, (int)var2_2, (Base64Dialect)var3_3, byteBuf.alloc());
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuf decode(ByteBuf src, int off, int len, Base64Dialect dialect, ByteBufAllocator allocator) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteBuf byteBuf;
        ObjectUtil.checkNotNull((Object)src, (String)"src");
        ObjectUtil.checkNotNull((Object)((Object)dialect), (String)"dialect");
        return new Decoder().decode(byteBuf, (int)var1_1, (int)var2_2, allocator, (Base64Dialect)var3_3);
    }

    static int decodedBufferSize(int len) {
        int n = len;
        return n - (n >>> 2);
    }

    private Base64() {
    }

    private static final class Decoder
    implements ByteProcessor {
        private final byte[] b4 = new byte[4];
        private int b4Posn;
        private byte[] decodabet;
        private int outBuffPosn;
        private ByteBuf dest;

        private Decoder() {
        }

        /*
         * WARNING - void declaration
         */
        final ByteBuf decode(ByteBuf src, int off, int len, ByteBufAllocator allocator, Base64Dialect dialect) {
            this.dest = allocator.buffer(Base64.decodedBufferSize(len)).order(src.order());
            this.decodabet = Base64.decodabet(dialect);
            try {
                void var3_4;
                void var2_3;
                src.forEachByte((int)var2_3, (int)var3_4, (ByteProcessor)this);
                return this.dest.slice(0, this.outBuffPosn);
            }
            catch (Throwable cause) {
                void var1_2;
                this.dest.release();
                PlatformDependent.throwException((Throwable)var1_2);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final boolean process(byte value) throws Exception {
            void var1_1;
            byte sbiDecode;
            if (value > 0 && (sbiDecode = this.decodabet[value]) >= -5) {
                void var2_2;
                if (var2_2 >= -1) {
                    this.b4[this.b4Posn++] = value;
                    if (this.b4Posn > 3) {
                        this.outBuffPosn += Decoder.decode4to3(this.b4, this.dest, this.outBuffPosn, this.decodabet);
                        this.b4Posn = 0;
                        return value != 61;
                    }
                }
                return true;
            }
            throw new IllegalArgumentException("invalid Base64 input character: " + (short)(var1_1 & 0xFF) + " (decimal)");
        }

        /*
         * WARNING - void declaration
         */
        private static int decode4to3(byte[] src, ByteBuf dest, int destOffset, byte[] decodabet) {
            void var0_2;
            void var2_4;
            void var1_3;
            int decodedValue;
            byte b1;
            byte[] decodedValue2;
            byte src0 = src[0];
            byte src1 = src[1];
            byte src2 = src[2];
            if (src2 == 61) {
                int decodedValue3;
                try {
                    decodedValue3 = (decodabet[src0] & 0xFF) << 2 | (decodabet[src1] & 0xFF) >>> 4;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalArgumentException("not encoded in Base64");
                }
                dest.setByte(destOffset, decodedValue3);
                return 1;
            }
            byte src3 = decodedValue2[3];
            if (src3 == 61) {
                b1 = decodabet[src1];
                try {
                    decodedValue = dest.order() == ByteOrder.BIG_ENDIAN ? ((decodabet[src0] & 0x3F) << 2 | (b1 & 0xF0) >> 4) << 8 | (b1 & 0xF) << 4 | (decodabet[src2] & 0xFC) >>> 2 : (decodabet[src0] & 0x3F) << 2 | (b1 & 0xF0) >> 4 | ((b1 & 0xF) << 4 | (decodabet[src2] & 0xFC) >>> 2) << 8;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalArgumentException("not encoded in Base64");
                }
                dest.setShort(destOffset, decodedValue);
                return 2;
            }
            try {
                if (dest.order() == ByteOrder.BIG_ENDIAN) {
                    decodedValue = (decodabet[src0] & 0x3F) << 18 | (decodabet[b1] & 0xFF) << 12 | (decodabet[src2] & 0xFF) << 6 | decodabet[decodedValue] & 0xFF;
                } else {
                    void var3_5;
                    b1 = decodabet[b1];
                    byte b2 = decodabet[src2];
                    decodedValue = (decodabet[src0] & 0x3F) << 2 | (b1 & 0xF) << 12 | (b1 & 0xF0) >>> 4 | (b2 & 3) << 22 | (b2 & 0xFC) << 6 | (var3_5[decodedValue] & 0xFF) << 16;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IllegalArgumentException("not encoded in Base64");
            }
            var1_3.setMedium((int)var2_4, (int)var0_2);
            return 3;
        }
    }
}

