/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.util.ByteProcessor;
import io.netty.util.Signal;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

final class ReplayingDecoderByteBuf
extends ByteBuf {
    private static final Signal REPLAY = ReplayingDecoder.REPLAY;
    private ByteBuf buffer;
    private boolean terminated;
    private SwappedByteBuf swapped;
    static final ReplayingDecoderByteBuf EMPTY_BUFFER = new ReplayingDecoderByteBuf(Unpooled.EMPTY_BUFFER);

    ReplayingDecoderByteBuf() {
    }

    /*
     * WARNING - void declaration
     */
    ReplayingDecoderByteBuf(ByteBuf buffer) {
        void var1_1;
        this.setCumulation((ByteBuf)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void setCumulation(ByteBuf buffer) {
        void var1_1;
        this.buffer = var1_1;
    }

    final void terminate() {
        this.terminated = true;
    }

    public final int capacity() {
        if (this.terminated) {
            return this.buffer.capacity();
        }
        return Integer.MAX_VALUE;
    }

    public final ByteBuf capacity(int newCapacity) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int maxCapacity() {
        return this.capacity();
    }

    public final ByteBufAllocator alloc() {
        return this.buffer.alloc();
    }

    public final boolean isReadOnly() {
        return false;
    }

    public final ByteBuf asReadOnly() {
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    public final boolean isDirect() {
        return this.buffer.isDirect();
    }

    public final boolean hasArray() {
        return false;
    }

    public final byte[] array() {
        throw new UnsupportedOperationException();
    }

    public final int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    public final boolean hasMemoryAddress() {
        return false;
    }

    public final long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    public final ByteBuf clear() {
        throw ReplayingDecoderByteBuf.reject();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        return this == var1_1;
    }

    public final int compareTo(ByteBuf buffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf copy() {
        throw ReplayingDecoderByteBuf.reject();
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf copy(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        return this.buffer.copy((int)var1_1, (int)var2_2);
    }

    public final ByteBuf discardReadBytes() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf ensureWritable(int writableBytes) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int ensureWritable(int minWritableBytes, boolean force) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf duplicate() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf retainedDuplicate() {
        throw ReplayingDecoderByteBuf.reject();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean getBoolean(int index) {
        void var1_1;
        this.checkIndex(index, 1);
        return this.buffer.getBoolean((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final byte getByte(int index) {
        void var1_1;
        this.checkIndex(index, 1);
        return this.buffer.getByte((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final short getUnsignedByte(int index) {
        void var1_1;
        this.checkIndex(index, 1);
        return this.buffer.getUnsignedByte((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        this.buffer.getBytes((int)var1_1, (byte[])var2_2, (int)var3_3, length);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf getBytes(int index, byte[] dst) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, dst.length);
        this.buffer.getBytes((int)var1_1, (byte[])var2_2);
        return this;
    }

    public final ByteBuf getBytes(int index, ByteBuffer dst) {
        throw ReplayingDecoderByteBuf.reject();
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        this.buffer.getBytes((int)var1_1, (ByteBuf)var2_2, (int)var3_3, length);
        return this;
    }

    public final ByteBuf getBytes(int index, ByteBuf dst, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf getBytes(int index, ByteBuf dst) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int getBytes(int index, GatheringByteChannel out, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int getBytes(int index, FileChannel out, long position, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf getBytes(int index, OutputStream out, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    /*
     * WARNING - void declaration
     */
    public final int getInt(int index) {
        void var1_1;
        this.checkIndex(index, 4);
        return this.buffer.getInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int getIntLE(int index) {
        void var1_1;
        this.checkIndex(index, 4);
        return this.buffer.getIntLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final long getUnsignedInt(int index) {
        void var1_1;
        this.checkIndex(index, 4);
        return this.buffer.getUnsignedInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final long getUnsignedIntLE(int index) {
        void var1_1;
        this.checkIndex(index, 4);
        return this.buffer.getUnsignedIntLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final long getLong(int index) {
        void var1_1;
        this.checkIndex(index, 8);
        return this.buffer.getLong((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final long getLongLE(int index) {
        void var1_1;
        this.checkIndex(index, 8);
        return this.buffer.getLongLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int getMedium(int index) {
        void var1_1;
        this.checkIndex(index, 3);
        return this.buffer.getMedium((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int getMediumLE(int index) {
        void var1_1;
        this.checkIndex(index, 3);
        return this.buffer.getMediumLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int getUnsignedMedium(int index) {
        void var1_1;
        this.checkIndex(index, 3);
        return this.buffer.getUnsignedMedium((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int getUnsignedMediumLE(int index) {
        void var1_1;
        this.checkIndex(index, 3);
        return this.buffer.getUnsignedMediumLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final short getShort(int index) {
        void var1_1;
        this.checkIndex(index, 2);
        return this.buffer.getShort((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final short getShortLE(int index) {
        void var1_1;
        this.checkIndex(index, 2);
        return this.buffer.getShortLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int getUnsignedShort(int index) {
        void var1_1;
        this.checkIndex(index, 2);
        return this.buffer.getUnsignedShort((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int getUnsignedShortLE(int index) {
        void var1_1;
        this.checkIndex(index, 2);
        return this.buffer.getUnsignedShortLE((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final char getChar(int index) {
        void var1_1;
        this.checkIndex(index, 2);
        return this.buffer.getChar((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final float getFloat(int index) {
        void var1_1;
        this.checkIndex(index, 4);
        return this.buffer.getFloat((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final double getDouble(int index) {
        void var1_1;
        this.checkIndex(index, 8);
        return this.buffer.getDouble((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final CharSequence getCharSequence(int index, int length, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        return this.buffer.getCharSequence((int)var1_1, (int)var2_2, (Charset)var3_3);
    }

    public final int hashCode() {
        throw ReplayingDecoderByteBuf.reject();
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOf(int fromIndex, int toIndex, byte value) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (fromIndex == toIndex) {
            return -1;
        }
        if (Math.max(fromIndex, toIndex) > this.buffer.writerIndex()) {
            throw REPLAY;
        }
        return this.buffer.indexOf((int)var1_1, (int)var2_2, (byte)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final int bytesBefore(byte value) {
        void var1_1;
        int bytes = this.buffer.bytesBefore(value);
        if (bytes < 0) {
            throw REPLAY;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final int bytesBefore(int length, byte value) {
        void var2_2;
        void var1_1;
        ReplayingDecoderByteBuf replayingDecoderByteBuf = this;
        return replayingDecoderByteBuf.bytesBefore(replayingDecoderByteBuf.buffer.readerIndex(), (int)var1_1, (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int bytesBefore(int index, int length, byte value) {
        void var1_1;
        void var3_3;
        int writerIndex = this.buffer.writerIndex();
        if (index >= writerIndex) {
            throw REPLAY;
        }
        if (index <= writerIndex - length) {
            void var2_2;
            return this.buffer.bytesBefore(index, (int)var2_2, value);
        }
        int res = this.buffer.bytesBefore(index, writerIndex - index, (byte)var3_3);
        if (res < 0) {
            throw REPLAY;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final int forEachByte(ByteProcessor processor) {
        void var1_2;
        int ret = this.buffer.forEachByte(processor);
        if (ret < 0) {
            throw REPLAY;
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final int forEachByte(int index, int length, ByteProcessor processor) {
        void var1_1;
        void var3_3;
        int writerIndex = this.buffer.writerIndex();
        if (index >= writerIndex) {
            throw REPLAY;
        }
        if (index <= writerIndex - length) {
            void var2_2;
            return this.buffer.forEachByte(index, (int)var2_2, processor);
        }
        int ret = this.buffer.forEachByte(index, writerIndex - index, (ByteProcessor)var3_3);
        if (ret < 0) {
            throw REPLAY;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final int forEachByteDesc(ByteProcessor processor) {
        if (this.terminated) {
            void var1_1;
            return this.buffer.forEachByteDesc((ByteProcessor)var1_1);
        }
        throw ReplayingDecoderByteBuf.reject();
    }

    /*
     * WARNING - void declaration
     */
    public final int forEachByteDesc(int index, int length, ByteProcessor processor) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (index + length > this.buffer.writerIndex()) {
            throw REPLAY;
        }
        return this.buffer.forEachByteDesc((int)var1_1, (int)var2_2, (ByteProcessor)var3_3);
    }

    public final ByteBuf markReaderIndex() {
        this.buffer.markReaderIndex();
        return this;
    }

    public final ByteBuf markWriterIndex() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteOrder order() {
        return this.buffer.order();
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf order(ByteOrder endianness) {
        void var1_1;
        if (ObjectUtil.checkNotNull((Object)endianness, (String)"endianness") == this.order()) {
            return this;
        }
        SwappedByteBuf swapped = this.swapped;
        if (swapped == null) {
            this.swapped = swapped = new SwappedByteBuf((ByteBuf)this);
        }
        return var1_1;
    }

    public final boolean isReadable() {
        return !this.terminated || this.buffer.isReadable();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isReadable(int size) {
        void var1_1;
        return !this.terminated || this.buffer.isReadable((int)var1_1);
    }

    public final int readableBytes() {
        if (this.terminated) {
            return this.buffer.readableBytes();
        }
        return Integer.MAX_VALUE - this.buffer.readerIndex();
    }

    public final boolean readBoolean() {
        this.checkReadableBytes(1);
        return this.buffer.readBoolean();
    }

    public final byte readByte() {
        this.checkReadableBytes(1);
        return this.buffer.readByte();
    }

    public final short readUnsignedByte() {
        this.checkReadableBytes(1);
        return this.buffer.readUnsignedByte();
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkReadableBytes(length);
        this.buffer.readBytes((byte[])var1_1, (int)var2_2, (int)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf readBytes(byte[] dst) {
        void var1_1;
        this.checkReadableBytes(dst.length);
        this.buffer.readBytes((byte[])var1_1);
        return this;
    }

    public final ByteBuf readBytes(ByteBuffer dst) {
        throw ReplayingDecoderByteBuf.reject();
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf readBytes(ByteBuf dst, int dstIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkReadableBytes(length);
        this.buffer.readBytes((ByteBuf)var1_1, (int)var2_2, (int)var3_3);
        return this;
    }

    public final ByteBuf readBytes(ByteBuf dst, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf readBytes(ByteBuf dst) {
        void var1_1;
        this.checkReadableBytes(dst.writableBytes());
        this.buffer.readBytes((ByteBuf)var1_1);
        return this;
    }

    public final int readBytes(GatheringByteChannel out, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int readBytes(FileChannel out, long position, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf readBytes(int length) {
        void var1_1;
        this.checkReadableBytes(length);
        return this.buffer.readBytes((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf readSlice(int length) {
        void var1_1;
        this.checkReadableBytes(length);
        return this.buffer.readSlice((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf readRetainedSlice(int length) {
        void var1_1;
        this.checkReadableBytes(length);
        return this.buffer.readRetainedSlice((int)var1_1);
    }

    public final ByteBuf readBytes(OutputStream out, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int readerIndex() {
        return this.buffer.readerIndex();
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf readerIndex(int readerIndex) {
        void var1_1;
        this.buffer.readerIndex((int)var1_1);
        return this;
    }

    public final int readInt() {
        this.checkReadableBytes(4);
        return this.buffer.readInt();
    }

    public final int readIntLE() {
        this.checkReadableBytes(4);
        return this.buffer.readIntLE();
    }

    public final long readUnsignedInt() {
        this.checkReadableBytes(4);
        return this.buffer.readUnsignedInt();
    }

    public final long readUnsignedIntLE() {
        this.checkReadableBytes(4);
        return this.buffer.readUnsignedIntLE();
    }

    public final long readLong() {
        this.checkReadableBytes(8);
        return this.buffer.readLong();
    }

    public final long readLongLE() {
        this.checkReadableBytes(8);
        return this.buffer.readLongLE();
    }

    public final int readMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readMedium();
    }

    public final int readMediumLE() {
        this.checkReadableBytes(3);
        return this.buffer.readMediumLE();
    }

    public final int readUnsignedMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readUnsignedMedium();
    }

    public final int readUnsignedMediumLE() {
        this.checkReadableBytes(3);
        return this.buffer.readUnsignedMediumLE();
    }

    public final short readShort() {
        this.checkReadableBytes(2);
        return this.buffer.readShort();
    }

    public final short readShortLE() {
        this.checkReadableBytes(2);
        return this.buffer.readShortLE();
    }

    public final int readUnsignedShort() {
        this.checkReadableBytes(2);
        return this.buffer.readUnsignedShort();
    }

    public final int readUnsignedShortLE() {
        this.checkReadableBytes(2);
        return this.buffer.readUnsignedShortLE();
    }

    public final char readChar() {
        this.checkReadableBytes(2);
        return this.buffer.readChar();
    }

    public final float readFloat() {
        this.checkReadableBytes(4);
        return this.buffer.readFloat();
    }

    public final double readDouble() {
        this.checkReadableBytes(8);
        return this.buffer.readDouble();
    }

    /*
     * WARNING - void declaration
     */
    public final CharSequence readCharSequence(int length, Charset charset) {
        void var2_2;
        void var1_1;
        this.checkReadableBytes(length);
        return this.buffer.readCharSequence((int)var1_1, (Charset)var2_2);
    }

    public final ByteBuf resetReaderIndex() {
        this.buffer.resetReaderIndex();
        return this;
    }

    public final ByteBuf resetWriterIndex() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setBoolean(int index, boolean value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setByte(int index, int value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setBytes(int index, byte[] src) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setBytes(int index, ByteBuffer src) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setBytes(int index, ByteBuf src, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setBytes(int index, ByteBuf src) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int setBytes(int index, InputStream in, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setZero(int index, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int setBytes(int index, ScatteringByteChannel in, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int setBytes(int index, FileChannel in, long position, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setIndex(int readerIndex, int writerIndex) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setInt(int index, int value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setIntLE(int index, int value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setLong(int index, long value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setLongLE(int index, long value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setMedium(int index, int value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setMediumLE(int index, int value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setShort(int index, int value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setShortLE(int index, int value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setChar(int index, int value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setFloat(int index, float value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf setDouble(int index, double value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf skipBytes(int length) {
        void var1_1;
        this.checkReadableBytes(length);
        this.buffer.skipBytes((int)var1_1);
        return this;
    }

    public final ByteBuf slice() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf retainedSlice() {
        throw ReplayingDecoderByteBuf.reject();
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf slice(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        return this.buffer.slice((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf retainedSlice(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        return this.buffer.retainedSlice((int)var1_1, (int)var2_2);
    }

    public final int nioBufferCount() {
        return this.buffer.nioBufferCount();
    }

    public final ByteBuffer nioBuffer() {
        throw ReplayingDecoderByteBuf.reject();
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuffer nioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        return this.buffer.nioBuffer((int)var1_1, (int)var2_2);
    }

    public final ByteBuffer[] nioBuffers() {
        throw ReplayingDecoderByteBuf.reject();
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuffer[] nioBuffers(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        return this.buffer.nioBuffers((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuffer internalNioBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        return this.buffer.internalNioBuffer((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString(int index, int length, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkIndex(index, length);
        return this.buffer.toString((int)var1_1, (int)var2_2, (Charset)var3_3);
    }

    public final String toString(Charset charsetName) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final String toString() {
        return StringUtil.simpleClassName((Object)((Object)this)) + '(' + "ridx=" + this.readerIndex() + ", widx=" + this.writerIndex() + ')';
    }

    public final boolean isWritable() {
        return false;
    }

    public final boolean isWritable(int size) {
        return false;
    }

    public final int writableBytes() {
        return 0;
    }

    public final int maxWritableBytes() {
        return 0;
    }

    public final ByteBuf writeBoolean(boolean value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeByte(int value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeBytes(byte[] src) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeBytes(ByteBuffer src) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeBytes(ByteBuf src, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeBytes(ByteBuf src) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int writeBytes(InputStream in, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int writeBytes(ScatteringByteChannel in, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int writeBytes(FileChannel in, long position, int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeInt(int value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeIntLE(int value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeLong(long value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeLongLE(long value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeMedium(int value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeMediumLE(int value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeZero(int length) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int writerIndex() {
        return this.buffer.writerIndex();
    }

    public final ByteBuf writerIndex(int writerIndex) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeShort(int value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeShortLE(int value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeChar(int value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeFloat(float value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf writeDouble(double value) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int setCharSequence(int index, CharSequence sequence, Charset charset) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int writeCharSequence(CharSequence sequence, Charset charset) {
        throw ReplayingDecoderByteBuf.reject();
    }

    /*
     * WARNING - void declaration
     */
    private void checkIndex(int index, int length) {
        void var2_2;
        if (index + var2_2 > this.buffer.writerIndex()) {
            throw REPLAY;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkReadableBytes(int readableBytes) {
        void var1_1;
        if (this.buffer.readableBytes() < var1_1) {
            throw REPLAY;
        }
    }

    public final ByteBuf discardSomeReadBytes() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final int refCnt() {
        return this.buffer.refCnt();
    }

    public final ByteBuf retain() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf retain(int increment) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf touch() {
        this.buffer.touch();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf touch(Object hint) {
        void var1_1;
        this.buffer.touch((Object)var1_1);
        return this;
    }

    public final boolean release() {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final boolean release(int decrement) {
        throw ReplayingDecoderByteBuf.reject();
    }

    public final ByteBuf unwrap() {
        throw ReplayingDecoderByteBuf.reject();
    }

    private static UnsupportedOperationException reject() {
        return new UnsupportedOperationException("not a replayable operation");
    }

    static {
        EMPTY_BUFFER.terminate();
    }
}

