/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.ReplayingDecoderByteBuf;
import io.netty.util.Signal;
import io.netty.util.internal.StringUtil;
import java.util.List;

public abstract class ReplayingDecoder<S>
extends ByteToMessageDecoder {
    static final Signal REPLAY = Signal.valueOf(ReplayingDecoder.class, (String)"REPLAY");
    private final ReplayingDecoderByteBuf replayable = new ReplayingDecoderByteBuf();
    private S state;
    private int checkpoint = -1;

    protected ReplayingDecoder() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    protected ReplayingDecoder(S initialState) {
        void var1_1;
        this.state = var1_1;
    }

    protected void checkpoint() {
        this.checkpoint = this.internalBuffer().readerIndex();
    }

    /*
     * WARNING - void declaration
     */
    protected void checkpoint(S state) {
        void var1_1;
        this.checkpoint();
        this.state(var1_1);
    }

    protected S state() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    protected S state(S newState) {
        void var2_2;
        void var1_1;
        S oldState = this.state;
        this.state = var1_1;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void channelInputClosed(ChannelHandlerContext ctx, List<Object> out) throws Exception {
        Signal signal;
        try {
            void var2_2;
            this.replayable.terminate();
            if (this.cumulation != null) {
                this.callDecode(ctx, this.internalBuffer(), out);
            } else {
                this.replayable.setCumulation(Unpooled.EMPTY_BUFFER);
            }
            this.decodeLast((ChannelHandlerContext)signal, this.replayable, (List<Object>)var2_2);
            return;
        }
        catch (Signal signal2) {
            signal = signal2;
            signal2.expect(REPLAY);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void callDecode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        this.replayable.setCumulation(in);
        try {
            while (in.isReadable()) {
                int oldReaderIndex = this.checkpoint = in.readerIndex();
                int outSize = out.size();
                if (outSize > 0) {
                    ReplayingDecoder.fireChannelRead(ctx, (List<Object>)out, outSize);
                    out.clear();
                    if (ctx.isRemoved()) return;
                    outSize = 0;
                }
                S oldState = this.state;
                int oldInputLength = in.readableBytes();
                try {
                    this.decodeRemovalReentryProtection(ctx, this.replayable, (List<Object>)out);
                    if (ctx.isRemoved()) {
                        return;
                    }
                    if (outSize == out.size()) {
                        if (oldInputLength != in.readableBytes() || oldState != this.state) continue;
                        throw new DecoderException(StringUtil.simpleClassName(((Object)((Object)this)).getClass()) + ".decode() must consume the inbound data or change its state if it did not decode anything.");
                    }
                }
                catch (Signal signal) {
                    void var1_2;
                    out = signal;
                    signal.expect(REPLAY);
                    if (ctx.isRemoved()) return;
                    int checkpoint = this.checkpoint;
                    if (checkpoint < 0) return;
                    in.readerIndex((int)var1_2);
                    return;
                }
                if (oldReaderIndex == in.readerIndex() && oldState == this.state) {
                    throw new DecoderException(StringUtil.simpleClassName(((Object)((Object)this)).getClass()) + ".decode() method must consume the inbound data or change its state if it decoded something.");
                }
                if (this.isSingleDecode()) return;
            }
            return;
        }
        catch (DecoderException decoderException) {
            DecoderException oldReaderIndex = decoderException;
            throw decoderException;
        }
        catch (Exception cause) {
            throw new DecoderException(cause);
        }
    }
}

