/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.CodecOutputList;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.TypeParameterMatcher;
import java.util.List;

public abstract class MessageToMessageEncoder<I>
extends ChannelOutboundHandlerAdapter {
    private final TypeParameterMatcher matcher;

    protected MessageToMessageEncoder() {
        this.matcher = TypeParameterMatcher.find((Object)((Object)this), MessageToMessageEncoder.class, (String)"I");
    }

    /*
     * WARNING - void declaration
     */
    protected MessageToMessageEncoder(Class<? extends I> outboundMessageType) {
        void var1_1;
        this.matcher = TypeParameterMatcher.get((Class)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        void var1_1;
        return this.matcher.match((Object)var1_1);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        CodecOutputList out = null;
        try {
            void cast;
            if (this.acceptOutboundMessage(msg)) {
                out = CodecOutputList.newInstance();
                try {
                    this.encode(ctx, cast, out);
                }
                catch (Throwable th) {
                    ReferenceCountUtil.safeRelease((Object)cast);
                    PlatformDependent.throwException((Throwable)th);
                }
                ReferenceCountUtil.release((Object)cast);
                if (out.isEmpty()) {
                    throw new EncoderException(StringUtil.simpleClassName((Object)((Object)this)) + " must produce at least one message.");
                }
            } else {
                ctx.write((Object)cast, promise);
            }
            if (out == null) return;
        }
        catch (EncoderException encoderException) {
            try {
                EncoderException sizeMinusOne = encoderException;
                throw encoderException;
                catch (Throwable t) {
                    void var2_6;
                    throw new EncoderException((Throwable)var2_6);
                }
            }
            catch (Throwable throwable) {
                if (out == null) throw throwable;
                try {
                    void var3_8;
                    void var1_1;
                    int sizeMinusOne = out.size() - 1;
                    if (sizeMinusOne == 0) {
                        ctx.write(out.getUnsafe(0), promise);
                        throw throwable;
                    }
                    if (sizeMinusOne <= 0) throw throwable;
                    if (promise == ctx.voidPromise()) {
                        MessageToMessageEncoder.writeVoidPromise(ctx, out);
                        throw throwable;
                    }
                    MessageToMessageEncoder.writePromiseCombiner((ChannelHandlerContext)var1_1, out, (ChannelPromise)var3_8);
                    throw throwable;
                }
                finally {
                    out.recycle();
                }
            }
        }
        try {
            int sizeMinusOne = out.size() - 1;
            if (sizeMinusOne == 0) {
                ctx.write(out.getUnsafe(0), promise);
                return;
            }
            if (sizeMinusOne <= 0) return;
            if (promise == ctx.voidPromise()) {
                MessageToMessageEncoder.writeVoidPromise(ctx, out);
                return;
            }
            MessageToMessageEncoder.writePromiseCombiner(ctx, out, promise);
            return;
        }
        finally {
            out.recycle();
        }
    }

    private static void writeVoidPromise(ChannelHandlerContext ctx, CodecOutputList out) {
        ChannelPromise voidPromise = ctx.voidPromise();
        for (int i = 0; i < out.size(); ++i) {
            ctx.write(out.getUnsafe(i), voidPromise);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void writePromiseCombiner(ChannelHandlerContext ctx, CodecOutputList out, ChannelPromise promise) {
        void var2_2;
        void var3_3;
        PromiseCombiner combiner = new PromiseCombiner(ctx.executor());
        for (int i = 0; i < out.size(); ++i) {
            combiner.add((Future)ctx.write(out.getUnsafe(i)));
        }
        var3_3.finish((Promise)var2_2);
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, List<Object> var3) throws Exception;
}

