/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.TypeParameterMatcher;

public abstract class MessageToByteEncoder<I>
extends ChannelOutboundHandlerAdapter {
    private final TypeParameterMatcher matcher;
    private final boolean preferDirect;

    protected MessageToByteEncoder() {
        this(true);
    }

    /*
     * WARNING - void declaration
     */
    protected MessageToByteEncoder(Class<? extends I> outboundMessageType) {
        this((Class<I>)var1_1, true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected MessageToByteEncoder(boolean preferDirect) {
        void var1_1;
        this.matcher = TypeParameterMatcher.find((Object)((Object)this), MessageToByteEncoder.class, (String)"I");
        this.preferDirect = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected MessageToByteEncoder(Class<? extends I> outboundMessageType, boolean preferDirect) {
        void var2_2;
        void var1_1;
        this.matcher = TypeParameterMatcher.get((Class)var1_1);
        this.preferDirect = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        void var1_1;
        return this.matcher.match((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ByteBuf buf = null;
        try {
            EncoderException cast;
            try {
                if (this.acceptOutboundMessage(msg)) {
                    buf = this.allocateBuffer(ctx, cast, this.preferDirect);
                    try {
                        this.encode(ctx, cast, buf);
                    }
                    finally {
                        ReferenceCountUtil.release((Object)cast);
                    }
                    if (buf.isReadable()) {
                        ctx.write((Object)buf, promise);
                    } else {
                        buf.release();
                        ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
                    }
                } else {
                    void var3_6;
                    void var1_1;
                    var1_1.write((Object)cast, (ChannelPromise)var3_6);
                    return;
                }
                buf = null;
            }
            catch (EncoderException encoderException) {
                cast = encoderException;
                throw encoderException;
            }
            catch (Throwable e) {
                void var2_5;
                throw new EncoderException((Throwable)var2_5);
            }
        }
        catch (Throwable throwable) {
            if (buf != null) {
                buf.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, I msg, boolean preferDirect) throws Exception {
        void var1_1;
        if (preferDirect) {
            return ctx.alloc().ioBuffer();
        }
        return var1_1.alloc().heapBuffer();
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, ByteBuf var3) throws Exception;

    protected boolean isPreferDirect() {
        return this.preferDirect;
    }
}

