/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.DecoderResultProvider;
import io.netty.handler.codec.MessageAggregationException;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public abstract class MessageAggregator<I, S, C extends ByteBufHolder, O extends ByteBufHolder>
extends MessageToMessageDecoder<I> {
    private static final int DEFAULT_MAX_COMPOSITEBUFFER_COMPONENTS = 1024;
    private final int maxContentLength;
    private O currentMessage;
    private boolean handlingOversizedMessage;
    private int maxCumulationBufferComponents = 1024;
    private ChannelHandlerContext ctx;
    private ChannelFutureListener continueResponseWriteListener;
    private boolean aggregating;
    private boolean handleIncompleteAggregateDuringClose = true;

    /*
     * WARNING - void declaration
     */
    protected MessageAggregator(int maxContentLength) {
        void var1_1;
        MessageAggregator.validateMaxContentLength(maxContentLength);
        this.maxContentLength = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected MessageAggregator(int maxContentLength, Class<? extends I> inboundMessageType) {
        super(var2_2);
        void var1_1;
        void var2_2;
        MessageAggregator.validateMaxContentLength(maxContentLength);
        this.maxContentLength = var1_1;
    }

    private static void validateMaxContentLength(int maxContentLength) {
        ObjectUtil.checkPositiveOrZero((int)maxContentLength, (String)"maxContentLength");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean acceptInboundMessage(Object msg) throws Exception {
        void var1_1;
        void in;
        if (!super.acceptInboundMessage(msg)) {
            return false;
        }
        if (this.isAggregated(in)) {
            return false;
        }
        if (this.isStartMessage(in)) {
            return true;
        }
        return this.aggregating && this.isContentMessage(var1_1);
    }

    protected abstract boolean isStartMessage(I var1) throws Exception;

    protected abstract boolean isContentMessage(I var1) throws Exception;

    protected abstract boolean isLastContentMessage(C var1) throws Exception;

    protected abstract boolean isAggregated(I var1) throws Exception;

    public final int maxContentLength() {
        return this.maxContentLength;
    }

    public final int maxCumulationBufferComponents() {
        return this.maxCumulationBufferComponents;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMaxCumulationBufferComponents(int maxCumulationBufferComponents) {
        if (maxCumulationBufferComponents < 2) {
            throw new IllegalArgumentException("maxCumulationBufferComponents: " + maxCumulationBufferComponents + " (expected: >= 2)");
        }
        if (this.ctx == null) {
            void var1_1;
            this.maxCumulationBufferComponents = var1_1;
            return;
        }
        throw new IllegalStateException("decoder properties cannot be changed once the decoder is added to a pipeline.");
    }

    @Deprecated
    public final boolean isHandlingOversizedMessage() {
        return this.handlingOversizedMessage;
    }

    protected final ChannelHandlerContext ctx() {
        if (this.ctx == null) {
            throw new IllegalStateException("not added to a pipeline yet");
        }
        return this.ctx;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, I msg, List<Object> out) throws Exception {
        ChannelFuture future;
        if (this.isStartMessage(msg)) {
            this.aggregating = true;
            this.handlingOversizedMessage = false;
            if (this.currentMessage != null) {
                this.currentMessage.release();
                this.currentMessage = null;
                throw new MessageAggregationException();
            }
            I m = msg;
            Object continueResponse = this.newContinueResponse(m, this.maxContentLength, ctx.pipeline());
            if (continueResponse != null) {
                ChannelFutureListener listener = this.continueResponseWriteListener;
                if (listener == null) {
                    this.continueResponseWriteListener = listener = new ChannelFutureListener(this, ctx){
                        final /* synthetic */ ChannelHandlerContext val$ctx;
                        final /* synthetic */ MessageAggregator this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                            this.val$ctx = channelHandlerContext;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (!future.isSuccess()) {
                                void var1_1;
                                this.val$ctx.fireExceptionCaught(var1_1.cause());
                            }
                        }
                    };
                }
                boolean closeAfterWrite = this.closeAfterContinueResponse(continueResponse);
                this.handlingOversizedMessage = this.ignoreContentAfterContinueResponse(continueResponse);
                future = ctx.writeAndFlush(continueResponse).addListener((GenericFutureListener)listener);
                if (closeAfterWrite) {
                    this.handleIncompleteAggregateDuringClose = false;
                    future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    return;
                }
                if (this.handlingOversizedMessage) {
                    return;
                }
            } else if (this.isContentLengthInvalid(m, this.maxContentLength)) {
                this.invokeHandleOversizedMessage(ctx, m);
                return;
            }
            if (m instanceof DecoderResultProvider && !((DecoderResultProvider)m).decoderResult().isSuccess()) {
                O aggregated;
                if (m instanceof ByteBufHolder) {
                    I i = m;
                    aggregated = this.beginAggregation(i, ((ByteBufHolder)i).content().retain());
                } else {
                    aggregated = this.beginAggregation(m, Unpooled.EMPTY_BUFFER);
                }
                this.finishAggregation0(aggregated);
                out.add(aggregated);
                return;
            }
            CompositeByteBuf content = ctx.alloc().compositeBuffer(this.maxCumulationBufferComponents);
            if (m instanceof ByteBufHolder) {
                MessageAggregator.appendPartialContent(content, ((ByteBufHolder)m).content());
            }
            this.currentMessage = this.beginAggregation(m, (ByteBuf)content);
            return;
        }
        if (this.isContentMessage(future)) {
            boolean last;
            if (this.currentMessage == null) {
                return;
            }
            CompositeByteBuf content = (CompositeByteBuf)this.currentMessage.content();
            ByteBufHolder m = (ByteBufHolder)future;
            if (content.readableBytes() > this.maxContentLength - m.content().readableBytes()) {
                void var1_1;
                O s = this.currentMessage;
                this.invokeHandleOversizedMessage((ChannelHandlerContext)var1_1, s);
                return;
            }
            MessageAggregator.appendPartialContent(content, m.content());
            MessageAggregator messageAggregator = this;
            messageAggregator.aggregate(messageAggregator.currentMessage, m);
            if (m instanceof DecoderResultProvider) {
                DecoderResult decoderResult = ((DecoderResultProvider)m).decoderResult();
                if (!decoderResult.isSuccess()) {
                    if (this.currentMessage instanceof DecoderResultProvider) {
                        ((DecoderResultProvider)this.currentMessage).setDecoderResult(DecoderResult.failure(decoderResult.cause()));
                    }
                    last = true;
                } else {
                    last = this.isLastContentMessage(m);
                }
            } else {
                void var2_2;
                last = this.isLastContentMessage(var2_2);
            }
            if (last) {
                void var3_3;
                MessageAggregator messageAggregator2 = this;
                messageAggregator2.finishAggregation0(messageAggregator2.currentMessage);
                var3_3.add(this.currentMessage);
                this.currentMessage = null;
            }
            return;
        }
        throw new MessageAggregationException();
    }

    /*
     * WARNING - void declaration
     */
    private static void appendPartialContent(CompositeByteBuf content, ByteBuf partialContent) {
        if (partialContent.isReadable()) {
            void var1_1;
            CompositeByteBuf compositeByteBuf;
            compositeByteBuf.addComponent(true, var1_1.retain());
        }
    }

    protected abstract boolean isContentLengthInvalid(S var1, int var2) throws Exception;

    protected abstract Object newContinueResponse(S var1, int var2, ChannelPipeline var3) throws Exception;

    protected abstract boolean closeAfterContinueResponse(Object var1) throws Exception;

    protected abstract boolean ignoreContentAfterContinueResponse(Object var1) throws Exception;

    protected abstract O beginAggregation(S var1, ByteBuf var2) throws Exception;

    protected void aggregate(O aggregated, C content) throws Exception {
    }

    /*
     * WARNING - void declaration
     */
    private void finishAggregation0(O aggregated) throws Exception {
        void var1_1;
        this.aggregating = false;
        this.finishAggregation(var1_1);
    }

    protected void finishAggregation(O aggregated) throws Exception {
    }

    /*
     * WARNING - void declaration
     */
    private void invokeHandleOversizedMessage(ChannelHandlerContext ctx, S oversized) throws Exception {
        this.handlingOversizedMessage = true;
        this.currentMessage = null;
        this.handleIncompleteAggregateDuringClose = false;
        try {
            void var1_1;
            this.handleOversizedMessage((ChannelHandlerContext)var1_1, oversized);
        }
        catch (Throwable throwable) {
            void var2_3;
            ReferenceCountUtil.release((Object)var2_3);
            throw throwable;
        }
        ReferenceCountUtil.release(oversized);
    }

    protected void handleOversizedMessage(ChannelHandlerContext ctx, S oversized) throws Exception {
        ctx.fireExceptionCaught((Throwable)new TooLongFrameException("content length exceeded " + this.maxContentLength() + " bytes."));
    }

    /*
     * WARNING - void declaration
     */
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (this.currentMessage != null && !ctx.channel().config().isAutoRead()) {
            ctx.read();
        }
        var1_1.fireChannelReadComplete();
    }

    /*
     * WARNING - void declaration
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.aggregating && this.handleIncompleteAggregateDuringClose) {
            ctx.fireExceptionCaught((Throwable)new PrematureChannelClosureException("Channel closed while still aggregating message"));
        }
        try {
            void var1_1;
            super.channelInactive((ChannelHandlerContext)var1_1);
            return;
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.ctx = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        try {
            void var1_1;
            super.handlerRemoved((ChannelHandlerContext)var1_1);
            return;
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    private void releaseCurrentMessage() {
        if (this.currentMessage != null) {
            this.currentMessage.release();
            this.currentMessage = null;
            this.handlingOversizedMessage = false;
            this.aggregating = false;
        }
    }
}

