/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import java.util.List;

public class LineBasedFrameDecoder
extends ByteToMessageDecoder {
    private final int maxLength;
    private final boolean failFast;
    private final boolean stripDelimiter;
    private boolean discarding;
    private int discardedBytes;
    private int offset;

    /*
     * WARNING - void declaration
     */
    public LineBasedFrameDecoder(int maxLength) {
        this((int)var1_1, true, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LineBasedFrameDecoder(int maxLength, boolean stripDelimiter, boolean failFast) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.maxLength = var1_1;
        this.failFast = var3_3;
        this.stripDelimiter = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        void var2_2;
        Object decoded = this.decode(ctx, (ByteBuf)var2_2);
        if (decoded != null) {
            void var1_1;
            void var3_3;
            var3_3.add(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object decode(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        int eol = this.findEndOfLine(buffer);
        if (!this.discarding) {
            if (eol >= 0) {
                ByteBuf frame;
                int delimLength;
                int length = eol - buffer.readerIndex();
                int n = delimLength = buffer.getByte(eol) == 13 ? 2 : 1;
                if (length > this.maxLength) {
                    buffer.readerIndex(eol + delimLength);
                    this.fail(ctx, length);
                    return null;
                }
                if (this.stripDelimiter) {
                    frame = buffer.readRetainedSlice(length);
                    buffer.skipBytes(delimLength);
                } else {
                    frame = buffer.readRetainedSlice(length + delimLength);
                }
                return frame;
            }
            int length = buffer.readableBytes();
            if (length > this.maxLength) {
                this.discardedBytes = length;
                ByteBuf byteBuf = buffer;
                byteBuf.readerIndex(byteBuf.writerIndex());
                this.discarding = true;
                this.offset = 0;
                if (this.failFast) {
                    this.fail(ctx, "over " + this.discardedBytes);
                }
            }
            return null;
        }
        if (eol >= 0) {
            void var3_3;
            int length = this.discardedBytes + eol - buffer.readerIndex();
            int delimLength = buffer.getByte(eol) == 13 ? 2 : 1;
            buffer.readerIndex((int)(var3_3 + delimLength));
            this.discardedBytes = 0;
            this.discarding = false;
            if (!this.failFast) {
                void var1_1;
                this.fail((ChannelHandlerContext)var1_1, length);
            }
        } else {
            void var2_2;
            this.discardedBytes += buffer.readableBytes();
            void v2 = var2_2;
            v2.readerIndex(v2.writerIndex());
            this.offset = 0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void fail(ChannelHandlerContext ctx, int length) {
        void var2_2;
        void var1_1;
        this.fail((ChannelHandlerContext)var1_1, String.valueOf((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private void fail(ChannelHandlerContext ctx, String length) {
        void var2_2;
        ctx.fireExceptionCaught((Throwable)new TooLongFrameException("frame length (" + (String)var2_2 + ") exceeds the allowed maximum (" + this.maxLength + ')'));
    }

    /*
     * WARNING - void declaration
     */
    private int findEndOfLine(ByteBuf buffer) {
        void var3_3;
        int totalLength = buffer.readableBytes();
        ByteBuf byteBuf = buffer;
        int i = byteBuf.indexOf(byteBuf.readerIndex() + this.offset, buffer.readerIndex() + totalLength, (byte)10);
        if (i >= 0) {
            void var1_1;
            this.offset = 0;
            if (i > 0 && var1_1.getByte(i - 1) == 13) {
                --i;
            }
        } else {
            void var2_2;
            this.offset = var2_2;
        }
        return (int)var3_3;
    }
}

