/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;
import java.util.List;

public class LengthFieldBasedFrameDecoder
extends ByteToMessageDecoder {
    private final ByteOrder byteOrder;
    private final int maxFrameLength;
    private final int lengthFieldOffset;
    private final int lengthFieldLength;
    private final int lengthFieldEndOffset;
    private final int lengthAdjustment;
    private final int initialBytesToStrip;
    private final boolean failFast;
    private boolean discardingTooLongFrame;
    private long tooLongFrameLength;
    private long bytesToDiscard;
    private int frameLengthInt = -1;

    /*
     * WARNING - void declaration
     */
    public LengthFieldBasedFrameDecoder(int maxFrameLength, int lengthFieldOffset, int lengthFieldLength) {
        this((int)var1_1, (int)var2_2, (int)var3_3, 0, 0);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LengthFieldBasedFrameDecoder(int maxFrameLength, int lengthFieldOffset, int lengthFieldLength, int lengthAdjustment, int initialBytesToStrip) {
        this((int)var1_1, (int)var2_2, (int)var3_3, lengthAdjustment, initialBytesToStrip, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LengthFieldBasedFrameDecoder(int maxFrameLength, int lengthFieldOffset, int lengthFieldLength, int lengthAdjustment, int initialBytesToStrip, boolean failFast) {
        this(ByteOrder.BIG_ENDIAN, (int)var1_1, (int)var2_2, (int)var3_3, lengthAdjustment, initialBytesToStrip, failFast);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LengthFieldBasedFrameDecoder(ByteOrder byteOrder, int maxFrameLength, int lengthFieldOffset, int lengthFieldLength, int lengthAdjustment, int initialBytesToStrip, boolean failFast) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.byteOrder = (ByteOrder)ObjectUtil.checkNotNull((Object)var1_1, (String)"byteOrder");
        ObjectUtil.checkPositive((int)maxFrameLength, (String)"maxFrameLength");
        ObjectUtil.checkPositiveOrZero((int)lengthFieldOffset, (String)"lengthFieldOffset");
        ObjectUtil.checkPositiveOrZero((int)initialBytesToStrip, (String)"initialBytesToStrip");
        if (lengthFieldOffset > maxFrameLength - lengthFieldLength) {
            throw new IllegalArgumentException("maxFrameLength (" + maxFrameLength + ") must be equal to or greater than lengthFieldOffset (" + lengthFieldOffset + ") + lengthFieldLength (" + lengthFieldLength + ").");
        }
        this.maxFrameLength = var2_2;
        this.lengthFieldOffset = lengthFieldOffset;
        this.lengthFieldLength = lengthFieldLength;
        this.lengthAdjustment = lengthAdjustment;
        this.lengthFieldEndOffset = var3_3 + lengthFieldLength;
        this.initialBytesToStrip = initialBytesToStrip;
        this.failFast = failFast;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        void var2_2;
        Object decoded = this.decode(ctx, (ByteBuf)var2_2);
        if (decoded != null) {
            void var1_1;
            void var3_3;
            var3_3.add(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void discardingTooLongFrame(ByteBuf in) {
        void var2_2;
        void var1_1;
        long bytesToDiscard = this.bytesToDiscard;
        int localBytesToDiscard = (int)Math.min(bytesToDiscard, (long)in.readableBytes());
        var1_1.skipBytes(localBytesToDiscard);
        bytesToDiscard -= (long)localBytesToDiscard;
        this.bytesToDiscard = var2_2;
        this.failIfNecessary(false);
    }

    /*
     * WARNING - void declaration
     */
    private static void failOnNegativeLengthField(ByteBuf in, long frameLength, int lengthFieldEndOffset) {
        void var1_1;
        void var3_2;
        in.skipBytes((int)var3_2);
        throw new CorruptedFrameException("negative pre-adjustment length field: " + (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void failOnFrameLengthLessThanLengthFieldEndOffset(ByteBuf in, long frameLength, int lengthFieldEndOffset) {
        void var3_2;
        void var1_1;
        in.skipBytes(lengthFieldEndOffset);
        throw new CorruptedFrameException("Adjusted frame length (" + (long)var1_1 + ") is less than lengthFieldEndOffset: " + (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    private void exceededFrameLength(ByteBuf in, long frameLength) {
        long discard = frameLength - (long)in.readableBytes();
        this.tooLongFrameLength = frameLength;
        if (discard < 0L) {
            void var2_2;
            in.skipBytes((int)var2_2);
        } else {
            void var1_1;
            this.discardingTooLongFrame = true;
            this.bytesToDiscard = discard;
            void v0 = var1_1;
            v0.skipBytes(v0.readableBytes());
        }
        this.failIfNecessary(true);
    }

    /*
     * WARNING - void declaration
     */
    private static void failOnFrameLengthLessThanInitialBytesToStrip(ByteBuf in, long frameLength, int initialBytesToStrip) {
        void var3_2;
        void var1_1;
        in.skipBytes((int)frameLength);
        throw new CorruptedFrameException("Adjusted frame length (" + (long)var1_1 + ") is less than initialBytesToStrip: " + (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        void var1_1;
        void var3_5;
        void var2_2;
        long actualLengthFieldOffset22;
        long frameLength = 0L;
        if (this.frameLengthInt == -1) {
            if (this.discardingTooLongFrame) {
                this.discardingTooLongFrame(in);
            }
            if (in.readableBytes() < this.lengthFieldEndOffset) {
                return null;
            }
            int actualLengthFieldOffset22 = in.readerIndex() + this.lengthFieldOffset;
            actualLengthFieldOffset22 = this.getUnadjustedFrameLength(in, actualLengthFieldOffset22, this.lengthFieldLength, this.byteOrder);
            if (actualLengthFieldOffset22 < 0L) {
                LengthFieldBasedFrameDecoder.failOnNegativeLengthField(in, actualLengthFieldOffset22, this.lengthFieldEndOffset);
            }
            if ((actualLengthFieldOffset22 += (long)(this.lengthAdjustment + this.lengthFieldEndOffset)) < (long)this.lengthFieldEndOffset) {
                LengthFieldBasedFrameDecoder.failOnFrameLengthLessThanLengthFieldEndOffset(in, actualLengthFieldOffset22, this.lengthFieldEndOffset);
            }
            if (actualLengthFieldOffset22 > (long)this.maxFrameLength) {
                this.exceededFrameLength(in, actualLengthFieldOffset22);
                return null;
            }
            this.frameLengthInt = (int)actualLengthFieldOffset22;
        }
        if (in.readableBytes() < this.frameLengthInt) {
            return null;
        }
        if (this.initialBytesToStrip > this.frameLengthInt) {
            LengthFieldBasedFrameDecoder.failOnFrameLengthLessThanInitialBytesToStrip(in, actualLengthFieldOffset22, this.initialBytesToStrip);
        }
        in.skipBytes(this.initialBytesToStrip);
        int readerIndex = in.readerIndex();
        int actualFrameLength = this.frameLengthInt - this.initialBytesToStrip;
        ByteBuf frame = this.extractFrame(ctx, in, readerIndex, actualFrameLength);
        var2_2.readerIndex((int)(var3_5 + actualFrameLength));
        this.frameLengthInt = -1;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected long getUnadjustedFrameLength(ByteBuf buf, int offset, int length, ByteOrder order) {
        long frameLength;
        void var3_3;
        buf = buf.order(order);
        switch (var3_3) {
            case 1: {
                frameLength = buf.getUnsignedByte(offset);
                break;
            }
            case 2: {
                frameLength = buf.getUnsignedShort(offset);
                break;
            }
            case 3: {
                frameLength = buf.getUnsignedMedium(offset);
                break;
            }
            case 4: {
                frameLength = buf.getUnsignedInt(offset);
                break;
            }
            case 8: {
                void var2_2;
                void var1_1;
                frameLength = var1_1.getLong((int)var2_2);
                break;
            }
            default: {
                throw new DecoderException("unsupported lengthFieldLength: " + this.lengthFieldLength + " (expected: 1, 2, 3, 4, or 8)");
            }
        }
        return frameLength;
    }

    /*
     * WARNING - void declaration
     */
    private void failIfNecessary(boolean firstDetectionOfTooLongFrame) {
        void var1_1;
        if (this.bytesToDiscard == 0L) {
            long tooLongFrameLength = this.tooLongFrameLength;
            this.tooLongFrameLength = 0L;
            this.discardingTooLongFrame = false;
            if (!this.failFast || firstDetectionOfTooLongFrame) {
                void var2_2;
                this.fail((long)var2_2);
            }
            return;
        }
        if (this.failFast && var1_1 != false) {
            LengthFieldBasedFrameDecoder lengthFieldBasedFrameDecoder = this;
            lengthFieldBasedFrameDecoder.fail(lengthFieldBasedFrameDecoder.tooLongFrameLength);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected ByteBuf extractFrame(ChannelHandlerContext ctx, ByteBuf buffer, int index, int length) {
        void var3_3;
        return buffer.retainedSlice((int)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    private void fail(long frameLength) {
        if (frameLength > 0L) {
            void var1_1;
            throw new TooLongFrameException("Adjusted frame length exceeds " + this.maxFrameLength + ": " + (long)var1_1 + " - discarded");
        }
        throw new TooLongFrameException("Adjusted frame length exceeds " + this.maxFrameLength + " - discarding");
    }
}

