/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.Headers;
import io.netty.util.internal.ObjectUtil;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class HeadersUtils {
    private HeadersUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> List<String> getAllAsString(Headers<K, V, ?> headers, K name) {
        Iterable iterable;
        void var1_1;
        Iterable allNames = headers.getAll(var1_1);
        return new AbstractList<String>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final String get(int index) {
                Object value = iterable.get(index);
                if (value != null) {
                    void var1_2;
                    return var1_2.toString();
                }
                return null;
            }

            @Override
            public final int size() {
                return iterable.size();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> String getAsString(Headers<K, V, ?> headers, K name) {
        void var1_1;
        Headers<K, V, Object> orig = headers.get(var1_1);
        if (orig != null) {
            Headers<K, V, Object> headers2;
            return headers2.toString();
        }
        return null;
    }

    public static Iterator<Map.Entry<String, String>> iteratorAsString(Iterable<Map.Entry<CharSequence, CharSequence>> headers) {
        Iterable<Map.Entry<CharSequence, CharSequence>> iterable;
        return new StringEntryIterator(iterable.iterator());
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> String toString(Class<?> headersClass, Iterator<Map.Entry<K, V>> headersIt, int size) {
        String string;
        String simpleName = headersClass.getSimpleName();
        if (size == 0) {
            return (String)simpleName + "[]";
        }
        String sb = new StringBuilder(simpleName.length() + 2 + size * 20).append(simpleName).append('[');
        while (headersIt.hasNext()) {
            void var2_3;
            Map.Entry<K, V> header = headersIt.next();
            ((StringBuilder)((Object)sb)).append(header.getKey()).append(": ").append(var2_3.getValue()).append(", ");
        }
        Object object = sb;
        ((StringBuilder)object).setLength(((StringBuilder)object).length() - 2);
        return ((StringBuilder)((Object)string)).append(']').toString();
    }

    public static Set<String> namesAsString(Headers<CharSequence, CharSequence, ?> headers) {
        Headers<CharSequence, CharSequence, ?> headers2;
        return new DelegatingNameSet(headers2);
    }

    private static final class DelegatingNameSet
    extends AbstractCollection<String>
    implements Set<String> {
        private final Headers<CharSequence, CharSequence, ?> headers;

        /*
         * WARNING - void declaration
         */
        DelegatingNameSet(Headers<CharSequence, CharSequence, ?> headers) {
            void var1_1;
            this.headers = (Headers)ObjectUtil.checkNotNull((Object)var1_1, (String)"headers");
        }

        @Override
        public final int size() {
            return this.headers.names().size();
        }

        @Override
        public final boolean isEmpty() {
            return this.headers.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            return this.headers.contains(var1_1.toString());
        }

        @Override
        public final Iterator<String> iterator() {
            return new StringIterator<CharSequence>(this.headers.names().iterator());
        }
    }

    private static final class StringIterator<T>
    implements Iterator<String> {
        private final Iterator<T> iter;

        /*
         * WARNING - void declaration
         */
        StringIterator(Iterator<T> iter) {
            void var1_1;
            this.iter = var1_1;
        }

        @Override
        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String next() {
            T next = this.iter.next();
            if (next != null) {
                void var1_1;
                return var1_1.toString();
            }
            return null;
        }

        @Override
        public final void remove() {
            this.iter.remove();
        }
    }

    private static final class StringEntry
    implements Map.Entry<String, String> {
        private final Map.Entry<CharSequence, CharSequence> entry;
        private String name;
        private String value;

        /*
         * WARNING - void declaration
         */
        StringEntry(Map.Entry<CharSequence, CharSequence> entry) {
            void var1_1;
            this.entry = var1_1;
        }

        @Override
        public final String getKey() {
            if (this.name == null) {
                this.name = this.entry.getKey().toString();
            }
            return this.name;
        }

        @Override
        public final String getValue() {
            if (this.value == null && this.entry.getValue() != null) {
                this.value = this.entry.getValue().toString();
            }
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String setValue(String value) {
            void var2_2;
            void var1_1;
            String old = this.getValue();
            this.entry.setValue((CharSequence)var1_1);
            return var2_2;
        }

        public final String toString() {
            return this.entry.toString();
        }
    }

    private static final class StringEntryIterator
    implements Iterator<Map.Entry<String, String>> {
        private final Iterator<Map.Entry<CharSequence, CharSequence>> iter;

        /*
         * WARNING - void declaration
         */
        StringEntryIterator(Iterator<Map.Entry<CharSequence, CharSequence>> iter) {
            void var1_1;
            this.iter = var1_1;
        }

        @Override
        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public final Map.Entry<String, String> next() {
            return new StringEntry(this.iter.next());
        }

        @Override
        public final void remove() {
            this.iter.remove();
        }
    }
}

