/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public class DelimiterBasedFrameDecoder
extends ByteToMessageDecoder {
    private final ByteBuf[] delimiters;
    private final int maxFrameLength;
    private final boolean stripDelimiter;
    private final boolean failFast;
    private boolean discardingTooLongFrame;
    private int tooLongFrameLength;
    private final LineBasedFrameDecoder lineBasedDecoder;

    /*
     * WARNING - void declaration
     */
    public DelimiterBasedFrameDecoder(int maxFrameLength, ByteBuf delimiter) {
        this((int)var1_1, true, (ByteBuf)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DelimiterBasedFrameDecoder(int maxFrameLength, boolean stripDelimiter, ByteBuf delimiter) {
        this((int)var1_1, (boolean)var2_2, true, (ByteBuf)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DelimiterBasedFrameDecoder(int maxFrameLength, boolean stripDelimiter, boolean failFast, ByteBuf delimiter) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteBuf[] byteBufArray = new ByteBuf[1];
        ByteBuf byteBuf = delimiter;
        byteBufArray[0] = byteBuf.slice(byteBuf.readerIndex(), delimiter.readableBytes());
        this((int)var1_1, (boolean)var2_2, (boolean)var3_3, byteBufArray);
    }

    /*
     * WARNING - void declaration
     */
    public DelimiterBasedFrameDecoder(int maxFrameLength, ByteBuf ... delimiters) {
        this((int)var1_1, true, (ByteBuf[])var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DelimiterBasedFrameDecoder(int maxFrameLength, boolean stripDelimiter, ByteBuf ... delimiters) {
        this((int)var1_1, (boolean)var2_2, true, (ByteBuf[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DelimiterBasedFrameDecoder(int maxFrameLength, boolean stripDelimiter, boolean failFast, ByteBuf ... delimiters) {
        void var3_3;
        void var2_2;
        void var1_1;
        DelimiterBasedFrameDecoder.validateMaxFrameLength(maxFrameLength);
        ObjectUtil.checkNonEmpty((Object[])delimiters, (String)"delimiters");
        if (DelimiterBasedFrameDecoder.isLineBased(delimiters) && !this.isSubclass()) {
            this.lineBasedDecoder = new LineBasedFrameDecoder(maxFrameLength, stripDelimiter, failFast);
            this.delimiters = null;
        } else {
            this.delimiters = new ByteBuf[delimiters.length];
            for (int i = 0; i < delimiters.length; ++i) {
                ByteBuf d = delimiters[i];
                DelimiterBasedFrameDecoder.validateDelimiter(d);
                ByteBuf byteBuf = d;
                this.delimiters[i] = byteBuf.slice(byteBuf.readerIndex(), d.readableBytes());
            }
            this.lineBasedDecoder = null;
        }
        this.maxFrameLength = var1_1;
        this.stripDelimiter = var2_2;
        this.failFast = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isLineBased(ByteBuf[] delimiters) {
        void var2_2;
        void var1_1;
        if (delimiters.length != 2) {
            return false;
        }
        ByteBuf a = delimiters[0];
        ByteBuf b = delimiters[1];
        if (a.capacity() < b.capacity()) {
            ByteBuf[] byteBufArray;
            a = delimiters[1];
            b = byteBufArray[0];
        }
        return a.capacity() == 2 && b.capacity() == 1 && a.getByte(0) == 13 && var1_1.getByte(1) == 10 && var2_2.getByte(0) == 10;
    }

    private boolean isSubclass() {
        return ((Object)((Object)this)).getClass() != DelimiterBasedFrameDecoder.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        void var2_2;
        Object decoded = this.decode(ctx, (ByteBuf)var2_2);
        if (decoded != null) {
            void var1_1;
            void var3_3;
            var3_3.add(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object decode(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        if (this.lineBasedDecoder != null) {
            return this.lineBasedDecoder.decode(ctx, buffer);
        }
        int minFrameLength = Integer.MAX_VALUE;
        ByteBuf minDelim = null;
        ByteBuf[] byteBufArray = this.delimiters;
        int n = this.delimiters.length;
        for (int i = 0; i < n; ++i) {
            ByteBuf delim = byteBufArray[i];
            int frameLength = DelimiterBasedFrameDecoder.indexOf(buffer, delim);
            if (frameLength < 0 || frameLength >= minFrameLength) continue;
            minFrameLength = frameLength;
            minDelim = delim;
        }
        if (minDelim != null) {
            ByteBuf frame;
            void var3_4;
            int minDelimLength = var3_4.capacity();
            if (this.discardingTooLongFrame) {
                this.discardingTooLongFrame = false;
                buffer.skipBytes(minFrameLength + minDelimLength);
                int tooLongFrameLength = this.tooLongFrameLength;
                this.tooLongFrameLength = 0;
                if (!this.failFast) {
                    this.fail(tooLongFrameLength);
                }
                return null;
            }
            if (minFrameLength > this.maxFrameLength) {
                buffer.skipBytes(minFrameLength + minDelimLength);
                this.fail(minFrameLength);
                return null;
            }
            if (this.stripDelimiter) {
                frame = buffer.readRetainedSlice(minFrameLength);
                buffer.skipBytes(minDelimLength);
            } else {
                void var1_2;
                frame = buffer.readRetainedSlice((int)(var1_2 + minDelimLength));
            }
            return frame;
        }
        if (!this.discardingTooLongFrame) {
            if (buffer.readableBytes() > this.maxFrameLength) {
                this.tooLongFrameLength = buffer.readableBytes();
                ByteBuf byteBuf = buffer;
                byteBuf.skipBytes(byteBuf.readableBytes());
                this.discardingTooLongFrame = true;
                if (this.failFast) {
                    DelimiterBasedFrameDecoder delimiterBasedFrameDecoder = this;
                    delimiterBasedFrameDecoder.fail(delimiterBasedFrameDecoder.tooLongFrameLength);
                }
            }
        } else {
            void var2_3;
            this.tooLongFrameLength += buffer.readableBytes();
            void v2 = var2_3;
            v2.skipBytes(v2.readableBytes());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void fail(long frameLength) {
        if (frameLength > 0L) {
            void var1_1;
            throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + ": " + (long)var1_1 + " - discarded");
        }
        throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + " - discarding");
    }

    /*
     * WARNING - void declaration
     */
    private static int indexOf(ByteBuf haystack, ByteBuf needle) {
        ByteBuf byteBuf;
        void var1_2;
        int index = ByteBufUtil.indexOf((ByteBuf)needle, (ByteBuf)haystack);
        if (index == -1) {
            return -1;
        }
        return (int)(var1_2 - byteBuf.readerIndex());
    }

    private static void validateDelimiter(ByteBuf delimiter) {
        ByteBuf byteBuf;
        ObjectUtil.checkNotNull((Object)delimiter, (String)"delimiter");
        if (!byteBuf.isReadable()) {
            throw new IllegalArgumentException("empty delimiter");
        }
    }

    private static void validateMaxFrameLength(int maxFrameLength) {
        ObjectUtil.checkPositive((int)maxFrameLength, (String)"maxFrameLength");
    }
}

