/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.Headers;
import io.netty.handler.codec.HeadersUtils;
import io.netty.handler.codec.ValueConverter;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class DefaultHeaders<K, V, T extends Headers<K, V, T>>
implements Headers<K, V, T> {
    static final int HASH_CODE_SEED = -1028477387;
    private final HeaderEntry<K, V>[] entries;
    protected final HeaderEntry<K, V> head;
    private final byte hashMask;
    private final ValueConverter<V> valueConverter;
    private final NameValidator<K> nameValidator;
    private final ValueValidator<V> valueValidator;
    private final HashingStrategy<K> hashingStrategy;
    int size;

    /*
     * WARNING - void declaration
     */
    public DefaultHeaders(ValueConverter<V> valueConverter) {
        this((HashingStrategy<K>)HashingStrategy.JAVA_HASHER, (ValueConverter<V>)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHeaders(ValueConverter<V> valueConverter, NameValidator<K> nameValidator) {
        this((HashingStrategy<K>)HashingStrategy.JAVA_HASHER, (ValueConverter<V>)var1_1, (NameValidator<K>)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHeaders(HashingStrategy<K> nameHashingStrategy, ValueConverter<V> valueConverter) {
        this((HashingStrategy<K>)var1_1, (ValueConverter<V>)var2_2, NameValidator.NOT_NULL);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHeaders(HashingStrategy<K> nameHashingStrategy, ValueConverter<V> valueConverter, NameValidator<K> nameValidator) {
        this((HashingStrategy<K>)var1_1, (ValueConverter<V>)var2_2, (NameValidator<K>)var3_3, 16);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHeaders(HashingStrategy<K> nameHashingStrategy, ValueConverter<V> valueConverter, NameValidator<K> nameValidator, int arraySizeHint) {
        this((HashingStrategy<K>)var1_1, (ValueConverter<?>)var2_2, (NameValidator<K>)var3_3, arraySizeHint, ValueValidator.NO_VALIDATION);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHeaders(HashingStrategy<K> nameHashingStrategy, ValueConverter<V> valueConverter, NameValidator<K> nameValidator, int arraySizeHint, ValueValidator<V> valueValidator) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.valueConverter = (ValueConverter)ObjectUtil.checkNotNull((Object)var2_2, (String)"valueConverter");
        this.nameValidator = (NameValidator)ObjectUtil.checkNotNull((Object)var3_3, (String)"nameValidator");
        this.hashingStrategy = (HashingStrategy)ObjectUtil.checkNotNull((Object)var1_1, (String)"nameHashingStrategy");
        this.valueValidator = (ValueValidator)ObjectUtil.checkNotNull(valueValidator, (String)"valueValidator");
        this.entries = new HeaderEntry[MathUtil.findNextPositivePowerOfTwo((int)Math.max(2, Math.min(arraySizeHint, 128)))];
        this.hashMask = (byte)(this.entries.length - 1);
        this.head = new HeaderEntry();
    }

    @Override
    public V get(K name) {
        ObjectUtil.checkNotNull(name, (String)"name");
        int h = this.hashingStrategy.hashCode(name);
        int i = this.index(h);
        HeaderEntry<K, V> e = this.entries[i];
        V value = null;
        while (e != null) {
            if (e.hash == h && this.hashingStrategy.equals(name, e.key)) {
                value = e.value;
            }
            e = e.next;
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(K name, V defaultValue) {
        void var1_1;
        V value = this.get(name);
        if (value == null) {
            void var2_2;
            return var2_2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V getAndRemove(K name) {
        void var1_1;
        void var2_2;
        int h = this.hashingStrategy.hashCode(name);
        return this.remove0(h, this.index((int)var2_2), ObjectUtil.checkNotNull((Object)var1_1, (String)"name"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V getAndRemove(K name, V defaultValue) {
        void var1_1;
        V value = this.getAndRemove(name);
        if (value == null) {
            void var2_2;
            return var2_2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<V> getAll(K name) {
        void var2_2;
        ObjectUtil.checkNotNull(name, (String)"name");
        LinkedList<V> values = new LinkedList<V>();
        int h = this.hashingStrategy.hashCode(name);
        int i = this.index(h);
        HeaderEntry<K, V> e = this.entries[i];
        while (e != null) {
            if (e.hash == h && this.hashingStrategy.equals(name, e.key)) {
                values.addFirst(e.getValue());
            }
            e = e.next;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Iterator<V> valueIterator(K name) {
        void var1_1;
        return new ValueIterator(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<V> getAllAndRemove(K name) {
        void var2_2;
        void var1_1;
        List<V> all = this.getAll(name);
        this.remove(var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(K name) {
        void var1_1;
        return this.get(var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsObject(K name, Object value) {
        void var2_2;
        void var1_1;
        return this.contains(name, this.fromObject(var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsBoolean(K name, boolean value) {
        void var2_2;
        void var1_1;
        return this.contains(name, this.fromBoolean(var1_1, (boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsByte(K name, byte value) {
        void var2_2;
        void var1_1;
        return this.contains(name, this.fromByte(var1_1, (byte)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsChar(K name, char value) {
        void var2_2;
        void var1_1;
        return this.contains(name, this.fromChar(var1_1, (char)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsShort(K name, short value) {
        void var2_2;
        void var1_1;
        return this.contains(name, this.fromShort(var1_1, (short)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsInt(K name, int value) {
        void var2_2;
        void var1_1;
        return this.contains(name, this.fromInt(var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsLong(K name, long value) {
        void var2_2;
        void var1_1;
        return this.contains(name, this.fromLong(var1_1, (long)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsFloat(K name, float value) {
        void var2_2;
        void var1_1;
        return this.contains(name, this.fromFloat(var1_1, (float)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsDouble(K name, double value) {
        void var2_2;
        void var1_1;
        return this.contains(name, this.fromDouble(var1_1, (double)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsTimeMillis(K name, long value) {
        void var2_2;
        void var1_1;
        return this.contains(name, this.fromTimeMillis(var1_1, (long)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(K name, V value) {
        void var2_2;
        void var1_1;
        return this.contains(var1_1, var2_2, HashingStrategy.JAVA_HASHER);
    }

    public final boolean contains(K name, V value, HashingStrategy<? super V> valueHashingStrategy) {
        ObjectUtil.checkNotNull(name, (String)"name");
        int h = this.hashingStrategy.hashCode(name);
        int i = this.index(h);
        HeaderEntry<K, V> e = this.entries[i];
        while (e != null) {
            if (e.hash == h && this.hashingStrategy.equals(name, e.key) && valueHashingStrategy.equals(value, e.value)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<K> names() {
        void var1_1;
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet names = new LinkedHashSet(this.size());
        HeaderEntry e = this.head.after;
        while (e != this.head) {
            names.add(e.getKey());
            e = e.after;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T add(K name, V value) {
        void var2_2;
        void var1_1;
        void var3_3;
        DefaultHeaders defaultHeaders = this;
        defaultHeaders.validateName(defaultHeaders.nameValidator, true, name);
        DefaultHeaders defaultHeaders2 = this;
        defaultHeaders2.validateValue(defaultHeaders2.valueValidator, name, value);
        ObjectUtil.checkNotNull(value, (String)"value");
        int h = this.hashingStrategy.hashCode(name);
        int i = this.index(h);
        this.add0((int)var3_3, i, var1_1, var2_2);
        return this.thisT();
    }

    @Override
    public T add(K name, Iterable<? extends V> values) {
        Iterator iterator;
        DefaultHeaders defaultHeaders = this;
        defaultHeaders.validateName(defaultHeaders.nameValidator, true, name);
        int h = this.hashingStrategy.hashCode(name);
        int i = this.index(h);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            DefaultHeaders defaultHeaders2 = this;
            defaultHeaders2.validateValue(defaultHeaders2.valueValidator, name, v);
            this.add0(h, i, name, v);
        }
        return this.thisT();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T add(K name, V ... values) {
        void var2_2;
        DefaultHeaders defaultHeaders = this;
        defaultHeaders.validateName(defaultHeaders.nameValidator, true, name);
        int h = this.hashingStrategy.hashCode(name);
        int i = this.index(h);
        for (void v : var2_2) {
            DefaultHeaders defaultHeaders2 = this;
            defaultHeaders2.validateValue(defaultHeaders2.valueValidator, name, v);
            this.add0(h, i, name, v);
        }
        return this.thisT();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T addObject(K name, Object value) {
        void var2_2;
        void var1_1;
        return this.add(name, this.fromObject(var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T addObject(K name, Iterable<?> values) {
        for (Object value : values) {
            void var3_3;
            this.addObject(name, (Object)var3_3);
        }
        return this.thisT();
    }

    @Override
    public T addObject(K name, Object ... values) {
        Object[] objectArray = values;
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            Object value = objectArray[i];
            this.addObject(name, value);
        }
        return this.thisT();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T addInt(K name, int value) {
        void var2_2;
        void var1_1;
        return this.add(name, this.fromInt(var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T addLong(K name, long value) {
        void var2_2;
        void var1_1;
        return this.add(name, this.fromLong(var1_1, (long)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T addDouble(K name, double value) {
        void var2_2;
        void var1_1;
        return this.add(name, this.fromDouble(var1_1, (double)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T addTimeMillis(K name, long value) {
        void var2_2;
        void var1_1;
        return this.add(name, this.fromTimeMillis(var1_1, (long)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T addChar(K name, char value) {
        void var2_2;
        void var1_1;
        return this.add(name, this.fromChar(var1_1, (char)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T addBoolean(K name, boolean value) {
        void var2_2;
        void var1_1;
        return this.add(name, this.fromBoolean(var1_1, (boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T addFloat(K name, float value) {
        void var2_2;
        void var1_1;
        return this.add(name, this.fromFloat(var1_1, (float)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T addByte(K name, byte value) {
        void var2_2;
        void var1_1;
        return this.add(name, this.fromByte(var1_1, (byte)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T addShort(K name, short value) {
        void var2_2;
        void var1_1;
        return this.add(name, this.fromShort(var1_1, (short)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T add(Headers<? extends K, ? extends V, ?> headers) {
        void var1_1;
        if (headers == this) {
            throw new IllegalArgumentException("can't add to itself.");
        }
        this.addImpl((Headers<? extends K, ? extends V, ?>)var1_1);
        return this.thisT();
    }

    /*
     * WARNING - void declaration
     */
    protected void addImpl(Headers<? extends K, ? extends V, ?> headers) {
        Iterator iterator;
        if (headers instanceof DefaultHeaders) {
            DefaultHeaders defaultHeaders = (DefaultHeaders)headers;
            HeaderEntry e = defaultHeaders.head.after;
            if (defaultHeaders.hashingStrategy == this.hashingStrategy && defaultHeaders.nameValidator == this.nameValidator) {
                while (e != defaultHeaders.head) {
                    this.add0(e.hash, this.index(e.hash), e.key, e.value);
                    e = e.after;
                }
            } else {
                while (e != defaultHeaders.head) {
                    this.add((K)e.key, (V)e.value);
                    e = e.after;
                }
            }
            return;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_3;
            Map.Entry header = iterator.next();
            this.add((K)header.getKey(), (V)var2_3.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T set(K name, V value) {
        void var2_2;
        void var1_1;
        void var3_3;
        DefaultHeaders defaultHeaders = this;
        defaultHeaders.validateName(defaultHeaders.nameValidator, false, name);
        DefaultHeaders defaultHeaders2 = this;
        defaultHeaders2.validateValue(defaultHeaders2.valueValidator, name, value);
        ObjectUtil.checkNotNull(value, (String)"value");
        int h = this.hashingStrategy.hashCode(name);
        int i = this.index(h);
        this.remove0(h, i, name);
        this.add0((int)var3_3, i, var1_1, var2_2);
        return this.thisT();
    }

    @Override
    public T set(K name, Iterable<? extends V> values) {
        Object v;
        Iterator iterator;
        DefaultHeaders defaultHeaders = this;
        defaultHeaders.validateName(defaultHeaders.nameValidator, false, name);
        ObjectUtil.checkNotNull(values, (String)"values");
        int h = this.hashingStrategy.hashCode(name);
        int i = this.index(h);
        this.remove0(h, i, name);
        iterator = iterator.iterator();
        while (iterator.hasNext() && (v = iterator.next()) != null) {
            DefaultHeaders defaultHeaders2 = this;
            defaultHeaders2.validateValue(defaultHeaders2.valueValidator, name, v);
            this.add0(h, i, name, v);
        }
        return this.thisT();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T set(K name, V ... values) {
        void var2_2;
        DefaultHeaders defaultHeaders = this;
        defaultHeaders.validateName(defaultHeaders.nameValidator, false, name);
        ObjectUtil.checkNotNull(values, (String)"values");
        int h = this.hashingStrategy.hashCode(name);
        int i = this.index(h);
        this.remove0(h, i, name);
        for (void v : var2_2) {
            if (v == null) break;
            DefaultHeaders defaultHeaders2 = this;
            defaultHeaders2.validateValue(defaultHeaders2.valueValidator, name, v);
            this.add0(h, i, name, v);
        }
        return this.thisT();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T setObject(K name, Object value) {
        void var2_2;
        void var1_1;
        Object convertedValue = ObjectUtil.checkNotNull(this.fromObject(name, value), (String)"convertedValue");
        return this.set((K)var1_1, (V)var2_2);
    }

    @Override
    public T setObject(K name, Iterable<?> values) {
        Object v;
        Iterator iterator;
        DefaultHeaders defaultHeaders = this;
        defaultHeaders.validateName(defaultHeaders.nameValidator, false, name);
        int h = this.hashingStrategy.hashCode(name);
        int i = this.index(h);
        this.remove0(h, i, name);
        iterator = iterator.iterator();
        while (iterator.hasNext() && (v = iterator.next()) != null) {
            V converted = this.fromObject(name, v);
            DefaultHeaders defaultHeaders2 = this;
            defaultHeaders2.validateValue(defaultHeaders2.valueValidator, name, converted);
            this.add0(h, i, name, converted);
        }
        return this.thisT();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T setObject(K name, Object ... values) {
        void var2_2;
        DefaultHeaders defaultHeaders = this;
        defaultHeaders.validateName(defaultHeaders.nameValidator, false, name);
        int h = this.hashingStrategy.hashCode(name);
        int i = this.index(h);
        this.remove0(h, i, name);
        for (void v : var2_2) {
            if (v == null) break;
            V converted = this.fromObject(name, v);
            DefaultHeaders defaultHeaders2 = this;
            defaultHeaders2.validateValue(defaultHeaders2.valueValidator, name, converted);
            this.add0(h, i, name, converted);
        }
        return this.thisT();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T setInt(K name, int value) {
        void var2_2;
        void var1_1;
        return this.set(name, this.fromInt(var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T setLong(K name, long value) {
        void var2_2;
        void var1_1;
        return this.set(name, this.fromLong(var1_1, (long)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T setDouble(K name, double value) {
        void var2_2;
        void var1_1;
        return this.set(name, this.fromDouble(var1_1, (double)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T setTimeMillis(K name, long value) {
        void var2_2;
        void var1_1;
        return this.set(name, this.fromTimeMillis(var1_1, (long)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T setFloat(K name, float value) {
        void var2_2;
        void var1_1;
        return this.set(name, this.fromFloat(var1_1, (float)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T setChar(K name, char value) {
        void var2_2;
        void var1_1;
        return this.set(name, this.fromChar(var1_1, (char)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T setBoolean(K name, boolean value) {
        void var2_2;
        void var1_1;
        return this.set(name, this.fromBoolean(var1_1, (boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T setByte(K name, byte value) {
        void var2_2;
        void var1_1;
        return this.set(name, this.fromByte(var1_1, (byte)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T setShort(K name, short value) {
        void var2_2;
        void var1_1;
        return this.set(name, this.fromShort(var1_1, (short)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T set(Headers<? extends K, ? extends V, ?> headers) {
        if (headers != this) {
            void var1_1;
            this.clear();
            this.addImpl((Headers<? extends K, ? extends V, ?>)var1_1);
        }
        return this.thisT();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T setAll(Headers<? extends K, ? extends V, ?> headers) {
        if (headers != this) {
            void var1_1;
            for (K key : headers.names()) {
                void var3_3;
                this.remove(var3_3);
            }
            this.addImpl((Headers<? extends K, ? extends V, ?>)var1_1);
        }
        return this.thisT();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(K name) {
        void var1_1;
        return this.getAndRemove(var1_1) != null;
    }

    @Override
    public T clear() {
        Arrays.fill(this.entries, null);
        this.head.after = this.head;
        this.head.before = this.head.after;
        this.size = 0;
        return this.thisT();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new HeaderIterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Boolean getBoolean(K name) {
        V v = this.get(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return this.toBoolean(var1_1, var2_2);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean getBoolean(K name, boolean defaultValue) {
        void var2_2;
        Boolean v = this.getBoolean(name);
        if (v != null) {
            void var1_1;
            return var1_1.booleanValue();
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Byte getByte(K name) {
        V v = this.get(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return this.toByte(var1_1, var2_2);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte getByte(K name, byte defaultValue) {
        void var2_2;
        Byte v = this.getByte(name);
        if (v != null) {
            void var1_1;
            return var1_1.byteValue();
        }
        return (byte)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Character getChar(K name) {
        V v = this.get(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return Character.valueOf(this.toChar(var1_1, var2_2));
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public char getChar(K name, char defaultValue) {
        void var2_2;
        Character v = this.getChar(name);
        if (v != null) {
            void var1_1;
            return var1_1.charValue();
        }
        return (char)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Short getShort(K name) {
        V v = this.get(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return this.toShort(var1_1, var2_2);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short getShort(K name, short defaultValue) {
        void var2_2;
        Short v = this.getShort(name);
        if (v != null) {
            void var1_1;
            return var1_1.shortValue();
        }
        return (short)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Integer getInt(K name) {
        V v = this.get(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return this.toInt(var1_1, var2_2);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getInt(K name, int defaultValue) {
        void var2_2;
        Integer v = this.getInt(name);
        if (v != null) {
            void var1_1;
            return var1_1.intValue();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Long getLong(K name) {
        V v = this.get(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return this.toLong(var1_1, var2_2);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLong(K name, long defaultValue) {
        void var2_2;
        Long v = this.getLong(name);
        if (v != null) {
            void var1_1;
            return var1_1.longValue();
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Float getFloat(K name) {
        V v = this.get(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return Float.valueOf(this.toFloat(var1_1, var2_2));
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getFloat(K name, float defaultValue) {
        void var2_2;
        Float v = this.getFloat(name);
        if (v != null) {
            void var1_1;
            return var1_1.floatValue();
        }
        return (float)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Double getDouble(K name) {
        V v = this.get(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return this.toDouble(var1_1, var2_2);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getDouble(K name, double defaultValue) {
        void var2_2;
        Double v = this.getDouble(name);
        if (v != null) {
            void var1_1;
            return var1_1.doubleValue();
        }
        return (double)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Long getTimeMillis(K name) {
        V v = this.get(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return this.toTimeMillis(var1_1, var2_2);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getTimeMillis(K name, long defaultValue) {
        void var2_2;
        Long v = this.getTimeMillis(name);
        if (v != null) {
            void var1_1;
            return var1_1.longValue();
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Boolean getBooleanAndRemove(K name) {
        V v = this.getAndRemove(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return this.toBoolean(var1_1, var2_2);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean getBooleanAndRemove(K name, boolean defaultValue) {
        void var2_2;
        Boolean v = this.getBooleanAndRemove(name);
        if (v != null) {
            void var1_1;
            return var1_1.booleanValue();
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Byte getByteAndRemove(K name) {
        V v = this.getAndRemove(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return this.toByte(var1_1, var2_2);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte getByteAndRemove(K name, byte defaultValue) {
        void var2_2;
        Byte v = this.getByteAndRemove(name);
        if (v != null) {
            void var1_1;
            return var1_1.byteValue();
        }
        return (byte)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Character getCharAndRemove(K name) {
        V v = this.getAndRemove(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return Character.valueOf(this.toChar(var1_1, var2_2));
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public char getCharAndRemove(K name, char defaultValue) {
        void var2_2;
        Character v = this.getCharAndRemove(name);
        if (v != null) {
            void var1_1;
            return var1_1.charValue();
        }
        return (char)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Short getShortAndRemove(K name) {
        V v = this.getAndRemove(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return this.toShort(var1_1, var2_2);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short getShortAndRemove(K name, short defaultValue) {
        void var2_2;
        Short v = this.getShortAndRemove(name);
        if (v != null) {
            void var1_1;
            return var1_1.shortValue();
        }
        return (short)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Integer getIntAndRemove(K name) {
        V v = this.getAndRemove(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return this.toInt(var1_1, var2_2);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getIntAndRemove(K name, int defaultValue) {
        void var2_2;
        Integer v = this.getIntAndRemove(name);
        if (v != null) {
            void var1_1;
            return var1_1.intValue();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Long getLongAndRemove(K name) {
        V v = this.getAndRemove(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return this.toLong(var1_1, var2_2);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLongAndRemove(K name, long defaultValue) {
        void var2_2;
        Long v = this.getLongAndRemove(name);
        if (v != null) {
            void var1_1;
            return var1_1.longValue();
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Float getFloatAndRemove(K name) {
        V v = this.getAndRemove(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return Float.valueOf(this.toFloat(var1_1, var2_2));
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getFloatAndRemove(K name, float defaultValue) {
        void var2_2;
        Float v = this.getFloatAndRemove(name);
        if (v != null) {
            void var1_1;
            return var1_1.floatValue();
        }
        return (float)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Double getDoubleAndRemove(K name) {
        V v = this.getAndRemove(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return this.toDouble(var1_1, var2_2);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getDoubleAndRemove(K name, double defaultValue) {
        void var2_2;
        Double v = this.getDoubleAndRemove(name);
        if (v != null) {
            void var1_1;
            return var1_1.doubleValue();
        }
        return (double)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Long getTimeMillisAndRemove(K name) {
        V v = this.getAndRemove(name);
        try {
            if (v != null) {
                void var2_2;
                void var1_1;
                return this.toTimeMillis(var1_1, var2_2);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getTimeMillisAndRemove(K name, long defaultValue) {
        void var2_2;
        Long v = this.getTimeMillisAndRemove(name);
        if (v != null) {
            void var1_1;
            return var1_1.longValue();
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (!(o instanceof Headers)) {
            return false;
        }
        return this.equals((Headers)var1_1, HashingStrategy.JAVA_HASHER);
    }

    public int hashCode() {
        return this.hashCode(HashingStrategy.JAVA_HASHER);
    }

    public final boolean equals(Headers<K, V, ?> h2, HashingStrategy<V> valueHashingStrategy) {
        if (h2.size() != this.size()) {
            return false;
        }
        if (this == h2) {
            return true;
        }
        for (K name : this.names()) {
            List<V> otherValues = h2.getAll(name);
            List<V> values = this.getAll(name);
            if (otherValues.size() != values.size()) {
                return false;
            }
            for (int i = 0; i < otherValues.size(); ++i) {
                if (valueHashingStrategy.equals(otherValues.get(i), values.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode(HashingStrategy<V> valueHashingStrategy) {
        void var2_2;
        int result = -1028477387;
        for (K name : this.names()) {
            result = result * 31 + this.hashingStrategy.hashCode(name);
            List<V> values = this.getAll(name);
            for (int i = 0; i < values.size(); ++i) {
                result = result * 31 + valueHashingStrategy.hashCode(values.get(i));
            }
        }
        return (int)var2_2;
    }

    public String toString() {
        return HeadersUtils.toString(this.getClass(), this.iterator(), this.size());
    }

    /*
     * WARNING - void declaration
     */
    protected void validateName(NameValidator<K> validator, boolean forAdd, K name) {
        void var3_3;
        validator.validateName(var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void validateValue(ValueValidator<V> validator, K name, V value) {
        try {
            void var3_4;
            validator.validate(var3_4);
            return;
        }
        catch (IllegalArgumentException e) {
            void var1_2;
            void var2_3;
            throw new IllegalArgumentException("Validation failed for header '" + var2_3 + "'", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected HeaderEntry<K, V> newHeaderEntry(int h, K name, V value, HeaderEntry<K, V> next) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new HeaderEntry<void, void>((int)var1_1, var2_2, var3_3, next, this.head);
    }

    protected ValueConverter<V> valueConverter() {
        return this.valueConverter;
    }

    protected NameValidator<K> nameValidator() {
        return this.nameValidator;
    }

    protected ValueValidator<V> valueValidator() {
        return this.valueValidator;
    }

    private int index(int hash) {
        return hash & this.hashMask;
    }

    /*
     * WARNING - void declaration
     */
    private void add0(int h, int i, K name, V value) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.entries[i] = this.newHeaderEntry((int)var1_1, var3_3, value, this.entries[var2_2]);
        ++this.size;
    }

    /*
     * WARNING - void declaration
     */
    private V remove0(int h, int i, K name) {
        void var3_3;
        void var1_1;
        HeaderEntry<K, V> e = this.entries[i];
        if (e == null) {
            return null;
        }
        V value = null;
        HeaderEntry next = e.next;
        while (next != null) {
            if (next.hash == h && this.hashingStrategy.equals(name, next.key)) {
                value = next.value;
                e.next = next.next;
                next.remove();
                --this.size;
            } else {
                e = next;
            }
            next = e.next;
        }
        e = this.entries[i];
        if (e.hash == var1_1 && this.hashingStrategy.equals((Object)var3_3, e.key)) {
            if (value == null) {
                value = e.value;
            }
            this.entries[var2_2] = e.next;
            e.remove();
            --this.size;
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    HeaderEntry<K, V> remove0(HeaderEntry<K, V> entry, HeaderEntry<K, V> previous) {
        void var2_2;
        void var1_1;
        int i = this.index(entry.hash);
        HeaderEntry<K, V> firstEntry = this.entries[i];
        if (firstEntry == entry) {
            this.entries[i] = entry.next;
            previous = this.entries[i];
        } else if (previous == null) {
            void var3_4;
            previous = firstEntry;
            HeaderEntry next = firstEntry.next;
            while (next != null && next != entry) {
                previous = next;
                next = next.next;
            }
            assert (var3_4 != null) : "Entry not found in its hash bucket: " + entry;
            previous.next = entry.next;
        } else {
            previous.next = entry.next;
        }
        var1_1.remove();
        --this.size;
        return var2_2;
    }

    private T thisT() {
        return (T)this;
    }

    /*
     * WARNING - void declaration
     */
    private V fromObject(K name, Object value) {
        try {
            return this.valueConverter.convertObject(ObjectUtil.checkNotNull((Object)value, (String)"value"));
        }
        catch (IllegalArgumentException e) {
            void var2_3;
            void var1_1;
            throw new IllegalArgumentException("Failed to convert object value for header '" + var1_1 + '\'', (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private V fromBoolean(K name, boolean value) {
        try {
            return this.valueConverter.convertBoolean(value);
        }
        catch (IllegalArgumentException e) {
            void var2_3;
            void var1_1;
            throw new IllegalArgumentException("Failed to convert boolean value for header '" + var1_1 + '\'', (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private V fromByte(K name, byte value) {
        try {
            return this.valueConverter.convertByte(value);
        }
        catch (IllegalArgumentException e) {
            void var2_3;
            void var1_1;
            throw new IllegalArgumentException("Failed to convert byte value for header '" + var1_1 + '\'', (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private V fromChar(K name, char value) {
        try {
            return this.valueConverter.convertChar(value);
        }
        catch (IllegalArgumentException e) {
            void var2_3;
            void var1_1;
            throw new IllegalArgumentException("Failed to convert char value for header '" + var1_1 + '\'', (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private V fromShort(K name, short value) {
        try {
            return this.valueConverter.convertShort(value);
        }
        catch (IllegalArgumentException e) {
            void var2_3;
            void var1_1;
            throw new IllegalArgumentException("Failed to convert short value for header '" + var1_1 + '\'', (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private V fromInt(K name, int value) {
        try {
            return this.valueConverter.convertInt(value);
        }
        catch (IllegalArgumentException e) {
            void var2_3;
            void var1_1;
            throw new IllegalArgumentException("Failed to convert int value for header '" + var1_1 + '\'', (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private V fromLong(K name, long value) {
        try {
            return this.valueConverter.convertLong(value);
        }
        catch (IllegalArgumentException e) {
            void var2_3;
            void var1_1;
            throw new IllegalArgumentException("Failed to convert long value for header '" + var1_1 + '\'', (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private V fromFloat(K name, float value) {
        try {
            return this.valueConverter.convertFloat(value);
        }
        catch (IllegalArgumentException e) {
            void var2_3;
            void var1_1;
            throw new IllegalArgumentException("Failed to convert float value for header '" + var1_1 + '\'', (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private V fromDouble(K name, double value) {
        try {
            return this.valueConverter.convertDouble(value);
        }
        catch (IllegalArgumentException e) {
            void var2_3;
            void var1_1;
            throw new IllegalArgumentException("Failed to convert double value for header '" + var1_1 + '\'', (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private V fromTimeMillis(K name, long value) {
        try {
            return this.valueConverter.convertTimeMillis(value);
        }
        catch (IllegalArgumentException e) {
            void var2_3;
            void var1_1;
            throw new IllegalArgumentException("Failed to convert millsecond value for header '" + var1_1 + '\'', (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean toBoolean(K name, V value) {
        try {
            void var2_2;
            return this.valueConverter.convertToBoolean(var2_2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void var1_1;
            throw new IllegalArgumentException("Failed to convert header value to boolean for header '" + var1_1 + '\'');
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte toByte(K name, V value) {
        try {
            void var2_2;
            return this.valueConverter.convertToByte(var2_2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void var1_1;
            throw new IllegalArgumentException("Failed to convert header value to byte for header '" + var1_1 + '\'');
        }
    }

    /*
     * WARNING - void declaration
     */
    private char toChar(K name, V value) {
        try {
            void var2_2;
            return this.valueConverter.convertToChar(var2_2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void var1_1;
            throw new IllegalArgumentException("Failed to convert header value to char for header '" + var1_1 + '\'');
        }
    }

    /*
     * WARNING - void declaration
     */
    private short toShort(K name, V value) {
        try {
            void var2_2;
            return this.valueConverter.convertToShort(var2_2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void var1_1;
            throw new IllegalArgumentException("Failed to convert header value to short for header '" + var1_1 + '\'');
        }
    }

    /*
     * WARNING - void declaration
     */
    private int toInt(K name, V value) {
        try {
            void var2_2;
            return this.valueConverter.convertToInt(var2_2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void var1_1;
            throw new IllegalArgumentException("Failed to convert header value to int for header '" + var1_1 + '\'');
        }
    }

    /*
     * WARNING - void declaration
     */
    private long toLong(K name, V value) {
        try {
            void var2_2;
            return this.valueConverter.convertToLong(var2_2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void var1_1;
            throw new IllegalArgumentException("Failed to convert header value to long for header '" + var1_1 + '\'');
        }
    }

    /*
     * WARNING - void declaration
     */
    private float toFloat(K name, V value) {
        try {
            void var2_2;
            return this.valueConverter.convertToFloat(var2_2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void var1_1;
            throw new IllegalArgumentException("Failed to convert header value to float for header '" + var1_1 + '\'');
        }
    }

    /*
     * WARNING - void declaration
     */
    private double toDouble(K name, V value) {
        try {
            void var2_2;
            return this.valueConverter.convertToDouble(var2_2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void var1_1;
            throw new IllegalArgumentException("Failed to convert header value to double for header '" + var1_1 + '\'');
        }
    }

    /*
     * WARNING - void declaration
     */
    private long toTimeMillis(K name, V value) {
        try {
            void var2_2;
            return this.valueConverter.convertToTimeMillis(var2_2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void var1_1;
            throw new IllegalArgumentException("Failed to convert header value to millsecond for header '" + var1_1 + '\'');
        }
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHeaders<K, V, T> copy() {
        void var1_1;
        DefaultHeaders<K, V, T> copy = new DefaultHeaders<K, V, T>(this.hashingStrategy, this.valueConverter, this.nameValidator, this.entries.length);
        copy.addImpl(this);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$300(DefaultHeaders x0, int x1) {
        void var1_1;
        return x0.index((int)var1_1);
    }

    protected static class HeaderEntry<K, V>
    implements Map.Entry<K, V> {
        protected final int hash;
        protected final K key;
        protected V value;
        protected HeaderEntry<K, V> next;
        protected HeaderEntry<K, V> before;
        protected HeaderEntry<K, V> after;

        /*
         * WARNING - void declaration
         */
        protected HeaderEntry(int hash, K key) {
            void var2_2;
            void var1_1;
            this.hash = var1_1;
            this.key = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        HeaderEntry(int hash, K key, V value, HeaderEntry<K, V> next, HeaderEntry<K, V> head) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.hash = var1_1;
            this.key = var2_2;
            this.value = var3_3;
            this.next = next;
            this.after = head;
            this.before = head.before;
            this.pointNeighborsToThis();
        }

        HeaderEntry() {
            HeaderEntry headerEntry;
            this.hash = -1;
            this.key = null;
            headerEntry = headerEntry.before = (headerEntry.after = this);
        }

        protected final void pointNeighborsToThis() {
            this.before.after = this;
            this.after.before = this;
        }

        public final HeaderEntry<K, V> before() {
            return this.before;
        }

        public final HeaderEntry<K, V> after() {
            return this.after;
        }

        protected void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V setValue(V value) {
            void var2_2;
            void var1_1;
            ObjectUtil.checkNotNull(value, (String)"value");
            V oldValue = this.value;
            this.value = var1_1;
            return var2_2;
        }

        public final String toString() {
            return this.key.toString() + '=' + this.value.toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            void var1_1;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)o;
            return (this.getKey() == null ? other.getKey() == null : this.getKey().equals(other.getKey())) && (this.getValue() == null ? other.getValue() == null : this.getValue().equals(var1_1.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    private final class ValueIterator
    implements Iterator<V> {
        private final K name;
        private final int hash;
        private HeaderEntry<K, V> removalPrevious;
        private HeaderEntry<K, V> previous;
        private HeaderEntry<K, V> next;

        /*
         * WARNING - void declaration
         */
        ValueIterator(K name) {
            void var2_2;
            this.name = ObjectUtil.checkNotNull(name, (String)"name");
            this.hash = DefaultHeaders.this.hashingStrategy.hashCode((Object)var2_2);
            this.calculateNext(DefaultHeaders.this.entries[DefaultHeaders.access$300(DefaultHeaders.this, this.hash)]);
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        @Override
        public final V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.previous != null) {
                this.removalPrevious = this.previous;
            }
            this.previous = this.next;
            ValueIterator valueIterator = this;
            valueIterator.calculateNext(valueIterator.next.next);
            return this.previous.value;
        }

        @Override
        public final void remove() {
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            this.removalPrevious = DefaultHeaders.this.remove0(this.previous, this.removalPrevious);
            this.previous = null;
        }

        private void calculateNext(HeaderEntry<K, V> entry) {
            while (entry != null) {
                if (entry.hash == this.hash && DefaultHeaders.this.hashingStrategy.equals(this.name, entry.key)) {
                    this.next = entry;
                    return;
                }
                entry = entry.next;
            }
            this.next = null;
        }
    }

    private final class HeaderIterator
    implements Iterator<Map.Entry<K, V>> {
        private HeaderEntry<K, V> current;

        private HeaderIterator() {
            this.current = DefaultHeaders.this.head;
        }

        @Override
        public final boolean hasNext() {
            return this.current.after != DefaultHeaders.this.head;
        }

        @Override
        public final Map.Entry<K, V> next() {
            this.current = this.current.after;
            if (this.current == DefaultHeaders.this.head) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("read only");
        }
    }

    public static interface ValueValidator<V> {
        public static final ValueValidator<?> NO_VALIDATION = new ValueValidator<Object>(){

            @Override
            public final void validate(Object value) {
            }
        };

        public void validate(V var1);
    }

    public static interface NameValidator<K> {
        public static final NameValidator NOT_NULL = new NameValidator(){

            public final void validateName(Object name) {
                ObjectUtil.checkNotNull((Object)name, (String)"name");
            }
        };

        public void validateName(K var1);
    }
}

