/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.util.AsciiString;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.ObjectUtil;
import java.util.BitSet;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class DateFormatter {
    private static final BitSet DELIMITERS;
    private static final String[] DAY_OF_WEEK_TO_SHORT_NAME;
    private static final String[] CALENDAR_MONTH_TO_SHORT_NAME;
    private static final FastThreadLocal<DateFormatter> INSTANCES;
    private final GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    private final StringBuilder sb = new StringBuilder(29);
    private boolean timeFound;
    private int hours;
    private int minutes;
    private int seconds;
    private boolean dayOfMonthFound;
    private int dayOfMonth;
    private boolean monthFound;
    private int month;
    private boolean yearFound;
    private int year;

    public static Date parseHttpDate(CharSequence txt) {
        CharSequence charSequence;
        return DateFormatter.parseHttpDate(txt, 0, charSequence.length());
    }

    /*
     * WARNING - void declaration
     */
    public static Date parseHttpDate(CharSequence txt, int start, int end) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        void var3_3;
        int length = end - start;
        if (length == 0) {
            return null;
        }
        if (length < 0) {
            throw new IllegalArgumentException("Can't have end < start");
        }
        if (var3_3 > 64) {
            throw new IllegalArgumentException("Can't parse more than 64 chars, looks like a user error or a malformed header");
        }
        return DateFormatter.formatter().parse0((CharSequence)ObjectUtil.checkNotNull((Object)charSequence, (String)"txt"), (int)var1_1, (int)var2_2);
    }

    public static String format(Date date) {
        Date date2;
        return DateFormatter.formatter().format0((Date)ObjectUtil.checkNotNull((Object)date2, (String)"date"));
    }

    /*
     * WARNING - void declaration
     */
    public static StringBuilder append(Date date, StringBuilder sb) {
        void var1_1;
        Date date2;
        return DateFormatter.formatter().append0((Date)ObjectUtil.checkNotNull((Object)date2, (String)"date"), (StringBuilder)ObjectUtil.checkNotNull((Object)var1_1, (String)"sb"));
    }

    /*
     * WARNING - void declaration
     */
    private static DateFormatter formatter() {
        void var0;
        DateFormatter formatter = (DateFormatter)INSTANCES.get();
        formatter.reset();
        return var0;
    }

    private static boolean isDelim(char c) {
        char c2;
        return DELIMITERS.get(c2);
    }

    private static boolean isDigit(char c) {
        char c2;
        return c >= '0' && c2 <= '9';
    }

    private static int getNumericalValue(char c) {
        return c - 48;
    }

    private DateFormatter() {
        this.reset();
    }

    public final void reset() {
        this.timeFound = false;
        this.hours = -1;
        this.minutes = -1;
        this.seconds = -1;
        this.dayOfMonthFound = false;
        this.dayOfMonth = -1;
        this.monthFound = false;
        this.month = -1;
        this.yearFound = false;
        this.year = -1;
        this.cal.clear();
        this.sb.setLength(0);
    }

    /*
     * WARNING - void declaration
     */
    private boolean tryParseTime(CharSequence txt, int tokenStart, int tokenEnd) {
        void i;
        int len = tokenEnd - tokenStart;
        if (len < 5 || len > 8) {
            return false;
        }
        int localHours = -1;
        int localMinutes = -1;
        int localSeconds = -1;
        int currentPartNumber = 0;
        int currentPartValue = 0;
        int numDigits = 0;
        while (i < tokenEnd) {
            char c = txt.charAt((int)i);
            if (DateFormatter.isDigit(c)) {
                currentPartValue = currentPartValue * 10 + DateFormatter.getNumericalValue(c);
                if (++numDigits > 2) {
                    return false;
                }
            } else if (c == ':') {
                if (numDigits == 0) {
                    return false;
                }
                switch (currentPartNumber) {
                    case 0: {
                        localHours = currentPartValue;
                        break;
                    }
                    case 1: {
                        localMinutes = currentPartValue;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                currentPartValue = 0;
                ++currentPartNumber;
                numDigits = 0;
            } else {
                return false;
            }
            ++i;
        }
        if (numDigits > 0) {
            localSeconds = currentPartValue;
        }
        if (localHours >= 0 && localMinutes >= 0 && localSeconds >= 0) {
            this.hours = localHours;
            this.minutes = localMinutes;
            this.seconds = localSeconds;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean tryParseDayOfMonth(CharSequence txt, int tokenStart, int tokenEnd) {
        char c0;
        int len = tokenEnd - tokenStart;
        if (len == 1) {
            c0 = txt.charAt(tokenStart);
            if (DateFormatter.isDigit(c0)) {
                this.dayOfMonth = DateFormatter.getNumericalValue(c0);
                return true;
            }
        } else if (c0 == '\u0002') {
            void var2_3;
            c0 = txt.charAt(tokenStart);
            char c1 = txt.charAt((int)(var2_3 + true));
            if (DateFormatter.isDigit(c0) && DateFormatter.isDigit(c1)) {
                void var1_2;
                void var3_4;
                this.dayOfMonth = DateFormatter.getNumericalValue((char)var3_4) * 10 + DateFormatter.getNumericalValue((char)var1_2);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean tryParseMonth(CharSequence txt, int tokenStart, int tokenEnd) {
        void var1_2;
        void var3_4;
        void var2_3;
        if ((tokenEnd -= tokenStart) != 3) {
            return false;
        }
        char monthChar1 = AsciiString.toLowerCase((char)txt.charAt(tokenStart));
        char monthChar2 = AsciiString.toLowerCase((char)txt.charAt(tokenStart + 1));
        char monthChar3 = AsciiString.toLowerCase((char)txt.charAt((int)(var2_3 + 2)));
        if (monthChar1 == 'j' && monthChar2 == 'a' && monthChar3 == 'n') {
            this.month = 0;
        } else if (monthChar1 == 'f' && monthChar2 == 'e' && monthChar3 == 'b') {
            this.month = 1;
        } else if (monthChar1 == 'm' && monthChar2 == 'a' && monthChar3 == 'r') {
            this.month = 2;
        } else if (monthChar1 == 'a' && monthChar2 == 'p' && monthChar3 == 'r') {
            this.month = 3;
        } else if (monthChar1 == 'm' && monthChar2 == 'a' && monthChar3 == 'y') {
            this.month = 4;
        } else if (monthChar1 == 'j' && monthChar2 == 'u' && monthChar3 == 'n') {
            this.month = 5;
        } else if (monthChar1 == 'j' && monthChar2 == 'u' && monthChar3 == 'l') {
            this.month = 6;
        } else if (monthChar1 == 'a' && monthChar2 == 'u' && monthChar3 == 'g') {
            this.month = 7;
        } else if (monthChar1 == 's' && monthChar2 == 'e' && monthChar3 == 'p') {
            this.month = 8;
        } else if (monthChar1 == 'o' && monthChar2 == 'c' && monthChar3 == 't') {
            this.month = 9;
        } else if (monthChar1 == 'n' && monthChar2 == 'o' && monthChar3 == 'v') {
            this.month = 10;
        } else if (var3_4 == 100 && monthChar2 == 'e' && var1_2 == 99) {
            this.month = 11;
        } else {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean tryParseYear(CharSequence txt, int tokenStart, int tokenEnd) {
        char c0;
        int len = tokenEnd - tokenStart;
        if (len == 2) {
            c0 = txt.charAt(tokenStart);
            char c1 = txt.charAt(tokenStart + 1);
            if (DateFormatter.isDigit(c0) && DateFormatter.isDigit(c1)) {
                this.year = DateFormatter.getNumericalValue(c0) * 10 + DateFormatter.getNumericalValue(c1);
                return true;
            }
        } else if (c0 == '\u0004') {
            void var2_3;
            c0 = txt.charAt(tokenStart);
            char c1 = txt.charAt(tokenStart + 1);
            char c2 = txt.charAt(tokenStart + 2);
            char c3 = txt.charAt((int)(var2_3 + 3));
            if (DateFormatter.isDigit(c0) && DateFormatter.isDigit(c1) && DateFormatter.isDigit(c2) && DateFormatter.isDigit(c3)) {
                void var1_2;
                void var3_4;
                this.year = DateFormatter.getNumericalValue((char)var3_4) * 1000 + DateFormatter.getNumericalValue(c1) * 100 + DateFormatter.getNumericalValue(c2) * 10 + DateFormatter.getNumericalValue((char)var1_2);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseToken(CharSequence txt, int tokenStart, int tokenEnd) {
        if (!this.timeFound) {
            this.timeFound = this.tryParseTime(txt, tokenStart, tokenEnd);
            if (this.timeFound) {
                return this.dayOfMonthFound && this.monthFound && this.yearFound;
            }
        }
        if (!this.dayOfMonthFound) {
            this.dayOfMonthFound = this.tryParseDayOfMonth(txt, tokenStart, tokenEnd);
            if (this.dayOfMonthFound) {
                return this.timeFound && this.monthFound && this.yearFound;
            }
        }
        if (!this.monthFound) {
            this.monthFound = this.tryParseMonth(txt, tokenStart, tokenEnd);
            if (this.monthFound) {
                return this.timeFound && this.dayOfMonthFound && this.yearFound;
            }
        }
        if (!this.yearFound) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.yearFound = this.tryParseYear((CharSequence)var1_1, (int)var2_2, (int)var3_3);
        }
        return this.timeFound && this.dayOfMonthFound && this.monthFound && this.yearFound;
    }

    /*
     * WARNING - void declaration
     */
    private Date parse0(CharSequence txt, int start, int end) {
        void var3_4;
        void var2_3;
        void var1_1;
        boolean bl = this.parse1((CharSequence)var1_1, (int)var2_3, (int)var3_4);
        if (bl && this.normalizeAndValidate()) {
            return this.computeDate();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean parse1(CharSequence txt, int start, int end) {
        void var1_1;
        void i;
        int tokenStart = -1;
        while (i < end) {
            char c = txt.charAt((int)i);
            if (DateFormatter.isDelim(c)) {
                if (tokenStart != -1) {
                    if (this.parseToken(txt, tokenStart, (int)i)) {
                        return true;
                    }
                    tokenStart = -1;
                }
            } else if (tokenStart == -1) {
                tokenStart = i;
            }
            ++i;
        }
        return tokenStart != -1 && this.parseToken(txt, tokenStart, var1_1.length());
    }

    private boolean normalizeAndValidate() {
        if (this.dayOfMonth <= 0 || this.dayOfMonth > 31 || this.hours > 23 || this.minutes > 59 || this.seconds > 59) {
            return false;
        }
        if (this.year >= 70 && this.year <= 99) {
            this.year += 1900;
        } else if (this.year >= 0 && this.year < 70) {
            this.year += 2000;
        } else if (this.year < 1601) {
            return false;
        }
        return true;
    }

    private Date computeDate() {
        this.cal.set(5, this.dayOfMonth);
        this.cal.set(2, this.month);
        this.cal.set(1, this.year);
        this.cal.set(11, this.hours);
        this.cal.set(12, this.minutes);
        this.cal.set(13, this.seconds);
        return this.cal.getTime();
    }

    /*
     * WARNING - void declaration
     */
    private String format0(Date date) {
        void var1_1;
        this.append0((Date)var1_1, this.sb);
        return this.sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder append0(Date date, StringBuilder sb) {
        void var2_2;
        void var1_1;
        this.cal.setTime((Date)var1_1);
        sb.append(DAY_OF_WEEK_TO_SHORT_NAME[this.cal.get(7) - 1]).append(", ");
        DateFormatter.appendZeroLeftPadded(this.cal.get(5), sb).append(' ');
        sb.append(CALENDAR_MONTH_TO_SHORT_NAME[this.cal.get(2)]).append(' ');
        sb.append(this.cal.get(1)).append(' ');
        DateFormatter.appendZeroLeftPadded(this.cal.get(11), sb).append(':');
        DateFormatter.appendZeroLeftPadded(this.cal.get(12), sb).append(':');
        return DateFormatter.appendZeroLeftPadded(this.cal.get(13), (StringBuilder)var2_2).append(" GMT");
    }

    /*
     * WARNING - void declaration
     */
    private static StringBuilder appendZeroLeftPadded(int value, StringBuilder sb) {
        int n;
        void var1_1;
        if (value < 10) {
            sb.append('0');
        }
        return var1_1.append(n);
    }

    static {
        int c;
        DELIMITERS = new BitSet();
        DELIMITERS.set(9);
        for (c = 32; c <= 47; c = (int)((char)(c + 1))) {
            DELIMITERS.set(c);
        }
        for (c = 59; c <= 64; c = (int)((char)(c + 1))) {
            DELIMITERS.set(c);
        }
        for (c = 91; c <= 96; c = (int)((char)(c + 1))) {
            DELIMITERS.set(c);
        }
        for (c = 123; c <= 126; c = (int)((char)(c + 1))) {
            DELIMITERS.set(c);
        }
        DAY_OF_WEEK_TO_SHORT_NAME = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        CALENDAR_MONTH_TO_SHORT_NAME = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        INSTANCES = new FastThreadLocal<DateFormatter>(){

            protected final DateFormatter initialValue() {
                return new DateFormatter();
            }
        };
    }
}

