/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;

public class DatagramPacketEncoder<M>
extends MessageToMessageEncoder<AddressedEnvelope<M, InetSocketAddress>> {
    private final MessageToMessageEncoder<? super M> encoder;

    /*
     * WARNING - void declaration
     */
    public DatagramPacketEncoder(MessageToMessageEncoder<? super M> encoder) {
        void var1_1;
        this.encoder = (MessageToMessageEncoder)((Object)ObjectUtil.checkNotNull((Object)var1_1, (String)"encoder"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        if (super.acceptOutboundMessage(msg)) {
            void var1_1;
            AddressedEnvelope envelope = (AddressedEnvelope)msg;
            return this.encoder.acceptOutboundMessage(envelope.content()) && (envelope.sender() instanceof InetSocketAddress || envelope.sender() == null) && var1_1.recipient() instanceof InetSocketAddress;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, AddressedEnvelope<M, InetSocketAddress> msg, List<Object> out) throws Exception {
        assert (out.isEmpty());
        this.encoder.encode(ctx, msg.content(), out);
        if (out.size() != 1) {
            throw new EncoderException(StringUtil.simpleClassName(this.encoder) + " must produce only one message.");
        }
        Object content = out.get(0);
        if (content instanceof ByteBuf) {
            void var2_2;
            void var1_1;
            void var3_3;
            var3_3.set(0, new DatagramPacket((ByteBuf)var1_1, (InetSocketAddress)msg.recipient(), (InetSocketAddress)var2_2.sender()));
            return;
        }
        throw new EncoderException(StringUtil.simpleClassName(this.encoder) + " must produce only ByteBuf.");
    }

    /*
     * WARNING - void declaration
     */
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        this.encoder.bind((ChannelHandlerContext)var1_1, (SocketAddress)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        this.encoder.connect((ChannelHandlerContext)var1_1, (SocketAddress)var2_2, (SocketAddress)var3_3, promise);
    }

    /*
     * WARNING - void declaration
     */
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var1_1;
        this.encoder.disconnect((ChannelHandlerContext)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var1_1;
        this.encoder.close((ChannelHandlerContext)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var1_1;
        this.encoder.deregister((ChannelHandlerContext)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void read(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.encoder.read((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void flush(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.encoder.flush((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.encoder.handlerAdded((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.encoder.handlerRemoved((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        void var2_2;
        void var1_1;
        this.encoder.exceptionCaught((ChannelHandlerContext)var1_1, (Throwable)var2_2);
    }

    public boolean isSharable() {
        return this.encoder.isSharable();
    }
}

