/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.AbstractList;
import java.util.RandomAccess;

final class CodecOutputList
extends AbstractList<Object>
implements RandomAccess {
    private static final CodecOutputListRecycler NOOP_RECYCLER = new CodecOutputListRecycler(){

        @Override
        public final void recycle(CodecOutputList object) {
        }
    };
    private static final FastThreadLocal<CodecOutputLists> CODEC_OUTPUT_LISTS_POOL = new FastThreadLocal<CodecOutputLists>(){

        protected final CodecOutputLists initialValue() throws Exception {
            return new CodecOutputLists(16);
        }
    };
    private final CodecOutputListRecycler recycler;
    private int size;
    private Object[] array;
    private boolean insertSinceRecycled;

    static CodecOutputList newInstance() {
        return ((CodecOutputLists)CODEC_OUTPUT_LISTS_POOL.get()).getOrCreate();
    }

    /*
     * WARNING - void declaration
     */
    private CodecOutputList(CodecOutputListRecycler recycler, int size) {
        void var2_2;
        void var1_1;
        this.recycler = var1_1;
        this.array = new Object[var2_2];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object get(int index) {
        void var1_1;
        this.checkIndex(index);
        return this.array[var1_1];
    }

    @Override
    public final int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(Object element) {
        ObjectUtil.checkNotNull((Object)element, (String)"element");
        try {
            CodecOutputList codecOutputList = this;
            codecOutputList.insert(codecOutputList.size, element);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            void var1_1;
            this.expandArray();
            CodecOutputList codecOutputList = this;
            codecOutputList.insert(codecOutputList.size, var1_1);
        }
        ++this.size;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object set(int index, Object element) {
        void var3_3;
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)element, (String)"element");
        this.checkIndex(index);
        Object old = this.array[index];
        this.insert((int)var1_1, var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void add(int index, Object element) {
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)element, (String)"element");
        this.checkIndex(index);
        if (this.size == this.array.length) {
            this.expandArray();
        }
        if (index != this.size) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        }
        this.insert((int)var1_1, var2_2);
        ++this.size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object remove(int index) {
        void var2_2;
        this.checkIndex(index);
        Object old = this.array[index];
        int len = this.size - index - 1;
        if (len > 0) {
            void var3_3;
            void var1_1;
            System.arraycopy(this.array, index + 1, this.array, (int)var1_1, (int)var3_3);
        }
        this.array[--this.size] = null;
        return var2_2;
    }

    @Override
    public final void clear() {
        this.size = 0;
    }

    final boolean insertSinceRecycled() {
        return this.insertSinceRecycled;
    }

    final void recycle() {
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = null;
        }
        this.size = 0;
        this.insertSinceRecycled = false;
        this.recycler.recycle(this);
    }

    /*
     * WARNING - void declaration
     */
    final Object getUnsafe(int index) {
        void var1_1;
        return this.array[var1_1];
    }

    private void checkIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("expected: index < (" + this.size + "),but actual is (" + this.size + ")");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void insert(int index, Object element) {
        void var2_2;
        this.array[var1_1] = var2_2;
        this.insertSinceRecycled = true;
    }

    /*
     * WARNING - void declaration
     */
    private void expandArray() {
        void var1_2;
        int newCapacity = this.array.length << 1;
        if (newCapacity < 0) {
            throw new OutOfMemoryError();
        }
        Object[] newArray = new Object[newCapacity];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        this.array = var1_2;
    }

    private static final class CodecOutputLists
    implements CodecOutputListRecycler {
        private final CodecOutputList[] elements;
        private final int mask;
        private int currentIdx;
        private int count;

        CodecOutputLists(int numElements) {
            this.elements = new CodecOutputList[MathUtil.safeFindNextPositivePowerOfTwo((int)numElements)];
            for (int i = 0; i < this.elements.length; ++i) {
                this.elements[i] = new CodecOutputList(this, 16);
            }
            this.count = this.elements.length;
            this.currentIdx = this.elements.length;
            this.mask = this.elements.length - 1;
        }

        /*
         * WARNING - void declaration
         */
        public final CodecOutputList getOrCreate() {
            void var2_2;
            void var1_1;
            if (this.count == 0) {
                return new CodecOutputList(NOOP_RECYCLER, 4);
            }
            --this.count;
            int idx = this.currentIdx - 1 & this.mask;
            CodecOutputList list = this.elements[idx];
            this.currentIdx = var1_1;
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void recycle(CodecOutputList codecOutputList) {
            void var2_2;
            void var1_1;
            int idx = this.currentIdx;
            this.elements[idx] = var1_1;
            this.currentIdx = var2_2 + true & this.mask;
            ++this.count;
            assert (this.count <= this.elements.length);
        }
    }

    private static interface CodecOutputListRecycler {
        public void recycle(CodecOutputList var1);
    }
}

