/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.ValueConverter;
import io.netty.util.AsciiString;
import io.netty.util.internal.PlatformDependent;
import java.text.ParseException;
import java.util.Date;

public class CharSequenceValueConverter
implements ValueConverter<CharSequence> {
    public static final CharSequenceValueConverter INSTANCE = new CharSequenceValueConverter();
    private static final AsciiString TRUE_ASCII = new AsciiString((CharSequence)"true");

    /*
     * WARNING - void declaration
     */
    @Override
    public CharSequence convertObject(Object value) {
        void var1_1;
        if (value instanceof CharSequence) {
            return (CharSequence)value;
        }
        return var1_1.toString();
    }

    @Override
    public CharSequence convertInt(int value) {
        return String.valueOf(value);
    }

    @Override
    public CharSequence convertLong(long value) {
        return String.valueOf(value);
    }

    @Override
    public CharSequence convertDouble(double value) {
        return String.valueOf(value);
    }

    @Override
    public CharSequence convertChar(char value) {
        return String.valueOf(value);
    }

    @Override
    public CharSequence convertBoolean(boolean value) {
        return String.valueOf(value);
    }

    @Override
    public CharSequence convertFloat(float value) {
        return String.valueOf(value);
    }

    @Override
    public boolean convertToBoolean(CharSequence value) {
        return AsciiString.contentEqualsIgnoreCase((CharSequence)value, (CharSequence)TRUE_ASCII);
    }

    @Override
    public CharSequence convertByte(byte value) {
        return String.valueOf(value);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte convertToByte(CharSequence value) {
        void var1_1;
        if (value instanceof AsciiString && value.length() == 1) {
            return ((AsciiString)value).byteAt(0);
        }
        return Byte.parseByte(var1_1.toString());
    }

    @Override
    public char convertToChar(CharSequence value) {
        return value.charAt(0);
    }

    @Override
    public CharSequence convertShort(short value) {
        return String.valueOf(value);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short convertToShort(CharSequence value) {
        void var1_1;
        if (value instanceof AsciiString) {
            return ((AsciiString)value).parseShort();
        }
        return Short.parseShort(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int convertToInt(CharSequence value) {
        void var1_1;
        if (value instanceof AsciiString) {
            return ((AsciiString)value).parseInt();
        }
        return Integer.parseInt(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long convertToLong(CharSequence value) {
        void var1_1;
        if (value instanceof AsciiString) {
            return ((AsciiString)value).parseLong();
        }
        return Long.parseLong(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharSequence convertTimeMillis(long value) {
        void var1_1;
        return DateFormatter.format(new Date((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long convertToTimeMillis(CharSequence value) {
        void var2_2;
        Date date = DateFormatter.parseHttpDate(value);
        if (date == null) {
            void var1_1;
            PlatformDependent.throwException((Throwable)new ParseException("header can't be parsed into a Date: " + var1_1, 0));
            return 0L;
        }
        return var2_2.getTime();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float convertToFloat(CharSequence value) {
        void var1_1;
        if (value instanceof AsciiString) {
            return ((AsciiString)value).parseFloat();
        }
        return Float.parseFloat(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double convertToDouble(CharSequence value) {
        void var1_1;
        if (value instanceof AsciiString) {
            return ((AsciiString)value).parseDouble();
        }
        return Double.parseDouble(var1_1.toString());
    }
}

