/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.handler.codec.CodecOutputList;
import io.netty.handler.codec.DecoderException;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.List;

public abstract class ByteToMessageDecoder
extends ChannelInboundHandlerAdapter {
    public static final Cumulator MERGE_CUMULATOR = new Cumulator(){

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf cumulate(ByteBufAllocator alloc, ByteBuf cumulation, ByteBuf in) {
            void var2_3;
            ByteBuf byteBuf;
            int required;
            block5: {
                if (cumulation == in) {
                    in.release();
                    return cumulation;
                }
                if (!cumulation.isReadable() && in.isContiguous()) {
                    cumulation.release();
                    return in;
                }
                try {
                    required = in.readableBytes();
                    if (required <= cumulation.maxWritableBytes() && (required <= cumulation.maxFastWritableBytes() || cumulation.refCnt() <= 1) && !cumulation.isReadOnly()) break block5;
                    byteBuf = ByteToMessageDecoder.expandCumulation((ByteBufAllocator)byteBuf, cumulation, in);
                }
                catch (Throwable throwable) {
                    void var3_4;
                    var3_4.release();
                    throw throwable;
                }
                in.release();
                return byteBuf;
            }
            ByteBuf byteBuf2 = in;
            cumulation.writeBytes(byteBuf2, byteBuf2.readerIndex(), required);
            ByteBuf byteBuf3 = in;
            byteBuf3.readerIndex(byteBuf3.writerIndex());
            byteBuf = var2_3;
            in.release();
            return byteBuf;
        }
    };
    public static final Cumulator COMPOSITE_CUMULATOR = new Cumulator(){

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteBuf cumulate(ByteBufAllocator alloc, ByteBuf cumulation, ByteBuf in) {
            if (cumulation == in) {
                in.release();
                return cumulation;
            }
            if (!cumulation.isReadable()) {
                cumulation.release();
                return in;
            }
            CompositeByteBuf composite = null;
            try {
                CompositeByteBuf compositeByteBuf;
                if (cumulation instanceof CompositeByteBuf && cumulation.refCnt() == 1) {
                    composite = (CompositeByteBuf)cumulation;
                    if (composite.writerIndex() != composite.capacity()) {
                        CompositeByteBuf compositeByteBuf2 = composite;
                        compositeByteBuf2.capacity(compositeByteBuf2.writerIndex());
                    }
                } else {
                    composite = compositeByteBuf.compositeBuffer(Integer.MAX_VALUE).addFlattenedComponents(true, cumulation);
                }
                composite.addFlattenedComponents(true, in);
                in = null;
                compositeByteBuf = composite;
                return compositeByteBuf;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    void var2_3;
                    void var3_4;
                    var3_4.release();
                    if (composite != null && composite != var2_3) {
                        composite.release();
                    }
                }
                throw throwable;
            }
        }
    };
    private static final byte STATE_INIT = 0;
    private static final byte STATE_CALLING_CHILD_DECODE = 1;
    private static final byte STATE_HANDLER_REMOVED_PENDING = 2;
    ByteBuf cumulation;
    private Cumulator cumulator = MERGE_CUMULATOR;
    private boolean singleDecode;
    private boolean first;
    private boolean firedChannelRead;
    private boolean selfFiredChannelRead;
    private byte decodeState = 0;
    private int discardAfterReads = 16;
    private int numReads;

    protected ByteToMessageDecoder() {
        this.ensureNotSharable();
    }

    /*
     * WARNING - void declaration
     */
    public void setSingleDecode(boolean singleDecode) {
        void var1_1;
        this.singleDecode = var1_1;
    }

    public boolean isSingleDecode() {
        return this.singleDecode;
    }

    /*
     * WARNING - void declaration
     */
    public void setCumulator(Cumulator cumulator) {
        void var1_1;
        this.cumulator = (Cumulator)ObjectUtil.checkNotNull((Object)var1_1, (String)"cumulator");
    }

    /*
     * WARNING - void declaration
     */
    public void setDiscardAfterReads(int discardAfterReads) {
        void var1_1;
        ObjectUtil.checkPositive((int)discardAfterReads, (String)"discardAfterReads");
        this.discardAfterReads = var1_1;
    }

    protected int actualReadableBytes() {
        return this.internalBuffer().readableBytes();
    }

    protected ByteBuf internalBuffer() {
        if (this.cumulation != null) {
            return this.cumulation;
        }
        return Unpooled.EMPTY_BUFFER;
    }

    /*
     * WARNING - void declaration
     */
    public final void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (this.decodeState == 1) {
            this.decodeState = (byte)2;
            return;
        }
        ByteBuf buf = this.cumulation;
        if (buf != null) {
            this.cumulation = null;
            this.numReads = 0;
            int n = buf.readableBytes();
            if (n > 0) {
                ctx.fireChannelRead((Object)buf);
                ctx.fireChannelReadComplete();
            } else {
                void var2_2;
                var2_2.release();
            }
        }
        this.handlerRemoved0((ChannelHandlerContext)var1_1);
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void channelRead(ChannelHandlerContext ctx2222222, Object msg) throws Exception {
        if (!(msg instanceof ByteBuf)) {
            void var2_4;
            void var1_1;
            var1_1.fireChannelRead((Object)var2_4);
            return;
        }
        this.selfFiredChannelRead = true;
        CodecOutputList out = CodecOutputList.newInstance();
        try {
            this.first = this.cumulation == null;
            this.cumulation = this.cumulator.cumulate(ctx2222222.alloc(), this.first ? Unpooled.EMPTY_BUFFER : this.cumulation, (ByteBuf)msg);
            this.callDecode(ctx2222222, this.cumulation, out);
        }
        catch (DecoderException decoderException) {
            try {
                DecoderException size = decoderException;
                throw decoderException;
                catch (Exception e) {
                    void var2_7;
                    throw new DecoderException((Throwable)var2_7);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.cumulation != null && !this.cumulation.isReadable()) {
                        this.numReads = 0;
                        try {
                            this.cumulation.release();
                        }
                        catch (IllegalReferenceCountException e) {
                            throw new IllegalReferenceCountException(((Object)((Object)this)).getClass().getSimpleName() + "#decode() might have released its input buffer, or passed it down the pipeline without a retain() call, which is not allowed.", (Throwable)e);
                        }
                        this.cumulation = null;
                    } else if (++this.numReads >= this.discardAfterReads) {
                        this.numReads = 0;
                        this.discardSomeReadBytes();
                    }
                    int size = out.size();
                    this.firedChannelRead |= out.insertSinceRecycled();
                    ByteToMessageDecoder.fireChannelRead(ctx2222222, out, size);
                    out.recycle();
                    throw throwable;
                }
                catch (Throwable ctx2222222) {
                    void var3_9;
                    var3_9.recycle();
                    throw ctx2222222;
                }
            }
        }
        try {
            ChannelHandlerContext ctx2222222;
            if (this.cumulation != null && !this.cumulation.isReadable()) {
                this.numReads = 0;
                try {
                    this.cumulation.release();
                }
                catch (IllegalReferenceCountException e) {
                    throw new IllegalReferenceCountException(((Object)((Object)this)).getClass().getSimpleName() + "#decode() might have released its input buffer, or passed it down the pipeline without a retain() call, which is not allowed.", (Throwable)e);
                }
                this.cumulation = null;
            } else if (++this.numReads >= this.discardAfterReads) {
                this.numReads = 0;
                this.discardSomeReadBytes();
            }
            int size = out.size();
            this.firedChannelRead |= out.insertSinceRecycled();
            ByteToMessageDecoder.fireChannelRead(ctx2222222, out, size);
            return;
        }
        finally {
            out.recycle();
        }
    }

    static void fireChannelRead(ChannelHandlerContext ctx, List<Object> msgs, int numElements) {
        if (msgs instanceof CodecOutputList) {
            ByteToMessageDecoder.fireChannelRead(ctx, (CodecOutputList)msgs, numElements);
            return;
        }
        for (int i = 0; i < numElements; ++i) {
            ctx.fireChannelRead(msgs.get(i));
        }
    }

    static void fireChannelRead(ChannelHandlerContext ctx, CodecOutputList msgs, int numElements) {
        for (int i = 0; i < numElements; ++i) {
            ctx.fireChannelRead(msgs.getUnsafe(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.numReads = 0;
        this.discardSomeReadBytes();
        if (this.selfFiredChannelRead && !this.firedChannelRead && !ctx.channel().config().isAutoRead()) {
            ctx.read();
        }
        this.firedChannelRead = false;
        this.selfFiredChannelRead = false;
        var1_1.fireChannelReadComplete();
    }

    protected final void discardSomeReadBytes() {
        if (this.cumulation != null && !this.first && this.cumulation.refCnt() == 1) {
            this.cumulation.discardSomeReadBytes();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.channelInputClosed((ChannelHandlerContext)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        void var2_2;
        void var1_1;
        if (evt instanceof ChannelInputShutdownEvent) {
            this.channelInputClosed(ctx, false);
        }
        super.userEventTriggered((ChannelHandlerContext)var1_1, (Object)var2_2);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void channelInputClosed(ChannelHandlerContext ctx, boolean callChannelInactive) {
        CodecOutputList out = CodecOutputList.newInstance();
        try {
            this.channelInputClosed(ctx, out);
        }
        catch (DecoderException decoderException) {
            try {
                DecoderException size = decoderException;
                throw decoderException;
                catch (Exception e) {
                    throw new DecoderException(e);
                }
            }
            catch (Throwable throwable) {
                try {
                    void var2_4;
                    if (this.cumulation != null) {
                        this.cumulation.release();
                        this.cumulation = null;
                    }
                    int size = out.size();
                    ByteToMessageDecoder.fireChannelRead(ctx, out, size);
                    if (size > 0) {
                        ctx.fireChannelReadComplete();
                    }
                    if (var2_4 != false) {
                        void var1_1;
                        var1_1.fireChannelInactive();
                    }
                    out.recycle();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    void var3_5;
                    var3_5.recycle();
                    throw throwable2;
                }
            }
        }
        try {
            if (this.cumulation != null) {
                this.cumulation.release();
                this.cumulation = null;
            }
            int size = out.size();
            ByteToMessageDecoder.fireChannelRead(ctx, out, size);
            if (size > 0) {
                ctx.fireChannelReadComplete();
            }
            if (!callChannelInactive) return;
            ctx.fireChannelInactive();
            return;
        }
        finally {
            out.recycle();
        }
    }

    /*
     * WARNING - void declaration
     */
    void channelInputClosed(ChannelHandlerContext ctx, List<Object> out) throws Exception {
        if (this.cumulation != null) {
            this.callDecode(ctx, this.cumulation, out);
            if (!ctx.isRemoved()) {
                void var3_3;
                ByteBuf buffer = this.cumulation == null ? Unpooled.EMPTY_BUFFER : this.cumulation;
                this.decodeLast(ctx, (ByteBuf)var3_3, out);
                return;
            }
        } else {
            void var2_2;
            void var1_1;
            this.decodeLast((ChannelHandlerContext)var1_1, Unpooled.EMPTY_BUFFER, (List<Object>)var2_2);
        }
    }

    protected void callDecode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        block7: {
            try {
                while (in.isReadable()) {
                    int outSize = out.size();
                    if (outSize > 0) {
                        ByteToMessageDecoder.fireChannelRead(ctx, out, outSize);
                        out.clear();
                        if (ctx.isRemoved()) break;
                    }
                    int oldInputLength = in.readableBytes();
                    this.decodeRemovalReentryProtection(ctx, in, out);
                    if (ctx.isRemoved()) break;
                    if (out.isEmpty()) {
                        if (oldInputLength != in.readableBytes()) continue;
                        break block7;
                    }
                    if (oldInputLength == in.readableBytes()) {
                        throw new DecoderException(StringUtil.simpleClassName(((Object)((Object)this)).getClass()) + ".decode() did not read anything but decoded a message.");
                    }
                    if (!this.isSingleDecode()) continue;
                }
                return;
            }
            catch (DecoderException decoderException) {
                DecoderException oldInputLength = decoderException;
                throw decoderException;
            }
            catch (Exception cause) {
                throw new DecoderException(cause);
            }
        }
    }

    protected abstract void decode(ChannelHandlerContext var1, ByteBuf var2, List<Object> var3) throws Exception;

    /*
     * WARNING - void declaration
     */
    final void decodeRemovalReentryProtection(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        void var2_3;
        this.decodeState = 1;
        try {
            this.decode(ctx, in, out);
            boolean removePending = this.decodeState == 2;
        }
        catch (Throwable throwable) {
            boolean removePending = this.decodeState == 2;
            this.decodeState = 0;
            if (removePending) {
                void var1_1;
                void var3_5;
                List<Object> list = out;
                ByteToMessageDecoder.fireChannelRead(ctx, list, list.size());
                var3_5.clear();
                this.handlerRemoved((ChannelHandlerContext)var1_1);
            }
            throw throwable;
        }
        this.decodeState = 0;
        if (var2_3 != false) {
            List<Object> list = out;
            ByteToMessageDecoder.fireChannelRead(ctx, list, list.size());
            out.clear();
            this.handlerRemoved(ctx);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.isReadable()) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.decodeRemovalReentryProtection((ChannelHandlerContext)var1_1, (ByteBuf)var2_2, (List<Object>)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    static ByteBuf expandCumulation(ByteBufAllocator alloc, ByteBuf oldCumulation, ByteBuf in) {
        int oldBytes = oldCumulation.readableBytes();
        int newBytes = in.readableBytes();
        int totalBytes = oldBytes + newBytes;
        ByteBufAllocator byteBufAllocator = alloc;
        ByteBufAllocator newCumulation = byteBufAllocator.buffer(byteBufAllocator.calculateNewCapacity(totalBytes, Integer.MAX_VALUE));
        ByteBuf toRelease = newCumulation;
        try {
            ByteBufAllocator byteBufAllocator2;
            void var1_2;
            void var2_3;
            void var3_4;
            ByteBuf byteBuf = oldCumulation;
            ByteBuf byteBuf2 = in;
            newCumulation.setBytes(0, byteBuf, byteBuf.readerIndex(), oldBytes).setBytes((int)var3_4, byteBuf2, byteBuf2.readerIndex(), newBytes).writerIndex(totalBytes);
            void v3 = var2_3;
            v3.readerIndex(v3.writerIndex());
            toRelease = var1_2;
            return byteBufAllocator2;
        }
        finally {
            toRelease.release();
        }
    }

    public static interface Cumulator {
        public ByteBuf cumulate(ByteBufAllocator var1, ByteBuf var2, ByteBuf var3);
    }
}

