/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.Map;

public final class AsciiHeadersEncoder {
    private final ByteBuf buf;
    private final SeparatorType separatorType;
    private final NewlineType newlineType;

    /*
     * WARNING - void declaration
     */
    public AsciiHeadersEncoder(ByteBuf buf) {
        this((ByteBuf)var1_1, SeparatorType.COLON_SPACE, NewlineType.CRLF);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AsciiHeadersEncoder(ByteBuf buf, SeparatorType separatorType, NewlineType newlineType) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.buf = (ByteBuf)ObjectUtil.checkNotNull((Object)var1_1, (String)"buf");
        this.separatorType = (SeparatorType)((Object)ObjectUtil.checkNotNull((Object)var2_2, (String)"separatorType"));
        this.newlineType = (NewlineType)((Object)ObjectUtil.checkNotNull((Object)var3_3, (String)"newlineType"));
    }

    /*
     * WARNING - void declaration
     */
    public final void encode(Map.Entry<CharSequence, CharSequence> entry) {
        void var3_3;
        void var1_1;
        void var2_2;
        CharSequence name = entry.getKey();
        CharSequence value = entry.getValue();
        ByteBuf buf = this.buf;
        int nameLen = name.length();
        int valueLen = value.length();
        int entryLen = nameLen + valueLen + 4;
        int offset = buf.writerIndex();
        buf.ensureWritable(entryLen);
        AsciiHeadersEncoder.writeAscii(buf, offset, (CharSequence)var2_2);
        offset += nameLen;
        switch (this.separatorType) {
            case COLON: {
                buf.setByte(offset++, 58);
                break;
            }
            case COLON_SPACE: {
                buf.setByte(offset++, 58);
                buf.setByte(offset++, 32);
                break;
            }
            default: {
                throw new Error();
            }
        }
        AsciiHeadersEncoder.writeAscii(buf, offset, (CharSequence)var1_1);
        offset += valueLen;
        switch (this.newlineType) {
            case LF: {
                buf.setByte(offset++, 10);
                break;
            }
            case CRLF: {
                buf.setByte(offset++, 13);
                buf.setByte(offset++, 10);
                break;
            }
            default: {
                throw new Error();
            }
        }
        var3_3.writerIndex(offset);
    }

    /*
     * WARNING - void declaration
     */
    private static void writeAscii(ByteBuf buf, int offset, CharSequence value) {
        void var2_2;
        void var1_1;
        ByteBuf byteBuf;
        if (value instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)((AsciiString)value), (int)0, (ByteBuf)buf, (int)offset, (int)value.length());
            return;
        }
        byteBuf.setCharSequence((int)var1_1, (CharSequence)var2_2, CharsetUtil.US_ASCII);
    }

    public static enum NewlineType {
        LF,
        CRLF;

    }

    public static enum SeparatorType {
        COLON,
        COLON_SPACE;

    }
}

