/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public abstract class Triple<L, M, R>
implements Serializable,
Comparable<Triple<L, M, R>> {
    private static final long serialVersionUID = 1L;
    public static final Triple<?, ?, ?>[] EMPTY_ARRAY = new TripleAdapter[0];

    public static <L, M, R> Triple<L, M, R>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    /*
     * WARNING - void declaration
     */
    public static <L, M, R> Triple<L, M, R> of(L left, M middle, R right) {
        void var2_2;
        void var1_1;
        L l;
        return new ImmutableTriple<L, void, void>(l, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(Triple<L, M, R> other) {
        void var1_1;
        return new CompareToBuilder().append(this.getLeft(), other.getLeft()).append(this.getMiddle(), other.getMiddle()).append(this.getRight(), var1_1.getRight()).toComparison();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Triple) {
            void var1_1;
            Triple other = (Triple)obj;
            return Objects.equals(this.getLeft(), other.getLeft()) && Objects.equals(this.getMiddle(), other.getMiddle()) && Objects.equals(this.getRight(), var1_1.getRight());
        }
        return false;
    }

    public abstract L getLeft();

    public abstract M getMiddle();

    public abstract R getRight();

    public int hashCode() {
        return Objects.hashCode(this.getLeft()) ^ Objects.hashCode(this.getMiddle()) ^ Objects.hashCode(this.getRight());
    }

    public String toString() {
        return "(" + this.getLeft() + "," + this.getMiddle() + "," + this.getRight() + ")";
    }

    public String toString(String format) {
        return String.format(format, this.getLeft(), this.getMiddle(), this.getRight());
    }

    private static final class TripleAdapter<L, M, R>
    extends Triple<L, M, R> {
        private static final long serialVersionUID = 1L;

        private TripleAdapter() {
        }

        @Override
        public final L getLeft() {
            return null;
        }

        @Override
        public final M getMiddle() {
            return null;
        }

        @Override
        public final R getRight() {
            return null;
        }
    }
}

