/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.Validate;

abstract class FormatCache<F extends Format> {
    static final int NONE = -1;
    private final ConcurrentMap<ArrayKey, F> cInstanceCache = new ConcurrentHashMap<ArrayKey, F>(7);
    private static final ConcurrentMap<ArrayKey, String> cDateTimeInstanceCache = new ConcurrentHashMap<ArrayKey, String>(7);

    FormatCache() {
    }

    public F getInstance() {
        return this.getDateTimeInstance(3, 3, TimeZone.getDefault(), Locale.getDefault());
    }

    /*
     * WARNING - void declaration
     */
    public F getInstance(String pattern, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var2_2;
        Format previousValue;
        ArrayKey key;
        Format format;
        Validate.notNull(pattern, "pattern", new Object[0]);
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        if ((format = (Format)this.cInstanceCache.get(key = new ArrayKey(pattern, timeZone, locale = LocaleUtils.toLocale(locale)))) == null && (previousValue = this.cInstanceCache.putIfAbsent(key, format = this.createInstance(pattern, (TimeZone)var2_2, (Locale)var3_3))) != null) {
            void var1_1;
            format = var1_1;
        }
        return (F)format;
    }

    protected abstract F createInstance(String var1, TimeZone var2, Locale var3);

    /*
     * WARNING - void declaration
     */
    private F getDateTimeInstance(Integer dateStyle, Integer timeStyle, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var1_1;
        void var2_2;
        locale = LocaleUtils.toLocale(locale);
        String pattern = FormatCache.getPatternForStyle(dateStyle, (Integer)var2_2, locale);
        return this.getInstance((String)var1_1, (TimeZone)var3_3, locale);
    }

    /*
     * WARNING - void declaration
     */
    F getDateTimeInstance(int dateStyle, int timeStyle, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getDateTimeInstance((Integer)((int)var1_1), (Integer)((int)var2_2), (TimeZone)var3_3, locale);
    }

    /*
     * WARNING - void declaration
     */
    F getDateInstance(int dateStyle, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getDateTimeInstance((Integer)((int)var1_1), null, (TimeZone)var2_2, (Locale)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    F getTimeInstance(int timeStyle, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getDateTimeInstance(null, (Integer)((int)var1_1), (TimeZone)var2_2, (Locale)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static String getPatternForStyle(Integer dateStyle, Integer timeStyle, Locale locale) {
        Locale safeLocale = LocaleUtils.toLocale(locale);
        ArrayKey key = new ArrayKey(dateStyle, timeStyle, safeLocale);
        Object pattern = (String)cDateTimeInstanceCache.get(key);
        if (pattern == null) {
            try {
                void var3_3;
                void var1_1;
                String formatter;
                formatter = dateStyle == null ? DateFormat.getTimeInstance(timeStyle, safeLocale) : (timeStyle == null ? DateFormat.getDateInstance((Integer)((Object)formatter), safeLocale) : DateFormat.getDateTimeInstance((Integer)((Object)formatter), var1_1.intValue(), safeLocale));
                pattern = ((SimpleDateFormat)((Object)formatter)).toPattern();
                String previous = cDateTimeInstanceCache.putIfAbsent((ArrayKey)var3_3, (String)pattern);
                if (previous != null) {
                    String string;
                    pattern = string;
                }
            }
            catch (ClassCastException classCastException) {
                void var2_2;
                throw new IllegalArgumentException("No date time pattern for locale: " + var2_2);
            }
        }
        return pattern;
    }

    private static final class ArrayKey {
        private final Object[] keys;
        private final int hashCode;

        private static int computeHashCode(Object[] result) {
            Object[] objectArray;
            int n = 31 + Arrays.hashCode(objectArray);
            return n;
        }

        /*
         * WARNING - void declaration
         */
        ArrayKey(Object ... keys) {
            void var1_1;
            this.keys = keys;
            this.hashCode = ArrayKey.computeHashCode((Object[])var1_1);
        }

        public final int hashCode() {
            return this.hashCode;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            void var1_1;
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArrayKey other = (ArrayKey)obj;
            return Arrays.deepEquals(this.keys, var1_1.keys);
        }
    }
}

