/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.GmtTimeZone;

public class FastTimeZone {
    private static final Pattern GMT_PATTERN = Pattern.compile("^(?:(?i)GMT)?([+-])?(\\d\\d?)?(:?(\\d\\d?))?$");
    private static final TimeZone GREENWICH = new GmtTimeZone(false, 0, 0);

    public static TimeZone getGmtTimeZone() {
        return GREENWICH;
    }

    /*
     * WARNING - void declaration
     */
    public static TimeZone getGmtTimeZone(String pattern) {
        if ("Z".equals(pattern) || "UTC".equals(pattern)) {
            return GREENWICH;
        }
        Matcher m = GMT_PATTERN.matcher(pattern);
        if (m.matches()) {
            void var2_2;
            void var1_1;
            Matcher matcher;
            int hours = FastTimeZone.parseInt(m.group(2));
            int minutes = FastTimeZone.parseInt(m.group(4));
            if (hours == 0 && minutes == 0) {
                return GREENWICH;
            }
            return new GmtTimeZone(FastTimeZone.parseSign(matcher.group(1)), (int)var1_1, (int)var2_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static TimeZone getTimeZone(String id) {
        String string;
        TimeZone tz = FastTimeZone.getGmtTimeZone(id);
        if (tz != null) {
            void var1_1;
            return var1_1;
        }
        return TimeZone.getTimeZone(string);
    }

    private static int parseInt(String group) {
        if (group != null) {
            String string;
            return Integer.parseInt(string);
        }
        return 0;
    }

    private static boolean parseSign(String group) {
        String string;
        return group != null && string.charAt(0) == '-';
    }

    private FastTimeZone() {
    }
}

