/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class DurationFormatUtils {
    public static final String ISO_EXTENDED_FORMAT_PATTERN = "'P'yyyy'Y'M'M'd'DT'H'H'm'M's.SSS'S'";
    static final String y = "y";
    static final String M = "M";
    static final String d = "d";
    static final String H = "H";
    static final String m = "m";
    static final String s = "s";
    static final String S = "S";

    public static String formatDurationHMS(long durationMillis) {
        return DurationFormatUtils.formatDuration(durationMillis, "HH:mm:ss.SSS");
    }

    public static String formatDurationISO(long durationMillis) {
        return DurationFormatUtils.formatDuration(durationMillis, ISO_EXTENDED_FORMAT_PATTERN, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String formatDuration(long durationMillis, String format) {
        void var2_1;
        return DurationFormatUtils.formatDuration(durationMillis, (String)var2_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String formatDuration(long durationMillis, String format, boolean padWithZeros) {
        void var3_2;
        void var2_1;
        long l;
        Validate.inclusiveBetween(0L, Long.MAX_VALUE, durationMillis, "durationMillis must not be negative");
        Token[] tokens = DurationFormatUtils.lexx(format);
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        long milliseconds = l;
        if (Token.containsTokenWithValue(tokens, d)) {
            days = milliseconds / 86400000L;
            milliseconds -= days * 86400000L;
        }
        if (Token.containsTokenWithValue(tokens, H)) {
            hours = milliseconds / 3600000L;
            milliseconds -= hours * 3600000L;
        }
        if (Token.containsTokenWithValue(tokens, m)) {
            minutes = milliseconds / 60000L;
            milliseconds -= minutes * 60000L;
        }
        if (Token.containsTokenWithValue(tokens, s)) {
            seconds = milliseconds / 1000L;
            milliseconds -= seconds * 1000L;
        }
        return DurationFormatUtils.format((Token[])var2_1, 0L, 0L, days, hours, minutes, seconds, milliseconds, (boolean)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String formatDurationWords(long durationMillis, boolean suppressLeadingZeroElements, boolean suppressTrailingZeroElements) {
        String string;
        void var3_3;
        String tmp;
        void var2_2;
        String duration = DurationFormatUtils.formatDuration(durationMillis, "d' days 'H' hours 'm' minutes 's' seconds'");
        if (var2_2 != false) {
            tmp = StringUtils.replaceOnce(duration = " " + duration, " 0 days", "");
            if (tmp.length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 hours", "")).length() != duration.length()) {
                duration = tmp;
                duration = tmp = StringUtils.replaceOnce(duration, " 0 minutes", "");
                if (tmp.length() != duration.length()) {
                    duration = StringUtils.replaceOnce(tmp, " 0 seconds", "");
                }
            }
            if (!duration.isEmpty()) {
                duration = duration.substring(1);
            }
        }
        if (var3_3 != false && (tmp = StringUtils.replaceOnce(duration, " 0 seconds", "")).length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 minutes", "")).length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 hours", "")).length() != duration.length()) {
            void var1_4;
            duration = StringUtils.replaceOnce((String)var1_4, " 0 days", "");
        }
        string = " " + string;
        string = StringUtils.replaceOnce(string, " 1 seconds", " 1 second");
        string = StringUtils.replaceOnce(string, " 1 minutes", " 1 minute");
        string = StringUtils.replaceOnce(string, " 1 hours", " 1 hour");
        string = StringUtils.replaceOnce(string, " 1 days", " 1 day");
        return string.trim();
    }

    /*
     * WARNING - void declaration
     */
    public static String formatPeriodISO(long startMillis, long endMillis) {
        void var2_1;
        return DurationFormatUtils.formatPeriod(startMillis, (long)var2_1, ISO_EXTENDED_FORMAT_PATTERN, false, TimeZone.getDefault());
    }

    /*
     * WARNING - void declaration
     */
    public static String formatPeriod(long startMillis, long endMillis, String format) {
        void var2_2;
        return DurationFormatUtils.formatPeriod(startMillis, (long)var2_2, format, true, TimeZone.getDefault());
    }

    /*
     * WARNING - void declaration
     */
    public static String formatPeriod(long startMillis, long endMillis, String format, boolean padWithZeros, TimeZone timezone) {
        void var1_9;
        void var2_3;
        void var3_10;
        int n;
        Validate.isTrue(startMillis <= endMillis, "startMillis must not be greater than endMillis", new Object[0]);
        Token[] tokens = DurationFormatUtils.lexx(format);
        Calendar start = Calendar.getInstance(timezone);
        start.setTime(new Date(startMillis));
        Calendar end = Calendar.getInstance(timezone);
        end.setTime(new Date(endMillis));
        int milliseconds = end.get(14) - start.get(14);
        int seconds = end.get(13) - start.get(13);
        int minutes = end.get(12) - start.get(12);
        int hours = end.get(11) - start.get(11);
        int days = end.get(5) - start.get(5);
        int months = end.get(2) - start.get(2);
        int years = end.get(1) - start.get(1);
        while (milliseconds < 0) {
            milliseconds += 1000;
            --seconds;
        }
        while (seconds < 0) {
            seconds += 60;
            --minutes;
        }
        while (minutes < 0) {
            minutes += 60;
            --hours;
        }
        while (hours < 0) {
            hours += 24;
            --days;
        }
        if (Token.containsTokenWithValue(tokens, M)) {
            while (days < 0) {
                days += start.getActualMaximum(5);
                --months;
                start.add(2, 1);
            }
            while (months < 0) {
                months += 12;
                --years;
            }
            if (!Token.containsTokenWithValue(tokens, y) && years != 0) {
                while (years != 0) {
                    months += years * 12;
                    years = 0;
                }
            }
        } else {
            if (!Token.containsTokenWithValue(tokens, y)) {
                int target = end.get(1);
                if (months < 0) {
                    --target;
                }
                while (start.get(1) != target) {
                    days += start.getActualMaximum(6) - start.get(6);
                    if (start instanceof GregorianCalendar && start.get(2) == 1 && start.get(5) == 29) {
                        ++days;
                    }
                    start.add(1, 1);
                    days += start.get(6);
                }
                n = 0;
            }
            while (start.get(2) != end.get(2)) {
                days += start.getActualMaximum(5);
                start.add(2, 1);
            }
            months = 0;
            while (days < 0) {
                days += start.getActualMaximum(5);
                --months;
                start.add(2, 1);
            }
        }
        if (!Token.containsTokenWithValue(tokens, d)) {
            hours += days * 24;
            days = 0;
        }
        if (!Token.containsTokenWithValue(tokens, H)) {
            minutes += hours * 60;
            hours = 0;
        }
        if (!Token.containsTokenWithValue(tokens, m)) {
            seconds += minutes * 60;
            minutes = 0;
        }
        if (!Token.containsTokenWithValue(tokens, s)) {
            milliseconds += seconds * 1000;
            seconds = 0;
        }
        return DurationFormatUtils.format(tokens, n, months, days, hours, (long)var3_10, (long)var2_3, (long)var1_9, padWithZeros);
    }

    static String format(Token[] tokens, long years, long months, long days, long hours, long minutes, long seconds, long milliseconds, boolean padWithZeros) {
        Token[] tokenArray;
        StringBuilder buffer = new StringBuilder();
        boolean lastOutputSeconds = false;
        for (Token token : tokenArray) {
            Object value = token.getValue();
            int count = token.getCount();
            if (value instanceof StringBuilder) {
                buffer.append(value.toString());
                continue;
            }
            if (value.equals(y)) {
                buffer.append(DurationFormatUtils.paddedValue(years, padWithZeros, count));
            } else if (value.equals(M)) {
                buffer.append(DurationFormatUtils.paddedValue(months, padWithZeros, count));
            } else if (value.equals(d)) {
                buffer.append(DurationFormatUtils.paddedValue(days, padWithZeros, count));
            } else if (value.equals(H)) {
                buffer.append(DurationFormatUtils.paddedValue(hours, padWithZeros, count));
            } else if (value.equals(m)) {
                buffer.append(DurationFormatUtils.paddedValue(minutes, padWithZeros, count));
            } else {
                if (value.equals(s)) {
                    buffer.append(DurationFormatUtils.paddedValue(seconds, padWithZeros, count));
                    lastOutputSeconds = true;
                    continue;
                }
                if (!value.equals(S)) continue;
                if (lastOutputSeconds) {
                    int width = padWithZeros ? Math.max(3, count) : 3;
                    buffer.append(DurationFormatUtils.paddedValue(milliseconds, true, width));
                } else {
                    buffer.append(DurationFormatUtils.paddedValue(milliseconds, padWithZeros, count));
                }
            }
            boolean bl = false;
        }
        return buffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String paddedValue(long value, boolean padWithZeros, int count) {
        void var0_1;
        void var2_2;
        String longString = Long.toString(value);
        if (var2_2 != false) {
            void var3_3;
            return StringUtils.leftPad(longString, (int)var3_3, '0');
        }
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    static Token[] lexx(String format) {
        void var1_1;
        void var2_2;
        ArrayList<Token> list = new ArrayList<Token>(format.length());
        boolean inLiteral = false;
        StringBuilder buffer = null;
        Token previous = null;
        for (int i = 0; i < format.length(); ++i) {
            Object var3_3;
            char ch = format.charAt(i);
            if (inLiteral && ch != '\'') {
                buffer.append(ch);
                continue;
            }
            String value = null;
            switch (ch) {
                case '\'': {
                    if (inLiteral) {
                        buffer = null;
                        inLiteral = false;
                        break;
                    }
                    buffer = new StringBuilder();
                    list.add(new Token(buffer));
                    inLiteral = true;
                    break;
                }
                case 'y': {
                    value = y;
                    break;
                }
                case 'M': {
                    value = M;
                    break;
                }
                case 'd': {
                    value = d;
                    break;
                }
                case 'H': {
                    value = H;
                    break;
                }
                case 'm': {
                    value = m;
                    break;
                }
                case 's': {
                    value = s;
                    break;
                }
                case 'S': {
                    value = S;
                    break;
                }
                default: {
                    if (buffer == null) {
                        buffer = new StringBuilder();
                        list.add(new Token(buffer));
                    }
                    buffer.append(ch);
                }
            }
            if (value == null) continue;
            if (previous != null && previous.getValue().equals(value)) {
                previous.increment();
            } else {
                Token token = new Token(value);
                list.add(token);
                previous = var3_3;
            }
            var3_3 = null;
        }
        if (var2_2 != false) {
            String string;
            throw new IllegalArgumentException("Unmatched quote in format: " + string);
        }
        return var1_1.toArray(Token.EMPTY_ARRAY);
    }

    static class Token {
        private static final Token[] EMPTY_ARRAY = new Token[0];
        private final Object value;
        private int count;

        static boolean containsTokenWithValue(Token[] tokens, Object value) {
            Token[] tokenArray = tokens;
            int n = tokens.length;
            for (int i = 0; i < n; ++i) {
                Token token = tokenArray[i];
                if (token.getValue() != value) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        Token(Object value) {
            void var1_1;
            this.value = var1_1;
            this.count = 1;
        }

        /*
         * WARNING - void declaration
         */
        Token(Object value, int count) {
            void var2_2;
            void var1_1;
            this.value = var1_1;
            this.count = var2_2;
        }

        void increment() {
            ++this.count;
        }

        int getCount() {
            return this.count;
        }

        Object getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj2) {
            if (obj2 instanceof Token) {
                void var1_1;
                Token tok2 = (Token)obj2;
                if (this.value.getClass() != tok2.value.getClass()) {
                    return false;
                }
                if (this.count != tok2.count) {
                    return false;
                }
                if (this.value instanceof StringBuilder) {
                    return this.value.toString().equals(tok2.value.toString());
                }
                if (this.value instanceof Number) {
                    return this.value.equals(tok2.value);
                }
                return this.value == var1_1.value;
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return StringUtils.repeat(this.value.toString(), this.count);
        }
    }
}

