/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class WordUtils {
    /*
     * WARNING - void declaration
     */
    public static String wrap(String str, int wrapLength) {
        void var1_1;
        return WordUtils.wrap(str, (int)var1_1, null, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String wrap(String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
        void var3_3;
        void var2_2;
        void var1_1;
        return WordUtils.wrap(str, (int)var1_1, (String)var2_2, (boolean)var3_3, " ");
    }

    public static String wrap(String str, int wrapLength, String newLineStr, boolean wrapLongWords, String wrapOn) {
        String string;
        if (str == null) {
            return null;
        }
        if (newLineStr == null) {
            newLineStr = System.lineSeparator();
        }
        if (wrapLength <= 0) {
            wrapLength = 1;
        }
        if (StringUtils.isBlank(wrapOn)) {
            wrapOn = " ";
        }
        Pattern patternToWrapOn = Pattern.compile(wrapOn);
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        while (offset < inputLineLength) {
            int spaceToWrapAt = -1;
            Matcher matcher = patternToWrapOn.matcher(str.substring(offset, Math.min((int)Math.min(Integer.MAX_VALUE, (long)(offset + wrapLength) + 1L), inputLineLength)));
            if (matcher.find()) {
                if (matcher.start() == 0) {
                    offset += matcher.end();
                    continue;
                }
                spaceToWrapAt = matcher.start() + offset;
            }
            if (inputLineLength - offset <= wrapLength) break;
            while (matcher.find()) {
                spaceToWrapAt = matcher.start() + offset;
            }
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                wrappedLine.append(str, offset, wrapLength + offset);
                wrappedLine.append(newLineStr);
                offset += wrapLength;
                continue;
            }
            matcher = patternToWrapOn.matcher(str.substring(offset + wrapLength));
            if (matcher.find()) {
                spaceToWrapAt = matcher.start() + offset + wrapLength;
            }
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str, offset, str.length());
            offset = inputLineLength;
        }
        wrappedLine.append(str, offset, string.length());
        return wrappedLine.toString();
    }

    public static String capitalize(String str) {
        return WordUtils.capitalize(str, null);
    }

    public static String capitalize(String str, char ... delimiters) {
        Object object;
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length;
        if (StringUtils.isEmpty(str) || delimLen == 0) {
            return str;
        }
        Object buffer = str.toCharArray();
        boolean capitalizeNext = true;
        for (int i = 0; i < ((Object)buffer).length; ++i) {
            Object ch = buffer[i];
            if (WordUtils.isDelimiter((char)ch, delimiters)) {
                capitalizeNext = true;
                continue;
            }
            if (!capitalizeNext) continue;
            buffer[i] = Character.toTitleCase((char)ch);
            capitalizeNext = false;
        }
        return new String((char[])object);
    }

    public static String capitalizeFully(String str) {
        return WordUtils.capitalizeFully(str, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String capitalizeFully(String str, char ... delimiters) {
        void var1_1;
        String string;
        void var2_2;
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length;
        if (StringUtils.isEmpty(str) || var2_2 == false) {
            return str;
        }
        string = string.toLowerCase();
        return WordUtils.capitalize(string, (char[])var1_1);
    }

    public static String uncapitalize(String str) {
        return WordUtils.uncapitalize(str, null);
    }

    public static String uncapitalize(String str, char ... delimiters) {
        Object object;
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length;
        if (StringUtils.isEmpty(str) || delimLen == 0) {
            return str;
        }
        Object buffer = str.toCharArray();
        boolean uncapitalizeNext = true;
        for (int i = 0; i < ((Object)buffer).length; ++i) {
            Object ch = buffer[i];
            if (WordUtils.isDelimiter((char)ch, delimiters)) {
                uncapitalizeNext = true;
                continue;
            }
            if (!uncapitalizeNext) continue;
            buffer[i] = Character.toLowerCase((char)ch);
            uncapitalizeNext = false;
        }
        return new String((char[])object);
    }

    /*
     * WARNING - void declaration
     */
    public static String swapCase(String str) {
        Object object;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        Object buffer = str.toCharArray();
        boolean whitespace = true;
        for (int i = 0; i < ((Object)buffer).length; ++i) {
            void var3_3;
            Object ch = buffer[i];
            if (Character.isUpperCase((char)ch) || Character.isTitleCase((char)ch)) {
                buffer[i] = Character.toLowerCase((char)ch);
                whitespace = false;
                continue;
            }
            if (Character.isLowerCase((char)ch)) {
                if (whitespace) {
                    buffer[i] = Character.toTitleCase((char)ch);
                    whitespace = false;
                    continue;
                }
                buffer[i] = Character.toUpperCase((char)ch);
                continue;
            }
            whitespace = Character.isWhitespace((char)var3_3);
        }
        return new String((char[])object);
    }

    public static String initials(String str) {
        return WordUtils.initials(str, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String initials(String str, char ... delimiters) {
        void var3_3;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (delimiters != null && delimiters.length == 0) {
            return "";
        }
        int strLen = str.length();
        char[] buf = new char[strLen / 2 + 1];
        int count = 0;
        boolean lastWasGap = true;
        for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            if (WordUtils.isDelimiter(ch, delimiters)) {
                lastWasGap = true;
                continue;
            }
            if (!lastWasGap) continue;
            buf[count++] = ch;
            lastWasGap = false;
        }
        return new String((char[])var3_3, 0, count);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsAllWords(CharSequence word, CharSequence ... words) {
        void var1_1;
        if (StringUtils.isEmpty(word) || ArrayUtils.isEmpty(words)) {
            return false;
        }
        for (void w : var1_1) {
            if (StringUtils.isBlank((CharSequence)w)) {
                return false;
            }
            Pattern pattern = Pattern.compile(".*\\b" + w + "\\b.*");
            if (pattern.matcher(word).matches()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isDelimiter(char ch, char[] delimiters) {
        void var1_1;
        if (delimiters == null) {
            return Character.isWhitespace(ch);
        }
        for (void delimiter : var1_1) {
            if (ch != delimiter) continue;
            return true;
        }
        return false;
    }
}

