/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.text.StrMatcher;
import org.apache.commons.lang3.text.StrTokenizer;

@Deprecated
public class StrBuilder
implements Serializable,
Appendable,
CharSequence,
Builder<String> {
    static final int CAPACITY = 32;
    private static final long serialVersionUID = 7628716375283629643L;
    protected char[] buffer;
    protected int size;
    private String newLine;
    private String nullText;

    public StrBuilder() {
        this(32);
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder(int initialCapacity) {
        void var1_1;
        if (initialCapacity <= 0) {
            initialCapacity = 32;
        }
        this.buffer = new char[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder(String str) {
        void var1_1;
        if (str == null) {
            this.buffer = new char[32];
            return;
        }
        this.buffer = new char[str.length() + 32];
        this.append((String)var1_1);
    }

    public String getNewLineText() {
        return this.newLine;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder setNewLineText(String newLine) {
        void var1_1;
        this.newLine = var1_1;
        return this;
    }

    public String getNullText() {
        return this.nullText;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder setNullText(String nullText) {
        void var1_1;
        if (nullText != null && nullText.isEmpty()) {
            nullText = null;
        }
        this.nullText = var1_1;
        return this;
    }

    @Override
    public int length() {
        return this.size;
    }

    public StrBuilder setLength(int length) {
        if (length < 0) {
            throw new StringIndexOutOfBoundsException(length);
        }
        if (length < this.size) {
            this.size = length;
        } else if (length > this.size) {
            this.ensureCapacity(length);
            int oldEnd = this.size;
            int newEnd = length;
            this.size = length;
            for (void i = var2_2; i < newEnd; ++i) {
                this.buffer[i] = '\u0000';
            }
        }
        return this;
    }

    public int capacity() {
        return this.buffer.length;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder ensureCapacity(int capacity) {
        if (capacity > this.buffer.length) {
            void var2_2;
            void var1_1;
            char[] old = this.buffer;
            this.buffer = new char[var1_1 << 1];
            System.arraycopy(var2_2, 0, this.buffer, 0, this.size);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder minimizeCapacity() {
        if (this.buffer.length > this.length()) {
            void var1_1;
            char[] old = this.buffer;
            this.buffer = new char[this.length()];
            System.arraycopy(var1_1, 0, this.buffer, 0, this.size);
        }
        return this;
    }

    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isNotEmpty() {
        return this.size > 0;
    }

    public StrBuilder clear() {
        this.size = 0;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public char charAt(int index) {
        void var1_1;
        if (index < 0 || index >= this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.buffer[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder setCharAt(int index, char ch) {
        void var2_2;
        if (index < 0 || index >= this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.buffer[var1_1] = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder deleteCharAt(int index) {
        void var1_1;
        if (index < 0 || index >= this.size) {
            throw new StringIndexOutOfBoundsException(index);
        }
        void v0 = var1_1;
        this.deleteImpl((int)v0, (int)(v0 + true), 1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public char[] toCharArray() {
        void var1_1;
        if (this.size == 0) {
            return ArrayUtils.EMPTY_CHAR_ARRAY;
        }
        char[] chars = new char[this.size];
        System.arraycopy(this.buffer, 0, chars, 0, this.size);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public char[] toCharArray(int startIndex, int endIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        int len = (endIndex = this.validateRange(startIndex, endIndex)) - startIndex;
        if (len == 0) {
            return ArrayUtils.EMPTY_CHAR_ARRAY;
        }
        char[] chars = new char[len];
        System.arraycopy(this.buffer, (int)var1_1, chars, 0, (int)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public char[] getChars(char[] destination) {
        void var1_1;
        void var2_2;
        int len = this.length();
        if (destination == null || destination.length < len) {
            destination = new char[len];
        }
        System.arraycopy(this.buffer, 0, destination, 0, (int)var2_2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void getChars(int startIndex, int endIndex, char[] destination, int destinationIndex) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (startIndex < 0) {
            throw new StringIndexOutOfBoundsException(startIndex);
        }
        if (endIndex < 0 || endIndex > this.length()) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (startIndex > endIndex) {
            throw new StringIndexOutOfBoundsException("end < start");
        }
        System.arraycopy(this.buffer, startIndex, var3_3, destinationIndex, (int)(var2_2 - var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public int readFrom(Readable readable) throws IOException {
        void var2_2;
        int oldSize = this.size;
        if (readable instanceof Reader) {
            int read;
            Reader r = (Reader)readable;
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + 1);
            while ((read = r.read(this.buffer, this.size, this.buffer.length - this.size)) != -1) {
                this.size += read;
                StrBuilder strBuilder2 = this;
                strBuilder2.ensureCapacity(strBuilder2.size + 1);
            }
        } else if (readable instanceof CharBuffer) {
            CharBuffer cb = (CharBuffer)readable;
            int remaining = cb.remaining();
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + remaining);
            cb.get(this.buffer, this.size, remaining);
            this.size += remaining;
        } else {
            while (true) {
                void var3_5;
                StrBuilder strBuilder = this;
                strBuilder.ensureCapacity(strBuilder.size + 1);
                CharBuffer buf = CharBuffer.wrap(this.buffer, this.size, this.buffer.length - this.size);
                int read = readable.read((CharBuffer)var3_5);
                if (read == -1) break;
                this.size += read;
            }
        }
        return this.size - var2_2;
    }

    public StrBuilder appendNewLine() {
        if (this.newLine == null) {
            this.append(System.lineSeparator());
            return this;
        }
        StrBuilder strBuilder = this;
        return strBuilder.append(strBuilder.newLine);
    }

    public StrBuilder appendNull() {
        if (this.nullText == null) {
            return this;
        }
        StrBuilder strBuilder = this;
        return strBuilder.append(strBuilder.nullText);
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(Object obj) {
        void var1_1;
        if (obj == null) {
            return this.appendNull();
        }
        if (obj instanceof CharSequence) {
            return this.append((CharSequence)obj);
        }
        return this.append(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StrBuilder append(CharSequence seq) {
        void var1_1;
        if (seq == null) {
            return this.appendNull();
        }
        if (seq instanceof StrBuilder) {
            return this.append((StrBuilder)seq);
        }
        if (seq instanceof StringBuilder) {
            return this.append((StringBuilder)seq);
        }
        if (seq instanceof StringBuffer) {
            return this.append((StringBuffer)seq);
        }
        if (seq instanceof CharBuffer) {
            return this.append((CharBuffer)seq);
        }
        return this.append(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StrBuilder append(CharSequence seq, int startIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (seq == null) {
            return this.appendNull();
        }
        return this.append(var1_1.toString(), (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(String str) {
        if (str == null) {
            return this.appendNull();
        }
        int strLen = str.length();
        if (strLen > 0) {
            void var2_2;
            void var3_3;
            void var1_1;
            int len = this.length();
            this.ensureCapacity(len + strLen);
            var1_1.getChars(0, strLen, this.buffer, (int)var3_3);
            this.size += var2_2;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(String str, int startIndex, int length) {
        if (str == null) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > str.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (length < 0 || startIndex + length > str.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (length > 0) {
            void var3_3;
            void var1_1;
            void var2_2;
            int len = this.length();
            this.ensureCapacity(len + length);
            void v0 = var2_2;
            var1_1.getChars((int)v0, (int)(v0 + length), this.buffer, len);
            this.size += var3_3;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(String format, Object ... objs) {
        void var2_2;
        void var1_1;
        return this.append(String.format((String)var1_1, (Object[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(CharBuffer buf) {
        if (buf == null) {
            return this.appendNull();
        }
        if (buf.hasArray()) {
            void var2_2;
            void var3_3;
            int length = buf.remaining();
            int len = this.length();
            this.ensureCapacity(len + length);
            System.arraycopy(buf.array(), buf.arrayOffset() + buf.position(), this.buffer, (int)var3_3, length);
            this.size += var2_2;
        } else {
            void var1_1;
            this.append(var1_1.toString());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(CharBuffer buf, int startIndex, int length) {
        if (buf == null) {
            return this.appendNull();
        }
        if (buf.hasArray()) {
            int totalLength = buf.remaining();
            if (startIndex < 0 || startIndex > totalLength) {
                throw new StringIndexOutOfBoundsException("startIndex must be valid");
            }
            if (length < 0 || startIndex + length > totalLength) {
                throw new StringIndexOutOfBoundsException("length must be valid");
            }
            int len = this.length();
            this.ensureCapacity(len + length);
            System.arraycopy(buf.array(), buf.arrayOffset() + buf.position() + startIndex, this.buffer, len, length);
            this.size += length;
        } else {
            void var3_3;
            void var2_2;
            void var1_1;
            this.append(var1_1.toString(), (int)var2_2, (int)var3_3);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(StringBuffer str) {
        if (str == null) {
            return this.appendNull();
        }
        int strLen = str.length();
        if (strLen > 0) {
            void var2_2;
            void var3_3;
            void var1_1;
            int len = this.length();
            this.ensureCapacity(len + strLen);
            var1_1.getChars(0, strLen, this.buffer, (int)var3_3);
            this.size += var2_2;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(StringBuffer str, int startIndex, int length) {
        if (str == null) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > str.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (length < 0 || startIndex + length > str.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (length > 0) {
            void var3_3;
            void var1_1;
            void var2_2;
            int len = this.length();
            this.ensureCapacity(len + length);
            void v0 = var2_2;
            var1_1.getChars((int)v0, (int)(v0 + length), this.buffer, len);
            this.size += var3_3;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(StringBuilder str) {
        if (str == null) {
            return this.appendNull();
        }
        int strLen = str.length();
        if (strLen > 0) {
            void var2_2;
            void var3_3;
            void var1_1;
            int len = this.length();
            this.ensureCapacity(len + strLen);
            var1_1.getChars(0, strLen, this.buffer, (int)var3_3);
            this.size += var2_2;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(StringBuilder str, int startIndex, int length) {
        if (str == null) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > str.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (length < 0 || startIndex + length > str.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (length > 0) {
            void var3_3;
            void var1_1;
            void var2_2;
            int len = this.length();
            this.ensureCapacity(len + length);
            void v0 = var2_2;
            var1_1.getChars((int)v0, (int)(v0 + length), this.buffer, len);
            this.size += var3_3;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(StrBuilder str) {
        if (str == null) {
            return this.appendNull();
        }
        int strLen = str.length();
        if (strLen > 0) {
            void var2_2;
            void var3_3;
            void var1_1;
            int len = this.length();
            this.ensureCapacity(len + strLen);
            System.arraycopy(var1_1.buffer, 0, this.buffer, (int)var3_3, strLen);
            this.size += var2_2;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(StrBuilder str, int startIndex, int length) {
        if (str == null) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > str.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (length < 0 || startIndex + length > str.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (length > 0) {
            void var3_3;
            void var1_1;
            void var2_2;
            int len = this.length();
            this.ensureCapacity(len + length);
            void v0 = var2_2;
            var1_1.getChars((int)v0, (int)(v0 + length), this.buffer, len);
            this.size += var3_3;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(char[] chars) {
        if (chars == null) {
            return this.appendNull();
        }
        int strLen = chars.length;
        if (strLen > 0) {
            void var2_2;
            void var3_3;
            void var1_1;
            int len = this.length();
            this.ensureCapacity(len + strLen);
            System.arraycopy(var1_1, 0, this.buffer, (int)var3_3, strLen);
            this.size += var2_2;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(char[] chars, int startIndex, int length) {
        if (chars == null) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > chars.length) {
            throw new StringIndexOutOfBoundsException("Invalid startIndex: " + length);
        }
        if (length < 0 || startIndex + length > chars.length) {
            throw new StringIndexOutOfBoundsException("Invalid length: " + length);
        }
        if (length > 0) {
            void var3_3;
            void var2_2;
            void var1_1;
            int len = this.length();
            this.ensureCapacity(len + length);
            System.arraycopy(var1_1, (int)var2_2, this.buffer, len, length);
            this.size += var3_3;
        }
        return this;
    }

    public StrBuilder append(boolean value) {
        if (value) {
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + 4);
            this.buffer[this.size++] = 116;
            this.buffer[this.size++] = 114;
            this.buffer[this.size++] = 117;
            this.buffer[this.size++] = 101;
        } else {
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + 5);
            this.buffer[this.size++] = 102;
            this.buffer[this.size++] = 97;
            this.buffer[this.size++] = 108;
            this.buffer[this.size++] = 115;
            this.buffer[this.size++] = 101;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StrBuilder append(char ch) {
        void var1_1;
        void var2_2;
        int len = this.length();
        this.ensureCapacity((int)(var2_2 + true));
        this.buffer[this.size++] = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(int value) {
        void var1_1;
        return this.append(String.valueOf((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(long value) {
        void var1_1;
        return this.append(String.valueOf((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(float value) {
        void var1_1;
        return this.append(String.valueOf((float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(double value) {
        void var1_1;
        return this.append(String.valueOf((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(Object obj) {
        void var1_1;
        return this.append(var1_1).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(String str) {
        void var1_1;
        return this.append((String)var1_1).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(String str, int startIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.append((String)var1_1, (int)var2_2, (int)var3_3).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(String format, Object ... objs) {
        void var2_2;
        void var1_1;
        return this.append((String)var1_1, (Object[])var2_2).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(StringBuffer str) {
        void var1_1;
        return this.append((StringBuffer)var1_1).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(StringBuilder str) {
        void var1_1;
        return this.append((StringBuilder)var1_1).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(StringBuilder str, int startIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.append((StringBuilder)var1_1, (int)var2_2, (int)var3_3).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(StringBuffer str, int startIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.append((StringBuffer)var1_1, (int)var2_2, (int)var3_3).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(StrBuilder str) {
        void var1_1;
        return this.append((StrBuilder)var1_1).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(StrBuilder str, int startIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.append((StrBuilder)var1_1, (int)var2_2, (int)var3_3).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(char[] chars) {
        void var1_1;
        return this.append((char[])var1_1).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(char[] chars, int startIndex, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.append((char[])var1_1, (int)var2_2, (int)var3_3).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(boolean value) {
        void var1_1;
        return this.append((boolean)var1_1).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(char ch) {
        void var1_1;
        return this.append((char)var1_1).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(int value) {
        void var1_1;
        return this.append((int)var1_1).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(long value) {
        void var1_1;
        return this.append((long)var1_1).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(float value) {
        void var1_1;
        return this.append((float)var1_1).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendln(double value) {
        void var1_1;
        return this.append((double)var1_1).appendNewLine();
    }

    /*
     * WARNING - void declaration
     */
    public <T> StrBuilder appendAll(T ... array) {
        if (ArrayUtils.isNotEmpty(array)) {
            void var1_1;
            for (void element : var1_1) {
                this.append(element);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendAll(Iterable<?> iterable) {
        if (iterable != null) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Object o = iterator.next();
                this.append(var2_2);
            }
        }
        return this;
    }

    public StrBuilder appendAll(Iterator<?> it) {
        if (it != null) {
            while (it.hasNext()) {
                this.append(it.next());
            }
        }
        return this;
    }

    public StrBuilder appendWithSeparators(Object[] array, String separator) {
        if (array != null && array.length > 0) {
            String sep = Objects.toString(separator, "");
            this.append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                this.append(sep);
                this.append(array[i]);
            }
        }
        return this;
    }

    public StrBuilder appendWithSeparators(Iterable<?> iterable, String separator) {
        if (iterable != null) {
            String sep = Objects.toString(separator, "");
            Iterator<?> it = iterable.iterator();
            while (it.hasNext()) {
                this.append(it.next());
                if (!it.hasNext()) continue;
                this.append(sep);
            }
        }
        return this;
    }

    public StrBuilder appendWithSeparators(Iterator<?> it, String separator) {
        if (it != null) {
            String sep = Objects.toString(separator, "");
            while (it.hasNext()) {
                this.append(it.next());
                if (!it.hasNext()) continue;
                this.append(sep);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendSeparator(String separator) {
        void var1_1;
        return this.appendSeparator((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendSeparator(String standard, String defaultIfEmpty) {
        void var2_2;
        Object str = this.isEmpty() ? var2_2 : standard;
        if (str != null) {
            void var1_1;
            this.append((String)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendSeparator(char separator) {
        if (this.isNotEmpty()) {
            void var1_1;
            this.append((char)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendSeparator(char standard, char defaultIfEmpty) {
        if (this.isNotEmpty()) {
            void var1_1;
            this.append((char)var1_1);
        } else {
            void var2_2;
            this.append((char)var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendSeparator(String separator, int loopIndex) {
        void var2_2;
        if (separator != null && var2_2 > 0) {
            void var1_1;
            this.append((String)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendSeparator(char separator, int loopIndex) {
        if (loopIndex > 0) {
            void var1_1;
            this.append((char)var1_1);
        }
        return this;
    }

    public StrBuilder appendPadding(int length, char padChar) {
        if (length >= 0) {
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + length);
            for (int i = 0; i < length; ++i) {
                this.buffer[this.size++] = padChar;
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendFixedWidthPadLeft(Object obj, int width, char padChar) {
        if (width > 0) {
            void var2_2;
            int strLen;
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + width);
            String str = obj == null ? this.getNullText() : obj.toString();
            if (str == null) {
                str = "";
            }
            if ((strLen = str.length()) >= width) {
                str.getChars(strLen - width, strLen, this.buffer, this.size);
            } else {
                void var1_1;
                int padLen = width - strLen;
                for (int i = 0; i < padLen; ++i) {
                    this.buffer[this.size + i] = padChar;
                }
                var1_1.getChars(0, strLen, this.buffer, this.size + padLen);
            }
            this.size += var2_2;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendFixedWidthPadLeft(int value, int width, char padChar) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.appendFixedWidthPadLeft(String.valueOf((int)var1_1), (int)var2_2, (char)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendFixedWidthPadRight(Object obj, int width, char padChar) {
        if (width > 0) {
            void var2_3;
            int strLen;
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + width);
            String str = obj == null ? this.getNullText() : obj.toString();
            if (str == null) {
                str = "";
            }
            if ((strLen = str.length()) >= width) {
                str.getChars(0, width, this.buffer, this.size);
            } else {
                int padLen = width - strLen;
                str.getChars(0, strLen, this.buffer, this.size);
                for (int i = 0; i < padLen; ++i) {
                    this.buffer[this.size + strLen + i] = padChar;
                }
            }
            this.size += var2_3;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder appendFixedWidthPadRight(int value, int width, char padChar) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.appendFixedWidthPadRight(String.valueOf((int)var1_1), (int)var2_2, (char)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder insert(int index, Object obj) {
        void var2_2;
        void var1_1;
        if (obj == null) {
            return this.insert(index, this.nullText);
        }
        return this.insert((int)var1_1, var2_2.toString());
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder insert(int index, String str) {
        int strLen;
        this.validateIndex(index);
        if (str == null) {
            str = this.nullText;
        }
        if (str != null && (strLen = str.length()) > 0) {
            void var1_1;
            void var3_3;
            void var2_2;
            int newSize = this.size + strLen;
            this.ensureCapacity(newSize);
            System.arraycopy(this.buffer, index, this.buffer, index + strLen, this.size - index);
            this.size = newSize;
            var2_2.getChars(0, (int)var3_3, this.buffer, (int)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder insert(int index, char[] chars) {
        this.validateIndex(index);
        if (chars == null) {
            return this.insert(index, this.nullText);
        }
        int len = chars.length;
        if (len > 0) {
            void var3_3;
            void var1_1;
            void var2_2;
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + len);
            System.arraycopy(this.buffer, index, this.buffer, index + len, this.size - index);
            System.arraycopy(var2_2, 0, this.buffer, (int)var1_1, len);
            this.size += var3_3;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder insert(int index, char[] chars, int offset, int length) {
        this.validateIndex(index);
        if (chars == null) {
            return this.insert(index, this.nullText);
        }
        if (offset < 0 || offset > chars.length) {
            throw new StringIndexOutOfBoundsException("Invalid offset: " + offset);
        }
        if (length < 0 || offset + length > chars.length) {
            throw new StringIndexOutOfBoundsException("Invalid length: " + length);
        }
        if (length > 0) {
            void var1_1;
            void var3_3;
            void var2_2;
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + length);
            System.arraycopy(this.buffer, index, this.buffer, index + length, this.size - index);
            System.arraycopy(var2_2, (int)var3_3, this.buffer, (int)var1_1, length);
            this.size += length;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder insert(int index, boolean value) {
        void var2_2;
        this.validateIndex(index);
        if (var2_2 != false) {
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + 4);
            System.arraycopy(this.buffer, index, this.buffer, index + 4, this.size - index);
            this.buffer[index++] = 116;
            this.buffer[index++] = 114;
            this.buffer[index++] = 117;
            this.buffer[index] = 101;
            this.size += 4;
        } else {
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + 5);
            System.arraycopy(this.buffer, index, this.buffer, index + 5, this.size - index);
            this.buffer[index++] = 102;
            this.buffer[index++] = 97;
            this.buffer[index++] = 108;
            this.buffer[index++] = 115;
            this.buffer[var1_1] = 101;
            this.size += 5;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder insert(int index, char value) {
        void var2_2;
        this.validateIndex(index);
        StrBuilder strBuilder = this;
        strBuilder.ensureCapacity(strBuilder.size + 1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.size - index);
        this.buffer[var1_1] = var2_2;
        ++this.size;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder insert(int index, int value) {
        void var2_2;
        void var1_1;
        return this.insert((int)var1_1, String.valueOf((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder insert(int index, long value) {
        void var2_2;
        void var1_1;
        return this.insert((int)var1_1, String.valueOf((long)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder insert(int index, float value) {
        void var2_2;
        void var1_1;
        return this.insert((int)var1_1, String.valueOf((float)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder insert(int index, double value) {
        void var2_2;
        void var1_1;
        return this.insert((int)var1_1, String.valueOf((double)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private void deleteImpl(int startIndex, int endIndex, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        System.arraycopy(this.buffer, endIndex, this.buffer, (int)var1_1, this.size - var2_2);
        this.size -= var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder delete(int startIndex, int endIndex) {
        int len = (endIndex = this.validateRange(startIndex, endIndex)) - startIndex;
        if (len > 0) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.deleteImpl((int)var1_1, (int)var2_2, (int)var3_3);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder deleteAll(char ch) {
        for (int i = 0; i < this.size; ++i) {
            void var3_3;
            if (this.buffer[i] != ch) continue;
            int start = i;
            while (++i < this.size && this.buffer[i] == ch) {
            }
            int len = i - start;
            this.deleteImpl((int)var3_3, i, len);
            i -= len;
        }
        return this;
    }

    public StrBuilder deleteFirst(char ch) {
        for (int i = 0; i < this.size; ++i) {
            if (this.buffer[i] != ch) continue;
            int n = i;
            this.deleteImpl(n, n + 1, 1);
            break;
        }
        return this;
    }

    public StrBuilder deleteAll(String str) {
        int len = str == null ? 0 : str.length();
        if (len > 0) {
            int index = this.indexOf(str, 0);
            while (index >= 0) {
                int n = index;
                this.deleteImpl(n, n + len, len);
                index = this.indexOf(str, index);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder deleteFirst(String str) {
        int index;
        int len = str == null ? 0 : str.length();
        if (len > 0 && (index = this.indexOf(str, 0)) >= 0) {
            void var2_3;
            void var1_2;
            void v0 = var1_2;
            this.deleteImpl((int)v0, (int)(v0 + len), (int)var2_3);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder deleteAll(StrMatcher matcher) {
        void var1_1;
        return this.replace((StrMatcher)var1_1, null, 0, this.size, -1);
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder deleteFirst(StrMatcher matcher) {
        void var1_1;
        return this.replace((StrMatcher)var1_1, null, 0, this.size, 1);
    }

    /*
     * WARNING - void declaration
     */
    private void replaceImpl(int startIndex, int endIndex, int removeLen, String insertStr, int insertLen) {
        void var3_3;
        int newSize = this.size - removeLen + insertLen;
        if (insertLen != var3_3) {
            void var2_2;
            this.ensureCapacity(newSize);
            System.arraycopy(this.buffer, endIndex, this.buffer, startIndex + insertLen, this.size - var2_2);
            this.size = newSize;
        }
        if (insertLen > 0) {
            void var1_1;
            insertStr.getChars(0, insertLen, this.buffer, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder replace(int startIndex, int endIndex, String replaceStr) {
        void var3_3;
        void var1_1;
        void var2_2;
        endIndex = this.validateRange(startIndex, endIndex);
        int insertLen = replaceStr == null ? 0 : replaceStr.length();
        void v0 = var2_2;
        this.replaceImpl(startIndex, (int)v0, (int)(v0 - var1_1), (String)var3_3, insertLen);
        return this;
    }

    public StrBuilder replaceAll(char search, char replace) {
        if (search != replace) {
            for (int i = 0; i < this.size; ++i) {
                if (this.buffer[i] != search) continue;
                this.buffer[i] = replace;
            }
        }
        return this;
    }

    public StrBuilder replaceFirst(char search, char replace) {
        if (search != replace) {
            for (int i = 0; i < this.size; ++i) {
                if (this.buffer[i] != search) continue;
                this.buffer[i] = replace;
                break;
            }
        }
        return this;
    }

    public StrBuilder replaceAll(String searchStr, String replaceStr) {
        int searchLen = searchStr == null ? 0 : searchStr.length();
        if (searchLen > 0) {
            int replaceLen = replaceStr == null ? 0 : replaceStr.length();
            int index = this.indexOf(searchStr, 0);
            while (index >= 0) {
                int n = index;
                this.replaceImpl(n, n + searchLen, searchLen, replaceStr, replaceLen);
                index = this.indexOf(searchStr, index + replaceLen);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder replaceFirst(String searchStr, String replaceStr) {
        int index;
        int searchLen = searchStr == null ? 0 : searchStr.length();
        if (searchLen > 0 && (index = this.indexOf(searchStr, 0)) >= 0) {
            void var2_3;
            void var3_4;
            void var1_2;
            int replaceLen = replaceStr == null ? 0 : replaceStr.length();
            void v0 = var1_2;
            this.replaceImpl((int)v0, (int)(v0 + searchLen), (int)var3_4, (String)var2_3, replaceLen);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder replaceAll(StrMatcher matcher, String replaceStr) {
        void var2_2;
        void var1_1;
        return this.replace((StrMatcher)var1_1, (String)var2_2, 0, this.size, -1);
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder replaceFirst(StrMatcher matcher, String replaceStr) {
        void var2_2;
        void var1_1;
        return this.replace((StrMatcher)var1_1, (String)var2_2, 0, this.size, 1);
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder replace(StrMatcher matcher, String replaceStr, int startIndex, int endIndex, int replaceCount) {
        void var3_3;
        void var2_2;
        void var1_1;
        endIndex = this.validateRange(startIndex, endIndex);
        return this.replaceImpl((StrMatcher)var1_1, (String)var2_2, (int)var3_3, endIndex, replaceCount);
    }

    private StrBuilder replaceImpl(StrMatcher matcher, String replaceStr, int from, int to, int replaceCount) {
        if (matcher == null || this.size == 0) {
            return this;
        }
        int replaceLen = replaceStr == null ? 0 : replaceStr.length();
        for (int i = from; i < to && replaceCount != 0; ++i) {
            char[] buf = this.buffer;
            int removeLen = matcher.isMatch(buf, i, from, to);
            if (removeLen <= 0) continue;
            int n = i;
            this.replaceImpl(n, n + removeLen, removeLen, replaceStr, replaceLen);
            to = to - removeLen + replaceLen;
            i = i + replaceLen - 1;
            if (replaceCount <= 0) continue;
            --replaceCount;
        }
        return this;
    }

    public StrBuilder reverse() {
        if (this.size == 0) {
            return this;
        }
        int half = this.size / 2;
        char[] buf = this.buffer;
        int leftIdx = 0;
        int rightIdx = this.size - 1;
        while (leftIdx < half) {
            char swap = buf[leftIdx];
            buf[leftIdx] = buf[rightIdx];
            buf[rightIdx] = swap;
            ++leftIdx;
            --rightIdx;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder trim() {
        int pos;
        if (this.size == 0) {
            return this;
        }
        int len = this.size;
        char[] buf = this.buffer;
        for (pos = 0; pos < len && buf[pos] <= ' '; ++pos) {
        }
        while (pos < len && buf[len - 1] <= ' ') {
            --len;
        }
        if (len < this.size) {
            void var1_1;
            this.delete((int)var1_1, this.size);
        }
        if (pos > 0) {
            void var3_3;
            this.delete(0, (int)var3_3);
        }
        return this;
    }

    public boolean startsWith(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len == 0) {
            return true;
        }
        if (len > this.size) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.buffer[i] == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len == 0) {
            return true;
        }
        if (len > this.size) {
            return false;
        }
        int pos = this.size - len;
        int i = 0;
        while (i < len) {
            if (this.buffer[pos] != str.charAt(i)) {
                return false;
            }
            ++i;
            ++pos;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharSequence subSequence(int startIndex, int endIndex) {
        void var2_2;
        void var1_1;
        if (startIndex < 0) {
            throw new StringIndexOutOfBoundsException(startIndex);
        }
        if (endIndex > this.size) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (startIndex > endIndex) {
            throw new StringIndexOutOfBoundsException(endIndex - startIndex);
        }
        return this.substring((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String substring(int start) {
        void var1_1;
        return this.substring((int)var1_1, this.size);
    }

    /*
     * WARNING - void declaration
     */
    public String substring(int startIndex, int endIndex) {
        void var1_1;
        void var2_2;
        endIndex = this.validateRange(startIndex, endIndex);
        return new String(this.buffer, startIndex, (int)(var2_2 - var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String leftString(int length) {
        void var1_1;
        if (length <= 0) {
            return "";
        }
        if (length >= this.size) {
            return new String(this.buffer, 0, this.size);
        }
        return new String(this.buffer, 0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String rightString(int length) {
        void var1_1;
        if (length <= 0) {
            return "";
        }
        if (length >= this.size) {
            return new String(this.buffer, 0, this.size);
        }
        return new String(this.buffer, this.size - length, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String midString(int index, int length) {
        void var2_2;
        void var1_1;
        if (index < 0) {
            index = 0;
        }
        if (length <= 0 || index >= this.size) {
            return "";
        }
        if (this.size <= index + length) {
            return new String(this.buffer, index, this.size - index);
        }
        return new String(this.buffer, (int)var1_1, (int)var2_2);
    }

    public boolean contains(char ch) {
        char[] thisBuf = this.buffer;
        for (int i = 0; i < this.size; ++i) {
            if (thisBuf[i] != ch) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(String str) {
        void var1_1;
        return this.indexOf((String)var1_1, 0) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(StrMatcher matcher) {
        void var1_1;
        return this.indexOf((StrMatcher)var1_1, 0) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public int indexOf(char ch) {
        void var1_1;
        return this.indexOf((char)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public int indexOf(char ch, int startIndex) {
        void i;
        if ((startIndex = Math.max(startIndex, 0)) >= this.size) {
            return -1;
        }
        char[] thisBuf = this.buffer;
        while (i < this.size) {
            if (thisBuf[i] == ch) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public int indexOf(String str) {
        void var1_1;
        return this.indexOf((String)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public int indexOf(String str, int startIndex) {
        void i;
        startIndex = Math.max(startIndex, 0);
        if (str == null || startIndex >= this.size) {
            return -1;
        }
        int strLen = str.length();
        if (strLen == 1) {
            return this.indexOf(str.charAt(0), startIndex);
        }
        if (strLen == 0) {
            return startIndex;
        }
        if (strLen > this.size) {
            return -1;
        }
        char[] thisBuf = this.buffer;
        int len = this.size - strLen + 1;
        while (i < len) {
            block7: {
                for (int j = 0; j < strLen; ++j) {
                    if (str.charAt(j) == thisBuf[i + j]) {
                        continue;
                    }
                    break block7;
                }
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public int indexOf(StrMatcher matcher) {
        void var1_1;
        return this.indexOf((StrMatcher)var1_1, 0);
    }

    public int indexOf(StrMatcher matcher, int startIndex) {
        startIndex = Math.max(startIndex, 0);
        if (matcher == null || startIndex >= this.size) {
            return -1;
        }
        int len = this.size;
        char[] buf = this.buffer;
        for (int i = startIndex; i < len; ++i) {
            if (matcher.isMatch(buf, i, startIndex, len) <= 0) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public int lastIndexOf(char ch) {
        void var1_1;
        return this.lastIndexOf((char)var1_1, this.size - 1);
    }

    /*
     * WARNING - void declaration
     */
    public int lastIndexOf(char ch, int startIndex) {
        void i;
        if ((startIndex = startIndex >= this.size ? this.size - 1 : startIndex) < 0) {
            return -1;
        }
        while (i >= 0) {
            if (this.buffer[i] == ch) {
                return (int)i;
            }
            --i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public int lastIndexOf(String str) {
        void var1_1;
        return this.lastIndexOf((String)var1_1, this.size - 1);
    }

    /*
     * WARNING - void declaration
     */
    public int lastIndexOf(String str, int startIndex) {
        void var3_3;
        int n = startIndex = startIndex >= this.size ? this.size - 1 : startIndex;
        if (str == null || startIndex < 0) {
            return -1;
        }
        int strLen = str.length();
        if (strLen > 0 && strLen <= this.size) {
            if (strLen == 1) {
                return this.lastIndexOf(str.charAt(0), startIndex);
            }
            block0: for (int i = startIndex - strLen + 1; i >= 0; --i) {
                for (int j = 0; j < strLen; ++j) {
                    if (str.charAt(j) != this.buffer[i + j]) continue block0;
                }
                return i;
            }
        } else if (var3_3 == false) {
            void var2_2;
            return (int)var2_2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public int lastIndexOf(StrMatcher matcher) {
        void var1_1;
        return this.lastIndexOf((StrMatcher)var1_1, this.size);
    }

    /*
     * WARNING - void declaration
     */
    public int lastIndexOf(StrMatcher matcher, int startIndex) {
        void i;
        int n = startIndex = startIndex >= this.size ? this.size - 1 : startIndex;
        if (matcher == null || startIndex < 0) {
            return -1;
        }
        char[] buf = this.buffer;
        int endIndex = startIndex + 1;
        while (i >= 0) {
            if (matcher.isMatch(buf, (int)i, 0, endIndex) > 0) {
                return (int)i;
            }
            --i;
        }
        return -1;
    }

    public StrTokenizer asTokenizer() {
        return new StrBuilderTokenizer(this);
    }

    public Reader asReader() {
        return new StrBuilderReader(this);
    }

    public Writer asWriter() {
        return new StrBuilderWriter(this);
    }

    /*
     * WARNING - void declaration
     */
    public void appendTo(Appendable appendable) throws IOException {
        void var1_1;
        if (appendable instanceof Writer) {
            ((Writer)appendable).write(this.buffer, 0, this.size);
            return;
        }
        if (appendable instanceof StringBuilder) {
            ((StringBuilder)appendable).append(this.buffer, 0, this.size);
            return;
        }
        if (appendable instanceof StringBuffer) {
            ((StringBuffer)appendable).append(this.buffer, 0, this.size);
            return;
        }
        if (appendable instanceof CharBuffer) {
            ((CharBuffer)appendable).put(this.buffer, 0, this.size);
            return;
        }
        var1_1.append(this);
    }

    public boolean equalsIgnoreCase(StrBuilder other) {
        if (this == other) {
            return true;
        }
        if (this.size != other.size) {
            return false;
        }
        char[] thisBuf = this.buffer;
        char[] otherBuf = other.buffer;
        for (int i = this.size - 1; i >= 0; --i) {
            char c1 = thisBuf[i];
            char c2 = otherBuf[i];
            if (c1 == c2 || Character.toUpperCase(c1) == Character.toUpperCase(c2)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(StrBuilder other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        char[] thisBuf = this.buffer;
        char[] otherBuf = other.buffer;
        for (int i = this.size - 1; i >= 0; --i) {
            if (thisBuf[i] == otherBuf[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        return obj instanceof StrBuilder && this.equals((StrBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var2_2;
        char[] buf = this.buffer;
        int hash = 0;
        for (int i = this.size - 1; i >= 0; --i) {
            hash = hash * 31 + buf[i];
        }
        return (int)var2_2;
    }

    @Override
    public String toString() {
        return new String(this.buffer, 0, this.size);
    }

    public StringBuffer toStringBuffer() {
        return new StringBuffer(this.size).append(this.buffer, 0, this.size);
    }

    public StringBuilder toStringBuilder() {
        return new StringBuilder(this.size).append(this.buffer, 0, this.size);
    }

    @Override
    public String build() {
        return this.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected int validateRange(int startIndex, int endIndex) {
        void var2_2;
        void var1_1;
        if (startIndex < 0) {
            throw new StringIndexOutOfBoundsException(startIndex);
        }
        if (endIndex > this.size) {
            endIndex = this.size;
        }
        if (var1_1 > endIndex) {
            throw new StringIndexOutOfBoundsException("end < start");
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void validateIndex(int index) {
        if (index < 0 || index > this.size) {
            void var1_1;
            throw new StringIndexOutOfBoundsException((int)var1_1);
        }
    }

    class StrBuilderWriter
    extends Writer {
        final /* synthetic */ StrBuilder this$0;

        /*
         * WARNING - void declaration
         */
        StrBuilderWriter(StrBuilder this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(int c) {
            void var1_1;
            this.this$0.append((char)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(char[] cbuf) {
            void var1_1;
            this.this$0.append((char[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(char[] cbuf, int off, int len) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0.append((char[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(String str) {
            void var1_1;
            this.this$0.append((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(String str, int off, int len) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0.append((String)var1_1, (int)var2_2, (int)var3_3);
        }
    }

    class StrBuilderReader
    extends Reader {
        private int pos;
        private int mark;
        final /* synthetic */ StrBuilder this$0;

        /*
         * WARNING - void declaration
         */
        StrBuilderReader(StrBuilder this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public void close() {
        }

        @Override
        public int read() {
            if (!this.ready()) {
                return -1;
            }
            return this.this$0.charAt(this.pos++);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int read(char[] b, int off, int len) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (off < 0 || len < 0 || off > b.length || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.pos >= this.this$0.size()) {
                return -1;
            }
            if (this.pos + len > this.this$0.size()) {
                len = this.this$0.size() - this.pos;
            }
            this.this$0.getChars(this.pos, this.pos + len, (char[])var1_1, (int)var2_2);
            this.pos += len;
            return (int)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long skip(long n) {
            void var1_1;
            if ((long)this.pos + n > (long)this.this$0.size()) {
                n = this.this$0.size() - this.pos;
            }
            if (n < 0L) {
                return 0L;
            }
            this.pos = (int)((long)this.pos + n);
            return (long)var1_1;
        }

        @Override
        public boolean ready() {
            return this.pos < this.this$0.size();
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.pos;
        }

        @Override
        public void reset() {
            this.pos = this.mark;
        }
    }

    class StrBuilderTokenizer
    extends StrTokenizer {
        final /* synthetic */ StrBuilder this$0;

        /*
         * WARNING - void declaration
         */
        StrBuilderTokenizer(StrBuilder this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected List<String> tokenize(char[] chars, int offset, int count) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (chars == null) {
                StrBuilderTokenizer strBuilderTokenizer = this;
                return super.tokenize(strBuilderTokenizer.this$0.buffer, 0, this.this$0.size());
            }
            return super.tokenize((char[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String getContent() {
            void var1_1;
            String str = super.getContent();
            if (str == null) {
                return this.this$0.toString();
            }
            return var1_1;
        }
    }
}

