/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.stream;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.apache.commons.lang3.function.Failable;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.function.FailablePredicate;

public class Streams {
    public static <O> FailableStream<O> stream(Collection<O> stream) {
        return Streams.stream(stream.stream());
    }

    public static <O> FailableStream<O> stream(Stream<O> stream) {
        Stream<O> stream2;
        return new FailableStream<O>(stream2);
    }

    public static <O> Collector<O, ?, O[]> toArray(Class<O> pElementType) {
        Class<O> clazz;
        return new ArrayCollector<O>(clazz);
    }

    public static class FailableStream<O> {
        private Stream<O> stream;
        private boolean terminated;

        /*
         * WARNING - void declaration
         */
        public FailableStream(Stream<O> stream) {
            void var1_1;
            this.stream = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public boolean allMatch(FailablePredicate<O, ?> predicate) {
            void var1_1;
            this.assertNotTerminated();
            return this.stream().allMatch(Failable.asPredicate(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public boolean anyMatch(FailablePredicate<O, ?> predicate) {
            void var1_1;
            this.assertNotTerminated();
            return this.stream().anyMatch(Failable.asPredicate(var1_1));
        }

        protected void assertNotTerminated() {
            if (this.terminated) {
                throw new IllegalStateException("This stream is already terminated.");
            }
        }

        /*
         * WARNING - void declaration
         */
        public <A, R> R collect(Collector<? super O, A, R> collector) {
            void var1_1;
            this.makeTerminated();
            return this.stream().collect(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public <A, R> R collect(Supplier<R> pupplier, BiConsumer<R, ? super O> accumulator, BiConsumer<R, R> combiner) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.makeTerminated();
            return this.stream().collect(var1_1, var2_2, var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public FailableStream<O> filter(FailablePredicate<O, ?> predicate) {
            void var1_1;
            this.assertNotTerminated();
            this.stream = this.stream.filter(Failable.asPredicate(var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public void forEach(FailableConsumer<O, ?> action) {
            void var1_1;
            this.makeTerminated();
            this.stream().forEach(Failable.asConsumer(var1_1));
        }

        protected void makeTerminated() {
            this.assertNotTerminated();
            this.terminated = true;
        }

        /*
         * WARNING - void declaration
         */
        public <R> FailableStream<R> map(FailableFunction<O, R, ?> mapper) {
            void var1_1;
            this.assertNotTerminated();
            return new FailableStream(this.stream.map(Failable.asFunction(var1_1)));
        }

        /*
         * WARNING - void declaration
         */
        public O reduce(O identity, BinaryOperator<O> accumulator) {
            void var2_2;
            void var1_1;
            this.makeTerminated();
            return this.stream().reduce(var1_1, (BinaryOperator<O>)var2_2);
        }

        public Stream<O> stream() {
            return this.stream;
        }
    }

    public static class ArrayCollector<O>
    implements Collector<O, List<O>, O[]> {
        private static final Set<Collector.Characteristics> characteristics = Collections.emptySet();
        private final Class<O> elementType;

        /*
         * WARNING - void declaration
         */
        public ArrayCollector(Class<O> elementType) {
            void var1_1;
            this.elementType = var1_1;
        }

        @Override
        public BiConsumer<List<O>, O> accumulator() {
            return List::add;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return characteristics;
        }

        @Override
        public BinaryOperator<List<O>> combiner() {
            return (left, right) -> {
                List list;
                void var1_1;
                left.addAll(var1_1);
                return list;
            };
        }

        @Override
        public Function<List<O>, O[]> finisher() {
            return list -> {
                void var2_2;
                void var1_1;
                Object[] array = (Object[])Array.newInstance(this.elementType, list.size());
                return var1_1.toArray((T[])var2_2);
            };
        }

        @Override
        public Supplier<List<O>> supplier() {
            return ArrayList::new;
        }
    }
}

