/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.reflect.Typed;

public class TypeUtils {
    public static final WildcardType WILDCARD_ALL = TypeUtils.wildcardType().withUpperBounds(new Type[]{Object.class}).build();

    private static <T> StringBuilder appendAllTo(StringBuilder builder, String sep, T ... types) {
        StringBuilder stringBuilder;
        Validate.notEmpty(Validate.noNullElements(types));
        if (types.length > 0) {
            builder.append(TypeUtils.toString(types[0]));
            for (int i = 1; i < types.length; ++i) {
                builder.append(sep).append(TypeUtils.toString(types[i]));
            }
        }
        return stringBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private static void appendRecursiveTypes(StringBuilder builder, int[] recursiveTypeIndexes, Type[] argumentTypes) {
        void var1_1;
        void var2_2;
        for (int i = 0; i < recursiveTypeIndexes.length; ++i) {
            TypeUtils.appendAllTo(builder.append('<'), ", ", argumentTypes[i].toString()).append('>');
        }
        Type[] argumentsFiltered = (Type[])ArrayUtils.removeAll(var2_2, (int[])var1_1);
        if (argumentsFiltered.length > 0) {
            void var3_4;
            StringBuilder stringBuilder;
            TypeUtils.appendAllTo(stringBuilder.append('<'), ", ", var3_4).append('>');
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String classToString(Class<?> cls) {
        void var1_1;
        if (cls.isArray()) {
            return TypeUtils.toString(cls.getComponentType()) + "[]";
        }
        StringBuilder buf = new StringBuilder();
        if (cls.getEnclosingClass() != null) {
            buf.append(TypeUtils.classToString(cls.getEnclosingClass())).append('.').append(cls.getSimpleName());
        } else {
            buf.append(cls.getName());
        }
        if (cls.getTypeParameters().length > 0) {
            Class<?> clazz;
            buf.append('<');
            TypeUtils.appendAllTo(buf, ", ", clazz.getTypeParameters());
            buf.append('>');
        }
        return var1_1.toString();
    }

    public static boolean containsTypeVariables(Type type) {
        while (true) {
            Type type2;
            if (type instanceof TypeVariable) {
                return true;
            }
            if (type instanceof Class) {
                return ((Class)type).getTypeParameters().length > 0;
            }
            if (type instanceof ParameterizedType) {
                for (Type type3 : ((ParameterizedType)type).getActualTypeArguments()) {
                    if (!TypeUtils.containsTypeVariables(type3)) continue;
                    return true;
                }
                return false;
            }
            if (type instanceof WildcardType) {
                Type wild = (WildcardType)type;
                return TypeUtils.containsTypeVariables(TypeUtils.getImplicitLowerBounds((WildcardType)wild)[0]) || TypeUtils.containsTypeVariables(TypeUtils.getImplicitUpperBounds((WildcardType)type2)[0]);
            }
            if (!(type2 instanceof GenericArrayType)) break;
            type2 = ((GenericArrayType)type2).getGenericComponentType();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean containsVariableTypeSameParametrizedTypeBound(TypeVariable<?> typeVariable, ParameterizedType parameterizedType) {
        void var1_1;
        return ArrayUtils.contains(typeVariable.getBounds(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<TypeVariable<?>, Type> determineTypeArguments(Class<?> cls, ParameterizedType superParameterizedType) {
        void var1_1;
        void var2_2;
        Class<?> clazz;
        Type midType;
        while (true) {
            Validate.notNull(cls, "cls", new Object[0]);
            Validate.notNull(superParameterizedType, "superParameterizedType", new Object[0]);
            Class<?> superClass = TypeUtils.getRawType(superParameterizedType);
            if (!TypeUtils.isAssignable(cls, superClass)) {
                return null;
            }
            if (cls.equals(superClass)) {
                return TypeUtils.getTypeArguments(superParameterizedType, superClass, null);
            }
            midType = TypeUtils.getClosestParentType(cls, superClass);
            if (!(midType instanceof Class)) break;
            cls = (Class)midType;
        }
        ParameterizedType midParameterizedType = (ParameterizedType)midType;
        Class<?> clazz2 = TypeUtils.getRawType(midParameterizedType);
        Map<TypeVariable<?>, Type> typeVarAssigns = TypeUtils.determineTypeArguments(clazz2, superParameterizedType);
        TypeUtils.mapTypeVariablesToArguments(clazz, (ParameterizedType)var2_2, typeVarAssigns);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean equals(GenericArrayType genericArrayType, Type type) {
        void var1_1;
        GenericArrayType genericArrayType2;
        return type instanceof GenericArrayType && TypeUtils.equals(genericArrayType2.getGenericComponentType(), ((GenericArrayType)var1_1).getGenericComponentType());
    }

    /*
     * WARNING - void declaration
     */
    private static boolean equals(ParameterizedType parameterizedType, Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType other = (ParameterizedType)type;
            if (TypeUtils.equals(parameterizedType.getRawType(), other.getRawType()) && TypeUtils.equals(parameterizedType.getOwnerType(), other.getOwnerType())) {
                void var1_1;
                ParameterizedType parameterizedType2;
                return TypeUtils.equals(parameterizedType2.getActualTypeArguments(), var1_1.getActualTypeArguments());
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(Type type1, Type type2) {
        if (Objects.equals(type1, type2)) {
            return true;
        }
        if (type1 instanceof ParameterizedType) {
            return TypeUtils.equals((ParameterizedType)type1, type2);
        }
        if (type1 instanceof GenericArrayType) {
            return TypeUtils.equals((GenericArrayType)type1, type2);
        }
        if (type1 instanceof WildcardType) {
            void var1_1;
            Type type;
            return TypeUtils.equals((WildcardType)type, (Type)var1_1);
        }
        return false;
    }

    private static boolean equals(Type[] type1, Type[] type2) {
        if (type1.length == type2.length) {
            for (int i = 0; i < type1.length; ++i) {
                if (TypeUtils.equals(type1[i], type2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean equals(WildcardType wildcardType, Type type) {
        if (type instanceof WildcardType) {
            void var1_1;
            WildcardType wildcardType2;
            WildcardType other = (WildcardType)type;
            return TypeUtils.equals(TypeUtils.getImplicitLowerBounds(wildcardType), TypeUtils.getImplicitLowerBounds(other)) && TypeUtils.equals(TypeUtils.getImplicitUpperBounds(wildcardType2), TypeUtils.getImplicitUpperBounds((WildcardType)var1_1));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static Type[] extractTypeArgumentsFrom(Map<TypeVariable<?>, Type> mappings, TypeVariable<?>[] variables) {
        void var2_2;
        void var1_1;
        Type[] result = new Type[variables.length];
        int index = 0;
        for (void var : var1_1) {
            Validate.isTrue(mappings.containsKey(var), "missing argument mapping for %s", TypeUtils.toString((Type)var));
            result[index++] = mappings.get(var);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] findRecursiveTypes(ParameterizedType parameterizedType) {
        void var2_2;
        Type[] filteredArgumentTypes = Arrays.copyOf(parameterizedType.getActualTypeArguments(), parameterizedType.getActualTypeArguments().length);
        int[] indexesToRemove = new int[]{};
        for (int i = 0; i < filteredArgumentTypes.length; ++i) {
            if (!(filteredArgumentTypes[i] instanceof TypeVariable) || !TypeUtils.containsVariableTypeSameParametrizedTypeBound((TypeVariable)filteredArgumentTypes[i], parameterizedType)) continue;
            indexesToRemove = ArrayUtils.add(indexesToRemove, i);
        }
        return var2_2;
    }

    public static GenericArrayType genericArrayType(Type componentType) {
        Type type;
        return new GenericArrayTypeImpl(Validate.notNull(type, "componentType", new Object[0]));
    }

    private static String genericArrayTypeToString(GenericArrayType genericArrayType) {
        GenericArrayType genericArrayType2;
        return String.format("%s[]", TypeUtils.toString(genericArrayType2.getGenericComponentType()));
    }

    public static Type getArrayComponentType(Type type) {
        Type type2;
        if (type instanceof Class) {
            Type cls = (Class)type;
            if (((Class)cls).isArray()) {
                return ((Class)type2).getComponentType();
            }
            return null;
        }
        if (type2 instanceof GenericArrayType) {
            return ((GenericArrayType)type2).getGenericComponentType();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Type getClosestParentType(Class<?> cls, Class<?> superClass) {
        Class<?> clazz;
        if (superClass.isInterface()) {
            void var2_2;
            Type[] interfaceTypes = cls.getGenericInterfaces();
            Type genericInterface = null;
            for (void midType : var2_2) {
                Class midClass;
                if (midType instanceof ParameterizedType) {
                    midClass = TypeUtils.getRawType((ParameterizedType)midType);
                } else if (midType instanceof Class) {
                    midClass = (Class)midType;
                } else {
                    throw new IllegalStateException("Unexpected generic interface type found: " + midType);
                }
                if (!TypeUtils.isAssignable((Type)midClass, superClass) || !TypeUtils.isAssignable(genericInterface, (Type)midClass)) continue;
                genericInterface = midType;
            }
            if (genericInterface != null) {
                void var3_3;
                return var3_3;
            }
        }
        return clazz.getGenericSuperclass();
    }

    public static Type[] getImplicitBounds(TypeVariable<?> typeVariable) {
        Type[] typeArray;
        Validate.notNull(typeVariable, "typeVariable", new Object[0]);
        Type[] bounds = typeVariable.getBounds();
        if (bounds.length == 0) {
            return new Type[]{Object.class};
        }
        return TypeUtils.normalizeUpperBounds(typeArray);
    }

    public static Type[] getImplicitLowerBounds(WildcardType wildcardType) {
        Type[] typeArray;
        Validate.notNull(wildcardType, "wildcardType", new Object[0]);
        Type[] bounds = wildcardType.getLowerBounds();
        if (bounds.length == 0) {
            return new Type[]{null};
        }
        return typeArray;
    }

    public static Type[] getImplicitUpperBounds(WildcardType wildcardType) {
        Type[] typeArray;
        Validate.notNull(wildcardType, "wildcardType", new Object[0]);
        Type[] bounds = wildcardType.getUpperBounds();
        if (bounds.length == 0) {
            return new Type[]{Object.class};
        }
        return TypeUtils.normalizeUpperBounds(typeArray);
    }

    private static Class<?> getRawType(ParameterizedType parameterizedType) {
        Type type;
        Type rawType = parameterizedType.getRawType();
        if (!(rawType instanceof Class)) {
            throw new IllegalStateException("Wait... What!? Type of rawType: " + rawType);
        }
        return (Class)type;
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> getRawType(Type type, Type assigningType) {
        Type type2;
        Class<?> clazz;
        while (true) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return TypeUtils.getRawType((ParameterizedType)type);
            }
            if (!(type instanceof TypeVariable)) break;
            if (assigningType == null) {
                return null;
            }
            Object genericDeclaration = ((TypeVariable)type).getGenericDeclaration();
            if (!(genericDeclaration instanceof Class)) {
                return null;
            }
            Map<TypeVariable<?>, Type> typeVarAssigns = TypeUtils.getTypeArguments(assigningType, (Class)genericDeclaration);
            if (typeVarAssigns == null) {
                return null;
            }
            Type typeArgument = (Type)clazz.get(type);
            if (typeArgument != null) continue;
            return null;
        }
        if (type2 instanceof GenericArrayType) {
            void var1_1;
            clazz = TypeUtils.getRawType(((GenericArrayType)type2).getGenericComponentType(), (Type)var1_1);
            return Array.newInstance(clazz, 0).getClass();
        }
        if (type2 instanceof WildcardType) {
            return null;
        }
        throw new IllegalArgumentException("unknown type: " + type2);
    }

    /*
     * WARNING - void declaration
     */
    private static Map<TypeVariable<?>, Type> getTypeArguments(Class<?> cls, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        void var2_2;
        void var1_1;
        Class<?> clazz;
        HashMap typeVarAssigns;
        if (!TypeUtils.isAssignable(cls, toClass)) {
            return null;
        }
        if (cls.isPrimitive()) {
            if (toClass.isPrimitive()) {
                return new HashMap();
            }
            cls = ClassUtils.primitiveToWrapper(cls);
        }
        HashMap hashMap = typeVarAssigns = subtypeVarAssigns == null ? new HashMap() : new HashMap(subtypeVarAssigns);
        if (toClass.equals(cls)) {
            return typeVarAssigns;
        }
        return TypeUtils.getTypeArguments(TypeUtils.getClosestParentType(clazz, toClass), var1_1, var2_2);
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType type) {
        ParameterizedType parameterizedType = type;
        return TypeUtils.getTypeArguments(parameterizedType, TypeUtils.getRawType(parameterizedType), null);
    }

    /*
     * WARNING - void declaration
     */
    private static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType parameterizedType, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        void var2_2;
        void var1_1;
        void var3_3;
        Map<TypeVariable<?>, Type> map;
        Class<?> cls = TypeUtils.getRawType(parameterizedType);
        if (!TypeUtils.isAssignable(cls, toClass)) {
            return null;
        }
        Type ownerType = parameterizedType.getOwnerType();
        if (ownerType instanceof ParameterizedType) {
            ParameterizedType parameterizedOwnerType = (ParameterizedType)ownerType;
            map = TypeUtils.getTypeArguments(parameterizedOwnerType, TypeUtils.getRawType(parameterizedOwnerType), subtypeVarAssigns);
        } else {
            map = subtypeVarAssigns == null ? new HashMap() : new HashMap(subtypeVarAssigns);
        }
        HashMap typeVarAssigns = map;
        Type[] typeArgs = parameterizedType.getActualTypeArguments();
        TypeVariable<Class<?>>[] typeParams = cls.getTypeParameters();
        for (int i = 0; i < typeParams.length; ++i) {
            Type typeArg;
            Type type = typeArg = typeArgs[i];
            typeVarAssigns.put(typeParams[i], typeVarAssigns.getOrDefault(type, type));
        }
        if (toClass.equals(cls)) {
            return typeVarAssigns;
        }
        return TypeUtils.getTypeArguments(TypeUtils.getClosestParentType(var3_3, toClass), var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> toClass) {
        void var1_1;
        return TypeUtils.getTypeArguments(type, var1_1, null);
    }

    private static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        Type type2;
        block7: {
            block0: while (true) {
                Type bound;
                int n;
                int n2;
                if (type instanceof Class) {
                    return TypeUtils.getTypeArguments((Class)type, toClass, subtypeVarAssigns);
                }
                if (type instanceof ParameterizedType) {
                    return TypeUtils.getTypeArguments((ParameterizedType)type, toClass, subtypeVarAssigns);
                }
                if (type instanceof GenericArrayType) {
                    toClass = toClass.isArray() ? toClass.getComponentType() : toClass;
                    type = ((GenericArrayType)type).getGenericComponentType();
                    continue;
                }
                if (type instanceof WildcardType) {
                    type = TypeUtils.getImplicitUpperBounds((WildcardType)type);
                    n2 = ((Type[])type).length;
                    for (n = 0; n < n2; ++n) {
                        bound = type[n];
                        if (!TypeUtils.isAssignable(bound, toClass)) continue;
                        type = bound;
                        continue block0;
                    }
                    return null;
                }
                if (!(type instanceof TypeVariable)) break block7;
                type = TypeUtils.getImplicitBounds((TypeVariable)type);
                n2 = ((Type[])type).length;
                for (n = 0; n < n2; ++n) {
                    bound = type[n];
                    if (!TypeUtils.isAssignable(bound, toClass)) continue;
                    type = bound;
                    continue block0;
                }
                break;
            }
            return null;
        }
        throw new IllegalStateException("found an unhandled type: " + type2);
    }

    public static boolean isArrayType(Type type) {
        Type type2;
        return type instanceof GenericArrayType || type instanceof Class && ((Class)type2).isArray();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isAssignable(Type type, Class<?> toClass) {
        Type type2;
        while (true) {
            if (type == null) {
                return toClass == null || !toClass.isPrimitive();
            }
            if (toClass == null) {
                return false;
            }
            if (toClass.equals(type)) {
                return true;
            }
            if (type instanceof Class) {
                return ClassUtils.isAssignable((Class)type, toClass);
            }
            if (!(type instanceof ParameterizedType)) break;
            type = TypeUtils.getRawType((ParameterizedType)type);
        }
        if (type instanceof TypeVariable) {
            for (Type type3 : ((TypeVariable)type).getBounds()) {
                if (!TypeUtils.isAssignable(type3, toClass)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof GenericArrayType) {
            void var1_1;
            return toClass.equals(Object.class) || toClass.isArray() && TypeUtils.isAssignable(((GenericArrayType)type).getGenericComponentType(), var1_1.getComponentType());
        }
        if (type instanceof WildcardType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + type2);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isAssignable(Type type, GenericArrayType toGenericArrayType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Type object;
        if (type == null) {
            return true;
        }
        if (toGenericArrayType == null) {
            return false;
        }
        if (toGenericArrayType.equals(type)) {
            return true;
        }
        Type toComponentType = toGenericArrayType.getGenericComponentType();
        if (type instanceof Class) {
            void var0_1;
            Class cls = (Class)type;
            return cls.isArray() && TypeUtils.isAssignable(var0_1.getComponentType(), toComponentType, typeVarAssigns);
        }
        if (object instanceof GenericArrayType) {
            void var2_5;
            void var3_8;
            return TypeUtils.isAssignable(((GenericArrayType)object).getGenericComponentType(), (Type)var3_8, var2_5);
        }
        if (object instanceof WildcardType) {
            for (Type type2 : TypeUtils.getImplicitUpperBounds((WildcardType)object)) {
                if (!TypeUtils.isAssignable(type2, (Type)toGenericArrayType)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof TypeVariable) {
            for (Type type3 : TypeUtils.getImplicitBounds((TypeVariable)object)) {
                if (!TypeUtils.isAssignable(type3, (Type)toGenericArrayType)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof ParameterizedType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + object);
    }

    private static boolean isAssignable(Type type, ParameterizedType toParameterizedType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Iterator<TypeVariable<?>> iterator;
        if (type == null) {
            return true;
        }
        if (toParameterizedType == null) {
            return false;
        }
        if (type instanceof GenericArrayType) {
            return false;
        }
        if (toParameterizedType.equals(type)) {
            return true;
        }
        Class<?> toClass = TypeUtils.getRawType(toParameterizedType);
        Map<TypeVariable<?>, Type> fromTypeVarAssigns = TypeUtils.getTypeArguments(type, toClass, null);
        if (fromTypeVarAssigns == null) {
            return false;
        }
        if (fromTypeVarAssigns.isEmpty()) {
            return true;
        }
        Map<TypeVariable<?>, Type> toTypeVarAssigns = TypeUtils.getTypeArguments(toParameterizedType, iterator, typeVarAssigns);
        for (TypeVariable<?> var : toTypeVarAssigns.keySet()) {
            Type toTypeArg = TypeUtils.unrollVariableAssignments(var, toTypeVarAssigns);
            Type fromTypeArg = TypeUtils.unrollVariableAssignments(var, fromTypeVarAssigns);
            if (toTypeArg == null && fromTypeArg instanceof Class || fromTypeArg == null || toTypeArg == null || toTypeArg.equals(fromTypeArg) || toTypeArg instanceof WildcardType && TypeUtils.isAssignable(fromTypeArg, toTypeArg, typeVarAssigns)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAssignable(Type type, Type toType) {
        void var1_1;
        return TypeUtils.isAssignable(type, (Type)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isAssignable(Type type, Type toType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        void var1_1;
        if (toType == null || toType instanceof Class) {
            return TypeUtils.isAssignable(type, (Class)toType);
        }
        if (toType instanceof ParameterizedType) {
            return TypeUtils.isAssignable(type, (ParameterizedType)toType, typeVarAssigns);
        }
        if (toType instanceof GenericArrayType) {
            return TypeUtils.isAssignable(type, (GenericArrayType)toType, typeVarAssigns);
        }
        if (toType instanceof WildcardType) {
            return TypeUtils.isAssignable(type, (WildcardType)toType, typeVarAssigns);
        }
        if (toType instanceof TypeVariable) {
            void var2_2;
            Type type2;
            return TypeUtils.isAssignable(type2, (TypeVariable)toType, var2_2);
        }
        throw new IllegalStateException("found an unhandled type: " + var1_1);
    }

    private static boolean isAssignable(Type type, TypeVariable<?> toTypeVariable, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Type type2;
        if (type == null) {
            return true;
        }
        if (toTypeVariable == null) {
            return false;
        }
        if (toTypeVariable.equals(type)) {
            return true;
        }
        if (type instanceof TypeVariable) {
            Type[] typeArray = TypeUtils.getImplicitBounds((TypeVariable)type);
            Type[] typeArray2 = typeArray;
            typeArray2 = typeArray;
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type3 = typeArray2[i];
                if (!TypeUtils.isAssignable(type3, toTypeVariable, typeVarAssigns)) continue;
                return true;
            }
        }
        if (type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType || type instanceof WildcardType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + type2);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isAssignable(Type type22, WildcardType toWildcardType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        void var1_2;
        Type type22;
        if (type22 == null) {
            return true;
        }
        if (toWildcardType == null) {
            return false;
        }
        if (toWildcardType.equals(type22)) {
            return true;
        }
        Type[] toUpperBounds = TypeUtils.getImplicitUpperBounds(toWildcardType);
        Type[] toLowerBounds = TypeUtils.getImplicitLowerBounds(toWildcardType);
        if (type22 instanceof WildcardType) {
            int n;
            int n2;
            Type[] typeArray;
            Type toBound;
            WildcardType wildcardType = (WildcardType)type22;
            Type[] upperBounds = TypeUtils.getImplicitUpperBounds(wildcardType);
            Type[] lowerBounds = TypeUtils.getImplicitLowerBounds(wildcardType);
            for (Type type3 : toUpperBounds) {
                toBound = TypeUtils.substituteTypeVariables(type3, typeVarAssigns);
                typeArray = upperBounds;
                n2 = upperBounds.length;
                for (n = 0; n < n2; ++n) {
                    Type type4 = typeArray[n];
                    if (TypeUtils.isAssignable(type4, toBound, typeVarAssigns)) continue;
                    return false;
                }
            }
            toUpperBounds = toLowerBounds;
            int type22 = toLowerBounds.length;
            for (int i = 0; i < type22; ++i) {
                toBound = toUpperBounds[i];
                toBound = TypeUtils.substituteTypeVariables(toBound, typeVarAssigns);
                typeArray = lowerBounds;
                n2 = lowerBounds.length;
                for (n = 0; n < n2; ++n) {
                    Type bound = typeArray[n];
                    if (TypeUtils.isAssignable(toBound, bound, typeVarAssigns)) continue;
                    return false;
                }
            }
            return true;
        }
        Type[] typeArray = toUpperBounds;
        int n = toUpperBounds.length;
        for (int i = 0; i < n; ++i) {
            Type type5;
            Type toBound = typeArray[i];
            if (TypeUtils.isAssignable(type22, TypeUtils.substituteTypeVariables(type5, typeVarAssigns), typeVarAssigns)) continue;
            return false;
        }
        for (Type type5 : var1_2) {
            if (TypeUtils.isAssignable(TypeUtils.substituteTypeVariables(type5, typeVarAssigns), type22, typeVarAssigns)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isInstance(Object value, Type type) {
        void var1_1;
        Object object;
        if (type == null) {
            return false;
        }
        if (value == null) {
            return !(type instanceof Class) || !((Class)type).isPrimitive();
        }
        return TypeUtils.isAssignable(object.getClass(), (Type)var1_1, null);
    }

    private static <T> void mapTypeVariablesToArguments(Class<T> cls, ParameterizedType parameterizedType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Type ownerType = parameterizedType.getOwnerType();
        if (ownerType instanceof ParameterizedType) {
            TypeUtils.mapTypeVariablesToArguments(cls, (ParameterizedType)ownerType, typeVarAssigns);
        }
        Type[] typeArgs = parameterizedType.getActualTypeArguments();
        TypeVariable<Class<?>>[] typeVars = TypeUtils.getRawType(parameterizedType).getTypeParameters();
        List<TypeVariable<Class<T>>> typeVarList = Arrays.asList(cls.getTypeParameters());
        for (int i = 0; i < typeArgs.length; ++i) {
            TypeVariable<Class<?>> typeVar = typeVars[i];
            Type typeArg = typeArgs[i];
            if (!typeVarList.contains(typeArg) || !typeVarAssigns.containsKey(typeVar)) continue;
            typeVarAssigns.put((TypeVariable)typeArg, typeVarAssigns.get(typeVar));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Type[] normalizeUpperBounds(Type[] bounds) {
        void var1_1;
        Validate.notNull(bounds, "bounds", new Object[0]);
        if (bounds.length < 2) {
            return bounds;
        }
        HashSet<Type> types = new HashSet<Type>(bounds.length);
        Type[] typeArray = bounds;
        int n = bounds.length;
        for (int i = 0; i < n; ++i) {
            Type type1 = typeArray[i];
            boolean subtypeFound = false;
            Type[] typeArray2 = bounds;
            int n2 = bounds.length;
            for (int j = 0; j < n2; ++j) {
                Type type2 = typeArray2[j];
                if (type1 == type2 || !TypeUtils.isAssignable(type2, type1, null)) continue;
                subtypeFound = true;
                break;
            }
            if (subtypeFound) continue;
            types.add(type1);
        }
        return var1_1.toArray(ArrayUtils.EMPTY_TYPE_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    public static final ParameterizedType parameterize(Class<?> rawClass, Map<TypeVariable<?>, Type> typeVariableMap) {
        Class<?> clazz;
        void var1_1;
        Validate.notNull(rawClass, "rawClass", new Object[0]);
        Validate.notNull(typeVariableMap, "typeVariableMap", new Object[0]);
        return TypeUtils.parameterizeWithOwner(null, rawClass, TypeUtils.extractTypeArgumentsFrom(var1_1, clazz.getTypeParameters()));
    }

    /*
     * WARNING - void declaration
     */
    public static final ParameterizedType parameterize(Class<?> rawClass, Type ... typeArguments) {
        void var1_1;
        Class<?> clazz;
        return TypeUtils.parameterizeWithOwner(null, clazz, (Type[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static String parameterizedTypeToString(ParameterizedType parameterizedType) {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        Type useOwner = parameterizedType.getOwnerType();
        Class raw = (Class)parameterizedType.getRawType();
        if (useOwner == null) {
            builder.append(raw.getName());
        } else {
            void var3_3;
            if (useOwner instanceof Class) {
                builder.append(((Class)useOwner).getName());
            } else {
                builder.append(useOwner.toString());
            }
            builder.append('.').append(var3_3.getSimpleName());
        }
        int[] recursiveTypeIndexes = TypeUtils.findRecursiveTypes(parameterizedType);
        if (recursiveTypeIndexes.length > 0) {
            void var2_2;
            TypeUtils.appendRecursiveTypes(builder, (int[])var2_2, parameterizedType.getActualTypeArguments());
        } else {
            ParameterizedType parameterizedType2;
            TypeUtils.appendAllTo(builder.append('<'), ", ", parameterizedType2.getActualTypeArguments()).append('>');
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final ParameterizedType parameterizeWithOwner(Type owner, Class<?> rawClass, Map<TypeVariable<?>, Type> typeVariableMap) {
        void var1_1;
        void var2_2;
        Type type;
        Validate.notNull(rawClass, "rawClass", new Object[0]);
        Validate.notNull(typeVariableMap, "typeVariableMap", new Object[0]);
        return TypeUtils.parameterizeWithOwner(type, rawClass, TypeUtils.extractTypeArgumentsFrom(var2_2, var1_1.getTypeParameters()));
    }

    /*
     * WARNING - void declaration
     */
    public static final ParameterizedType parameterizeWithOwner(Type owner, Class<?> rawClass, Type ... typeArguments) {
        void var2_2;
        Class<?> clazz;
        void var1_1;
        Class<?> useOwner;
        Validate.notNull(rawClass, "rawClass", new Object[0]);
        if (rawClass.getEnclosingClass() == null) {
            Validate.isTrue(owner == null, "no owner allowed for top-level %s", rawClass);
            useOwner = null;
        } else if (useOwner == null) {
            useOwner = rawClass.getEnclosingClass();
        } else {
            Validate.isTrue(TypeUtils.isAssignable(useOwner, rawClass.getEnclosingClass()), "%s is invalid owner type for parameterized %s", useOwner, rawClass);
        }
        Validate.noNullElements(typeArguments, "null type argument at index %s", new Object[0]);
        Validate.isTrue(rawClass.getTypeParameters().length == typeArguments.length, "invalid number of type parameters specified: expected %d, got %d", rawClass.getTypeParameters().length, typeArguments.length);
        return new ParameterizedTypeImpl((Class)var1_1, clazz, (Type[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static Type substituteTypeVariables(Type type, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Type type2;
        if (type instanceof TypeVariable && typeVarAssigns != null) {
            void var1_1;
            Type replacementType = typeVarAssigns.get(type);
            if (replacementType == null) {
                throw new IllegalArgumentException("missing assignment type for type variable " + type);
            }
            return var1_1;
        }
        return type2;
    }

    /*
     * WARNING - void declaration
     */
    public static String toLongString(TypeVariable<?> typeVariable) {
        TypeVariable<?> typeVariable2;
        void var1_1;
        block5: {
            void var2_2;
            Validate.notNull(typeVariable, "typeVariable", new Object[0]);
            StringBuilder buf = new StringBuilder();
            Object d = typeVariable.getGenericDeclaration();
            if (d instanceof Class) {
                Class<?> c = (Class<?>)d;
                while (true) {
                    if (c.getEnclosingClass() == null) {
                        buf.insert(0, c.getName());
                        break block5;
                    }
                    buf.insert(0, c.getSimpleName()).insert(0, '.');
                    c = c.getEnclosingClass();
                }
            }
            if (var2_2 instanceof Type) {
                buf.append(TypeUtils.toString((Type)var2_2));
            } else {
                buf.append(var2_2);
            }
        }
        return var1_1.append(':').append(TypeUtils.typeVariableToString(typeVariable2)).toString();
    }

    private static <T> String toString(T object) {
        T t;
        if (object instanceof Type) {
            return TypeUtils.toString((Type)object);
        }
        return t.toString();
    }

    public static String toString(Type type) {
        Type type2;
        Validate.notNull(type);
        if (type instanceof Class) {
            return TypeUtils.classToString((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.parameterizedTypeToString((ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            return TypeUtils.wildcardTypeToString((WildcardType)type);
        }
        if (type instanceof TypeVariable) {
            return TypeUtils.typeVariableToString((TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            return TypeUtils.genericArrayTypeToString((GenericArrayType)type);
        }
        throw new IllegalArgumentException(ObjectUtils.identityToString(type2));
    }

    public static boolean typesSatisfyVariables(Map<TypeVariable<?>, Type> typeVariableMap) {
        Validate.notNull(typeVariableMap, "typeVariableMap", new Object[0]);
        for (Map.Entry<TypeVariable<?>, Type> entry : typeVariableMap.entrySet()) {
            Type[] typeArray;
            TypeVariable<?> typeVar = entry.getKey();
            Type type = entry.getValue();
            for (Type bound : TypeUtils.getImplicitBounds(typeArray)) {
                if (TypeUtils.isAssignable(type, TypeUtils.substituteTypeVariables(bound, typeVariableMap), typeVariableMap)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static String typeVariableToString(TypeVariable<?> typeVariable) {
        void var1_1;
        void var2_2;
        StringBuilder buf = new StringBuilder(typeVariable.getName());
        Type[] bounds = typeVariable.getBounds();
        if (!(bounds.length <= 0 || bounds.length == 1 && Object.class.equals((Object)var2_2[0]))) {
            TypeVariable<?> typeVariable2;
            buf.append(" extends ");
            TypeUtils.appendAllTo(buf, " & ", typeVariable2.getBounds());
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static Type[] unrollBounds(Map<TypeVariable<?>, Type> typeArguments, Type[] bounds) {
        void var1_1;
        Type[] result = bounds;
        for (int i = 0; i < result.length; ++i) {
            void var3_3;
            Type unrolled = TypeUtils.unrollVariables(typeArguments, result[i]);
            if (unrolled == null) {
                result = ArrayUtils.remove(result, i--);
                continue;
            }
            result[i] = var3_3;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static Type unrollVariableAssignments(TypeVariable<?> typeVariable, Map<TypeVariable<?>, Type> typeVarAssigns) {
        void var2_2;
        Type result;
        while ((result = typeVarAssigns.get(typeVariable)) instanceof TypeVariable && !result.equals(typeVariable)) {
            typeVariable = (TypeVariable)result;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Type unrollVariables(Map<TypeVariable<?>, Type> typeArguments, Type type) {
        void var1_1;
        block6: {
            ParameterizedType p;
            while (true) {
                if (typeArguments == null) {
                    typeArguments = Collections.emptyMap();
                }
                if (!TypeUtils.containsTypeVariables(type)) break block6;
                if (!(type instanceof TypeVariable)) break;
                type = typeArguments.get(type);
            }
            if (type instanceof ParameterizedType) {
                void var2_2;
                Map<TypeVariable<?>, Type> parameterizedTypeArguments;
                p = (ParameterizedType)type;
                if (p.getOwnerType() != null) {
                    parameterizedTypeArguments = new HashMap(parameterizedTypeArguments);
                    parameterizedTypeArguments.putAll(TypeUtils.getTypeArguments(p));
                }
                Type[] args = p.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    Type unrolled = TypeUtils.unrollVariables(parameterizedTypeArguments, args[i]);
                    if (unrolled == null) continue;
                    args[i] = unrolled;
                }
                return TypeUtils.parameterizeWithOwner(p.getOwnerType(), (Class)p.getRawType(), (Type[])var2_2);
            }
            if (p instanceof WildcardType) {
                Map<TypeVariable<?>, Type> map;
                WildcardType wild = (WildcardType)((Object)p);
                return TypeUtils.wildcardType().withUpperBounds(TypeUtils.unrollBounds(map, wild.getUpperBounds())).withLowerBounds(TypeUtils.unrollBounds(map, var1_1.getLowerBounds())).build();
            }
        }
        return var1_1;
    }

    public static WildcardTypeBuilder wildcardType() {
        return new WildcardTypeBuilder();
    }

    /*
     * WARNING - void declaration
     */
    private static String wildcardTypeToString(WildcardType wildcardType) {
        void var1_1;
        StringBuilder buf = new StringBuilder("?");
        Type[] lowerBounds = wildcardType.getLowerBounds();
        Type[] upperBounds = wildcardType.getUpperBounds();
        if (lowerBounds.length > 1 || lowerBounds.length == 1 && lowerBounds[0] != null) {
            void var2_2;
            TypeUtils.appendAllTo(buf.append(" super "), " & ", var2_2);
        } else if (upperBounds.length > 1 || upperBounds.length == 1 && !Object.class.equals((Object)upperBounds[0])) {
            Type[] typeArray;
            TypeUtils.appendAllTo(buf.append(" extends "), " & ", typeArray);
        }
        return var1_1.toString();
    }

    public static <T> Typed<T> wrap(Class<T> type) {
        return TypeUtils.wrap(type);
    }

    public static <T> Typed<T> wrap(Type type) {
        return () -> type;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$000(GenericArrayType x0, Type x1) {
        void var1_1;
        return TypeUtils.equals(x0, (Type)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$100(ParameterizedType x0, Type x1) {
        void var1_1;
        return TypeUtils.equals(x0, (Type)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$300(WildcardType x0, Type x1) {
        void var1_1;
        return TypeUtils.equals(x0, (Type)var1_1);
    }

    private static final class WildcardTypeImpl
    implements WildcardType {
        private final Type[] upperBounds;
        private final Type[] lowerBounds;

        /*
         * WARNING - void declaration
         */
        private WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            void var2_2;
            void var1_1;
            this.upperBounds = ObjectUtils.defaultIfNull(var1_1, ArrayUtils.EMPTY_TYPE_ARRAY);
            this.lowerBounds = ObjectUtils.defaultIfNull(var2_2, ArrayUtils.EMPTY_TYPE_ARRAY);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            void var1_1;
            return obj == this || obj instanceof WildcardType && TypeUtils.access$300(this, (WildcardType)var1_1);
        }

        @Override
        public final Type[] getLowerBounds() {
            return (Type[])this.lowerBounds.clone();
        }

        @Override
        public final Type[] getUpperBounds() {
            return (Type[])this.upperBounds.clone();
        }

        public final int hashCode() {
            int n = 0x4900 | Arrays.hashCode(this.upperBounds);
            n <<= 8;
            return n |= Arrays.hashCode(this.lowerBounds);
        }

        public final String toString() {
            return TypeUtils.toString(this);
        }
    }

    public static class WildcardTypeBuilder
    implements Builder<WildcardType> {
        private Type[] upperBounds;
        private Type[] lowerBounds;

        private WildcardTypeBuilder() {
        }

        @Override
        public WildcardType build() {
            return new WildcardTypeImpl(this.upperBounds, this.lowerBounds);
        }

        /*
         * WARNING - void declaration
         */
        public WildcardTypeBuilder withLowerBounds(Type ... bounds) {
            void var1_1;
            this.lowerBounds = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public WildcardTypeBuilder withUpperBounds(Type ... bounds) {
            void var1_1;
            this.upperBounds = var1_1;
            return this;
        }
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Class<?> raw;
        private final Type useOwner;
        private final Type[] typeArguments;

        /*
         * WARNING - void declaration
         */
        private ParameterizedTypeImpl(Class<?> rawClass, Type useOwner, Type[] typeArguments) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.raw = var1_1;
            this.useOwner = var2_2;
            void v0 = var3_3;
            this.typeArguments = (Type[])Arrays.copyOf(v0, ((void)v0).length, Type[].class);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            void var1_1;
            return obj == this || obj instanceof ParameterizedType && TypeUtils.access$100(this, (ParameterizedType)var1_1);
        }

        @Override
        public final Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public final Type getOwnerType() {
            return this.useOwner;
        }

        @Override
        public final Type getRawType() {
            return this.raw;
        }

        public final int hashCode() {
            int n = 0x470 | this.raw.hashCode();
            n <<= 4;
            n |= Objects.hashCode(this.useOwner);
            n <<= 8;
            return n |= Arrays.hashCode(this.typeArguments);
        }

        public final String toString() {
            return TypeUtils.toString(this);
        }
    }

    private static final class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type componentType;

        /*
         * WARNING - void declaration
         */
        private GenericArrayTypeImpl(Type componentType) {
            void var1_1;
            this.componentType = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            void var1_1;
            return obj == this || obj instanceof GenericArrayType && TypeUtils.access$000(this, (GenericArrayType)var1_1);
        }

        @Override
        public final Type getGenericComponentType() {
            return this.componentType;
        }

        public final int hashCode() {
            int n = 0x430 | this.componentType.hashCode();
            return n;
        }

        public final String toString() {
            return TypeUtils.toString(this);
        }
    }
}

