/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MemberUtils;
import org.apache.commons.lang3.reflect.TypeUtils;

public class MethodUtils {
    private static final Comparator<Method> METHOD_BY_SIGNATURE = Comparator.comparing(Method::toString);

    /*
     * WARNING - void declaration
     */
    public static Object invokeMethod(Object object, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var1_1;
        return MethodUtils.invokeMethod(object, (String)var1_1, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeMethod(Object object, boolean forceAccess, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var2_2;
        void var1_1;
        return MethodUtils.invokeMethod(object, (boolean)var1_1, (String)var2_2, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeMethod(Object object, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var3_3;
        void var2_2;
        void var1_1;
        Object object2;
        args = ArrayUtils.nullToEmpty(args);
        Class<?>[] parameterTypes = ClassUtils.toClass(args);
        return MethodUtils.invokeMethod(object2, (String)var1_1, (Object[])var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeMethod(Object object, boolean forceAccess, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var3_3;
        void var2_2;
        void var1_1;
        Object object2;
        args = ArrayUtils.nullToEmpty(args);
        Class<?>[] parameterTypes = ClassUtils.toClass(args);
        return MethodUtils.invokeMethod(object2, (boolean)var1_1, (String)var2_2, (Object[])var3_3, parameterTypes);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeMethod(Object object, boolean forceAccess, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var3_4;
        Object object2;
        Method method;
        String messagePrefix;
        parameterTypes = ArrayUtils.nullToEmpty(parameterTypes);
        args = ArrayUtils.nullToEmpty(args);
        if (forceAccess) {
            messagePrefix = "No such method: ";
            method = MethodUtils.getMatchingMethod(object.getClass(), methodName, parameterTypes);
            if (method != null && !method.isAccessible()) {
                method.setAccessible(true);
            }
        } else {
            messagePrefix = "No such accessible method: ";
            method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), methodName, method);
        }
        if (method == null) {
            void var2_3;
            void var1_2;
            throw new NoSuchMethodException((String)var1_2 + (String)var2_3 + "() on object: " + object.getClass().getName());
        }
        args = MethodUtils.toVarArgs(method, args);
        return method.invoke(object2, (Object[])var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeMethod(Object object, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var3_3;
        void var2_2;
        void var1_1;
        return MethodUtils.invokeMethod(object, false, (String)var1_1, (Object[])var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeExactMethod(Object object, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var1_1;
        return MethodUtils.invokeExactMethod(object, (String)var1_1, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeExactMethod(Object object, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var3_3;
        void var2_2;
        void var1_1;
        Object object2;
        args = ArrayUtils.nullToEmpty(args);
        Class<?>[] parameterTypes = ClassUtils.toClass(args);
        return MethodUtils.invokeExactMethod(object2, (String)var1_1, (Object[])var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeExactMethod(Object object, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var2_2;
        Object object2;
        void var3_3;
        args = ArrayUtils.nullToEmpty(args);
        parameterTypes = ArrayUtils.nullToEmpty(parameterTypes);
        Method method = MethodUtils.getAccessibleMethod(object.getClass(), methodName, parameterTypes);
        if (method == null) {
            void var1_1;
            throw new NoSuchMethodException("No such accessible method: " + (String)var1_1 + "() on object: " + object.getClass().getName());
        }
        return var3_3.invoke(object2, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeExactStaticMethod(Class<?> cls, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var2_2;
        void var3_3;
        args = ArrayUtils.nullToEmpty(args);
        Method method = MethodUtils.getAccessibleMethod(cls, methodName, parameterTypes = ArrayUtils.nullToEmpty(parameterTypes));
        if (method == null) {
            Class<?> clazz;
            void var1_1;
            throw new NoSuchMethodException("No such accessible method: " + (String)var1_1 + "() on class: " + clazz.getName());
        }
        return var3_3.invoke(null, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeStaticMethod(Class<?> cls, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var3_3;
        void var2_2;
        void var1_1;
        Class<?> clazz;
        args = ArrayUtils.nullToEmpty(args);
        Class<?>[] parameterTypes = ClassUtils.toClass(args);
        return MethodUtils.invokeStaticMethod(clazz, (String)var1_1, (Object[])var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeStaticMethod(Class<?> cls, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var2_2;
        void var3_3;
        args = ArrayUtils.nullToEmpty(args);
        Method method = MethodUtils.getMatchingAccessibleMethod(cls, methodName, parameterTypes = ArrayUtils.nullToEmpty(parameterTypes));
        if (method == null) {
            Class<?> clazz;
            void var1_1;
            throw new NoSuchMethodException("No such accessible method: " + (String)var1_1 + "() on class: " + clazz.getName());
        }
        args = MethodUtils.toVarArgs(method, args);
        return var3_3.invoke(null, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static Object[] toVarArgs(Method method, Object[] args) {
        void var1_1;
        if (method.isVarArgs()) {
            Class<?>[] classArray;
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            args = MethodUtils.getVarArgs(args, classArray);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static Object[] getVarArgs(Object[] args, Class<?>[] methodParameterTypes) {
        void var2_2;
        void var3_3;
        Object[] objectArray;
        if (args.length == methodParameterTypes.length && (args[args.length - 1] == null || args[args.length - 1].getClass().equals(methodParameterTypes[methodParameterTypes.length - 1]))) {
            return args;
        }
        Object[] newArgs = new Object[methodParameterTypes.length];
        System.arraycopy(args, 0, newArgs, 0, methodParameterTypes.length - 1);
        Class<?> varArgComponentType = methodParameterTypes[methodParameterTypes.length - 1].getComponentType();
        int varArgLength = args.length - methodParameterTypes.length + 1;
        Object varArgsArray = Array.newInstance(ClassUtils.primitiveToWrapper(varArgComponentType), varArgLength);
        System.arraycopy(objectArray, methodParameterTypes.length - 1, varArgsArray, 0, varArgLength);
        if (var3_3.isPrimitive()) {
            varArgsArray = ArrayUtils.toPrimitive(varArgsArray);
        }
        newArgs[((void)var1_1).length - 1] = varArgsArray;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeExactStaticMethod(Class<?> cls, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        void var3_3;
        void var2_2;
        void var1_1;
        Class<?> clazz;
        args = ArrayUtils.nullToEmpty(args);
        Class<?>[] parameterTypes = ClassUtils.toClass(args);
        return MethodUtils.invokeExactStaticMethod(clazz, (String)var1_1, (Object[])var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Method getAccessibleMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        try {
            void var2_2;
            void var1_1;
            return MethodUtils.getAccessibleMethod(cls.getMethod((String)var1_1, (Class<?>)var2_2));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Method getAccessibleMethod(Method method) {
        Method method2;
        Class<?>[] parameterTypes;
        if (!MemberUtils.isAccessible(method)) {
            return null;
        }
        Class<?> cls = method.getDeclaringClass();
        if (Modifier.isPublic(cls.getModifiers())) {
            return method;
        }
        String methodName = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(cls, methodName, parameterTypes = method.getParameterTypes())) == null) {
            void var3_3;
            void var2_2;
            void var1_1;
            method = MethodUtils.getAccessibleMethodFromSuperclass(var1_1, (String)var2_2, var3_3);
        }
        return method2;
    }

    private static Method getAccessibleMethodFromSuperclass(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        for (Class<?> parentClass = cls.getSuperclass(); parentClass != null; parentClass = parentClass.getSuperclass()) {
            if (!Modifier.isPublic(parentClass.getModifiers())) continue;
            try {
                return parentClass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        while (cls != null) {
            Class<?>[] classArray = cls.getInterfaces();
            Class<?>[] classArray2 = classArray;
            classArray2 = classArray;
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?> anInterface = classArray2[i];
                if (!Modifier.isPublic(anInterface.getModifiers())) continue;
                try {
                    return anInterface.getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method method = MethodUtils.getAccessibleMethodFromInterfaceNest(anInterface, methodName, parameterTypes);
                    if (method == null) continue;
                    return method;
                }
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Method getMatchingAccessibleMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = cls.getMethod(methodName, parameterTypes);
            MemberUtils.setAccessibleWorkaround(method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            void var3_4;
            Method[] methods = cls.getMethods();
            Serializable matchingMethods = new ArrayList();
            for (Method method : methods) {
                if (!method.getName().equals(methodName) || !MemberUtils.isMatchingMethod(method, parameterTypes)) continue;
                matchingMethods.add(method);
            }
            matchingMethods.sort(METHOD_BY_SIGNATURE);
            Method bestMatch = null;
            Iterator iterator = matchingMethods.iterator();
            while (iterator.hasNext()) {
                Method method = (Method)iterator.next();
                Method accessibleMethod = MethodUtils.getAccessibleMethod(method);
                if (accessibleMethod == null || bestMatch != null && MemberUtils.compareMethodFit(accessibleMethod, bestMatch, parameterTypes) >= 0) continue;
                bestMatch = accessibleMethod;
            }
            if (bestMatch != null) {
                MemberUtils.setAccessibleWorkaround(bestMatch);
            }
            if (bestMatch != null && bestMatch.isVarArgs() && bestMatch.getParameterTypes().length > 0 && parameterTypes.length > 0) {
                Serializable serializable;
                void var1_1;
                Serializable parameterTypeSuperClassName;
                void var2_2;
                Class<?>[] methodParameterTypes = bestMatch.getParameterTypes();
                Class<?> clazz = methodParameterTypes[methodParameterTypes.length - 1].getComponentType();
                String methodParameterComponentTypeName = ClassUtils.primitiveToWrapper(clazz).getName();
                void v1 = var2_2;
                Serializable lastParameterType = v1[((void)v1).length - 1];
                String parameterTypeName = lastParameterType == null ? null : ((Class)lastParameterType).getName();
                Serializable serializable2 = parameterTypeSuperClassName = lastParameterType == null ? null : ((Class)lastParameterType).getSuperclass().getName();
                if (parameterTypeName != null && parameterTypeSuperClassName != null && !methodParameterComponentTypeName.equals(var1_1) && !methodParameterComponentTypeName.equals(serializable)) {
                    return null;
                }
            }
            return var3_4;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Method getMatchingMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        Class<?> clazz;
        void var2_2;
        void var1_1;
        void var3_3;
        Validate.notNull(cls, "cls", new Object[0]);
        Validate.notEmpty(methodName, "methodName", new Object[0]);
        List methods = Arrays.stream(cls.getDeclaredMethods()).filter(method -> {
            String string;
            return method.getName().equals(string);
        }).collect(Collectors.toList());
        ClassUtils.getAllSuperclasses(cls).stream().map(Class::getDeclaredMethods).flatMap(Arrays::stream).filter(method -> {
            String string;
            return method.getName().equals(string);
        }).forEach(methods::add);
        for (Method method2 : methods) {
            if (!Arrays.deepEquals(method2.getParameterTypes(), parameterTypes)) continue;
            return method2;
        }
        TreeMap candidates = new TreeMap();
        var3_3.stream().filter(method -> {
            void var1_1;
            return ClassUtils.isAssignable(parameterTypes, var1_1.getParameterTypes(), true);
        }).forEach(method -> {
            void var2_4;
            void var0_1;
            void var1_3;
            int distance = MethodUtils.distance(parameterTypes, method.getParameterTypes());
            List list = var1_3.computeIfAbsent((int)var0_1, k -> new ArrayList());
            list.add(var2_4);
        });
        if (candidates.isEmpty()) {
            return null;
        }
        List bestCandidates = (List)candidates.values().iterator().next();
        if (bestCandidates.size() == 1) {
            return (Method)bestCandidates.get(0);
        }
        throw new IllegalStateException(String.format("Found multiple candidates for method %s on class %s : %s", (String)var1_1 + Arrays.stream(var2_2).map(String::valueOf).collect(Collectors.joining(",", "(", ")")), clazz.getName(), bestCandidates.stream().map(Method::toString).collect(Collectors.joining(",", "[", "]"))));
    }

    /*
     * WARNING - void declaration
     */
    private static int distance(Class<?>[] fromClassArray, Class<?>[] toClassArray) {
        void var2_2;
        int answer = 0;
        if (!ClassUtils.isAssignable(fromClassArray, toClassArray, true)) {
            return -1;
        }
        for (int offset = 0; offset < fromClassArray.length; ++offset) {
            Class<?> aClass = fromClassArray[offset];
            Class<?> toClass = toClassArray[offset];
            if (aClass == null || aClass.equals(toClass)) continue;
            if (ClassUtils.isAssignable(aClass, toClass, true) && !ClassUtils.isAssignable(aClass, toClass, false)) {
                ++answer;
                continue;
            }
            answer += 2;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Set<Method> getOverrideHierarchy(Method method, ClassUtils.Interfaces interfacesBehavior) {
        void var2_2;
        Validate.notNull(method);
        LinkedHashSet<Method> result = new LinkedHashSet<Method>();
        result.add(method);
        Object[] parameterTypes = method.getParameterTypes();
        Class<?> declaringClass = method.getDeclaringClass();
        Iterator<Class<?>> hierarchy = ClassUtils.hierarchy(declaringClass, interfacesBehavior).iterator();
        hierarchy.next();
        block0: while (hierarchy.hasNext()) {
            Class<?> clazz = hierarchy.next();
            Method m = MethodUtils.getMatchingAccessibleMethod(clazz, method.getName(), parameterTypes);
            if (m == null) continue;
            if (Arrays.equals(m.getParameterTypes(), parameterTypes)) {
                result.add(m);
                continue;
            }
            Map<TypeVariable<?>, Type> typeArguments = TypeUtils.getTypeArguments(declaringClass, m.getDeclaringClass());
            for (int i = 0; i < parameterTypes.length; ++i) {
                Type parentType;
                Type childType = TypeUtils.unrollVariables(typeArguments, method.getGenericParameterTypes()[i]);
                if (!TypeUtils.equals(childType, parentType = TypeUtils.unrollVariables(typeArguments, m.getGenericParameterTypes()[i]))) continue block0;
            }
            result.add(m);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Method[] getMethodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        void var1_1;
        return MethodUtils.getMethodsWithAnnotation(cls, (Class<? extends Annotation>)var1_1, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Method> getMethodsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        void var1_1;
        return MethodUtils.getMethodsListWithAnnotation(cls, (Class<? extends Annotation>)var1_1, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Method[] getMethodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        void var3_3;
        void var2_2;
        void var1_1;
        List<Method> list = MethodUtils.getMethodsListWithAnnotation(cls, (Class<? extends Annotation>)var1_1, (boolean)var2_2, (boolean)var3_3);
        return list.toArray(ArrayUtils.EMPTY_METHOD_ARRAY);
    }

    public static List<Method> getMethodsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        Serializable serializable;
        Iterator iterator;
        Validate.notNull(cls, "cls", new Object[0]);
        Validate.notNull(annotationCls, "annotationCls", new Object[0]);
        ArrayList classes = searchSupers ? MethodUtils.getAllSuperclassesAndInterfaces(cls) : new ArrayList();
        classes.add(0, cls);
        Serializable annotatedMethods = new ArrayList();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Class acls = (Class)iterator.next();
            Method[] methodArray = ignoreAccess ? acls.getDeclaredMethods() : acls.getMethods();
            Method[] methodArray2 = methodArray;
            methodArray2 = methodArray;
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                Method method = methodArray2[i];
                if (method.getAnnotation(annotationCls) == null) continue;
                annotatedMethods.add((Method)method);
            }
        }
        return serializable;
    }

    /*
     * WARNING - void declaration
     */
    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        void var2_2;
        Validate.notNull(method, "method", new Object[0]);
        Validate.notNull(annotationCls, "annotationCls", new Object[0]);
        if (!ignoreAccess && !MemberUtils.isAccessible(method)) {
            return null;
        }
        A annotation = method.getAnnotation(annotationCls);
        if (annotation == null && var2_2 != false) {
            Iterator<Class<?>> iterator = method.getDeclaringClass();
            iterator = MethodUtils.getAllSuperclassesAndInterfaces(iterator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Class<?> acls = iterator.next();
                Method equivalentMethod = ignoreAccess ? MethodUtils.getMatchingMethod(acls, method.getName(), method.getParameterTypes()) : MethodUtils.getMatchingAccessibleMethod(acls, method.getName(), method.getParameterTypes());
                if (equivalentMethod == null || (annotation = equivalentMethod.getAnnotation(annotationCls)) == null) continue;
            }
        }
        return annotation;
    }

    /*
     * WARNING - void declaration
     */
    private static List<Class<?>> getAllSuperclassesAndInterfaces(Class<?> cls) {
        void var1_1;
        if (cls == null) {
            return null;
        }
        ArrayList<Class> allSuperClassesAndInterfaces = new ArrayList<Class>();
        List<Class<?>> allSuperclasses = ClassUtils.getAllSuperclasses(cls);
        int superClassIndex = 0;
        List<Class<?>> allInterfaces = ClassUtils.getAllInterfaces(cls);
        int interfaceIndex = 0;
        while (interfaceIndex < allInterfaces.size() || superClassIndex < allSuperclasses.size()) {
            Class acls = interfaceIndex < allInterfaces.size() && (superClassIndex >= allSuperclasses.size() || interfaceIndex < superClassIndex || superClassIndex >= interfaceIndex) ? (Class)allInterfaces.get(interfaceIndex++) : allSuperclasses.get(superClassIndex++);
            allSuperClassesAndInterfaces.add(acls);
        }
        return var1_1;
    }
}

