/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MemberUtils;

public class FieldUtils {
    /*
     * WARNING - void declaration
     */
    public static Field getField(Class<?> cls, String fieldName) {
        AnnotatedElement annotatedElement;
        void var1_1;
        AnnotatedElement field = FieldUtils.getField(cls, (String)var1_1, false);
        MemberUtils.setAccessibleWorkaround((AccessibleObject)field);
        return annotatedElement;
    }

    /*
     * WARNING - void declaration
     */
    public static Field getField(Class<?> cls, String fieldName, boolean forceAccess) {
        void var3_4;
        Validate.notNull(cls, "cls", new Object[0]);
        Validate.isTrue(StringUtils.isNotBlank(fieldName), "The field name must not be blank/empty", new Object[0]);
        for (Class<?> acls = cls; acls != null; acls = acls.getSuperclass()) {
            try {
                Field field = acls.getDeclaredField(fieldName);
                if (!Modifier.isPublic(field.getModifiers())) {
                    if (!forceAccess) continue;
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        Object match = null;
        for (Class<?> class1 : ClassUtils.getAllInterfaces(cls)) {
            try {
                void var2_3;
                Field test = class1.getField(fieldName);
                Validate.isTrue(match == null, "Reference to field %s is ambiguous relative to %s; a matching field exists on two or more implemented interfaces.", fieldName, cls);
                match = var2_3;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static Field getDeclaredField(Class<?> cls, String fieldName) {
        void var1_1;
        return FieldUtils.getDeclaredField(cls, (String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Field getDeclaredField(Class<?> cls, String fieldName, boolean forceAccess) {
        Validate.notNull(cls, "cls", new Object[0]);
        Validate.isTrue(StringUtils.isNotBlank(fieldName), "The field name must not be blank/empty", new Object[0]);
        try {
            AnnotatedElement annotatedElement;
            void var1_1;
            AnnotatedElement field = cls.getDeclaredField((String)var1_1);
            if (!MemberUtils.isAccessible((Member)((Object)field))) {
                void var2_2;
                if (var2_2 != false) {
                    ((Field)field).setAccessible(true);
                } else {
                    return null;
                }
            }
            return annotatedElement;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Field[] getAllFields(Class<?> cls) {
        List<Field> list = FieldUtils.getAllFieldsList(cls);
        return list.toArray(ArrayUtils.EMPTY_FIELD_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Field> getAllFieldsList(Class<?> cls) {
        void var1_1;
        Class<?> currentClass;
        Validate.notNull(cls, "cls", new Object[0]);
        ArrayList allFields = new ArrayList();
        while (currentClass != null) {
            void var2_2;
            Field[] declaredFields = currentClass.getDeclaredFields();
            Collections.addAll(allFields, var2_2);
            currentClass = currentClass.getSuperclass();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Field[] getFieldsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        void var1_1;
        List<Field> list = FieldUtils.getFieldsListWithAnnotation(cls, (Class<? extends Annotation>)var1_1);
        return list.toArray(ArrayUtils.EMPTY_FIELD_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Field> getFieldsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        void var2_2;
        Iterator iterator;
        Validate.notNull(annotationCls, "annotationCls", new Object[0]);
        Iterator allFields = FieldUtils.getAllFieldsList(cls);
        ArrayList<void> annotatedFields = new ArrayList<void>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Field field = (Field)iterator.next();
            if (field.getAnnotation(annotationCls) == null) continue;
            annotatedFields.add(var3_3);
        }
        return var2_2;
    }

    public static Object readStaticField(Field field) throws IllegalAccessException {
        return FieldUtils.readStaticField(field, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Object readStaticField(Field field, boolean forceAccess) throws IllegalAccessException {
        void var1_1;
        Field field2;
        Validate.notNull(field, "field", new Object[0]);
        Validate.isTrue(Modifier.isStatic(field.getModifiers()), "The field '%s' is not static", field.getName());
        return FieldUtils.readField(field2, null, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Object readStaticField(Class<?> cls, String fieldName) throws IllegalAccessException {
        void var1_1;
        return FieldUtils.readStaticField(cls, (String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Object readStaticField(Class<?> cls, String fieldName, boolean forceAccess) throws IllegalAccessException {
        void var2_3;
        Class<?> clazz;
        void var1_1;
        Field field = FieldUtils.getField(cls, fieldName, forceAccess);
        Validate.notNull(field, "Cannot locate field '%s' on %s", var1_1, clazz);
        return FieldUtils.readStaticField((Field)var2_3, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Object readDeclaredStaticField(Class<?> cls, String fieldName) throws IllegalAccessException {
        void var1_1;
        return FieldUtils.readDeclaredStaticField(cls, (String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Object readDeclaredStaticField(Class<?> cls, String fieldName, boolean forceAccess) throws IllegalAccessException {
        void var2_3;
        void var1_1;
        Class<?> clazz;
        Field field = FieldUtils.getDeclaredField(cls, fieldName, forceAccess);
        Validate.notNull(field, "Cannot locate declared field %s.%s", clazz.getName(), var1_1);
        return FieldUtils.readStaticField((Field)var2_3, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Object readField(Field field, Object target) throws IllegalAccessException {
        void var1_1;
        return FieldUtils.readField(field, var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Object readField(Field field, Object target, boolean forceAccess) throws IllegalAccessException {
        void var1_1;
        Field field2;
        void var2_2;
        Validate.notNull(field, "field", new Object[0]);
        if (var2_2 != false && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround(field);
        }
        return field2.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Object readField(Object target, String fieldName) throws IllegalAccessException {
        void var1_1;
        return FieldUtils.readField(target, (String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Object readField(Object target, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Object object;
        void var2_3;
        void var3_4;
        void var1_1;
        Validate.notNull(target, "target", new Object[0]);
        Class<?> cls = target.getClass();
        Field field = FieldUtils.getField(cls, fieldName, forceAccess);
        Validate.isTrue(field != null, "Cannot locate field %s on %s", var1_1, var3_4);
        return FieldUtils.readField((Field)var2_3, object, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Object readDeclaredField(Object target, String fieldName) throws IllegalAccessException {
        void var1_1;
        return FieldUtils.readDeclaredField(target, (String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Object readDeclaredField(Object target, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Object object;
        void var2_3;
        void var1_1;
        void var3_4;
        Validate.notNull(target, "target", new Object[0]);
        Class<?> cls = target.getClass();
        Field field = FieldUtils.getDeclaredField(cls, fieldName, forceAccess);
        Validate.isTrue(field != null, "Cannot locate declared field %s.%s", var3_4, var1_1);
        return FieldUtils.readField((Field)var2_3, object, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeStaticField(Field field, Object value) throws IllegalAccessException {
        void var1_1;
        FieldUtils.writeStaticField(field, var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeStaticField(Field field, Object value, boolean forceAccess) throws IllegalAccessException {
        void var2_2;
        void var1_1;
        Field field2;
        Validate.notNull(field, "field", new Object[0]);
        Validate.isTrue(Modifier.isStatic(field.getModifiers()), "The field %s.%s is not static", field.getDeclaringClass().getName(), field.getName());
        FieldUtils.writeField(field2, null, (Object)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeStaticField(Class<?> cls, String fieldName, Object value) throws IllegalAccessException {
        void var2_2;
        void var1_1;
        FieldUtils.writeStaticField(cls, (String)var1_1, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeStaticField(Class<?> cls, String fieldName, Object value, boolean forceAccess) throws IllegalAccessException {
        void var2_2;
        void var3_4;
        Class<?> clazz;
        void var1_1;
        Field field = FieldUtils.getField(cls, fieldName, forceAccess);
        Validate.notNull(field, "Cannot locate field %s on %s", var1_1, clazz);
        FieldUtils.writeStaticField((Field)var3_4, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeDeclaredStaticField(Class<?> cls, String fieldName, Object value) throws IllegalAccessException {
        void var2_2;
        void var1_1;
        FieldUtils.writeDeclaredStaticField(cls, (String)var1_1, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeDeclaredStaticField(Class<?> cls, String fieldName, Object value, boolean forceAccess) throws IllegalAccessException {
        void var2_2;
        void var3_4;
        void var1_1;
        Class<?> clazz;
        Field field = FieldUtils.getDeclaredField(cls, fieldName, forceAccess);
        Validate.notNull(field, "Cannot locate declared field %s.%s", clazz.getName(), var1_1);
        FieldUtils.writeField((Field)var3_4, null, (Object)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeField(Field field, Object target, Object value) throws IllegalAccessException {
        void var2_2;
        void var1_1;
        FieldUtils.writeField(field, var1_1, (Object)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeField(Field field, Object target, Object value, boolean forceAccess) throws IllegalAccessException {
        void var2_2;
        void var1_1;
        Field field2;
        void var3_3;
        Validate.notNull(field, "field", new Object[0]);
        if (var3_3 != false && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround(field);
        }
        field2.set(var1_1, var2_2);
    }

    public static void removeFinalModifier(Field field) {
        FieldUtils.removeFinalModifier(field, true);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void removeFinalModifier(Field field, boolean forceAccess) {
        block8: {
            Validate.notNull(field, "field", new Object[0]);
            try {
                block7: {
                    if (Modifier.isFinal(field.getModifiers())) {
                        Field modifiersField = Field.class.getDeclaredField("modifiers");
                        boolean doForceAccess = forceAccess && !modifiersField.isAccessible();
                        if (doForceAccess) {
                            modifiersField.setAccessible(true);
                        }
                        try {
                            Field field2;
                            Field field3 = field2;
                            modifiersField.setInt(field3, field3.getModifiers() & 0xFFFFFFEF);
                            if (!doForceAccess) break block7;
                            modifiersField.setAccessible(false);
                            break block8;
                        }
                        catch (Throwable throwable) {
                            void var1_2;
                            if (var1_2 != false) {
                                modifiersField.setAccessible(false);
                            }
                            throw throwable;
                        }
                    }
                }
                return;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                void var2_4;
                if (!SystemUtils.isJavaVersionAtLeast(JavaVersion.JAVA_12)) break block8;
                throw new UnsupportedOperationException("In java 12+ final cannot be removed.", (Throwable)var2_4);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeField(Object target, String fieldName, Object value) throws IllegalAccessException {
        void var2_2;
        void var1_1;
        FieldUtils.writeField(target, (String)var1_1, (Object)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeField(Object target, String fieldName, Object value, boolean forceAccess) throws IllegalAccessException {
        void var2_2;
        Object object;
        void var3_4;
        void var1_1;
        Validate.notNull(target, "target", new Object[0]);
        Class<?> cls = target.getClass();
        Field field = FieldUtils.getField(cls, fieldName, forceAccess);
        Validate.isTrue(field != null, "Cannot locate declared field %s.%s", cls.getName(), var1_1);
        FieldUtils.writeField((Field)var3_4, object, (Object)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeDeclaredField(Object target, String fieldName, Object value) throws IllegalAccessException {
        void var2_2;
        void var1_1;
        FieldUtils.writeDeclaredField(target, (String)var1_1, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeDeclaredField(Object target, String fieldName, Object value, boolean forceAccess) throws IllegalAccessException {
        void var2_2;
        Object object;
        void var3_4;
        void var1_1;
        Validate.notNull(target, "target", new Object[0]);
        Class<?> cls = target.getClass();
        Field field = FieldUtils.getDeclaredField(cls, fieldName, forceAccess);
        Validate.isTrue(field != null, "Cannot locate declared field %s.%s", cls.getName(), var1_1);
        FieldUtils.writeField((Field)var3_4, object, (Object)var2_2, false);
    }
}

