/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MemberUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class ConstructorUtils {
    /*
     * WARNING - void declaration
     */
    public static <T> T invokeConstructor(Class<T> cls, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        void var2_2;
        void var1_1;
        Class<T> clazz;
        args = ArrayUtils.nullToEmpty(args);
        Class<?>[] parameterTypes = ClassUtils.toClass(args);
        return ConstructorUtils.invokeConstructor(clazz, (Object[])var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invokeConstructor(Class<T> cls, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        void var1_1;
        void var2_2;
        args = ArrayUtils.nullToEmpty(args);
        Constructor<T> ctor = ConstructorUtils.getMatchingAccessibleConstructor(cls, parameterTypes = ArrayUtils.nullToEmpty(parameterTypes));
        if (ctor == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + cls.getName());
        }
        if (ctor.isVarArgs()) {
            Class<?>[] classArray;
            Class<?>[] methodParameterTypes = ctor.getParameterTypes();
            args = MethodUtils.getVarArgs(args, classArray);
        }
        return var2_2.newInstance((Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invokeExactConstructor(Class<T> cls, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        void var2_2;
        void var1_1;
        Class<T> clazz;
        args = ArrayUtils.nullToEmpty(args);
        Class<?>[] parameterTypes = ClassUtils.toClass(args);
        return ConstructorUtils.invokeExactConstructor(clazz, (Object[])var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invokeExactConstructor(Class<T> cls, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        void var1_1;
        void var2_2;
        args = ArrayUtils.nullToEmpty(args);
        Constructor<T> ctor = ConstructorUtils.getAccessibleConstructor(cls, parameterTypes = ArrayUtils.nullToEmpty(parameterTypes));
        if (ctor == null) {
            Class<T> clazz;
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        return var2_2.newInstance((Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Constructor<T> getAccessibleConstructor(Class<T> cls, Class<?> ... parameterTypes) {
        Validate.notNull(cls, "cls", new Object[0]);
        try {
            void var1_1;
            Class<T> clazz;
            return ConstructorUtils.getAccessibleConstructor(clazz.getConstructor((Class<?>)var1_1));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static <T> Constructor<T> getAccessibleConstructor(Constructor<T> ctor) {
        Validate.notNull(ctor, "ctor", new Object[0]);
        if (MemberUtils.isAccessible(ctor) && ConstructorUtils.isAccessible(ctor.getDeclaringClass())) {
            Constructor<T> constructor;
            return constructor;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Constructor<T> getMatchingAccessibleConstructor(Class<T> cls, Class<?> ... parameterTypes) {
        Validate.notNull(cls, "cls", new Object[0]);
        try {
            Constructor<T> ctor = cls.getConstructor(parameterTypes);
            MemberUtils.setAccessibleWorkaround(ctor);
            return ctor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            void var2_3;
            Constructor<?>[] constructorArray;
            Constructor<?> result = null;
            Constructor<?>[] constructorArray2 = constructorArray.getConstructors();
            constructorArray = constructorArray2;
            constructorArray = constructorArray2;
            int n = constructorArray2.length;
            for (int i = 0; i < n; ++i) {
                Constructor<?> ctor = constructorArray[i];
                if (!MemberUtils.isMatchingConstructor(ctor, parameterTypes) || (ctor = ConstructorUtils.getAccessibleConstructor(ctor)) == null) continue;
                MemberUtils.setAccessibleWorkaround(ctor);
                if (result != null && MemberUtils.compareConstructorFit(ctor, result, parameterTypes) >= 0) continue;
                result = ctor;
            }
            return var2_3;
        }
    }

    private static boolean isAccessible(Class<?> type) {
        for (Class<?> cls = type; cls != null; cls = cls.getEnclosingClass()) {
            if (Modifier.isPublic(cls.getModifiers())) continue;
            return false;
        }
        return true;
    }
}

