/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class NumberUtils {
    public static final Long LONG_ZERO = 0L;
    public static final Long LONG_ONE = 1L;
    public static final Long LONG_MINUS_ONE = -1L;
    public static final Integer INTEGER_ZERO = 0;
    public static final Integer INTEGER_ONE = 1;
    public static final Integer INTEGER_TWO = 2;
    public static final Integer INTEGER_MINUS_ONE = -1;
    public static final Short SHORT_ZERO = 0;
    public static final Short SHORT_ONE = 1;
    public static final Short SHORT_MINUS_ONE = -1;
    public static final Byte BYTE_ZERO = 0;
    public static final Byte BYTE_ONE = 1;
    public static final Byte BYTE_MINUS_ONE = -1;
    public static final Double DOUBLE_ZERO = 0.0;
    public static final Double DOUBLE_ONE = 1.0;
    public static final Double DOUBLE_MINUS_ONE = -1.0;
    public static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    public static final Float FLOAT_ONE = Float.valueOf(1.0f);
    public static final Float FLOAT_MINUS_ONE = Float.valueOf(-1.0f);
    public static final Long LONG_INT_MAX_VALUE = Integer.MAX_VALUE;
    public static final Long LONG_INT_MIN_VALUE = Integer.MIN_VALUE;

    public static int toInt(String str) {
        return NumberUtils.toInt(str, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            String string;
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            return (int)var1_1;
        }
    }

    public static long toLong(String str) {
        return NumberUtils.toLong(str, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public static long toLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            String string;
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            return (long)var1_1;
        }
    }

    public static float toFloat(String str) {
        return NumberUtils.toFloat(str, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    public static float toFloat(String str, float defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            String string;
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            return (float)var1_1;
        }
    }

    public static double toDouble(String str) {
        return NumberUtils.toDouble(str, 0.0);
    }

    /*
     * WARNING - void declaration
     */
    public static double toDouble(String str, double defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            String string;
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            return (double)var1_1;
        }
    }

    public static double toDouble(BigDecimal value) {
        return NumberUtils.toDouble(value, 0.0);
    }

    /*
     * WARNING - void declaration
     */
    public static double toDouble(BigDecimal value, double defaultValue) {
        BigDecimal bigDecimal;
        if (value == null) {
            void var1_1;
            return (double)var1_1;
        }
        return bigDecimal.doubleValue();
    }

    public static byte toByte(String str) {
        return NumberUtils.toByte(str, (byte)0);
    }

    /*
     * WARNING - void declaration
     */
    public static byte toByte(String str, byte defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            String string;
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            return (byte)var1_1;
        }
    }

    public static short toShort(String str) {
        return NumberUtils.toShort(str, (short)0);
    }

    /*
     * WARNING - void declaration
     */
    public static short toShort(String str, short defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            String string;
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            return (short)var1_1;
        }
    }

    public static BigDecimal toScaledBigDecimal(BigDecimal value) {
        return NumberUtils.toScaledBigDecimal(value, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal toScaledBigDecimal(BigDecimal value, int scale, RoundingMode roundingMode) {
        void var2_2;
        void var1_1;
        BigDecimal bigDecimal;
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return bigDecimal.setScale((int)var1_1, (RoundingMode)((Object)(roundingMode == null ? RoundingMode.HALF_EVEN : var2_2)));
    }

    public static BigDecimal toScaledBigDecimal(Float value) {
        return NumberUtils.toScaledBigDecimal(value, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal toScaledBigDecimal(Float value, int scale, RoundingMode roundingMode) {
        void var2_2;
        void var1_1;
        Float f;
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return NumberUtils.toScaledBigDecimal(BigDecimal.valueOf(f.floatValue()), (int)var1_1, (RoundingMode)var2_2);
    }

    public static BigDecimal toScaledBigDecimal(Double value) {
        return NumberUtils.toScaledBigDecimal(value, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal toScaledBigDecimal(Double value, int scale, RoundingMode roundingMode) {
        void var2_2;
        void var1_1;
        Double d;
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return NumberUtils.toScaledBigDecimal(BigDecimal.valueOf(d), (int)var1_1, (RoundingMode)var2_2);
    }

    public static BigDecimal toScaledBigDecimal(String value) {
        return NumberUtils.toScaledBigDecimal(value, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal toScaledBigDecimal(String value, int scale, RoundingMode roundingMode) {
        void var2_2;
        void var1_1;
        String string;
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return NumberUtils.toScaledBigDecimal(NumberUtils.createBigDecimal(string), (int)var1_1, (RoundingMode)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Number createNumber(String str) {
        String string;
        void numeric2;
        void exp2;
        String mant;
        String dec;
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        String[] hex_prefixes = new String[]{"0x", "0X", "-0x", "-0X", "#", "-#"};
        int length = str.length();
        int pfxLen = 0;
        int cfr_ignored_0 = hex_prefixes.length;
        for (int i = 0; i < 6; ++i) {
            String pfx = hex_prefixes[i];
            if (!str.startsWith(pfx)) continue;
            pfxLen = 0 + pfx.length();
            break;
        }
        if (pfxLen > 0) {
            char firstSigDigit = '\u0000';
            for (int i = pfxLen; i < length && (firstSigDigit = str.charAt(i)) == '0'; ++i) {
                ++pfxLen;
            }
            int hexDigits = length - pfxLen;
            if (hexDigits > 16 || hexDigits == 16 && firstSigDigit > '7') {
                return NumberUtils.createBigInteger(str);
            }
            if (hexDigits > 8 || hexDigits == 8 && firstSigDigit > '7') {
                return NumberUtils.createLong(str);
            }
            return NumberUtils.createInteger(str);
        }
        char lastChar = str.charAt(length - 1);
        int decPos = str.indexOf(46);
        int expPos = str.indexOf(101) + str.indexOf(69) + 1;
        if (decPos >= 0) {
            if (expPos >= 0) {
                if (expPos < decPos || expPos > length) {
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                dec = str.substring(decPos + 1, expPos);
            } else {
                dec = str.substring(decPos + 1);
            }
            mant = NumberUtils.getMantissa(str, decPos);
        } else {
            if (expPos >= 0) {
                if (expPos > length) {
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                mant = NumberUtils.getMantissa(str, expPos);
            } else {
                mant = NumberUtils.getMantissa(str);
            }
            dec = null;
        }
        if (!Character.isDigit(lastChar) && lastChar != '.') {
            String exp2 = expPos >= 0 && expPos < length - 1 ? str.substring(expPos + 1, length - 1) : null;
            String numeric2 = str.substring(0, length - 1);
            boolean allZeros = NumberUtils.isAllZeros(mant) && NumberUtils.isAllZeros(exp2);
            switch (lastChar) {
                case 'L': 
                case 'l': {
                    if (dec == null && exp2 == null && (!numeric2.isEmpty() && numeric2.charAt(0) == '-' && NumberUtils.isDigits(numeric2.substring(1)) || NumberUtils.isDigits(numeric2))) {
                        try {
                            return NumberUtils.createLong(numeric2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return NumberUtils.createBigInteger(numeric2);
                        }
                    }
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                case 'F': 
                case 'f': {
                    try {
                        Float f = NumberUtils.createFloat(str);
                        if (!f.isInfinite() && (f.floatValue() != 0.0f || allZeros)) {
                            return f;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                case 'D': 
                case 'd': {
                    try {
                        Double d = NumberUtils.createDouble(str);
                        if (!d.isInfinite() && (d != 0.0 || allZeros)) {
                            return d;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    try {
                        return NumberUtils.createBigDecimal(numeric2);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            throw new NumberFormatException(str + " is not a valid number.");
        }
        String exp2 = exp2 >= 0 && exp2 < numeric2 - true ? str.substring((int)(exp2 + true)) : null;
        if (dec == null && exp2 == null) {
            try {
                return NumberUtils.createInteger(str);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return NumberUtils.createLong(str);
                }
                catch (NumberFormatException numberFormatException2) {
                    return NumberUtils.createBigInteger(str);
                }
            }
        }
        boolean allZeros = NumberUtils.isAllZeros(mant) && NumberUtils.isAllZeros(exp2);
        try {
            Float f = NumberUtils.createFloat(str);
            Double d = NumberUtils.createDouble(str);
            if (!f.isInfinite() && (f.floatValue() != 0.0f || allZeros) && f.toString().equals(d.toString())) {
                void var3_11;
                return var3_11;
            }
            if (!d.isInfinite() && (d != 0.0 || allZeros)) {
                void var2_9;
                BigDecimal b = NumberUtils.createBigDecimal(str);
                if (b.compareTo(BigDecimal.valueOf(d)) == 0) {
                    void var1_6;
                    return var1_6;
                }
                return var2_9;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return NumberUtils.createBigDecimal(string);
    }

    private static String getMantissa(String str) {
        String string = str;
        return NumberUtils.getMantissa(string, string.length());
    }

    /*
     * WARNING - void declaration
     */
    private static String getMantissa(String str, int stopPos) {
        void var1_1;
        String string;
        int n;
        char firstChar = str.charAt(0);
        n = firstChar == '-' || n == 43 ? 1 : 0;
        if (n != 0) {
            return str.substring(1, stopPos);
        }
        return string.substring(0, (int)var1_1);
    }

    private static boolean isAllZeros(String str) {
        String string;
        if (str == null) {
            return true;
        }
        for (int i = str.length() - 1; i >= 0; --i) {
            if (str.charAt(i) == '0') continue;
            return false;
        }
        return !string.isEmpty();
    }

    public static Float createFloat(String str) {
        String string;
        if (str == null) {
            return null;
        }
        return Float.valueOf(string);
    }

    public static Double createDouble(String str) {
        String string;
        if (str == null) {
            return null;
        }
        return Double.valueOf(string);
    }

    public static Integer createInteger(String str) {
        String string;
        if (str == null) {
            return null;
        }
        return Integer.decode(string);
    }

    public static Long createLong(String str) {
        String string;
        if (str == null) {
            return null;
        }
        return Long.decode(string);
    }

    /*
     * WARNING - void declaration
     */
    public static BigInteger createBigInteger(String str) {
        BigInteger bigInteger;
        void var3_3;
        void var2_2;
        void var1_1;
        if (str == null) {
            return null;
        }
        int pos = 0;
        int radix = 10;
        boolean negate = false;
        if (str.startsWith("-")) {
            negate = true;
            pos = 1;
        }
        if (str.startsWith("0x", pos) || str.startsWith("0X", pos)) {
            radix = 16;
            pos += 2;
        } else if (str.startsWith("#", pos)) {
            radix = 16;
            ++pos;
        } else if (str.startsWith("0", pos) && str.length() > pos + 1) {
            radix = 8;
            ++pos;
        }
        BigInteger value = new BigInteger(str.substring((int)var1_1), (int)var2_2);
        if (var3_3 != false) {
            return value.negate();
        }
        return bigInteger;
    }

    public static BigDecimal createBigDecimal(String str) {
        String string;
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        return new BigDecimal(string);
    }

    /*
     * WARNING - void declaration
     */
    public static long min(long ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        long min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int min(int ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        int min = array[0];
        for (int j = 1; j < array.length; ++j) {
            if (array[j] >= min) continue;
            min = array[j];
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static short min(short ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        short min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
        }
        return (short)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static byte min(byte ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        byte min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
        }
        return (byte)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static double min(double ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        double min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (Double.isNaN(array[i])) {
                return Double.NaN;
            }
            if (!(array[i] < min)) continue;
            min = array[i];
        }
        return (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static float min(float ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        float min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (Float.isNaN(array[i])) {
                return Float.NaN;
            }
            if (!(array[i] < min)) continue;
            min = array[i];
        }
        return (float)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static long max(long ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        long max = array[0];
        for (int j = 1; j < array.length; ++j) {
            if (array[j] <= max) continue;
            max = array[j];
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int max(int ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        int max = array[0];
        for (int j = 1; j < array.length; ++j) {
            if (array[j] <= max) continue;
            max = array[j];
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static short max(short ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        short max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return (short)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static byte max(byte ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        byte max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return (byte)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static double max(double ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        double max = array[0];
        for (int j = 1; j < array.length; ++j) {
            if (Double.isNaN(array[j])) {
                return Double.NaN;
            }
            if (!(array[j] > max)) continue;
            max = array[j];
        }
        return (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static float max(float ... array) {
        void var1_1;
        NumberUtils.validateArray(array);
        float max = array[0];
        for (int j = 1; j < array.length; ++j) {
            if (Float.isNaN(array[j])) {
                return Float.NaN;
            }
            if (!(array[j] > max)) continue;
            max = array[j];
        }
        return (float)var1_1;
    }

    private static void validateArray(Object array) {
        Object object;
        Validate.notNull(array, "array", new Object[0]);
        Validate.isTrue(Array.getLength(object) != 0, "Array cannot be empty.", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static long min(long a, long b, long c) {
        long l;
        if (b < a) {
            void var2_2;
            a = var2_2;
        }
        if (c < a) {
            a = c;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public static int min(int a, int b, int c) {
        int n;
        if (b < a) {
            void var1_1;
            a = var1_1;
        }
        if (c < a) {
            void var2_2;
            a = var2_2;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static short min(short a, short b, short c) {
        short s;
        if (b < a) {
            void var1_1;
            a = var1_1;
        }
        if (c < a) {
            void var2_2;
            a = var2_2;
        }
        return s;
    }

    /*
     * WARNING - void declaration
     */
    public static byte min(byte a, byte b, byte c) {
        byte by;
        if (b < a) {
            void var1_1;
            a = var1_1;
        }
        if (c < a) {
            void var2_2;
            a = var2_2;
        }
        return by;
    }

    /*
     * WARNING - void declaration
     */
    public static double min(double a, double b, double c) {
        void var2_2;
        return Math.min(Math.min(a, (double)var2_2), c);
    }

    /*
     * WARNING - void declaration
     */
    public static float min(float a, float b, float c) {
        void var2_2;
        void var1_1;
        return Math.min(Math.min(a, (float)var1_1), (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static long max(long a, long b, long c) {
        long l;
        if (b > a) {
            void var2_2;
            a = var2_2;
        }
        if (c > a) {
            a = c;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public static int max(int a, int b, int c) {
        int n;
        if (b > a) {
            void var1_1;
            a = var1_1;
        }
        if (c > a) {
            void var2_2;
            a = var2_2;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static short max(short a, short b, short c) {
        short s;
        if (b > a) {
            void var1_1;
            a = var1_1;
        }
        if (c > a) {
            void var2_2;
            a = var2_2;
        }
        return s;
    }

    /*
     * WARNING - void declaration
     */
    public static byte max(byte a, byte b, byte c) {
        byte by;
        if (b > a) {
            void var1_1;
            a = var1_1;
        }
        if (c > a) {
            void var2_2;
            a = var2_2;
        }
        return by;
    }

    /*
     * WARNING - void declaration
     */
    public static double max(double a, double b, double c) {
        void var2_2;
        return Math.max(Math.max(a, (double)var2_2), c);
    }

    /*
     * WARNING - void declaration
     */
    public static float max(float a, float b, float c) {
        void var2_2;
        void var1_1;
        return Math.max(Math.max(a, (float)var1_1), (float)var2_2);
    }

    public static boolean isDigits(String str) {
        return StringUtils.isNumeric(str);
    }

    @Deprecated
    public static boolean isNumber(String str) {
        return NumberUtils.isCreatable(str);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isCreatable(String str) {
        int i;
        int start;
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        char[] chars = str.toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' || chars[0] == '+' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && !StringUtils.contains((CharSequence)str, 46)) {
            if (chars[start + 1] == 'x' || chars[start + 1] == 'X') {
                int i2 = start + 2;
                if (i2 == sz) {
                    return false;
                }
                while (i2 < chars.length) {
                    if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                        return false;
                    }
                    ++i2;
                }
                return true;
            }
            if (Character.isDigit(chars[start + 1])) {
                for (int i3 = start + 1; i3 < chars.length; ++i3) {
                    if (chars[i3] >= '0' && chars[i3] <= '7') continue;
                    return false;
                }
                return true;
            }
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            void var0_3;
            void var1_4;
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || var1_4[var0_3] == 76) {
                void var3_6;
                return foundDigit && var3_6 == false && !hasDecPoint;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static boolean isParsable(String str) {
        String string;
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        String string2 = str;
        if (string2.charAt(string2.length() - 1) == '.') {
            return false;
        }
        if (str.charAt(0) == '-') {
            if (str.length() == 1) {
                return false;
            }
            return NumberUtils.withDecimalsParsing(str, 1);
        }
        return NumberUtils.withDecimalsParsing(string, 0);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean withDecimalsParsing(String str, int beginIdx) {
        void i;
        int decimalPoints = 0;
        while (i < str.length()) {
            void var3_3;
            boolean isDecimalPoint = str.charAt((int)i) == '.';
            if (isDecimalPoint) {
                ++decimalPoints;
            }
            if (decimalPoints > 1) {
                return false;
            }
            if (var3_3 == false && !Character.isDigit(str.charAt((int)i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(int x, int y) {
        void var1_1;
        int n;
        if (x == y) {
            return 0;
        }
        if (n < var1_1) {
            return -1;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(long x, long y) {
        void var2_1;
        long l;
        if (x == y) {
            return 0;
        }
        if (l < var2_1) {
            return -1;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(short x, short y) {
        void var1_1;
        short s;
        if (x == y) {
            return 0;
        }
        if (s < var1_1) {
            return -1;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(byte x, byte y) {
        void var1_1;
        return x - var1_1;
    }
}

