/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;

public class ExceptionUtils {
    private static final int NOT_FOUND = -1;
    private static final String[] CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};
    static final String WRAPPED_MARKER = " [wrapped] ";

    @Deprecated
    public static Throwable getCause(Throwable throwable) {
        return ExceptionUtils.getCause(throwable, null);
    }

    @Deprecated
    public static Throwable getCause(Throwable throwable, String[] methodNames) {
        String[] stringArray;
        if (throwable == null) {
            return null;
        }
        if (methodNames == null) {
            Throwable cause = throwable.getCause();
            if (cause != null) {
                return stringArray;
            }
            stringArray = CAUSE_METHOD_NAMES;
        }
        for (String methodName : stringArray) {
            Throwable legacyCause;
            if (methodName == null || (legacyCause = ExceptionUtils.getCauseUsingMethodName(throwable, methodName)) == null) continue;
            return legacyCause;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Throwable getCauseUsingMethodName(Throwable throwable, String methodName) {
        Method method = null;
        try {
            void var1_1;
            method = throwable.getClass().getMethod((String)var1_1, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {}
        if (method != null && Throwable.class.isAssignableFrom(method.getReturnType())) {
            try {
                Throwable throwable2;
                void var2_2;
                return (Throwable)var2_2.invoke((Object)throwable2, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {}
        }
        return null;
    }

    @Deprecated
    public static String[] getDefaultCauseMethodNames() {
        return ArrayUtils.clone(CAUSE_METHOD_NAMES);
    }

    /*
     * WARNING - void declaration
     */
    public static String getMessage(Throwable th) {
        String string;
        void var1_1;
        if (th == null) {
            return "";
        }
        String clsName = ClassUtils.getShortClassName(th, null);
        String msg = th.getMessage();
        return (String)var1_1 + ": " + StringUtils.defaultString(string);
    }

    public static Throwable getRootCause(Throwable throwable) {
        List<Throwable> list;
        List<Throwable> list2 = ExceptionUtils.getThrowableList(throwable);
        if (list2.isEmpty()) {
            return null;
        }
        List<Throwable> list3 = list;
        return (Throwable)list3.get(list3.size() - 1);
    }

    public static String getRootCauseMessage(Throwable th) {
        Throwable throwable;
        Throwable throwable2;
        Throwable root = ExceptionUtils.getRootCause(th);
        throwable = root == null ? throwable2 : throwable;
        return ExceptionUtils.getMessage(throwable);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] getRootCauseStackTrace(Throwable throwable) {
        void var2_2;
        if (throwable == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Throwable[] throwables = ExceptionUtils.getThrowables(throwable);
        int count = throwables.length;
        ArrayList<String> frames = new ArrayList<String>();
        List<String> nextTrace = ExceptionUtils.getStackFrameList(throwables[count - 1]);
        int i = count;
        while (--i >= 0) {
            List<String> trace = nextTrace;
            if (i != 0) {
                nextTrace = ExceptionUtils.getStackFrameList(throwables[i - 1]);
                ExceptionUtils.removeCommonFrames(trace, nextTrace);
            }
            if (i == count - 1) {
                frames.add(throwables[i].toString());
            } else {
                frames.add(WRAPPED_MARKER + throwables[i].toString());
            }
            frames.addAll(trace);
        }
        return var2_2.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    static List<String> getStackFrameList(Throwable t) {
        void var1_1;
        String stackTrace = ExceptionUtils.getStackTrace(t);
        String linebreak = System.lineSeparator();
        String frames = new StringTokenizer(stackTrace, linebreak);
        ArrayList<void> list = new ArrayList<void>();
        boolean traceStarted = false;
        while (((StringTokenizer)((Object)frames)).hasMoreTokens()) {
            String token = ((StringTokenizer)((Object)frames)).nextToken();
            int at = token.indexOf("at");
            if (at != -1 && token.substring(0, at).trim().isEmpty()) {
                void var3_3;
                traceStarted = true;
                list.add(var3_3);
                continue;
            }
            if (!traceStarted) continue;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static String[] getStackFrames(String stackTrace) {
        void var1_1;
        String linebreak = System.lineSeparator();
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        ArrayList<String> list = new ArrayList<String>();
        while (frames.hasMoreTokens()) {
            list.add(frames.nextToken());
        }
        return var1_1.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String[] getStackFrames(Throwable throwable) {
        Throwable throwable2;
        if (throwable == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return ExceptionUtils.getStackFrames(ExceptionUtils.getStackTrace(throwable2));
    }

    /*
     * WARNING - void declaration
     */
    public static String getStackTrace(Throwable throwable) {
        void var1_1;
        void var2_2;
        Throwable throwable2;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable2.printStackTrace((PrintWriter)var2_2);
        return var1_1.getBuffer().toString();
    }

    public static int getThrowableCount(Throwable throwable) {
        return ExceptionUtils.getThrowableList(throwable).size();
    }

    /*
     * WARNING - void declaration
     */
    public static List<Throwable> getThrowableList(Throwable throwable) {
        void var1_1;
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = throwable.getCause();
        }
        return var1_1;
    }

    public static Throwable[] getThrowables(Throwable throwable) {
        List<Throwable> list = ExceptionUtils.getThrowableList(throwable);
        return list.toArray(ArrayUtils.EMPTY_THROWABLE_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasCause(Throwable chain, Class<? extends Throwable> type) {
        Throwable throwable;
        void var1_1;
        if (chain instanceof UndeclaredThrowableException) {
            chain = chain.getCause();
        }
        return var1_1.isInstance(throwable);
    }

    /*
     * WARNING - void declaration
     */
    private static int indexOf(Throwable throwable, Class<? extends Throwable> type, int fromIndex, boolean subclass) {
        void i;
        void var3_3;
        Throwable[] throwables;
        if (throwable == null || type == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex >= (throwables = ExceptionUtils.getThrowables(throwable)).length) {
            return -1;
        }
        if (var3_3 != false) {
            while (i < throwables.length) {
                if (type.isAssignableFrom(throwables[i].getClass())) {
                    return (int)i;
                }
                ++i;
            }
        } else {
            while (i < throwables.length) {
                if (type.equals(throwables[i].getClass())) {
                    return (int)i;
                }
                ++i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfThrowable(Throwable throwable, Class<? extends Throwable> clazz) {
        void var1_1;
        return ExceptionUtils.indexOf(throwable, (Class<? extends Throwable>)var1_1, 0, false);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfThrowable(Throwable throwable, Class<? extends Throwable> clazz, int fromIndex) {
        void var2_2;
        void var1_1;
        return ExceptionUtils.indexOf(throwable, (Class<? extends Throwable>)var1_1, (int)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfType(Throwable throwable, Class<? extends Throwable> type) {
        void var1_1;
        return ExceptionUtils.indexOf(throwable, (Class<? extends Throwable>)var1_1, 0, true);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfType(Throwable throwable, Class<? extends Throwable> type, int fromIndex) {
        void var2_2;
        void var1_1;
        return ExceptionUtils.indexOf(throwable, (Class<? extends Throwable>)var1_1, (int)var2_2, true);
    }

    public static void printRootCauseStackTrace(Throwable throwable) {
        ExceptionUtils.printRootCauseStackTrace(throwable, System.err);
    }

    /*
     * WARNING - void declaration
     */
    public static void printRootCauseStackTrace(Throwable throwable, PrintStream printStream) {
        void var1_1;
        String[] stringArray;
        if (throwable == null) {
            return;
        }
        Objects.requireNonNull(printStream, "printStream");
        String[] stringArray2 = ExceptionUtils.getRootCauseStackTrace((Throwable)stringArray);
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String element = stringArray[i];
            printStream.println(element);
        }
        var1_1.flush();
    }

    /*
     * WARNING - void declaration
     */
    public static void printRootCauseStackTrace(Throwable throwable, PrintWriter printWriter) {
        void var1_1;
        String[] stringArray;
        if (throwable == null) {
            return;
        }
        Objects.requireNonNull(printWriter, "printWriter");
        String[] stringArray2 = ExceptionUtils.getRootCauseStackTrace((Throwable)stringArray);
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String element = stringArray[i];
            printWriter.println(element);
        }
        var1_1.flush();
    }

    public static void removeCommonFrames(List<String> causeFrames, List<String> wrapperFrames) {
        if (causeFrames == null || wrapperFrames == null) {
            throw new IllegalArgumentException("The List must not be null");
        }
        int causeFrameIndex = causeFrames.size() - 1;
        for (int wrapperFrameIndex = wrapperFrames.size() - 1; causeFrameIndex >= 0 && wrapperFrameIndex >= 0; --causeFrameIndex, --wrapperFrameIndex) {
            String wrapperFrame;
            String causeFrame = causeFrames.get(causeFrameIndex);
            if (!causeFrame.equals(wrapperFrame = wrapperFrames.get(wrapperFrameIndex))) continue;
            causeFrames.remove(causeFrameIndex);
        }
    }

    public static <R> R rethrow(Throwable throwable) {
        return ExceptionUtils.typeErasure(throwable);
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends Throwable> T throwableOf(Throwable throwable, Class<T> type, int fromIndex, boolean subclass) {
        void i;
        void var3_3;
        Throwable[] throwables;
        if (throwable == null || type == null) {
            return null;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex >= (throwables = ExceptionUtils.getThrowables(throwable)).length) {
            return null;
        }
        if (var3_3 != false) {
            while (i < throwables.length) {
                if (type.isAssignableFrom(throwables[i].getClass())) {
                    return (T)((Throwable)type.cast(throwables[i]));
                }
                ++i;
            }
        } else {
            while (i < throwables.length) {
                if (type.equals(throwables[i].getClass())) {
                    return (T)((Throwable)type.cast(throwables[i]));
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Throwable> T throwableOfThrowable(Throwable throwable, Class<T> clazz) {
        void var1_1;
        return ExceptionUtils.throwableOf(throwable, var1_1, 0, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Throwable> T throwableOfThrowable(Throwable throwable, Class<T> clazz, int fromIndex) {
        void var2_2;
        void var1_1;
        return ExceptionUtils.throwableOf(throwable, var1_1, (int)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Throwable> T throwableOfType(Throwable throwable, Class<T> type) {
        void var1_1;
        return ExceptionUtils.throwableOf(throwable, var1_1, 0, true);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Throwable> T throwableOfType(Throwable throwable, Class<T> type, int fromIndex) {
        void var2_2;
        void var1_1;
        return ExceptionUtils.throwableOf(throwable, var1_1, (int)var2_2, true);
    }

    private static <R, T extends Throwable> R typeErasure(Throwable throwable) throws T {
        throw throwable;
    }

    public static <R> R wrapAndThrow(Throwable throwable) {
        Throwable throwable2;
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new UndeclaredThrowableException(throwable2);
    }
}

