/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultExceptionContext
implements Serializable,
ExceptionContext {
    private static final long serialVersionUID = 20110706L;
    private final List<Pair<String, Object>> contextValues = new ArrayList<Pair<String, Object>>();

    /*
     * WARNING - void declaration
     */
    @Override
    public DefaultExceptionContext addContextValue(String label, Object value) {
        void var2_2;
        void var1_1;
        this.contextValues.add(new ImmutablePair<void, void>(var1_1, var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DefaultExceptionContext setContextValue(String label, Object value) {
        void var2_2;
        void var1_1;
        this.contextValues.removeIf(p -> {
            void var1_1;
            return StringUtils.equals(label, (CharSequence)var1_1.getKey());
        });
        this.addContextValue((String)var1_1, var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Object> getContextValues(String label) {
        void var2_2;
        ArrayList<Object> values = new ArrayList<Object>();
        for (Pair<String, Object> pair : this.contextValues) {
            if (!StringUtils.equals(label, pair.getKey())) continue;
            values.add(pair.getValue());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getFirstContextValue(String label) {
        for (Pair<String, Object> pair : this.contextValues) {
            void var3_3;
            if (!StringUtils.equals(label, pair.getKey())) continue;
            return var3_3.getValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<String> getContextLabels() {
        void var1_1;
        HashSet labels = new HashSet();
        for (Pair<String, Object> pair : this.contextValues) {
            void var3_3;
            labels.add(var3_3.getKey());
        }
        return var1_1;
    }

    @Override
    public List<Pair<String, Object>> getContextEntries() {
        return this.contextValues;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedExceptionMessage(String baseMessage) {
        void var2_3;
        StringBuilder buffer = new StringBuilder(256);
        if (baseMessage != null) {
            buffer.append(baseMessage);
        }
        if (!this.contextValues.isEmpty()) {
            if (buffer.length() > 0) {
                buffer.append('\n');
            }
            buffer.append("Exception Context:\n");
            int i = 0;
            for (Pair<String, Object> pair : this.contextValues) {
                buffer.append("\t[");
                buffer.append(++i);
                buffer.append(':');
                buffer.append(pair.getKey());
                buffer.append("=");
                Object value = pair.getValue();
                if (value == null) {
                    buffer.append("null");
                } else {
                    String valueStr;
                    try {
                        valueStr = value.toString();
                    }
                    catch (Exception e) {
                        valueStr = "Exception thrown on toString(): " + ExceptionUtils.getStackTrace(e);
                    }
                    buffer.append(valueStr);
                }
                buffer.append("]\n");
            }
            buffer.append("---------------------------------");
        }
        return var2_3.toString();
    }
}

