/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.event;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.Validate;

public class EventListenerSupport<L>
implements Serializable {
    private static final long serialVersionUID = 3593265990380473632L;
    private List<L> listeners = new CopyOnWriteArrayList<L>();
    private transient L proxy;
    private transient L[] prototypeArray;

    public static <T> EventListenerSupport<T> create(Class<T> listenerInterface) {
        Class<T> clazz;
        return new EventListenerSupport<T>(clazz);
    }

    /*
     * WARNING - void declaration
     */
    public EventListenerSupport(Class<L> listenerInterface) {
        this((Class<L>)var1_1, Thread.currentThread().getContextClassLoader());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EventListenerSupport(Class<L> listenerInterface, ClassLoader classLoader) {
        this();
        void var2_2;
        void var1_1;
        Validate.notNull(listenerInterface, "listenerInterface", new Object[0]);
        Validate.notNull(classLoader, "classLoader", new Object[0]);
        Validate.isTrue(listenerInterface.isInterface(), "Class %s is not an interface", listenerInterface.getName());
        super.initializeTransientFields((Class<L>)var1_1, (ClassLoader)var2_2);
    }

    private EventListenerSupport() {
    }

    public L fire() {
        return this.proxy;
    }

    /*
     * WARNING - void declaration
     */
    public void addListener(L listener) {
        void var1_1;
        this.addListener(var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public void addListener(L listener, boolean allowDuplicate) {
        void var2_2;
        Validate.notNull(listener, "listener", new Object[0]);
        if (var2_2 != false || !this.listeners.contains(listener)) {
            void var1_1;
            this.listeners.add(var1_1);
        }
    }

    int getListenerCount() {
        return this.listeners.size();
    }

    /*
     * WARNING - void declaration
     */
    public void removeListener(L listener) {
        void var1_1;
        Validate.notNull(listener, "listener", new Object[0]);
        this.listeners.remove(var1_1);
    }

    public L[] getListeners() {
        return this.listeners.toArray(this.prototypeArray);
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        void var2_2;
        void var1_1;
        ArrayList<L> serializableListeners = new ArrayList<L>();
        ObjectOutputStream testObjectOutputStream = new ObjectOutputStream(new ByteArrayOutputStream());
        for (L listener : this.listeners) {
            try {
                testObjectOutputStream.writeObject(listener);
                serializableListeners.add(listener);
            }
            catch (IOException iOException) {
                testObjectOutputStream = new ObjectOutputStream(new ByteArrayOutputStream());
            }
        }
        var1_1.writeObject(var2_2.toArray(this.prototypeArray));
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        void var1_1;
        Object[] srcListeners = (Object[])objectInputStream.readObject();
        this.listeners = new CopyOnWriteArrayList<Object>(srcListeners);
        Class<?> listenerInterface = srcListeners.getClass().getComponentType();
        this.initializeTransientFields((Class<L>)var1_1, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - void declaration
     */
    private void initializeTransientFields(Class<L> listenerInterface, ClassLoader classLoader) {
        void var2_2;
        void var1_1;
        void var3_3;
        Object[] array = (Object[])Array.newInstance(listenerInterface, 0);
        this.prototypeArray = var3_3;
        this.createProxy((Class<L>)var1_1, (ClassLoader)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void createProxy(Class<L> listenerInterface, ClassLoader classLoader) {
        void var1_1;
        void var2_2;
        this.proxy = listenerInterface.cast(Proxy.newProxyInstance((ClassLoader)var2_2, new Class[]{var1_1}, this.createInvocationHandler()));
    }

    protected InvocationHandler createInvocationHandler() {
        return new ProxyInvocationHandler(this);
    }

    protected class ProxyInvocationHandler
    implements InvocationHandler {
        final /* synthetic */ EventListenerSupport this$0;

        /*
         * WARNING - void declaration
         */
        protected ProxyInvocationHandler(EventListenerSupport this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public Object invoke(Object unusedProxy, Method method, Object[] args) throws Throwable {
            for (Object listener : this.this$0.listeners) {
                method.invoke(listener, args);
            }
            return null;
        }
    }
}

