/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent.locks;

import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.apache.commons.lang3.function.Failable;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableFunction;

public class LockingVisitors {
    public static <O> ReadWriteLockVisitor<O> reentrantReadWriteLockVisitor(O object) {
        O o;
        return new ReadWriteLockVisitor<O>(o, new ReentrantReadWriteLock());
    }

    public static <O> StampedLockVisitor<O> stampedLockVisitor(O object) {
        O o;
        return new StampedLockVisitor<O>(o, new StampedLock());
    }

    public static class StampedLockVisitor<O>
    extends LockVisitor<O, StampedLock> {
        /*
         * WARNING - void declaration
         */
        protected StampedLockVisitor(O object, StampedLock stampedLock) {
            void var2_2;
            void var1_1;
            StampedLock stampedLock2 = stampedLock;
            super(var1_1, stampedLock2, stampedLock2::asReadLock, ((StampedLock)var2_2)::asWriteLock);
        }
    }

    public static class ReadWriteLockVisitor<O>
    extends LockVisitor<O, ReadWriteLock> {
        /*
         * WARNING - void declaration
         */
        protected ReadWriteLockVisitor(O object, ReadWriteLock readWriteLock) {
            void var2_2;
            void var1_1;
            ReadWriteLock readWriteLock2 = readWriteLock;
            super(var1_1, readWriteLock2, readWriteLock2::readLock, ((ReadWriteLock)var2_2)::writeLock);
        }
    }

    public static class LockVisitor<O, L> {
        private final L lock;
        private final O object;
        private final Supplier<Lock> readLockSupplier;
        private final Supplier<Lock> writeLockSupplier;

        /*
         * WARNING - void declaration
         */
        protected LockVisitor(O object, L lock, Supplier<Lock> readLockSupplier, Supplier<Lock> writeLockSupplier) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.object = Objects.requireNonNull(var1_1, "object");
            this.lock = Objects.requireNonNull(var2_2, "lock");
            this.readLockSupplier = (Supplier)Objects.requireNonNull(var3_3, "readLockSupplier");
            this.writeLockSupplier = Objects.requireNonNull(writeLockSupplier, "writeLockSupplier");
        }

        /*
         * WARNING - void declaration
         */
        public void acceptReadLocked(FailableConsumer<O, ?> consumer) {
            void var1_1;
            LockVisitor lockVisitor = this;
            lockVisitor.lockAcceptUnlock(lockVisitor.readLockSupplier, (FailableConsumer<O, ?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void acceptWriteLocked(FailableConsumer<O, ?> consumer) {
            void var1_1;
            LockVisitor lockVisitor = this;
            lockVisitor.lockAcceptUnlock(lockVisitor.writeLockSupplier, (FailableConsumer<O, ?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public <T> T applyReadLocked(FailableFunction<O, T, ?> function) {
            void var1_1;
            LockVisitor lockVisitor = this;
            return lockVisitor.lockApplyUnlock(lockVisitor.readLockSupplier, (FailableFunction<O, T, ?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public <T> T applyWriteLocked(FailableFunction<O, T, ?> function) {
            void var1_1;
            LockVisitor lockVisitor = this;
            return lockVisitor.lockApplyUnlock(lockVisitor.writeLockSupplier, (FailableFunction<O, T, ?>)var1_1);
        }

        public L getLock() {
            return this.lock;
        }

        public O getObject() {
            return this.object;
        }

        /*
         * WARNING - void declaration
         */
        protected void lockAcceptUnlock(Supplier<Lock> lockSupplier, FailableConsumer<O, ?> consumer) {
            Throwable throwable;
            Lock lock = lockSupplier.get();
            lock.lock();
            try {
                throwable.accept(this.object);
                lock.unlock();
                return;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw Failable.rethrow(throwable2);
                }
                catch (Throwable throwable3) {
                    void var1_1;
                    var1_1.unlock();
                    throw throwable3;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        protected <T> T lockApplyUnlock(Supplier<Lock> lockSupplier, FailableFunction<O, T, ?> function) {
            Throwable throwable;
            Lock lock = lockSupplier.get();
            lock.lock();
            try {
                throwable = throwable.apply(this.object);
                lock.unlock();
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw Failable.rethrow(throwable2);
                }
                catch (Throwable throwable3) {
                    void var1_1;
                    var1_1.unlock();
                    throw throwable3;
                }
            }
            return (T)throwable;
        }
    }
}

