/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.concurrent.BackgroundInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;

public class MultiBackgroundInitializer
extends BackgroundInitializer<MultiBackgroundInitializerResults> {
    private final Map<String, BackgroundInitializer<?>> childInitializers = new HashMap();

    public MultiBackgroundInitializer() {
    }

    /*
     * WARNING - void declaration
     */
    public MultiBackgroundInitializer(ExecutorService exec) {
        super((ExecutorService)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addInitializer(String name, BackgroundInitializer<?> backgroundInitializer) {
        Validate.notNull(name, "name", new Object[0]);
        Validate.notNull(backgroundInitializer, "backgroundInitializer", new Object[0]);
        MultiBackgroundInitializer multiBackgroundInitializer = this;
        synchronized (multiBackgroundInitializer) {
            void var2_3;
            void var1_1;
            if (this.isStarted()) {
                throw new IllegalStateException("addInitializer() must not be called after start()!");
            }
            this.childInitializers.put((String)var1_1, (BackgroundInitializer<?>)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getTaskCount() {
        void var1_1;
        int result = 1;
        for (BackgroundInitializer<?> bi : this.childInitializers.values()) {
            void var3_3;
            result += var3_3.getTaskCount();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected MultiBackgroundInitializerResults initialize() throws Exception {
        void var1_2;
        HashMap inits;
        MultiBackgroundInitializer multiBackgroundInitializer = this;
        synchronized (multiBackgroundInitializer) {
            inits = new HashMap(this.childInitializers);
        }
        ExecutorService exec = this.getActiveExecutor();
        Iterator iterator = inits.values().iterator();
        while (iterator.hasNext()) {
            BackgroundInitializer bi = (BackgroundInitializer)iterator.next();
            if (bi.getExternalExecutor() == null) {
                bi.setExternalExecutor(exec);
            }
            bi.start();
        }
        HashMap results = new HashMap();
        HashMap excepts = new HashMap();
        for (Map.Entry entry : inits.entrySet()) {
            try {
                results.put(entry.getKey(), ((BackgroundInitializer)entry.getValue()).get());
            }
            catch (ConcurrentException cex) {
                excepts.put(entry.getKey(), cex);
            }
        }
        return new MultiBackgroundInitializerResults((Map)var1_2, (Map)((Object)iterator), excepts);
    }

    public static class MultiBackgroundInitializerResults {
        private final Map<String, BackgroundInitializer<?>> initializers;
        private final Map<String, Object> resultObjects;
        private final Map<String, ConcurrentException> exceptions;

        /*
         * WARNING - void declaration
         */
        private MultiBackgroundInitializerResults(Map<String, BackgroundInitializer<?>> inits, Map<String, Object> results, Map<String, ConcurrentException> excepts) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.initializers = var1_1;
            this.resultObjects = var2_2;
            this.exceptions = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public BackgroundInitializer<?> getInitializer(String name) {
            void var1_1;
            return this.checkName((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Object getResultObject(String name) {
            void var1_1;
            this.checkName(name);
            return this.resultObjects.get(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public boolean isException(String name) {
            void var1_1;
            this.checkName(name);
            return this.exceptions.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public ConcurrentException getException(String name) {
            void var1_1;
            this.checkName(name);
            return this.exceptions.get(var1_1);
        }

        public Set<String> initializerNames() {
            return Collections.unmodifiableSet(this.initializers.keySet());
        }

        public boolean isSuccessful() {
            return this.exceptions.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        private BackgroundInitializer<?> checkName(String name) {
            void var2_2;
            BackgroundInitializer<?> init = this.initializers.get(name);
            if (init == null) {
                void var1_1;
                throw new NoSuchElementException("No child initializer with name " + (String)var1_1);
            }
            return var2_2;
        }
    }
}

