/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.commons.lang3.concurrent.Computable;

public class Memoizer<I, O>
implements Computable<I, O> {
    private final ConcurrentMap<I, Future<O>> cache = new ConcurrentHashMap<I, Future<O>>();
    private final Computable<I, O> computable;
    private final boolean recalculate;

    /*
     * WARNING - void declaration
     */
    public Memoizer(Computable<I, O> computable) {
        this((Computable<I, O>)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Memoizer(Computable<I, O> computable, boolean recalculate) {
        void var2_2;
        void var1_1;
        this.computable = var1_1;
        this.recalculate = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public O compute(I arg) throws InterruptedException {
        while (true) {
            Callable<Object> eval;
            FutureTask<Object> futureTask;
            FutureTask<Object> future;
            if ((future = (FutureTask<Object>)this.cache.get(arg)) == null && (future = (Future)this.cache.putIfAbsent(arg, futureTask = new FutureTask<Object>(eval = () -> {
                void var1_1;
                return this.computable.compute(var1_1);
            }))) == null) {
                future = futureTask;
                futureTask.run();
            }
            try {
                return (O)future.get();
            }
            catch (CancellationException cancellationException) {
                this.cache.remove(arg, future);
                continue;
            }
            catch (ExecutionException e) {
                void var3_4;
                if (this.recalculate) {
                    void var2_2;
                    void var1_1;
                    this.cache.remove(var1_1, var2_2);
                }
                throw this.launderException(var3_4.getCause());
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    private RuntimeException launderException(Throwable throwable) {
        void var1_1;
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new IllegalStateException("Unchecked exception", (Throwable)var1_1);
    }
}

