/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.concurrent.AbstractCircuitBreaker;

public class EventCountCircuitBreaker
extends AbstractCircuitBreaker<Integer> {
    private static final Map<AbstractCircuitBreaker.State, StateStrategy> STRATEGY_MAP = EventCountCircuitBreaker.createStrategyMap();
    private final AtomicReference<CheckIntervalData> checkIntervalData = new AtomicReference<CheckIntervalData>(new CheckIntervalData(0, 0L));
    private final int openingThreshold;
    private final long openingInterval;
    private final int closingThreshold;
    private final long closingInterval;

    /*
     * WARNING - void declaration
     */
    public EventCountCircuitBreaker(int openingThreshold, long openingInterval, TimeUnit openingUnit, int closingThreshold, long closingInterval, TimeUnit closingUnit) {
        void var2_2;
        void var1_1;
        this.openingThreshold = var1_1;
        this.openingInterval = openingUnit.toNanos((long)var2_2);
        this.closingThreshold = closingThreshold;
        this.closingInterval = closingUnit.toNanos(closingInterval);
    }

    /*
     * WARNING - void declaration
     */
    public EventCountCircuitBreaker(int openingThreshold, long checkInterval, TimeUnit checkUnit, int closingThreshold) {
        this((int)var1_1, checkInterval, checkUnit, closingThreshold, (long)var2_2, checkUnit);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EventCountCircuitBreaker(int threshold, long checkInterval, TimeUnit checkUnit) {
        this(threshold, (long)var2_2, checkUnit, (int)var1_1);
        void var1_1;
        void var2_2;
    }

    public int getOpeningThreshold() {
        return this.openingThreshold;
    }

    public long getOpeningInterval() {
        return this.openingInterval;
    }

    public int getClosingThreshold() {
        return this.closingThreshold;
    }

    public long getClosingInterval() {
        return this.closingInterval;
    }

    @Override
    public boolean checkState() {
        return this.performStateCheck(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean incrementAndCheckState(Integer increment) {
        void var1_1;
        return this.performStateCheck(var1_1.intValue());
    }

    public boolean incrementAndCheckState() {
        return this.incrementAndCheckState(1);
    }

    @Override
    public void open() {
        super.open();
        this.checkIntervalData.set(new CheckIntervalData(0, this.nanoTime()));
    }

    @Override
    public void close() {
        super.close();
        this.checkIntervalData.set(new CheckIntervalData(0, this.nanoTime()));
    }

    /*
     * WARNING - void declaration
     */
    private boolean performStateCheck(int increment) {
        void var3_3;
        void var2_2;
        long time;
        AbstractCircuitBreaker.State currentState;
        CheckIntervalData nextData;
        CheckIntervalData currentData;
        do {
            time = this.nanoTime();
            currentState = this.state.get();
        } while (!this.updateCheckIntervalData(currentData = this.checkIntervalData.get(), nextData = this.nextCheckIntervalData(increment, currentData, currentState, time)));
        if (EventCountCircuitBreaker.stateStrategy(currentState).isStateTransition(this, (CheckIntervalData)var2_2, (CheckIntervalData)var3_3)) {
            currentState = currentState.oppositeState();
            this.changeStateAndStartNewCheckInterval(currentState);
        }
        return !EventCountCircuitBreaker.isOpen(currentState);
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateCheckIntervalData(CheckIntervalData currentData, CheckIntervalData nextData) {
        void var2_2;
        void var1_1;
        return currentData == nextData || this.checkIntervalData.compareAndSet((CheckIntervalData)var1_1, (CheckIntervalData)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void changeStateAndStartNewCheckInterval(AbstractCircuitBreaker.State newState) {
        void var1_1;
        this.changeState((AbstractCircuitBreaker.State)var1_1);
        this.checkIntervalData.set(new CheckIntervalData(0, this.nanoTime()));
    }

    /*
     * WARNING - void declaration
     */
    private CheckIntervalData nextCheckIntervalData(int increment, CheckIntervalData currentData, AbstractCircuitBreaker.State currentState, long time) {
        void var1_2;
        void nextData;
        void var2_3;
        CheckIntervalData nextData2 = EventCountCircuitBreaker.stateStrategy(currentState).isCheckIntervalFinished(this, currentData, time) ? new CheckIntervalData(increment, time) : var2_3.increment((int)nextData);
        return var1_2;
    }

    long nanoTime() {
        return System.nanoTime();
    }

    private static StateStrategy stateStrategy(AbstractCircuitBreaker.State state) {
        AbstractCircuitBreaker.State state2;
        return STRATEGY_MAP.get((Object)state2);
    }

    /*
     * WARNING - void declaration
     */
    private static Map<AbstractCircuitBreaker.State, StateStrategy> createStrategyMap() {
        void var0;
        EnumMap<AbstractCircuitBreaker.State, StateStrategy> map = new EnumMap<AbstractCircuitBreaker.State, StateStrategy>(AbstractCircuitBreaker.State.class);
        map.put(AbstractCircuitBreaker.State.CLOSED, new StateStrategyClosed());
        map.put(AbstractCircuitBreaker.State.OPEN, new StateStrategyOpen());
        return var0;
    }

    private static class StateStrategyOpen
    extends StateStrategy {
        private StateStrategyOpen() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean isStateTransition(EventCountCircuitBreaker breaker, CheckIntervalData currentData, CheckIntervalData nextData) {
            void var1_1;
            void var2_2;
            return nextData.getCheckIntervalStart() != currentData.getCheckIntervalStart() && var2_2.getEventCount() < var1_1.getClosingThreshold();
        }

        @Override
        protected long fetchCheckInterval(EventCountCircuitBreaker breaker) {
            return breaker.getClosingInterval();
        }
    }

    private static class StateStrategyClosed
    extends StateStrategy {
        private StateStrategyClosed() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean isStateTransition(EventCountCircuitBreaker breaker, CheckIntervalData currentData, CheckIntervalData nextData) {
            void var1_1;
            return nextData.getEventCount() > var1_1.getOpeningThreshold();
        }

        @Override
        protected long fetchCheckInterval(EventCountCircuitBreaker breaker) {
            return breaker.getOpeningInterval();
        }
    }

    private static abstract class StateStrategy {
        private StateStrategy() {
        }

        /*
         * WARNING - void declaration
         */
        public boolean isCheckIntervalFinished(EventCountCircuitBreaker breaker, CheckIntervalData currentData, long now) {
            void var1_1;
            void var2_2;
            return now - var2_2.getCheckIntervalStart() > this.fetchCheckInterval((EventCountCircuitBreaker)var1_1);
        }

        public abstract boolean isStateTransition(EventCountCircuitBreaker var1, CheckIntervalData var2, CheckIntervalData var3);

        protected abstract long fetchCheckInterval(EventCountCircuitBreaker var1);
    }

    private static class CheckIntervalData {
        private final int eventCount;
        private final long checkIntervalStart;

        /*
         * WARNING - void declaration
         */
        CheckIntervalData(int count, long intervalStart) {
            void var2_2;
            void var1_1;
            this.eventCount = var1_1;
            this.checkIntervalStart = var2_2;
        }

        public int getEventCount() {
            return this.eventCount;
        }

        public long getCheckIntervalStart() {
            return this.checkIntervalStart;
        }

        /*
         * WARNING - void declaration
         */
        public CheckIntervalData increment(int delta) {
            void var1_1;
            if (delta == 0) {
                return this;
            }
            return new CheckIntervalData(this.getEventCount() + var1_1, this.getCheckIntervalStart());
        }
    }
}

