/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.Validate;

public class BasicThreadFactory
implements ThreadFactory {
    private final AtomicLong threadCounter;
    private final ThreadFactory wrappedFactory;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final String namingPattern;
    private final Integer priority;
    private final Boolean daemon;

    /*
     * WARNING - void declaration
     */
    private BasicThreadFactory(Builder builder) {
        void var1_1;
        this.wrappedFactory = builder.wrappedFactory == null ? Executors.defaultThreadFactory() : builder.wrappedFactory;
        this.namingPattern = builder.namingPattern;
        this.priority = builder.priority;
        this.daemon = builder.daemon;
        this.uncaughtExceptionHandler = ((Builder)var1_1).exceptionHandler;
        this.threadCounter = new AtomicLong();
    }

    public final ThreadFactory getWrappedFactory() {
        return this.wrappedFactory;
    }

    public final String getNamingPattern() {
        return this.namingPattern;
    }

    public final Boolean getDaemonFlag() {
        return this.daemon;
    }

    public final Integer getPriority() {
        return this.priority;
    }

    public final Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public long getThreadCount() {
        return this.threadCounter.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Thread newThread(Runnable runnable) {
        void var1_1;
        Thread thread = this.getWrappedFactory().newThread(runnable);
        this.initializeThread(thread);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void initializeThread(Thread thread) {
        if (this.getNamingPattern() != null) {
            void var2_2;
            Long count = this.threadCounter.incrementAndGet();
            thread.setName(String.format(this.getNamingPattern(), var2_2));
        }
        if (this.getUncaughtExceptionHandler() != null) {
            thread.setUncaughtExceptionHandler(this.getUncaughtExceptionHandler());
        }
        if (this.getPriority() != null) {
            thread.setPriority(this.getPriority());
        }
        if (this.getDaemonFlag() != null) {
            void var1_1;
            var1_1.setDaemon(this.getDaemonFlag());
        }
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<BasicThreadFactory> {
        private ThreadFactory wrappedFactory;
        private Thread.UncaughtExceptionHandler exceptionHandler;
        private String namingPattern;
        private Integer priority;
        private Boolean daemon;

        /*
         * WARNING - void declaration
         */
        public Builder wrappedFactory(ThreadFactory factory) {
            void var1_1;
            Validate.notNull(factory, "factory", new Object[0]);
            this.wrappedFactory = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder namingPattern(String pattern) {
            void var1_1;
            Validate.notNull(pattern, "pattern", new Object[0]);
            this.namingPattern = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder daemon(boolean daemon) {
            void var1_1;
            this.daemon = (boolean)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder priority(int priority) {
            void var1_1;
            this.priority = (int)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder uncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler) {
            void var1_1;
            Validate.notNull(handler, "handler", new Object[0]);
            this.exceptionHandler = var1_1;
            return this;
        }

        public void reset() {
            this.wrappedFactory = null;
            this.exceptionHandler = null;
            this.namingPattern = null;
            this.priority = null;
            this.daemon = null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public BasicThreadFactory build() {
            void var1_1;
            BasicThreadFactory factory = new BasicThreadFactory(this);
            this.reset();
            return var1_1;
        }
    }
}

