/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;

public abstract class BackgroundInitializer<T>
implements ConcurrentInitializer<T> {
    private ExecutorService externalExecutor;
    private ExecutorService executor;
    private Future<T> future;

    protected BackgroundInitializer() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    protected BackgroundInitializer(ExecutorService exec) {
        void var1_1;
        this.setExternalExecutor((ExecutorService)var1_1);
    }

    public final synchronized ExecutorService getExternalExecutor() {
        return this.externalExecutor;
    }

    public synchronized boolean isStarted() {
        return this.future != null;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void setExternalExecutor(ExecutorService externalExecutor) {
        void var1_1;
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot set ExecutorService after start()!");
        }
        this.externalExecutor = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean start() {
        if (!this.isStarted()) {
            void var1_1;
            ExecutorService tempExec;
            this.executor = this.getExternalExecutor();
            if (this.executor == null) {
                this.executor = tempExec = this.createExecutor();
            } else {
                tempExec = null;
            }
            this.future = this.executor.submit(this.createTask((ExecutorService)var1_1));
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T get() throws ConcurrentException {
        try {
            return this.getFuture().get();
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            ConcurrentUtils.handleCause(executionException);
            return null;
        }
        catch (InterruptedException iex) {
            void var1_2;
            Thread.currentThread().interrupt();
            throw new ConcurrentException((Throwable)var1_2);
        }
    }

    public synchronized Future<T> getFuture() {
        if (this.future == null) {
            throw new IllegalStateException("start() must be called first!");
        }
        return this.future;
    }

    protected final synchronized ExecutorService getActiveExecutor() {
        return this.executor;
    }

    protected int getTaskCount() {
        return 1;
    }

    protected abstract T initialize() throws Exception;

    /*
     * WARNING - void declaration
     */
    private Callable<T> createTask(ExecutorService execDestroy) {
        void var1_1;
        return new InitializationTask((ExecutorService)var1_1);
    }

    private ExecutorService createExecutor() {
        return Executors.newFixedThreadPool(this.getTaskCount());
    }

    private class InitializationTask
    implements Callable<T> {
        private final ExecutorService execFinally;

        /*
         * WARNING - void declaration
         */
        InitializationTask(ExecutorService exec) {
            void var2_2;
            this.execFinally = var2_2;
        }

        @Override
        public T call() throws Exception {
            try {
                Object t = BackgroundInitializer.this.initialize();
                return t;
            }
            finally {
                if (this.execFinally != null) {
                    this.execFinally.shutdown();
                }
            }
        }
    }
}

