/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ToStringStyle
implements Serializable {
    private static final long serialVersionUID = -2587890625525655916L;
    public static final ToStringStyle DEFAULT_STYLE = new DefaultToStringStyle();
    public static final ToStringStyle MULTI_LINE_STYLE = new MultiLineToStringStyle();
    public static final ToStringStyle NO_FIELD_NAMES_STYLE = new NoFieldNameToStringStyle();
    public static final ToStringStyle SHORT_PREFIX_STYLE = new ShortPrefixToStringStyle();
    public static final ToStringStyle SIMPLE_STYLE = new SimpleToStringStyle();
    public static final ToStringStyle NO_CLASS_NAME_STYLE = new NoClassNameToStringStyle();
    public static final ToStringStyle JSON_STYLE = new JsonToStringStyle();
    private static final ThreadLocal<WeakHashMap<Object, Object>> REGISTRY = new ThreadLocal();
    private boolean useFieldNames = true;
    private boolean useClassName = true;
    private boolean useShortClassName;
    private boolean useIdentityHashCode = true;
    private String contentStart = "[";
    private String contentEnd = "]";
    private String fieldNameValueSeparator = "=";
    private boolean fieldSeparatorAtStart;
    private boolean fieldSeparatorAtEnd;
    private String fieldSeparator = ",";
    private String arrayStart = "{";
    private String arraySeparator = ",";
    private boolean arrayContentDetail = true;
    private String arrayEnd = "}";
    private boolean defaultFullDetail = true;
    private String nullText = "<null>";
    private String sizeStartText = "<size=";
    private String sizeEndText = ">";
    private String summaryObjectStartText = "<";
    private String summaryObjectEndText = ">";

    static Map<Object, Object> getRegistry() {
        return REGISTRY.get();
    }

    /*
     * WARNING - void declaration
     */
    static boolean isRegistered(Object value) {
        Object object;
        void var1_1;
        Map<Object, Object> m = ToStringStyle.getRegistry();
        return m != null && var1_1.containsKey(object);
    }

    static void register(Object value) {
        if (value != null) {
            Object object;
            Map<Object, Object> map = ToStringStyle.getRegistry();
            if (map == null) {
                REGISTRY.set(new WeakHashMap());
            }
            ToStringStyle.getRegistry().put(object, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void unregister(Object value) {
        Map<Object, Object> m;
        if (value != null && (m = ToStringStyle.getRegistry()) != null) {
            void var1_1;
            Object object;
            m.remove(object);
            if (var1_1.isEmpty()) {
                REGISTRY.remove();
            }
        }
    }

    protected ToStringStyle() {
    }

    /*
     * WARNING - void declaration
     */
    public void appendSuper(StringBuffer buffer, String superToString) {
        void var2_2;
        void var1_1;
        this.appendToString((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void appendToString(StringBuffer buffer, String toString) {
        int pos2;
        int pos1;
        if (toString != null && (pos1 = toString.indexOf(this.contentStart) + this.contentStart.length()) != (pos2 = toString.lastIndexOf(this.contentEnd)) && pos1 >= 0 && pos2 >= 0) {
            void var1_1;
            void var3_3;
            void var2_2;
            if (this.fieldSeparatorAtStart) {
                this.removeLastFieldSeparator(buffer);
            }
            buffer.append((CharSequence)var2_2, (int)var3_3, pos2);
            this.appendFieldSeparator((StringBuffer)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void appendStart(StringBuffer buffer, Object object) {
        if (object != null) {
            void var2_2;
            this.appendClassName(buffer, object);
            this.appendIdentityHashCode(buffer, var2_2);
            this.appendContentStart(buffer);
            if (this.fieldSeparatorAtStart) {
                void var1_1;
                this.appendFieldSeparator((StringBuffer)var1_1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void appendEnd(StringBuffer buffer, Object object) {
        void var2_2;
        void var1_1;
        if (!this.fieldSeparatorAtEnd) {
            this.removeLastFieldSeparator(buffer);
        }
        this.appendContentEnd((StringBuffer)var1_1);
        ToStringStyle.unregister(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void removeLastFieldSeparator(StringBuffer buffer) {
        if (StringUtils.endsWith(buffer, this.fieldSeparator)) {
            void var1_1;
            void v0 = var1_1;
            v0.setLength(v0.length() - this.fieldSeparator.length());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, Object value, Boolean fullDetail) {
        void var2_2;
        void var1_1;
        this.appendFieldStart(buffer, fieldName);
        if (value == null) {
            this.appendNullText(buffer, fieldName);
        } else {
            void var3_3;
            this.appendInternal(buffer, fieldName, var3_3, this.isFullDetail(fullDetail));
        }
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendInternal(StringBuffer buffer, String fieldName, Object value, boolean detail) {
        block37: {
            if (ToStringStyle.isRegistered(value) && !(value instanceof Number) && !(value instanceof Boolean) && !(value instanceof Character)) {
                this.appendCyclicObject(buffer, fieldName, value);
                return;
            }
            ToStringStyle.register(value);
            try {
                void var2_3;
                void var1_1;
                if (value instanceof Collection) {
                    if (detail) {
                        this.appendDetail(buffer, fieldName, (Collection)value);
                    } else {
                        this.appendSummarySize(buffer, fieldName, ((Collection)value).size());
                    }
                    break block37;
                }
                if (value instanceof Map) {
                    if (detail) {
                        this.appendDetail(buffer, fieldName, (Map)value);
                    } else {
                        this.appendSummarySize(buffer, fieldName, ((Map)value).size());
                    }
                    break block37;
                }
                if (value instanceof long[]) {
                    if (detail) {
                        this.appendDetail(buffer, fieldName, (long[])value);
                    } else {
                        this.appendSummary(buffer, fieldName, (long[])value);
                    }
                    break block37;
                }
                if (value instanceof int[]) {
                    if (detail) {
                        this.appendDetail(buffer, fieldName, (int[])value);
                    } else {
                        this.appendSummary(buffer, fieldName, (int[])value);
                    }
                    break block37;
                }
                if (value instanceof short[]) {
                    if (detail) {
                        this.appendDetail(buffer, fieldName, (short[])value);
                    } else {
                        this.appendSummary(buffer, fieldName, (short[])value);
                    }
                    break block37;
                }
                if (value instanceof byte[]) {
                    if (detail) {
                        this.appendDetail(buffer, fieldName, (byte[])value);
                    } else {
                        this.appendSummary(buffer, fieldName, (byte[])value);
                    }
                    break block37;
                }
                if (value instanceof char[]) {
                    if (detail) {
                        this.appendDetail(buffer, fieldName, (char[])value);
                    } else {
                        this.appendSummary(buffer, fieldName, (char[])value);
                    }
                    break block37;
                }
                if (value instanceof double[]) {
                    if (detail) {
                        this.appendDetail(buffer, fieldName, (double[])value);
                    } else {
                        this.appendSummary(buffer, fieldName, (double[])value);
                    }
                    break block37;
                }
                if (value instanceof float[]) {
                    if (detail) {
                        this.appendDetail(buffer, fieldName, (float[])value);
                    } else {
                        this.appendSummary(buffer, fieldName, (float[])value);
                    }
                    break block37;
                }
                if (value instanceof boolean[]) {
                    if (detail) {
                        this.appendDetail(buffer, fieldName, (boolean[])value);
                    } else {
                        this.appendSummary(buffer, fieldName, (boolean[])value);
                    }
                    break block37;
                }
                if (value.getClass().isArray()) {
                    if (detail) {
                        this.appendDetail(buffer, fieldName, (Object[])value);
                    } else {
                        this.appendSummary(buffer, fieldName, (Object[])value);
                    }
                    break block37;
                }
                if (detail) {
                    this.appendDetail(buffer, fieldName, value);
                    break block37;
                }
                this.appendSummary((StringBuffer)var1_1, (String)var2_3, value);
            }
            catch (Throwable throwable) {
                void var3_4;
                ToStringStyle.unregister(var3_4);
                throw throwable;
            }
        }
        ToStringStyle.unregister(value);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendCyclicObject(StringBuffer buffer, String fieldName, Object value) {
        void var3_3;
        ObjectUtils.identityToString(buffer, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, Object value) {
        void var3_3;
        buffer.append(var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, Collection<?> coll) {
        void var3_3;
        buffer.append(var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, Map<?, ?> map) {
        void var3_3;
        buffer.append(var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendSummary(StringBuffer buffer, String fieldName, Object value) {
        void var1_1;
        void var3_3;
        buffer.append(this.summaryObjectStartText);
        buffer.append(this.getShortClassName(var3_3.getClass()));
        var1_1.append(this.summaryObjectEndText);
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, long value) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.appendFieldStart(buffer, fieldName);
        this.appendDetail(buffer, fieldName, (long)var3_3);
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, long value) {
        void var3_3;
        buffer.append((long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, int value) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.appendFieldStart(buffer, fieldName);
        this.appendDetail(buffer, fieldName, (int)var3_3);
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, int value) {
        void var3_3;
        buffer.append((int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, short value) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.appendFieldStart(buffer, fieldName);
        this.appendDetail(buffer, fieldName, (short)var3_3);
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, short value) {
        void var3_3;
        buffer.append((int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, byte value) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.appendFieldStart(buffer, fieldName);
        this.appendDetail(buffer, fieldName, (byte)var3_3);
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, byte value) {
        void var3_3;
        buffer.append((int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, char value) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.appendFieldStart(buffer, fieldName);
        this.appendDetail(buffer, fieldName, (char)var3_3);
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, char value) {
        void var3_3;
        buffer.append((char)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, double value) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.appendFieldStart(buffer, fieldName);
        this.appendDetail(buffer, fieldName, (double)var3_3);
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, double value) {
        void var3_3;
        buffer.append((double)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, float value) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.appendFieldStart(buffer, fieldName);
        this.appendDetail(buffer, fieldName, (float)var3_3);
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, float value) {
        void var3_3;
        buffer.append((float)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, boolean value) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.appendFieldStart(buffer, fieldName);
        this.appendDetail(buffer, fieldName, (boolean)var3_3);
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, boolean value) {
        void var3_3;
        buffer.append((boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, Object[] array, Boolean fullDetail) {
        void var2_2;
        void var1_1;
        this.appendFieldStart(buffer, fieldName);
        if (array == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array);
        } else {
            void var3_3;
            this.appendSummary(buffer, fieldName, (Object[])var3_3);
        }
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, Object[] array) {
        void var1_1;
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            Object item = array[i];
            this.appendDetail(buffer, fieldName, i, item);
        }
        var1_1.append(this.arrayEnd);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, int i, Object item) {
        void var2_2;
        void var1_1;
        if (i > 0) {
            buffer.append(this.arraySeparator);
        }
        if (item == null) {
            this.appendNullText(buffer, fieldName);
            return;
        }
        this.appendInternal((StringBuffer)var1_1, (String)var2_2, item, this.arrayContentDetail);
    }

    /*
     * WARNING - void declaration
     */
    protected void reflectionAppendArrayDetail(StringBuffer buffer, String fieldName, Object array) {
        void var1_1;
        buffer.append(this.arrayStart);
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(array, i);
            this.appendDetail(buffer, fieldName, i, item);
        }
        var1_1.append(this.arrayEnd);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendSummary(StringBuffer buffer, String fieldName, Object[] array) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.appendSummarySize((StringBuffer)var1_1, (String)var2_2, ((void)var3_3).length);
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, long[] array, Boolean fullDetail) {
        void var2_2;
        void var1_1;
        this.appendFieldStart(buffer, fieldName);
        if (array == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array);
        } else {
            void var3_3;
            this.appendSummary(buffer, fieldName, (long[])var3_3);
        }
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, long[] array) {
        void var1_1;
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array[i]);
        }
        var1_1.append(this.arrayEnd);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendSummary(StringBuffer buffer, String fieldName, long[] array) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.appendSummarySize((StringBuffer)var1_1, (String)var2_2, ((void)var3_3).length);
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, int[] array, Boolean fullDetail) {
        void var2_2;
        void var1_1;
        this.appendFieldStart(buffer, fieldName);
        if (array == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array);
        } else {
            void var3_3;
            this.appendSummary(buffer, fieldName, (int[])var3_3);
        }
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, int[] array) {
        void var1_1;
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array[i]);
        }
        var1_1.append(this.arrayEnd);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendSummary(StringBuffer buffer, String fieldName, int[] array) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.appendSummarySize((StringBuffer)var1_1, (String)var2_2, ((void)var3_3).length);
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, short[] array, Boolean fullDetail) {
        void var2_2;
        void var1_1;
        this.appendFieldStart(buffer, fieldName);
        if (array == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array);
        } else {
            void var3_3;
            this.appendSummary(buffer, fieldName, (short[])var3_3);
        }
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, short[] array) {
        void var1_1;
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array[i]);
        }
        var1_1.append(this.arrayEnd);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendSummary(StringBuffer buffer, String fieldName, short[] array) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.appendSummarySize((StringBuffer)var1_1, (String)var2_2, ((void)var3_3).length);
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, byte[] array, Boolean fullDetail) {
        void var2_2;
        void var1_1;
        this.appendFieldStart(buffer, fieldName);
        if (array == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array);
        } else {
            void var3_3;
            this.appendSummary(buffer, fieldName, (byte[])var3_3);
        }
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, byte[] array) {
        void var1_1;
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array[i]);
        }
        var1_1.append(this.arrayEnd);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendSummary(StringBuffer buffer, String fieldName, byte[] array) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.appendSummarySize((StringBuffer)var1_1, (String)var2_2, ((void)var3_3).length);
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, char[] array, Boolean fullDetail) {
        void var2_2;
        void var1_1;
        this.appendFieldStart(buffer, fieldName);
        if (array == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array);
        } else {
            void var3_3;
            this.appendSummary(buffer, fieldName, (char[])var3_3);
        }
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, char[] array) {
        void var1_1;
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array[i]);
        }
        var1_1.append(this.arrayEnd);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendSummary(StringBuffer buffer, String fieldName, char[] array) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.appendSummarySize((StringBuffer)var1_1, (String)var2_2, ((void)var3_3).length);
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, double[] array, Boolean fullDetail) {
        void var2_2;
        void var1_1;
        this.appendFieldStart(buffer, fieldName);
        if (array == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array);
        } else {
            void var3_3;
            this.appendSummary(buffer, fieldName, (double[])var3_3);
        }
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, double[] array) {
        void var1_1;
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array[i]);
        }
        var1_1.append(this.arrayEnd);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendSummary(StringBuffer buffer, String fieldName, double[] array) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.appendSummarySize((StringBuffer)var1_1, (String)var2_2, ((void)var3_3).length);
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, float[] array, Boolean fullDetail) {
        void var2_2;
        void var1_1;
        this.appendFieldStart(buffer, fieldName);
        if (array == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array);
        } else {
            void var3_3;
            this.appendSummary(buffer, fieldName, (float[])var3_3);
        }
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, float[] array) {
        void var1_1;
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array[i]);
        }
        var1_1.append(this.arrayEnd);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendSummary(StringBuffer buffer, String fieldName, float[] array) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.appendSummarySize((StringBuffer)var1_1, (String)var2_2, ((void)var3_3).length);
    }

    /*
     * WARNING - void declaration
     */
    public void append(StringBuffer buffer, String fieldName, boolean[] array, Boolean fullDetail) {
        void var2_2;
        void var1_1;
        this.appendFieldStart(buffer, fieldName);
        if (array == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array);
        } else {
            void var3_3;
            this.appendSummary(buffer, fieldName, (boolean[])var3_3);
        }
        this.appendFieldEnd((StringBuffer)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDetail(StringBuffer buffer, String fieldName, boolean[] array) {
        void var1_1;
        buffer.append(this.arrayStart);
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array[i]);
        }
        var1_1.append(this.arrayEnd);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendSummary(StringBuffer buffer, String fieldName, boolean[] array) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.appendSummarySize((StringBuffer)var1_1, (String)var2_2, ((void)var3_3).length);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendClassName(StringBuffer buffer, Object object) {
        if (this.useClassName && object != null) {
            void var2_2;
            void var1_1;
            ToStringStyle.register(object);
            if (this.useShortClassName) {
                buffer.append(this.getShortClassName(object.getClass()));
                return;
            }
            var1_1.append(var2_2.getClass().getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void appendIdentityHashCode(StringBuffer buffer, Object object) {
        if (this.isUseIdentityHashCode() && object != null) {
            void var2_2;
            void var1_1;
            ToStringStyle.register(object);
            buffer.append('@');
            var1_1.append(Integer.toHexString(System.identityHashCode(var2_2)));
        }
    }

    protected void appendContentStart(StringBuffer buffer) {
        buffer.append(this.contentStart);
    }

    protected void appendContentEnd(StringBuffer buffer) {
        buffer.append(this.contentEnd);
    }

    protected void appendNullText(StringBuffer buffer, String fieldName) {
        buffer.append(this.nullText);
    }

    protected void appendFieldSeparator(StringBuffer buffer) {
        buffer.append(this.fieldSeparator);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendFieldStart(StringBuffer buffer, String fieldName) {
        if (this.useFieldNames && fieldName != null) {
            void var1_1;
            void var2_2;
            buffer.append((String)var2_2);
            var1_1.append(this.fieldNameValueSeparator);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void appendFieldEnd(StringBuffer buffer, String fieldName) {
        void var1_1;
        this.appendFieldSeparator((StringBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendSummarySize(StringBuffer buffer, String fieldName, int size) {
        void var1_1;
        void var3_3;
        buffer.append(this.sizeStartText);
        buffer.append((int)var3_3);
        var1_1.append(this.sizeEndText);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isFullDetail(Boolean fullDetailRequest) {
        void var1_1;
        if (fullDetailRequest == null) {
            return this.defaultFullDetail;
        }
        return var1_1.booleanValue();
    }

    protected String getShortClassName(Class<?> cls) {
        return ClassUtils.getShortClassName(cls);
    }

    protected boolean isUseClassName() {
        return this.useClassName;
    }

    /*
     * WARNING - void declaration
     */
    protected void setUseClassName(boolean useClassName) {
        void var1_1;
        this.useClassName = var1_1;
    }

    protected boolean isUseShortClassName() {
        return this.useShortClassName;
    }

    /*
     * WARNING - void declaration
     */
    protected void setUseShortClassName(boolean useShortClassName) {
        void var1_1;
        this.useShortClassName = var1_1;
    }

    protected boolean isUseIdentityHashCode() {
        return this.useIdentityHashCode;
    }

    /*
     * WARNING - void declaration
     */
    protected void setUseIdentityHashCode(boolean useIdentityHashCode) {
        void var1_1;
        this.useIdentityHashCode = var1_1;
    }

    protected boolean isUseFieldNames() {
        return this.useFieldNames;
    }

    /*
     * WARNING - void declaration
     */
    protected void setUseFieldNames(boolean useFieldNames) {
        void var1_1;
        this.useFieldNames = var1_1;
    }

    protected boolean isDefaultFullDetail() {
        return this.defaultFullDetail;
    }

    /*
     * WARNING - void declaration
     */
    protected void setDefaultFullDetail(boolean defaultFullDetail) {
        void var1_1;
        this.defaultFullDetail = var1_1;
    }

    protected boolean isArrayContentDetail() {
        return this.arrayContentDetail;
    }

    /*
     * WARNING - void declaration
     */
    protected void setArrayContentDetail(boolean arrayContentDetail) {
        void var1_1;
        this.arrayContentDetail = var1_1;
    }

    protected String getArrayStart() {
        return this.arrayStart;
    }

    /*
     * WARNING - void declaration
     */
    protected void setArrayStart(String arrayStart) {
        void var1_1;
        if (arrayStart == null) {
            arrayStart = "";
        }
        this.arrayStart = var1_1;
    }

    protected String getArrayEnd() {
        return this.arrayEnd;
    }

    /*
     * WARNING - void declaration
     */
    protected void setArrayEnd(String arrayEnd) {
        void var1_1;
        if (arrayEnd == null) {
            arrayEnd = "";
        }
        this.arrayEnd = var1_1;
    }

    protected String getArraySeparator() {
        return this.arraySeparator;
    }

    /*
     * WARNING - void declaration
     */
    protected void setArraySeparator(String arraySeparator) {
        void var1_1;
        if (arraySeparator == null) {
            arraySeparator = "";
        }
        this.arraySeparator = var1_1;
    }

    protected String getContentStart() {
        return this.contentStart;
    }

    /*
     * WARNING - void declaration
     */
    protected void setContentStart(String contentStart) {
        void var1_1;
        if (contentStart == null) {
            contentStart = "";
        }
        this.contentStart = var1_1;
    }

    protected String getContentEnd() {
        return this.contentEnd;
    }

    /*
     * WARNING - void declaration
     */
    protected void setContentEnd(String contentEnd) {
        void var1_1;
        if (contentEnd == null) {
            contentEnd = "";
        }
        this.contentEnd = var1_1;
    }

    protected String getFieldNameValueSeparator() {
        return this.fieldNameValueSeparator;
    }

    /*
     * WARNING - void declaration
     */
    protected void setFieldNameValueSeparator(String fieldNameValueSeparator) {
        void var1_1;
        if (fieldNameValueSeparator == null) {
            fieldNameValueSeparator = "";
        }
        this.fieldNameValueSeparator = var1_1;
    }

    protected String getFieldSeparator() {
        return this.fieldSeparator;
    }

    /*
     * WARNING - void declaration
     */
    protected void setFieldSeparator(String fieldSeparator) {
        void var1_1;
        if (fieldSeparator == null) {
            fieldSeparator = "";
        }
        this.fieldSeparator = var1_1;
    }

    protected boolean isFieldSeparatorAtStart() {
        return this.fieldSeparatorAtStart;
    }

    /*
     * WARNING - void declaration
     */
    protected void setFieldSeparatorAtStart(boolean fieldSeparatorAtStart) {
        void var1_1;
        this.fieldSeparatorAtStart = var1_1;
    }

    protected boolean isFieldSeparatorAtEnd() {
        return this.fieldSeparatorAtEnd;
    }

    /*
     * WARNING - void declaration
     */
    protected void setFieldSeparatorAtEnd(boolean fieldSeparatorAtEnd) {
        void var1_1;
        this.fieldSeparatorAtEnd = var1_1;
    }

    protected String getNullText() {
        return this.nullText;
    }

    /*
     * WARNING - void declaration
     */
    protected void setNullText(String nullText) {
        void var1_1;
        if (nullText == null) {
            nullText = "";
        }
        this.nullText = var1_1;
    }

    protected String getSizeStartText() {
        return this.sizeStartText;
    }

    /*
     * WARNING - void declaration
     */
    protected void setSizeStartText(String sizeStartText) {
        void var1_1;
        if (sizeStartText == null) {
            sizeStartText = "";
        }
        this.sizeStartText = var1_1;
    }

    protected String getSizeEndText() {
        return this.sizeEndText;
    }

    /*
     * WARNING - void declaration
     */
    protected void setSizeEndText(String sizeEndText) {
        void var1_1;
        if (sizeEndText == null) {
            sizeEndText = "";
        }
        this.sizeEndText = var1_1;
    }

    protected String getSummaryObjectStartText() {
        return this.summaryObjectStartText;
    }

    /*
     * WARNING - void declaration
     */
    protected void setSummaryObjectStartText(String summaryObjectStartText) {
        void var1_1;
        if (summaryObjectStartText == null) {
            summaryObjectStartText = "";
        }
        this.summaryObjectStartText = var1_1;
    }

    protected String getSummaryObjectEndText() {
        return this.summaryObjectEndText;
    }

    /*
     * WARNING - void declaration
     */
    protected void setSummaryObjectEndText(String summaryObjectEndText) {
        void var1_1;
        if (summaryObjectEndText == null) {
            summaryObjectEndText = "";
        }
        this.summaryObjectEndText = var1_1;
    }

    private static final class JsonToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_NAME_QUOTE = "\"";

        JsonToStringStyle() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
            this.setContentStart("{");
            this.setContentEnd("}");
            this.setArrayStart("[");
            this.setArrayEnd("]");
            this.setFieldSeparator(",");
            this.setFieldNameValueSeparator(":");
            this.setNullText("null");
            this.setSummaryObjectStartText("\"<");
            this.setSummaryObjectEndText(">\"");
            this.setSizeStartText("\"<size=");
            this.setSizeEndText(">\"");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void append(StringBuffer buffer, String fieldName, Object[] array, Boolean fullDetail) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append((StringBuffer)var1_1, (String)var2_2, (Object[])var3_3, fullDetail);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void append(StringBuffer buffer, String fieldName, long[] array, Boolean fullDetail) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append((StringBuffer)var1_1, (String)var2_2, (long[])var3_3, fullDetail);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void append(StringBuffer buffer, String fieldName, int[] array, Boolean fullDetail) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append((StringBuffer)var1_1, (String)var2_2, (int[])var3_3, fullDetail);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void append(StringBuffer buffer, String fieldName, short[] array, Boolean fullDetail) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append((StringBuffer)var1_1, (String)var2_2, (short[])var3_3, fullDetail);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void append(StringBuffer buffer, String fieldName, byte[] array, Boolean fullDetail) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append((StringBuffer)var1_1, (String)var2_2, (byte[])var3_3, fullDetail);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void append(StringBuffer buffer, String fieldName, char[] array, Boolean fullDetail) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append((StringBuffer)var1_1, (String)var2_2, (char[])var3_3, fullDetail);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void append(StringBuffer buffer, String fieldName, double[] array, Boolean fullDetail) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append((StringBuffer)var1_1, (String)var2_2, (double[])var3_3, fullDetail);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void append(StringBuffer buffer, String fieldName, float[] array, Boolean fullDetail) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append((StringBuffer)var1_1, (String)var2_2, (float[])var3_3, fullDetail);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void append(StringBuffer buffer, String fieldName, boolean[] array, Boolean fullDetail) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append((StringBuffer)var1_1, (String)var2_2, (boolean[])var3_3, fullDetail);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void append(StringBuffer buffer, String fieldName, Object value, Boolean fullDetail) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append((StringBuffer)var1_1, (String)var2_2, var3_3, fullDetail);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void appendDetail(StringBuffer buffer, String fieldName, char value) {
            void var3_3;
            void var1_1;
            this.appendValueAsString((StringBuffer)var1_1, String.valueOf((char)var3_3));
        }

        @Override
        protected final void appendDetail(StringBuffer buffer, String fieldName, Object value) {
            while (true) {
                if (value == null) {
                    this.appendNullText(buffer, fieldName);
                    return;
                }
                if (value instanceof String || value instanceof Character) {
                    this.appendValueAsString(buffer, value.toString());
                    return;
                }
                if (value instanceof Number || value instanceof Boolean) {
                    buffer.append(value);
                    return;
                }
                String valueAsString = value.toString();
                if (this.isJsonObject(valueAsString) || this.isJsonArray(valueAsString)) {
                    buffer.append(value);
                    return;
                }
                value = valueAsString;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void appendDetail(StringBuffer buffer, String fieldName, Collection<?> coll) {
            void var3_3;
            void var1_1;
            if (coll != null && !coll.isEmpty()) {
                buffer.append(this.getArrayStart());
                int i = 0;
                coll = coll.iterator();
                while (coll.hasNext()) {
                    Object item = coll.next();
                    this.appendDetail(buffer, fieldName, i++, item);
                }
                buffer.append(this.getArrayEnd());
                return;
            }
            var1_1.append(var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void appendDetail(StringBuffer buffer, String fieldName, Map<?, ?> map) {
            void var3_4;
            void var1_1;
            if (map != null && !map.isEmpty()) {
                buffer.append(this.getContentStart());
                boolean firstItem = true;
                for (Map.Entry entry : map.entrySet()) {
                    String keyStr = Objects.toString(entry.getKey(), null);
                    if (keyStr == null) continue;
                    if (firstItem) {
                        firstItem = false;
                    } else {
                        this.appendFieldEnd(buffer, keyStr);
                    }
                    this.appendFieldStart(buffer, keyStr);
                    Object v = entry.getValue();
                    if (v == null) {
                        this.appendNullText(buffer, keyStr);
                        continue;
                    }
                    this.appendInternal(buffer, keyStr, v, true);
                }
                buffer.append(this.getContentEnd());
                return;
            }
            var1_1.append(var3_4);
        }

        /*
         * WARNING - void declaration
         */
        private boolean isJsonArray(String valueAsString) {
            void var1_1;
            return valueAsString.startsWith(this.getArrayStart()) && var1_1.endsWith(this.getArrayEnd());
        }

        /*
         * WARNING - void declaration
         */
        private boolean isJsonObject(String valueAsString) {
            void var1_1;
            return valueAsString.startsWith(this.getContentStart()) && var1_1.endsWith(this.getContentEnd());
        }

        /*
         * WARNING - void declaration
         */
        private void appendValueAsString(StringBuffer buffer, String value) {
            void var2_2;
            buffer.append('\"').append(StringEscapeUtils.escapeJson((String)var2_2)).append('\"');
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void appendFieldStart(StringBuffer buffer, String fieldName) {
            void var2_2;
            void var1_1;
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            super.appendFieldStart((StringBuffer)var1_1, FIELD_NAME_QUOTE + StringEscapeUtils.escapeJson((String)var2_2) + FIELD_NAME_QUOTE);
        }

        private Object readResolve() {
            return JSON_STYLE;
        }
    }

    private static final class NoClassNameToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        NoClassNameToStringStyle() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
        }

        private Object readResolve() {
            return NO_CLASS_NAME_STYLE;
        }
    }

    private static final class MultiLineToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        MultiLineToStringStyle() {
            this.setContentStart("[");
            this.setFieldSeparator(System.lineSeparator() + "  ");
            this.setFieldSeparatorAtStart(true);
            this.setContentEnd(System.lineSeparator() + "]");
        }

        private Object readResolve() {
            return MULTI_LINE_STYLE;
        }
    }

    private static final class SimpleToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        SimpleToStringStyle() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
            this.setUseFieldNames(false);
            this.setContentStart("");
            this.setContentEnd("");
        }

        private Object readResolve() {
            return SIMPLE_STYLE;
        }
    }

    private static final class ShortPrefixToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        ShortPrefixToStringStyle() {
            this.setUseShortClassName(true);
            this.setUseIdentityHashCode(false);
        }

        private Object readResolve() {
            return SHORT_PREFIX_STYLE;
        }
    }

    private static final class NoFieldNameToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        NoFieldNameToStringStyle() {
            this.setUseFieldNames(false);
        }

        private Object readResolve() {
            return NO_FIELD_NAMES_STYLE;
        }
    }

    private static final class DefaultToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        DefaultToStringStyle() {
        }

        private Object readResolve() {
            return DEFAULT_STYLE;
        }
    }
}

