/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.lang3.ArraySorter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringExclude;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringSummary;

public class ReflectionToStringBuilder
extends ToStringBuilder {
    private boolean appendStatics;
    private boolean appendTransients;
    private boolean excludeNullValues;
    protected String[] excludeFieldNames;
    private Class<?> upToClass;

    public static String toString(Object object) {
        return ReflectionToStringBuilder.toString(object, null, false, false, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Object object, ToStringStyle style) {
        void var1_1;
        return ReflectionToStringBuilder.toString(object, (ToStringStyle)var1_1, false, false, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Object object, ToStringStyle style, boolean outputTransients) {
        void var2_2;
        void var1_1;
        return ReflectionToStringBuilder.toString(object, (ToStringStyle)var1_1, (boolean)var2_2, false, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Object object, ToStringStyle style, boolean outputTransients, boolean outputStatics) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ReflectionToStringBuilder.toString(object, (ToStringStyle)var1_1, (boolean)var2_2, (boolean)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> String toString(T object, ToStringStyle style, boolean outputTransients, boolean outputStatics, Class<? super T> reflectUpToClass) {
        void var3_3;
        void var2_2;
        void var1_1;
        T t;
        return ((ToStringBuilder)new ReflectionToStringBuilder(t, (ToStringStyle)var1_1, null, reflectUpToClass, (boolean)var2_2, (boolean)var3_3)).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> String toString(T object, ToStringStyle style, boolean outputTransients, boolean outputStatics, boolean excludeNullValues, Class<? super T> reflectUpToClass) {
        void var3_3;
        void var2_2;
        void var1_1;
        T t;
        return ((ToStringBuilder)new ReflectionToStringBuilder(t, (ToStringStyle)var1_1, null, reflectUpToClass, (boolean)var2_2, (boolean)var3_3, excludeNullValues)).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String toStringExclude(Object object, Collection<String> excludeFieldNames) {
        void var1_1;
        return ReflectionToStringBuilder.toStringExclude(object, ReflectionToStringBuilder.toNoNullStringArray((Collection<String>)var1_1));
    }

    static String[] toNoNullStringArray(Collection<String> collection) {
        Collection<String> collection2;
        if (collection == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return ReflectionToStringBuilder.toNoNullStringArray(collection2.toArray());
    }

    /*
     * WARNING - void declaration
     */
    static String[] toNoNullStringArray(Object[] array) {
        void var1_1;
        Object[] objectArray;
        ArrayList<String> list = new ArrayList<String>(array.length);
        for (Object e : objectArray) {
            if (e == null) continue;
            list.add(e.toString());
        }
        return var1_1.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    public static String toStringExclude(Object object, String ... excludeFieldNames) {
        void var1_1;
        Object object2;
        return ((ToStringBuilder)new ReflectionToStringBuilder(object2).setExcludeFieldNames((String[])var1_1)).toString();
    }

    private static Object checkNotNull(Object obj) {
        return Validate.notNull(obj, "obj", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public ReflectionToStringBuilder(Object object) {
        super(ReflectionToStringBuilder.checkNotNull(var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ReflectionToStringBuilder(Object object, ToStringStyle style) {
        super(ReflectionToStringBuilder.checkNotNull(var1_1), (ToStringStyle)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ReflectionToStringBuilder(Object object, ToStringStyle style, StringBuffer buffer) {
        super(ReflectionToStringBuilder.checkNotNull(var1_1), (ToStringStyle)var2_2, (StringBuffer)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public <T> ReflectionToStringBuilder(T object, ToStringStyle style, StringBuffer buffer, Class<? super T> reflectUpToClass, boolean outputTransients, boolean outputStatics) {
        super(ReflectionToStringBuilder.checkNotNull(var1_1), (ToStringStyle)var2_2, (StringBuffer)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.setUpToClass(reflectUpToClass);
        this.setAppendTransients(outputTransients);
        this.setAppendStatics(outputStatics);
    }

    /*
     * WARNING - void declaration
     */
    public <T> ReflectionToStringBuilder(T object, ToStringStyle style, StringBuffer buffer, Class<? super T> reflectUpToClass, boolean outputTransients, boolean outputStatics, boolean excludeNullValues) {
        super(ReflectionToStringBuilder.checkNotNull(var1_1), (ToStringStyle)var2_2, (StringBuffer)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.setUpToClass(reflectUpToClass);
        this.setAppendTransients(outputTransients);
        this.setAppendStatics(outputStatics);
        this.setExcludeNullValues(excludeNullValues);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean accept(Field field) {
        void var1_1;
        if (field.getName().indexOf(36) != -1) {
            return false;
        }
        if (Modifier.isTransient(field.getModifiers()) && !this.isAppendTransients()) {
            return false;
        }
        if (Modifier.isStatic(field.getModifiers()) && !this.isAppendStatics()) {
            return false;
        }
        if (this.excludeFieldNames != null && Arrays.binarySearch(this.excludeFieldNames, field.getName()) >= 0) {
            return false;
        }
        return !var1_1.isAnnotationPresent(ToStringExclude.class);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendFieldsIn(Class<?> clazz) {
        void var1_1;
        if (clazz.isArray()) {
            ReflectionToStringBuilder reflectionToStringBuilder = this;
            reflectionToStringBuilder.reflectionAppendArray(reflectionToStringBuilder.getObject());
            return;
        }
        AccessibleObject[] fields = ArraySorter.sort(clazz.getDeclaredFields(), Comparator.comparing(Field::getName));
        AccessibleObject.setAccessible(fields, true);
        for (void field : var1_1) {
            String fieldName = field.getName();
            if (!this.accept((Field)field)) continue;
            try {
                Object fieldValue = this.getValue((Field)field);
                if (this.excludeNullValues && fieldValue == null) continue;
                this.append(fieldName, fieldValue, !field.isAnnotationPresent(ToStringSummary.class));
            }
            catch (IllegalAccessException ex) {
                throw new InternalError("Unexpected IllegalAccessException: " + ex.getMessage());
            }
        }
    }

    public String[] getExcludeFieldNames() {
        return (String[])this.excludeFieldNames.clone();
    }

    public Class<?> getUpToClass() {
        return this.upToClass;
    }

    protected Object getValue(Field field) throws IllegalAccessException {
        return field.get(this.getObject());
    }

    public boolean isAppendStatics() {
        return this.appendStatics;
    }

    public boolean isAppendTransients() {
        return this.appendTransients;
    }

    public boolean isExcludeNullValues() {
        return this.excludeNullValues;
    }

    /*
     * WARNING - void declaration
     */
    public ReflectionToStringBuilder reflectionAppendArray(Object array) {
        void var1_1;
        this.getStyle().reflectionAppendArrayDetail(this.getStringBuffer(), null, var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void setAppendStatics(boolean appendStatics) {
        void var1_1;
        this.appendStatics = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setAppendTransients(boolean appendTransients) {
        void var1_1;
        this.appendTransients = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setExcludeNullValues(boolean excludeNullValues) {
        void var1_1;
        this.excludeNullValues = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ReflectionToStringBuilder setExcludeFieldNames(String ... excludeFieldNamesParam) {
        void var1_1;
        this.excludeFieldNames = excludeFieldNamesParam == null ? null : ArraySorter.sort(ReflectionToStringBuilder.toNoNullStringArray((Object[])var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void setUpToClass(Class<?> clazz) {
        void var1_1;
        void var2_2;
        Object object;
        if (clazz != null && (object = this.getObject()) != null && !clazz.isInstance(var2_2)) {
            throw new IllegalArgumentException("Specified class is not a superclass of the object");
        }
        this.upToClass = var1_1;
    }

    @Override
    public String toString() {
        Class<?> clazz;
        if (this.getObject() == null) {
            return this.getStyle().getNullText();
        }
        this.appendFieldsIn(clazz);
        for (clazz = this.getObject().getClass(); clazz.getSuperclass() != null && clazz != this.getUpToClass(); clazz = clazz.getSuperclass()) {
            this.appendFieldsIn(clazz);
        }
        return super.toString();
    }
}

