/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.builder.DiffBuilder;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.reflect.FieldUtils;

public class ReflectionDiffBuilder<T>
implements Builder<DiffResult<T>> {
    private final Object left;
    private final Object right;
    private final DiffBuilder<T> diffBuilder;

    /*
     * WARNING - void declaration
     */
    public ReflectionDiffBuilder(T lhs, T rhs, ToStringStyle style) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.left = lhs;
        this.right = rhs;
        this.diffBuilder = new DiffBuilder<void>(var1_1, var2_2, (ToStringStyle)var3_3);
    }

    @Override
    public DiffResult<T> build() {
        if (this.left.equals(this.right)) {
            return this.diffBuilder.build();
        }
        ReflectionDiffBuilder reflectionDiffBuilder = this;
        reflectionDiffBuilder.appendFields(reflectionDiffBuilder.left.getClass());
        return this.diffBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private void appendFields(Class<?> clazz) {
        for (Field field : FieldUtils.getAllFields(clazz)) {
            if (!this.accept(field)) continue;
            try {
                this.diffBuilder.append(field.getName(), FieldUtils.readField(field, this.left, true), FieldUtils.readField(field, this.right, true));
            }
            catch (IllegalAccessException ex) {
                void var1_2;
                throw new InternalError("Unexpected IllegalAccessException: " + var1_2.getMessage());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean accept(Field field) {
        void var1_1;
        if (field.getName().indexOf(36) != -1) {
            return false;
        }
        if (Modifier.isTransient(field.getModifiers())) {
            return false;
        }
        return !Modifier.isStatic(var1_1.getModifiers());
    }
}

