/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DiffBuilder<T>
implements Builder<DiffResult<T>> {
    private final List<Diff<?>> diffs;
    private final boolean objectsTriviallyEqual;
    private final T left;
    private final T right;
    private final ToStringStyle style;

    /*
     * WARNING - void declaration
     */
    public DiffBuilder(T lhs, T rhs, ToStringStyle style, boolean testTriviallyEqual) {
        void var2_2;
        void var1_1;
        void var3_3;
        Validate.notNull(lhs, "lhs", new Object[0]);
        Validate.notNull(rhs, "rhs", new Object[0]);
        this.diffs = new ArrayList();
        this.left = lhs;
        this.right = rhs;
        this.style = var3_3;
        this.objectsTriviallyEqual = testTriviallyEqual && (lhs == rhs || var1_1.equals(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder(T lhs, T rhs, ToStringStyle style) {
        this(var1_1, var2_2, (ToStringStyle)var3_3, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, boolean lhs, boolean rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.diffs.add(new Diff<Boolean>(this, (String)var1_1, (boolean)var2_2, (boolean)var3_3){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ boolean val$lhs;
                final /* synthetic */ boolean val$rhs;
                final /* synthetic */ DiffBuilder this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lhs = bl;
                    this.val$rhs = bl2;
                    super((String)var2_2);
                }

                @Override
                public Boolean getLeft() {
                    return this.val$lhs;
                }

                @Override
                public Boolean getRight() {
                    return this.val$rhs;
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, boolean[] lhs, boolean[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.diffs.add(new Diff<Boolean[]>(this, (String)var1_1, (boolean[])var2_2, (boolean[])var3_3){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ boolean[] val$lhs;
                final /* synthetic */ boolean[] val$rhs;
                final /* synthetic */ DiffBuilder this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lhs = blArray;
                    this.val$rhs = blArray2;
                    super((String)var2_2);
                }

                @Override
                public Boolean[] getLeft() {
                    return ArrayUtils.toObject(this.val$lhs);
                }

                @Override
                public Boolean[] getRight() {
                    return ArrayUtils.toObject(this.val$rhs);
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, byte lhs, byte rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.diffs.add(new Diff<Byte>(this, (String)var1_1, (byte)var2_2, (byte)var3_3){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ byte val$lhs;
                final /* synthetic */ byte val$rhs;
                final /* synthetic */ DiffBuilder this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lhs = by;
                    this.val$rhs = by2;
                    super((String)var2_2);
                }

                @Override
                public Byte getLeft() {
                    return this.val$lhs;
                }

                @Override
                public Byte getRight() {
                    return this.val$rhs;
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, byte[] lhs, byte[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.diffs.add(new Diff<Byte[]>(this, (String)var1_1, (byte[])var2_2, (byte[])var3_3){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ byte[] val$lhs;
                final /* synthetic */ byte[] val$rhs;
                final /* synthetic */ DiffBuilder this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lhs = byArray;
                    this.val$rhs = byArray2;
                    super((String)var2_2);
                }

                @Override
                public Byte[] getLeft() {
                    return ArrayUtils.toObject(this.val$lhs);
                }

                @Override
                public Byte[] getRight() {
                    return ArrayUtils.toObject(this.val$rhs);
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, char lhs, char rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.diffs.add(new Diff<Character>(this, (String)var1_1, (char)var2_2, (char)var3_3){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ char val$lhs;
                final /* synthetic */ char val$rhs;
                final /* synthetic */ DiffBuilder this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lhs = c;
                    this.val$rhs = c2;
                    super((String)var2_2);
                }

                @Override
                public Character getLeft() {
                    return Character.valueOf(this.val$lhs);
                }

                @Override
                public Character getRight() {
                    return Character.valueOf(this.val$rhs);
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, char[] lhs, char[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.diffs.add(new Diff<Character[]>(this, (String)var1_1, (char[])var2_2, (char[])var3_3){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ char[] val$lhs;
                final /* synthetic */ char[] val$rhs;
                final /* synthetic */ DiffBuilder this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lhs = cArray;
                    this.val$rhs = cArray2;
                    super((String)var2_2);
                }

                @Override
                public Character[] getLeft() {
                    return ArrayUtils.toObject(this.val$lhs);
                }

                @Override
                public Character[] getRight() {
                    return ArrayUtils.toObject(this.val$rhs);
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, double lhs, double rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (Double.doubleToLongBits(lhs) != Double.doubleToLongBits(rhs)) {
            void var2_2;
            void var1_1;
            this.diffs.add(new Diff<Double>(this, (String)var1_1, (double)var2_2, rhs){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ double val$lhs;
                final /* synthetic */ double val$rhs;
                final /* synthetic */ DiffBuilder this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lhs = d;
                    this.val$rhs = d2;
                    super((String)var2_2);
                }

                @Override
                public Double getLeft() {
                    return this.val$lhs;
                }

                @Override
                public Double getRight() {
                    return this.val$rhs;
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, double[] lhs, double[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.diffs.add(new Diff<Double[]>(this, (String)var1_1, (double[])var2_2, (double[])var3_3){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ double[] val$lhs;
                final /* synthetic */ double[] val$rhs;
                final /* synthetic */ DiffBuilder this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lhs = dArray;
                    this.val$rhs = dArray2;
                    super((String)var2_2);
                }

                @Override
                public Double[] getLeft() {
                    return ArrayUtils.toObject(this.val$lhs);
                }

                @Override
                public Double[] getRight() {
                    return ArrayUtils.toObject(this.val$rhs);
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, float lhs, float rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (Float.floatToIntBits(lhs) != Float.floatToIntBits(rhs)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.diffs.add(new Diff<Float>(this, (String)var1_1, (float)var2_2, (float)var3_3){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ float val$lhs;
                final /* synthetic */ float val$rhs;
                final /* synthetic */ DiffBuilder this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lhs = f;
                    this.val$rhs = f2;
                    super((String)var2_2);
                }

                @Override
                public Float getLeft() {
                    return Float.valueOf(this.val$lhs);
                }

                @Override
                public Float getRight() {
                    return Float.valueOf(this.val$rhs);
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, float[] lhs, float[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.diffs.add(new Diff<Float[]>(this, (String)var1_1, (float[])var2_2, (float[])var3_3){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ float[] val$lhs;
                final /* synthetic */ float[] val$rhs;
                final /* synthetic */ DiffBuilder this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lhs = fArray;
                    this.val$rhs = fArray2;
                    super((String)var2_2);
                }

                @Override
                public Float[] getLeft() {
                    return ArrayUtils.toObject(this.val$lhs);
                }

                @Override
                public Float[] getRight() {
                    return ArrayUtils.toObject(this.val$rhs);
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, int lhs, int rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.diffs.add(new Diff<Integer>(this, (String)var1_1, (int)var2_2, (int)var3_3){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ int val$lhs;
                final /* synthetic */ int val$rhs;
                final /* synthetic */ DiffBuilder this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lhs = n;
                    this.val$rhs = n2;
                    super((String)var2_2);
                }

                @Override
                public Integer getLeft() {
                    return this.val$lhs;
                }

                @Override
                public Integer getRight() {
                    return this.val$rhs;
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, int[] lhs, int[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.diffs.add(new Diff<Integer[]>(this, (String)var1_1, (int[])var2_2, (int[])var3_3){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ int[] val$lhs;
                final /* synthetic */ int[] val$rhs;
                final /* synthetic */ DiffBuilder this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lhs = nArray;
                    this.val$rhs = nArray2;
                    super((String)var2_2);
                }

                @Override
                public Integer[] getLeft() {
                    return ArrayUtils.toObject(this.val$lhs);
                }

                @Override
                public Integer[] getRight() {
                    return ArrayUtils.toObject(this.val$rhs);
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, long lhs, long rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            void var2_2;
            void var1_1;
            this.diffs.add(new Diff<Long>(this, (String)var1_1, (long)var2_2, rhs){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ long val$lhs;
                final /* synthetic */ long val$rhs;
                final /* synthetic */ DiffBuilder this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lhs = l;
                    this.val$rhs = l2;
                    super((String)var2_2);
                }

                @Override
                public Long getLeft() {
                    return this.val$lhs;
                }

                @Override
                public Long getRight() {
                    return this.val$rhs;
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, long[] lhs, long[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.diffs.add(new Diff<Long[]>(this, (String)var1_1, (long[])var2_2, (long[])var3_3){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ long[] val$lhs;
                final /* synthetic */ long[] val$rhs;
                final /* synthetic */ DiffBuilder this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lhs = lArray;
                    this.val$rhs = lArray2;
                    super((String)var2_2);
                }

                @Override
                public Long[] getLeft() {
                    return ArrayUtils.toObject(this.val$lhs);
                }

                @Override
                public Long[] getRight() {
                    return ArrayUtils.toObject(this.val$rhs);
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, short lhs, short rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.diffs.add(new Diff<Short>(this, (String)var1_1, (short)var2_2, (short)var3_3){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ short val$lhs;
                final /* synthetic */ short val$rhs;
                final /* synthetic */ DiffBuilder this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lhs = s;
                    this.val$rhs = s2;
                    super((String)var2_2);
                }

                @Override
                public Short getLeft() {
                    return this.val$lhs;
                }

                @Override
                public Short getRight() {
                    return this.val$rhs;
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, short[] lhs, short[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.diffs.add(new Diff<Short[]>(this, (String)var1_1, (short[])var2_2, (short[])var3_3){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ short[] val$lhs;
                final /* synthetic */ short[] val$rhs;
                final /* synthetic */ DiffBuilder this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lhs = sArray;
                    this.val$rhs = sArray2;
                    super((String)var2_2);
                }

                @Override
                public Short[] getLeft() {
                    return ArrayUtils.toObject(this.val$lhs);
                }

                @Override
                public Short[] getRight() {
                    return ArrayUtils.toObject(this.val$rhs);
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, Object lhs, Object rhs) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        Object objectToTest = lhs != null ? lhs : rhs;
        if (objectToTest.getClass().isArray()) {
            if (objectToTest instanceof boolean[]) {
                return this.append(fieldName, (boolean[])lhs, (boolean[])rhs);
            }
            if (objectToTest instanceof byte[]) {
                return this.append(fieldName, (byte[])lhs, (byte[])rhs);
            }
            if (objectToTest instanceof char[]) {
                return this.append(fieldName, (char[])lhs, (char[])rhs);
            }
            if (objectToTest instanceof double[]) {
                return this.append(fieldName, (double[])lhs, (double[])rhs);
            }
            if (objectToTest instanceof float[]) {
                return this.append(fieldName, (float[])lhs, (float[])rhs);
            }
            if (objectToTest instanceof int[]) {
                return this.append(fieldName, (int[])lhs, (int[])rhs);
            }
            if (objectToTest instanceof long[]) {
                return this.append(fieldName, (long[])lhs, (long[])rhs);
            }
            if (objectToTest instanceof short[]) {
                return this.append(fieldName, (short[])lhs, (short[])rhs);
            }
            return this.append(fieldName, (Object[])lhs, (Object[])rhs);
        }
        if (lhs != null && lhs.equals(rhs)) {
            return this;
        }
        this.diffs.add(new Diff<Object>(this, (String)var1_1, (Object)var2_2, (Object)var3_3){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ Object val$lhs;
            final /* synthetic */ Object val$rhs;
            final /* synthetic */ DiffBuilder this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.val$lhs = object;
                this.val$rhs = object2;
                super((String)var2_2);
            }

            @Override
            public Object getLeft() {
                return this.val$lhs;
            }

            @Override
            public Object getRight() {
                return this.val$rhs;
            }
        });
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, Object[] lhs, Object[] rhs) {
        this.validateFieldNameNotNull(fieldName);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.diffs.add(new Diff<Object[]>(this, (String)var1_1, (Object[])var2_2, (Object[])var3_3){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ Object[] val$lhs;
                final /* synthetic */ Object[] val$rhs;
                final /* synthetic */ DiffBuilder this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lhs = objectArray;
                    this.val$rhs = objectArray2;
                    super((String)var2_2);
                }

                @Override
                public Object[] getLeft() {
                    return this.val$lhs;
                }

                @Override
                public Object[] getRight() {
                    return this.val$rhs;
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DiffBuilder<T> append(String fieldName, DiffResult<T> diffResult) {
        Iterator<Diff<?>> iterator;
        this.validateFieldNameNotNull(fieldName);
        Validate.notNull(diffResult, "diffResult", new Object[0]);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        for (Diff<?> diff : ((DiffResult)((Object)iterator)).getDiffs()) {
            void var3_3;
            this.append(fieldName + "." + diff.getFieldName(), diff.getLeft(), var3_3.getRight());
        }
        return this;
    }

    @Override
    public DiffResult<T> build() {
        return new DiffResult<T>(this.left, this.right, this.diffs, this.style);
    }

    private void validateFieldNameNotNull(String fieldName) {
        Validate.notNull(fieldName, "fieldName", new Object[0]);
    }
}

