/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Validate {
    private static final String DEFAULT_NOT_NAN_EX_MESSAGE = "The validated value is not a number";
    private static final String DEFAULT_FINITE_EX_MESSAGE = "The value is invalid: %f";
    private static final String DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE = "The value %s is not in the specified exclusive range of %s to %s";
    private static final String DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE = "The value %s is not in the specified inclusive range of %s to %s";
    private static final String DEFAULT_MATCHES_PATTERN_EX = "The string %s does not match the pattern %s";
    private static final String DEFAULT_IS_NULL_EX_MESSAGE = "The validated object is null";
    private static final String DEFAULT_IS_TRUE_EX_MESSAGE = "The validated expression is false";
    private static final String DEFAULT_NO_NULL_ELEMENTS_ARRAY_EX_MESSAGE = "The validated array contains null element at index: %d";
    private static final String DEFAULT_NO_NULL_ELEMENTS_COLLECTION_EX_MESSAGE = "The validated collection contains null element at index: %d";
    private static final String DEFAULT_NOT_BLANK_EX_MESSAGE = "The validated character sequence is blank";
    private static final String DEFAULT_NOT_EMPTY_ARRAY_EX_MESSAGE = "The validated array is empty";
    private static final String DEFAULT_NOT_EMPTY_CHAR_SEQUENCE_EX_MESSAGE = "The validated character sequence is empty";
    private static final String DEFAULT_NOT_EMPTY_COLLECTION_EX_MESSAGE = "The validated collection is empty";
    private static final String DEFAULT_NOT_EMPTY_MAP_EX_MESSAGE = "The validated map is empty";
    private static final String DEFAULT_VALID_INDEX_ARRAY_EX_MESSAGE = "The validated array index is invalid: %d";
    private static final String DEFAULT_VALID_INDEX_CHAR_SEQUENCE_EX_MESSAGE = "The validated character sequence index is invalid: %d";
    private static final String DEFAULT_VALID_INDEX_COLLECTION_EX_MESSAGE = "The validated collection index is invalid: %d";
    private static final String DEFAULT_VALID_STATE_EX_MESSAGE = "The validated state is false";
    private static final String DEFAULT_IS_ASSIGNABLE_EX_MESSAGE = "Cannot assign a %s to a %s";
    private static final String DEFAULT_IS_INSTANCE_OF_EX_MESSAGE = "Expected type: %s, actual: %s";

    /*
     * WARNING - void declaration
     */
    public static void isTrue(boolean expression, String message, long value) {
        if (!expression) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(String.format((String)var1_1, (long)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void isTrue(boolean expression, String message, double value) {
        if (!expression) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(String.format((String)var1_1, (double)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void isTrue(boolean expression, String message, Object ... values) {
        if (!expression) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(String.format((String)var1_1, (Object[])var2_2));
        }
    }

    public static void isTrue(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException(DEFAULT_IS_TRUE_EX_MESSAGE);
        }
    }

    public static <T> T notNull(T object) {
        return Validate.notNull(object, DEFAULT_IS_NULL_EX_MESSAGE, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T notNull(T object, String message, Object ... values) {
        void var2_2;
        void var1_1;
        return Objects.requireNonNull(object, () -> Validate.lambda$notNull$0((String)var1_1, (Object[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] notEmpty(T[] array, String message, Object ... values) {
        T[] TArray;
        Objects.requireNonNull(array, () -> {
            void var1_1;
            return String.format(message, (Object[])var1_1);
        });
        if (array.length == 0) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(String.format((String)var1_1, (Object[])var2_2));
        }
        return TArray;
    }

    public static <T> T[] notEmpty(T[] array) {
        return Validate.notEmpty(array, DEFAULT_NOT_EMPTY_ARRAY_EX_MESSAGE, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<?>> T notEmpty(T collection, String message, Object ... values) {
        T t;
        Objects.requireNonNull(collection, () -> {
            void var1_1;
            return String.format(message, (Object[])var1_1);
        });
        if (collection.isEmpty()) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(String.format((String)var1_1, (Object[])var2_2));
        }
        return t;
    }

    public static <T extends Collection<?>> T notEmpty(T collection) {
        return Validate.notEmpty(collection, DEFAULT_NOT_EMPTY_COLLECTION_EX_MESSAGE, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Map<?, ?>> T notEmpty(T map, String message, Object ... values) {
        T t;
        Objects.requireNonNull(map, () -> {
            void var1_1;
            return String.format(message, (Object[])var1_1);
        });
        if (map.isEmpty()) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(String.format((String)var1_1, (Object[])var2_2));
        }
        return t;
    }

    public static <T extends Map<?, ?>> T notEmpty(T map) {
        return Validate.notEmpty(map, DEFAULT_NOT_EMPTY_MAP_EX_MESSAGE, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T notEmpty(T chars, String message, Object ... values) {
        T t;
        Objects.requireNonNull(chars, () -> {
            void var1_1;
            return String.format(message, (Object[])var1_1);
        });
        if (chars.length() == 0) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(String.format((String)var1_1, (Object[])var2_2));
        }
        return t;
    }

    public static <T extends CharSequence> T notEmpty(T chars) {
        return Validate.notEmpty(chars, DEFAULT_NOT_EMPTY_CHAR_SEQUENCE_EX_MESSAGE, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T notBlank(T chars, String message, Object ... values) {
        T t;
        Objects.requireNonNull(chars, () -> {
            void var1_1;
            return String.format(message, (Object[])var1_1);
        });
        if (StringUtils.isBlank(chars)) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(String.format((String)var1_1, (Object[])var2_2));
        }
        return t;
    }

    public static <T extends CharSequence> T notBlank(T chars) {
        return Validate.notBlank(chars, DEFAULT_NOT_BLANK_EX_MESSAGE, new Object[0]);
    }

    public static <T> T[] noNullElements(T[] array, String message, Object ... values) {
        Object[] objectArray;
        Validate.notNull(array);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            Object[] values2 = ArrayUtils.add(values, Integer.valueOf(i));
            throw new IllegalArgumentException(String.format(message, objectArray));
        }
        return objectArray;
    }

    public static <T> T[] noNullElements(T[] array) {
        return Validate.noNullElements(array, DEFAULT_NO_NULL_ELEMENTS_ARRAY_EX_MESSAGE, new Object[0]);
    }

    public static <T extends Iterable<?>> T noNullElements(T iterable, String message, Object ... values) {
        Object object;
        Validate.notNull(iterable);
        int i = 0;
        Iterator<?> it = iterable.iterator();
        while (it.hasNext()) {
            if (it.next() == null) {
                Object values2 = ArrayUtils.addAll(values, i);
                throw new IllegalArgumentException(String.format(message, object));
            }
            ++i;
        }
        return object;
    }

    public static <T extends Iterable<?>> T noNullElements(T iterable) {
        return Validate.noNullElements(iterable, DEFAULT_NO_NULL_ELEMENTS_COLLECTION_EX_MESSAGE, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] validIndex(T[] array, int index, String message, Object ... values) {
        T[] TArray;
        void var1_1;
        Validate.notNull(array);
        if (index < 0 || var1_1 >= array.length) {
            void var3_3;
            void var2_2;
            throw new IndexOutOfBoundsException(String.format((String)var2_2, (Object[])var3_3));
        }
        return TArray;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] validIndex(T[] array, int index) {
        void var1_1;
        return Validate.validIndex(array, index, DEFAULT_VALID_INDEX_ARRAY_EX_MESSAGE, new Object[]{(int)var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<?>> T validIndex(T collection, int index, String message, Object ... values) {
        T t;
        void var1_1;
        Validate.notNull(collection);
        if (index < 0 || var1_1 >= collection.size()) {
            void var3_3;
            void var2_2;
            throw new IndexOutOfBoundsException(String.format((String)var2_2, (Object[])var3_3));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<?>> T validIndex(T collection, int index) {
        void var1_1;
        return Validate.validIndex(collection, index, DEFAULT_VALID_INDEX_COLLECTION_EX_MESSAGE, new Object[]{(int)var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validIndex(T chars, int index, String message, Object ... values) {
        T t;
        void var1_1;
        Validate.notNull(chars);
        if (index < 0 || var1_1 >= chars.length()) {
            void var3_3;
            void var2_2;
            throw new IndexOutOfBoundsException(String.format((String)var2_2, (Object[])var3_3));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T validIndex(T chars, int index) {
        void var1_1;
        return Validate.validIndex(chars, index, DEFAULT_VALID_INDEX_CHAR_SEQUENCE_EX_MESSAGE, (int)var1_1);
    }

    public static void validState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException(DEFAULT_VALID_STATE_EX_MESSAGE);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void validState(boolean expression, String message, Object ... values) {
        if (!expression) {
            void var2_2;
            void var1_1;
            throw new IllegalStateException(String.format((String)var1_1, (Object[])var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void matchesPattern(CharSequence input, String pattern) {
        if (!Pattern.matches(pattern, input)) {
            void var1_1;
            CharSequence charSequence;
            throw new IllegalArgumentException(String.format(DEFAULT_MATCHES_PATTERN_EX, charSequence, var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void matchesPattern(CharSequence input, String pattern, String message, Object ... values) {
        CharSequence charSequence;
        if (!Pattern.matches(pattern, charSequence)) {
            void var3_3;
            void var2_2;
            throw new IllegalArgumentException(String.format((String)var2_2, (Object[])var3_3));
        }
    }

    public static void notNaN(double value) {
        Validate.notNaN(value, DEFAULT_NOT_NAN_EX_MESSAGE, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static void notNaN(double value, String message, Object ... values) {
        if (Double.isNaN(value)) {
            void var3_2;
            void var2_1;
            throw new IllegalArgumentException(String.format((String)var2_1, (Object[])var3_2));
        }
    }

    public static void finite(double value) {
        double d;
        Validate.finite(value, DEFAULT_FINITE_EX_MESSAGE, d);
    }

    /*
     * WARNING - void declaration
     */
    public static void finite(double value, String message, Object ... values) {
        double d;
        if (Double.isNaN(value) || Double.isInfinite(d)) {
            void var3_2;
            void var2_1;
            throw new IllegalArgumentException(String.format((String)var2_1, (Object[])var3_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> void inclusiveBetween(T start, T end, Comparable<T> value) {
        if (value.compareTo(start) < 0 || value.compareTo(end) > 0) {
            void var1_1;
            T t;
            void var2_2;
            throw new IllegalArgumentException(String.format(DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE, var2_2, t, var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> void inclusiveBetween(T start, T end, Comparable<T> value, String message, Object ... values) {
        void var1_1;
        void var2_2;
        T t;
        if (value.compareTo(t) < 0 || var2_2.compareTo(var1_1) > 0) {
            void var3_3;
            throw new IllegalArgumentException(String.format((String)var3_3, values));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void inclusiveBetween(long start, long end, long value) {
        if (value < start || value > end) {
            void var2_2;
            long l;
            throw new IllegalArgumentException(String.format(DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE, value, l, (long)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void inclusiveBetween(long start, long end, long value, String message) {
        void var2_1;
        long l;
        if (value < l || value > var2_1) {
            throw new IllegalArgumentException(message);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void inclusiveBetween(double start, double end, double value) {
        if (value < start || value > end) {
            void var2_2;
            double d;
            throw new IllegalArgumentException(String.format(DEFAULT_INCLUSIVE_BETWEEN_EX_MESSAGE, value, d, (double)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void inclusiveBetween(double start, double end, double value, String message) {
        void var2_1;
        double d;
        if (value < d || value > var2_1) {
            throw new IllegalArgumentException(message);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> void exclusiveBetween(T start, T end, Comparable<T> value) {
        if (value.compareTo(start) <= 0 || value.compareTo(end) >= 0) {
            void var1_1;
            T t;
            void var2_2;
            throw new IllegalArgumentException(String.format(DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE, var2_2, t, var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> void exclusiveBetween(T start, T end, Comparable<T> value, String message, Object ... values) {
        void var1_1;
        void var2_2;
        T t;
        if (value.compareTo(t) <= 0 || var2_2.compareTo(var1_1) >= 0) {
            void var3_3;
            throw new IllegalArgumentException(String.format((String)var3_3, values));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void exclusiveBetween(long start, long end, long value) {
        if (value <= start || value >= end) {
            void var2_2;
            long l;
            throw new IllegalArgumentException(String.format(DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE, value, l, (long)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void exclusiveBetween(long start, long end, long value, String message) {
        void var2_1;
        long l;
        if (value <= l || value >= var2_1) {
            throw new IllegalArgumentException(message);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void exclusiveBetween(double start, double end, double value) {
        if (value <= start || value >= end) {
            void var2_2;
            double d;
            throw new IllegalArgumentException(String.format(DEFAULT_EXCLUSIVE_BETWEEN_EX_MESSAGE, value, d, (double)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void exclusiveBetween(double start, double end, double value, String message) {
        void var2_1;
        double d;
        if (value <= d || value >= var2_1) {
            throw new IllegalArgumentException(message);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void isInstanceOf(Class<?> type, Object obj) {
        if (!type.isInstance(obj)) {
            void var1_1;
            Class<?> clazz;
            throw new IllegalArgumentException(String.format(DEFAULT_IS_INSTANCE_OF_EX_MESSAGE, clazz.getName(), obj == null ? "null" : var1_1.getClass().getName()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void isInstanceOf(Class<?> type, Object obj, String message, Object ... values) {
        void var1_1;
        if (!type.isInstance(var1_1)) {
            void var3_3;
            void var2_2;
            throw new IllegalArgumentException(String.format((String)var2_2, (Object[])var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void isAssignableFrom(Class<?> superType, Class<?> type) {
        if (!superType.isAssignableFrom(type)) {
            Class<?> clazz;
            void var1_1;
            throw new IllegalArgumentException(String.format(DEFAULT_IS_ASSIGNABLE_EX_MESSAGE, type == null ? "null" : var1_1.getName(), clazz.getName()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void isAssignableFrom(Class<?> superType, Class<?> type, String message, Object ... values) {
        void var1_1;
        if (!superType.isAssignableFrom((Class<?>)var1_1)) {
            void var3_3;
            void var2_2;
            throw new IllegalArgumentException(String.format((String)var2_2, (Object[])var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ String lambda$notNull$0(String message, Object[] values) {
        void var1_1;
        return String.format(message, (Object[])var1_1);
    }
}

